#version 120
#ifdef GL_ES
precision mediump float;
#endif

varying vec4 v_color;
varying vec2 v_texCoords;
varying vec2 v_worldPosition;  // World position from vertex shader

uniform sampler2D u_texture;
uniform float u_time;  // Time passed from Java code
uniform vec2 u_resolution;  // Screen resolution to normalize world position

void main() {
    vec4 color = texture2D(u_texture, v_texCoords) * v_color;

    // Normalize world position to screen space
    vec2 normalizedPosition = v_worldPosition / u_resolution;

    // Beam speed and width
    float beamSpeed = 0.5;  // Speed of the beam
    float beamWidth = 0.1;  // Width of the light beam

    // Calculate beam position: make it loop seamlessly
    float beamPosition = mod(u_time * beamSpeed, 1.0);  

    // Create the beam factor using smoothstep
    // Define the light beam with a gradient effect
    float beamFactor = smoothstep(beamPosition - beamWidth, beamPosition + beamWidth, normalizedPosition.x);

    // Define a gradient color for the light beam (white to light blue)
    vec3 beamColor = vec3(1.0, 1.0, 1.0); // White color for the beam

    // Use the beamFactor to blend the text color with the beam color
    gl_FragColor = vec4(mix(color.rgb, beamColor, beamFactor), color.a);
}
