#ifdef GL_ES
precision mediump float;
#endif

varying vec2 v_texCoord0;
uniform sampler2D u_texture;
uniform float u_blurAmount;
uniform vec2 u_resolution;

void main() {
    vec4 color = vec4(0.0);
    vec2 tex_offset = vec2(u_blurAmount / u_resolution.x, 0.0);

    // Sample neighboring pixels along the horizontal axis
    color += texture2D(u_texture, v_texCoord0 - 4.0 * tex_offset) * 0.05;
    color += texture2D(u_texture, v_texCoord0 - 3.0 * tex_offset) * 0.09;
    color += texture2D(u_texture, v_texCoord0 - 2.0 * tex_offset) * 0.12;
    color += texture2D(u_texture, v_texCoord0 - tex_offset) * 0.15;
    color += texture2D(u_texture, v_texCoord0) * 0.16;
    color += texture2D(u_texture, v_texCoord0 + tex_offset) * 0.15;
    color += texture2D(u_texture, v_texCoord0 + 2.0 * tex_offset) * 0.12;
    color += texture2D(u_texture, v_texCoord0 + 3.0 * tex_offset) * 0.09;
    color += texture2D(u_texture, v_texCoord0 + 4.0 * tex_offset) * 0.05;

    gl_FragColor = color;
}
