#ifdef GL_ES
precision mediump float;
#endif

varying vec2 v_texCoord0;
uniform sampler2D u_texture;
uniform float u_blurAmount;
uniform vec2 u_resolution;

void main() {
    vec4 sum = vec4(0.0);
    vec2 tex_offset = vec2(1.0 / u_resolution.x, 1.0 / u_resolution.y) * u_blurAmount;

    for (int x = -4; x <= 4; x++) {
        for (int y = -4; y <= 4; y++) {
            vec2 offset = vec2(float(x), float(y)) * tex_offset;
            sum += texture2D(u_texture, v_texCoord0 + offset);
        }
    }

    gl_FragColor = sum / 81.0; // Normalize by the number of samples (9x9 kernel)
}
