/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.windows.POINT;
import org.lwjgl.system.windows.RECT;
import org.lwjgl.system.windows.WINDOWPLACEMENT$Buffer;

public class WINDOWPLACEMENT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LENGTH;
    public static final int FLAGS;
    public static final int SHOWCMD;
    public static final int PTMINPOSITION;
    public static final int PTMAXPOSITION;
    public static final int RCNORMALPOSITION;

    protected WINDOWPLACEMENT(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected WINDOWPLACEMENT create(long l2, ByteBuffer byteBuffer) {
        return new WINDOWPLACEMENT(l2, byteBuffer);
    }

    public WINDOWPLACEMENT(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), WINDOWPLACEMENT.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int length() {
        return WINDOWPLACEMENT.nlength(this.address());
    }

    public int flags() {
        return WINDOWPLACEMENT.nflags(this.address());
    }

    public int showCmd() {
        return WINDOWPLACEMENT.nshowCmd(this.address());
    }

    public POINT ptMinPosition() {
        return WINDOWPLACEMENT.nptMinPosition(this.address());
    }

    public POINT ptMaxPosition() {
        return WINDOWPLACEMENT.nptMaxPosition(this.address());
    }

    public RECT rcNormalPosition() {
        return WINDOWPLACEMENT.nrcNormalPosition(this.address());
    }

    public WINDOWPLACEMENT length(int n2) {
        WINDOWPLACEMENT.nlength(this.address(), n2);
        return this;
    }

    public WINDOWPLACEMENT flags(int n2) {
        WINDOWPLACEMENT.nflags(this.address(), n2);
        return this;
    }

    public WINDOWPLACEMENT showCmd(int n2) {
        WINDOWPLACEMENT.nshowCmd(this.address(), n2);
        return this;
    }

    public WINDOWPLACEMENT ptMinPosition(POINT pOINT) {
        WINDOWPLACEMENT.nptMinPosition(this.address(), pOINT);
        return this;
    }

    public WINDOWPLACEMENT ptMinPosition(Consumer consumer) {
        consumer.accept(this.ptMinPosition());
        return this;
    }

    public WINDOWPLACEMENT ptMaxPosition(POINT pOINT) {
        WINDOWPLACEMENT.nptMaxPosition(this.address(), pOINT);
        return this;
    }

    public WINDOWPLACEMENT ptMaxPosition(Consumer consumer) {
        consumer.accept(this.ptMaxPosition());
        return this;
    }

    public WINDOWPLACEMENT rcNormalPosition(RECT rECT) {
        WINDOWPLACEMENT.nrcNormalPosition(this.address(), rECT);
        return this;
    }

    public WINDOWPLACEMENT rcNormalPosition(Consumer consumer) {
        consumer.accept(this.rcNormalPosition());
        return this;
    }

    public WINDOWPLACEMENT set(int n2, int n3, int n4, POINT pOINT, POINT pOINT2, RECT rECT) {
        this.length(n2);
        this.flags(n3);
        this.showCmd(n4);
        this.ptMinPosition(pOINT);
        this.ptMaxPosition(pOINT2);
        this.rcNormalPosition(rECT);
        return this;
    }

    public WINDOWPLACEMENT set(WINDOWPLACEMENT wINDOWPLACEMENT) {
        MemoryUtil.memCopy(wINDOWPLACEMENT.address(), this.address(), SIZEOF);
        return this;
    }

    public static WINDOWPLACEMENT malloc() {
        return new WINDOWPLACEMENT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static WINDOWPLACEMENT calloc() {
        return new WINDOWPLACEMENT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static WINDOWPLACEMENT create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new WINDOWPLACEMENT(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static WINDOWPLACEMENT create(long l2) {
        return new WINDOWPLACEMENT(l2, null);
    }

    public static WINDOWPLACEMENT createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new WINDOWPLACEMENT(l2, null);
    }

    public static WINDOWPLACEMENT$Buffer malloc(int n2) {
        return new WINDOWPLACEMENT$Buffer(MemoryUtil.nmemAllocChecked(WINDOWPLACEMENT.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static WINDOWPLACEMENT$Buffer calloc(int n2) {
        return new WINDOWPLACEMENT$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static WINDOWPLACEMENT$Buffer create(int n2) {
        ByteBuffer byteBuffer = WINDOWPLACEMENT.__create(n2, SIZEOF);
        int n3 = n2;
        return new WINDOWPLACEMENT$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static WINDOWPLACEMENT$Buffer create(long l2, int n2) {
        return new WINDOWPLACEMENT$Buffer(l2, n2);
    }

    public static WINDOWPLACEMENT$Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new WINDOWPLACEMENT$Buffer(l2, n2);
    }

    public static WINDOWPLACEMENT mallocStack() {
        return WINDOWPLACEMENT.malloc(MemoryStack.stackGet());
    }

    public static WINDOWPLACEMENT callocStack() {
        return WINDOWPLACEMENT.calloc(MemoryStack.stackGet());
    }

    public static WINDOWPLACEMENT mallocStack(MemoryStack memoryStack) {
        return WINDOWPLACEMENT.malloc(memoryStack);
    }

    public static WINDOWPLACEMENT callocStack(MemoryStack memoryStack) {
        return WINDOWPLACEMENT.calloc(memoryStack);
    }

    public static WINDOWPLACEMENT$Buffer mallocStack(int n2) {
        return WINDOWPLACEMENT.malloc(n2, MemoryStack.stackGet());
    }

    public static WINDOWPLACEMENT$Buffer callocStack(int n2) {
        return WINDOWPLACEMENT.calloc(n2, MemoryStack.stackGet());
    }

    public static WINDOWPLACEMENT$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return WINDOWPLACEMENT.malloc(n2, memoryStack);
    }

    public static WINDOWPLACEMENT$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return WINDOWPLACEMENT.calloc(n2, memoryStack);
    }

    public static WINDOWPLACEMENT malloc(MemoryStack memoryStack) {
        return new WINDOWPLACEMENT(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static WINDOWPLACEMENT calloc(MemoryStack memoryStack) {
        return new WINDOWPLACEMENT(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static WINDOWPLACEMENT$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new WINDOWPLACEMENT$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static WINDOWPLACEMENT$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new WINDOWPLACEMENT$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int nlength(long l2) {
        return UNSAFE.getInt(null, l2 + (long)LENGTH);
    }

    public static int nflags(long l2) {
        return UNSAFE.getInt(null, l2 + (long)FLAGS);
    }

    public static int nshowCmd(long l2) {
        return UNSAFE.getInt(null, l2 + (long)SHOWCMD);
    }

    public static POINT nptMinPosition(long l2) {
        return POINT.create(l2 + (long)PTMINPOSITION);
    }

    public static POINT nptMaxPosition(long l2) {
        return POINT.create(l2 + (long)PTMAXPOSITION);
    }

    public static RECT nrcNormalPosition(long l2) {
        return RECT.create(l2 + (long)RCNORMALPOSITION);
    }

    public static void nlength(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)LENGTH, n2);
    }

    public static void nflags(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)FLAGS, n2);
    }

    public static void nshowCmd(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)SHOWCMD, n2);
    }

    public static void nptMinPosition(long l2, POINT pOINT) {
        MemoryUtil.memCopy(pOINT.address(), l2 + (long)PTMINPOSITION, POINT.SIZEOF);
    }

    public static void nptMaxPosition(long l2, POINT pOINT) {
        MemoryUtil.memCopy(pOINT.address(), l2 + (long)PTMAXPOSITION, POINT.SIZEOF);
    }

    public static void nrcNormalPosition(long l2, RECT rECT) {
        MemoryUtil.memCopy(rECT.address(), l2 + (long)RCNORMALPOSITION, RECT.SIZEOF);
    }

    static {
        Struct$Layout struct$Layout = WINDOWPLACEMENT.__struct(WINDOWPLACEMENT.__member(4), WINDOWPLACEMENT.__member(4), WINDOWPLACEMENT.__member(4), WINDOWPLACEMENT.__member(POINT.SIZEOF, POINT.ALIGNOF), WINDOWPLACEMENT.__member(POINT.SIZEOF, POINT.ALIGNOF), WINDOWPLACEMENT.__member(RECT.SIZEOF, RECT.ALIGNOF));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        LENGTH = struct$Layout.offsetof(0);
        FLAGS = struct$Layout.offsetof(1);
        SHOWCMD = struct$Layout.offsetof(2);
        PTMINPOSITION = struct$Layout.offsetof(3);
        PTMAXPOSITION = struct$Layout.offsetof(4);
        RCNORMALPOSITION = struct$Layout.offsetof(5);
    }
}

