/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.windows.Kernel32$Functions;

public class Kernel32 {
    private static final SharedLibrary KERNEL32 = Library.loadNative(Kernel32.class, "org.lwjgl", "kernel32");

    public static SharedLibrary getLibrary() {
        return KERNEL32;
    }

    protected Kernel32() {
        throw new UnsupportedOperationException();
    }

    public static long GetCurrentProcess() {
        return JNI.callP(Kernel32$Functions.GetCurrentProcess);
    }

    public static int GetCurrentProcessId() {
        return JNI.callI(Kernel32$Functions.GetCurrentProcessId);
    }

    public static int GetProcessId(long l2) {
        long l3 = Kernel32$Functions.GetProcessId;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.callPI(l2, l3);
    }

    public static long GetCurrentThread() {
        return JNI.callP(Kernel32$Functions.GetCurrentThread);
    }

    public static int GetCurrentThreadId() {
        return JNI.callI(Kernel32$Functions.GetCurrentThreadId);
    }

    public static int GetThreadId(long l2) {
        long l3 = Kernel32$Functions.GetThreadId;
        if (Checks.CHECKS) {
            Checks.check(l3);
            Checks.check(l2);
        }
        return JNI.callPI(l2, l3);
    }

    public static int GetProcessIdOfThread(long l2) {
        long l3 = Kernel32$Functions.GetProcessIdOfThread;
        if (Checks.CHECKS) {
            Checks.check(l3);
            Checks.check(l2);
        }
        return JNI.callPI(l2, l3);
    }

    public static int GetCurrentProcessorNumber() {
        long l2 = Kernel32$Functions.GetCurrentProcessorNumber;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.callI(l2);
    }

    static /* synthetic */ SharedLibrary access$000() {
        return KERNEL32;
    }
}

