/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.macosx;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.macosx.ObjCPropertyAttribute$Buffer;

public class ObjCPropertyAttribute
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int VALUE;

    protected ObjCPropertyAttribute(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected ObjCPropertyAttribute create(long l2, ByteBuffer byteBuffer) {
        return new ObjCPropertyAttribute(l2, byteBuffer);
    }

    public ObjCPropertyAttribute(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), ObjCPropertyAttribute.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public ByteBuffer name() {
        return ObjCPropertyAttribute.nname(this.address());
    }

    public String nameString() {
        return ObjCPropertyAttribute.nnameString(this.address());
    }

    public ByteBuffer value() {
        return ObjCPropertyAttribute.nvalue(this.address());
    }

    public String valueString() {
        return ObjCPropertyAttribute.nvalueString(this.address());
    }

    public ObjCPropertyAttribute name(ByteBuffer byteBuffer) {
        ObjCPropertyAttribute.nname(this.address(), byteBuffer);
        return this;
    }

    public ObjCPropertyAttribute value(ByteBuffer byteBuffer) {
        ObjCPropertyAttribute.nvalue(this.address(), byteBuffer);
        return this;
    }

    public ObjCPropertyAttribute set(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        this.name(byteBuffer);
        this.value(byteBuffer2);
        return this;
    }

    public ObjCPropertyAttribute set(ObjCPropertyAttribute objCPropertyAttribute) {
        MemoryUtil.memCopy(objCPropertyAttribute.address(), this.address(), SIZEOF);
        return this;
    }

    public static ObjCPropertyAttribute malloc() {
        return new ObjCPropertyAttribute(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static ObjCPropertyAttribute calloc() {
        return new ObjCPropertyAttribute(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static ObjCPropertyAttribute create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new ObjCPropertyAttribute(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static ObjCPropertyAttribute create(long l2) {
        return new ObjCPropertyAttribute(l2, null);
    }

    public static ObjCPropertyAttribute createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new ObjCPropertyAttribute(l2, null);
    }

    public static ObjCPropertyAttribute$Buffer malloc(int n2) {
        return new ObjCPropertyAttribute$Buffer(MemoryUtil.nmemAllocChecked(ObjCPropertyAttribute.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static ObjCPropertyAttribute$Buffer calloc(int n2) {
        return new ObjCPropertyAttribute$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static ObjCPropertyAttribute$Buffer create(int n2) {
        ByteBuffer byteBuffer = ObjCPropertyAttribute.__create(n2, SIZEOF);
        int n3 = n2;
        return new ObjCPropertyAttribute$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static ObjCPropertyAttribute$Buffer create(long l2, int n2) {
        return new ObjCPropertyAttribute$Buffer(l2, n2);
    }

    public static ObjCPropertyAttribute$Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new ObjCPropertyAttribute$Buffer(l2, n2);
    }

    public static ObjCPropertyAttribute mallocStack() {
        return ObjCPropertyAttribute.malloc(MemoryStack.stackGet());
    }

    public static ObjCPropertyAttribute callocStack() {
        return ObjCPropertyAttribute.calloc(MemoryStack.stackGet());
    }

    public static ObjCPropertyAttribute mallocStack(MemoryStack memoryStack) {
        return ObjCPropertyAttribute.malloc(memoryStack);
    }

    public static ObjCPropertyAttribute callocStack(MemoryStack memoryStack) {
        return ObjCPropertyAttribute.calloc(memoryStack);
    }

    public static ObjCPropertyAttribute$Buffer mallocStack(int n2) {
        return ObjCPropertyAttribute.malloc(n2, MemoryStack.stackGet());
    }

    public static ObjCPropertyAttribute$Buffer callocStack(int n2) {
        return ObjCPropertyAttribute.calloc(n2, MemoryStack.stackGet());
    }

    public static ObjCPropertyAttribute$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return ObjCPropertyAttribute.malloc(n2, memoryStack);
    }

    public static ObjCPropertyAttribute$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return ObjCPropertyAttribute.calloc(n2, memoryStack);
    }

    public static ObjCPropertyAttribute malloc(MemoryStack memoryStack) {
        return new ObjCPropertyAttribute(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static ObjCPropertyAttribute calloc(MemoryStack memoryStack) {
        return new ObjCPropertyAttribute(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static ObjCPropertyAttribute$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new ObjCPropertyAttribute$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static ObjCPropertyAttribute$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new ObjCPropertyAttribute$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static ByteBuffer nname(long l2) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(l2 + (long)NAME));
    }

    public static String nnameString(long l2) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(l2 + (long)NAME));
    }

    public static ByteBuffer nvalue(long l2) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(l2 + (long)VALUE));
    }

    public static String nvalueString(long l2) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(l2 + (long)VALUE));
    }

    public static void nname(long l2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        MemoryUtil.memPutAddress(l2 + (long)NAME, MemoryUtil.memAddress(byteBuffer));
    }

    public static void nvalue(long l2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        MemoryUtil.memPutAddress(l2 + (long)VALUE, MemoryUtil.memAddress(byteBuffer));
    }

    public static void validate(long l2) {
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)NAME));
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)VALUE));
    }

    static {
        Struct$Layout struct$Layout = ObjCPropertyAttribute.__struct(ObjCPropertyAttribute.__member(POINTER_SIZE), ObjCPropertyAttribute.__member(POINTER_SIZE));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        NAME = struct$Layout.offsetof(0);
        VALUE = struct$Layout.offsetof(1);
    }
}

