/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.liburing.IOURingSQ$Buffer;
import org.lwjgl.system.linux.liburing.IOURingSQE;

public class IOURingSQ
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int KHEAD;
    public static final int KTAIL;
    public static final int KRING_MASK;
    public static final int KRING_ENTRIES;
    public static final int KFLAGS;
    public static final int KDROPPED;
    public static final int ARRAY;
    public static final int SQES;
    public static final int SQE_HEAD;
    public static final int SQE_TAIL;
    public static final int RING_SZ;
    public static final int RING_PTR;
    public static final int RING_MASK;
    public static final int RING_ENTRIES;
    public static final int PAD;

    protected IOURingSQ(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected IOURingSQ create(long l2, ByteBuffer byteBuffer) {
        return new IOURingSQ(l2, byteBuffer);
    }

    public IOURingSQ(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), IOURingSQ.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public IntBuffer khead(int n2) {
        return IOURingSQ.nkhead(this.address(), n2);
    }

    public IntBuffer ktail(int n2) {
        return IOURingSQ.nktail(this.address(), n2);
    }

    public IntBuffer kring_mask(int n2) {
        return IOURingSQ.nkring_mask(this.address(), n2);
    }

    public IntBuffer kring_entries(int n2) {
        return IOURingSQ.nkring_entries(this.address(), n2);
    }

    public IntBuffer kflags(int n2) {
        return IOURingSQ.nkflags(this.address(), n2);
    }

    public IntBuffer kdropped(int n2) {
        return IOURingSQ.nkdropped(this.address(), n2);
    }

    public IntBuffer array(int n2) {
        return IOURingSQ.narray(this.address(), n2);
    }

    public IOURingSQE sqes() {
        return IOURingSQ.nsqes(this.address());
    }

    public int sqe_head() {
        return IOURingSQ.nsqe_head(this.address());
    }

    public int sqe_tail() {
        return IOURingSQ.nsqe_tail(this.address());
    }

    public long ring_sz() {
        return IOURingSQ.nring_sz(this.address());
    }

    public ByteBuffer ring_ptr() {
        return IOURingSQ.nring_ptr(this.address());
    }

    public int ring_mask() {
        return IOURingSQ.nring_mask(this.address());
    }

    public int ring_entries() {
        return IOURingSQ.nring_entries(this.address());
    }

    public IOURingSQ khead(IntBuffer intBuffer) {
        IOURingSQ.nkhead(this.address(), intBuffer);
        return this;
    }

    public IOURingSQ ktail(IntBuffer intBuffer) {
        IOURingSQ.nktail(this.address(), intBuffer);
        return this;
    }

    public IOURingSQ kring_mask(IntBuffer intBuffer) {
        IOURingSQ.nkring_mask(this.address(), intBuffer);
        return this;
    }

    public IOURingSQ kring_entries(IntBuffer intBuffer) {
        IOURingSQ.nkring_entries(this.address(), intBuffer);
        return this;
    }

    public IOURingSQ kflags(IntBuffer intBuffer) {
        IOURingSQ.nkflags(this.address(), intBuffer);
        return this;
    }

    public IOURingSQ kdropped(IntBuffer intBuffer) {
        IOURingSQ.nkdropped(this.address(), intBuffer);
        return this;
    }

    public IOURingSQ array(IntBuffer intBuffer) {
        IOURingSQ.narray(this.address(), intBuffer);
        return this;
    }

    public IOURingSQ sqes(IOURingSQE iOURingSQE) {
        IOURingSQ.nsqes(this.address(), iOURingSQE);
        return this;
    }

    public IOURingSQ sqe_head(int n2) {
        IOURingSQ.nsqe_head(this.address(), n2);
        return this;
    }

    public IOURingSQ sqe_tail(int n2) {
        IOURingSQ.nsqe_tail(this.address(), n2);
        return this;
    }

    public IOURingSQ ring_ptr(ByteBuffer byteBuffer) {
        IOURingSQ.nring_ptr(this.address(), byteBuffer);
        return this;
    }

    public IOURingSQ ring_mask(int n2) {
        IOURingSQ.nring_mask(this.address(), n2);
        return this;
    }

    public IOURingSQ ring_entries(int n2) {
        IOURingSQ.nring_entries(this.address(), n2);
        return this;
    }

    public IOURingSQ set(IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3, IntBuffer intBuffer4, IntBuffer intBuffer5, IntBuffer intBuffer6, IntBuffer intBuffer7, IOURingSQE iOURingSQE, int n2, int n3, ByteBuffer byteBuffer, int n4, int n5) {
        this.khead(intBuffer);
        this.ktail(intBuffer2);
        this.kring_mask(intBuffer3);
        this.kring_entries(intBuffer4);
        this.kflags(intBuffer5);
        this.kdropped(intBuffer6);
        this.array(intBuffer7);
        this.sqes(iOURingSQE);
        this.sqe_head(n2);
        this.sqe_tail(n3);
        this.ring_ptr(byteBuffer);
        this.ring_mask(n4);
        this.ring_entries(n5);
        return this;
    }

    public IOURingSQ set(IOURingSQ iOURingSQ) {
        MemoryUtil.memCopy(iOURingSQ.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOURingSQ malloc() {
        return new IOURingSQ(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static IOURingSQ calloc() {
        return new IOURingSQ(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static IOURingSQ create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new IOURingSQ(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static IOURingSQ create(long l2) {
        return new IOURingSQ(l2, null);
    }

    public static IOURingSQ createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new IOURingSQ(l2, null);
    }

    public static IOURingSQ$Buffer malloc(int n2) {
        return new IOURingSQ$Buffer(MemoryUtil.nmemAllocChecked(IOURingSQ.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static IOURingSQ$Buffer calloc(int n2) {
        return new IOURingSQ$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static IOURingSQ$Buffer create(int n2) {
        ByteBuffer byteBuffer = IOURingSQ.__create(n2, SIZEOF);
        int n3 = n2;
        return new IOURingSQ$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static IOURingSQ$Buffer create(long l2, int n2) {
        return new IOURingSQ$Buffer(l2, n2);
    }

    public static IOURingSQ$Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new IOURingSQ$Buffer(l2, n2);
    }

    public static IOURingSQ malloc(MemoryStack memoryStack) {
        return new IOURingSQ(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static IOURingSQ calloc(MemoryStack memoryStack) {
        return new IOURingSQ(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static IOURingSQ$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new IOURingSQ$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static IOURingSQ$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new IOURingSQ$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static IntBuffer nkhead(long l2, int n2) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(l2 + (long)KHEAD), n2);
    }

    public static IntBuffer nktail(long l2, int n2) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(l2 + (long)KTAIL), n2);
    }

    public static IntBuffer nkring_mask(long l2, int n2) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(l2 + (long)KRING_MASK), n2);
    }

    public static IntBuffer nkring_entries(long l2, int n2) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(l2 + (long)KRING_ENTRIES), n2);
    }

    public static IntBuffer nkflags(long l2, int n2) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(l2 + (long)KFLAGS), n2);
    }

    public static IntBuffer nkdropped(long l2, int n2) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(l2 + (long)KDROPPED), n2);
    }

    public static IntBuffer narray(long l2, int n2) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(l2 + (long)ARRAY), n2);
    }

    public static IOURingSQE nsqes(long l2) {
        return IOURingSQE.create(MemoryUtil.memGetAddress(l2 + (long)SQES));
    }

    public static int nsqe_head(long l2) {
        return UNSAFE.getInt(null, l2 + (long)SQE_HEAD);
    }

    public static int nsqe_tail(long l2) {
        return UNSAFE.getInt(null, l2 + (long)SQE_TAIL);
    }

    public static long nring_sz(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)RING_SZ);
    }

    public static ByteBuffer nring_ptr(long l2) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(l2 + (long)RING_PTR), (int)IOURingSQ.nring_sz(l2));
    }

    public static int nring_mask(long l2) {
        return UNSAFE.getInt(null, l2 + (long)RING_MASK);
    }

    public static int nring_entries(long l2) {
        return UNSAFE.getInt(null, l2 + (long)RING_ENTRIES);
    }

    public static IntBuffer npad(long l2) {
        return MemoryUtil.memIntBuffer(l2 + (long)PAD, 2);
    }

    public static int npad(long l2, int n2) {
        return UNSAFE.getInt(null, l2 + (long)PAD + (Checks.check(n2, 2) << 2));
    }

    public static void nkhead(long l2, IntBuffer intBuffer) {
        MemoryUtil.memPutAddress(l2 + (long)KHEAD, MemoryUtil.memAddress(intBuffer));
    }

    public static void nktail(long l2, IntBuffer intBuffer) {
        MemoryUtil.memPutAddress(l2 + (long)KTAIL, MemoryUtil.memAddress(intBuffer));
    }

    public static void nkring_mask(long l2, IntBuffer intBuffer) {
        MemoryUtil.memPutAddress(l2 + (long)KRING_MASK, MemoryUtil.memAddress(intBuffer));
    }

    public static void nkring_entries(long l2, IntBuffer intBuffer) {
        MemoryUtil.memPutAddress(l2 + (long)KRING_ENTRIES, MemoryUtil.memAddress(intBuffer));
    }

    public static void nkflags(long l2, IntBuffer intBuffer) {
        MemoryUtil.memPutAddress(l2 + (long)KFLAGS, MemoryUtil.memAddress(intBuffer));
    }

    public static void nkdropped(long l2, IntBuffer intBuffer) {
        MemoryUtil.memPutAddress(l2 + (long)KDROPPED, MemoryUtil.memAddress(intBuffer));
    }

    public static void narray(long l2, IntBuffer intBuffer) {
        MemoryUtil.memPutAddress(l2 + (long)ARRAY, MemoryUtil.memAddress(intBuffer));
    }

    public static void nsqes(long l2, IOURingSQE iOURingSQE) {
        MemoryUtil.memPutAddress(l2 + (long)SQES, iOURingSQE.address());
    }

    public static void nsqe_head(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)SQE_HEAD, n2);
    }

    public static void nsqe_tail(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)SQE_TAIL, n2);
    }

    public static void nring_sz(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)RING_SZ, l3);
    }

    public static void nring_ptr(long l2, ByteBuffer byteBuffer) {
        MemoryUtil.memPutAddress(l2 + (long)RING_PTR, MemoryUtil.memAddress(byteBuffer));
        IOURingSQ.nring_sz(l2, byteBuffer.remaining());
    }

    public static void nring_mask(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)RING_MASK, n2);
    }

    public static void nring_entries(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)RING_ENTRIES, n2);
    }

    public static void npad(long l2, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.checkGT(intBuffer, 2);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(intBuffer), l2 + (long)PAD, intBuffer.remaining() << 2);
    }

    public static void npad(long l2, int n2, int n3) {
        UNSAFE.putInt(null, l2 + (long)PAD + (Checks.check(n2, 2) << 2), n3);
    }

    public static void validate(long l2) {
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)KHEAD));
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)KTAIL));
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)KRING_MASK));
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)KRING_ENTRIES));
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)KFLAGS));
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)KDROPPED));
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)ARRAY));
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)SQES));
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)RING_PTR));
    }

    static {
        Struct$Layout struct$Layout = IOURingSQ.__struct(IOURingSQ.__member(POINTER_SIZE), IOURingSQ.__member(POINTER_SIZE), IOURingSQ.__member(POINTER_SIZE), IOURingSQ.__member(POINTER_SIZE), IOURingSQ.__member(POINTER_SIZE), IOURingSQ.__member(POINTER_SIZE), IOURingSQ.__member(POINTER_SIZE), IOURingSQ.__member(POINTER_SIZE), IOURingSQ.__member(4), IOURingSQ.__member(4), IOURingSQ.__member(POINTER_SIZE), IOURingSQ.__member(POINTER_SIZE), IOURingSQ.__member(4), IOURingSQ.__member(4), IOURingSQ.__array(4, 2));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        KHEAD = struct$Layout.offsetof(0);
        KTAIL = struct$Layout.offsetof(1);
        KRING_MASK = struct$Layout.offsetof(2);
        KRING_ENTRIES = struct$Layout.offsetof(3);
        KFLAGS = struct$Layout.offsetof(4);
        KDROPPED = struct$Layout.offsetof(5);
        ARRAY = struct$Layout.offsetof(6);
        SQES = struct$Layout.offsetof(7);
        SQE_HEAD = struct$Layout.offsetof(8);
        SQE_TAIL = struct$Layout.offsetof(9);
        RING_SZ = struct$Layout.offsetof(10);
        RING_PTR = struct$Layout.offsetof(11);
        RING_MASK = struct$Layout.offsetof(12);
        RING_ENTRIES = struct$Layout.offsetof(13);
        PAD = struct$Layout.offsetof(14);
    }
}

