/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Pointer$Default;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.liburing.IOURingBuf;
import org.lwjgl.system.linux.liburing.IOURingBuf$Buffer;
import org.lwjgl.system.linux.liburing.IOURingBufRing$Buffer;

public class IOURingBufRing
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RESV1;
    public static final int RESV2;
    public static final int RESV3;
    public static final int TAIL;
    public static final int BUFS;

    protected IOURingBufRing(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected IOURingBufRing create(long l2, ByteBuffer byteBuffer) {
        return new IOURingBufRing(l2, byteBuffer);
    }

    public IOURingBufRing(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), IOURingBufRing.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long resv1() {
        return IOURingBufRing.nresv1(this.address());
    }

    public int resv2() {
        return IOURingBufRing.nresv2(this.address());
    }

    public short resv3() {
        return IOURingBufRing.nresv3(this.address());
    }

    public short tail() {
        return IOURingBufRing.ntail(this.address());
    }

    public IOURingBuf$Buffer bufs() {
        return IOURingBufRing.nbufs(this.address());
    }

    public IOURingBuf bufs(int n2) {
        return IOURingBufRing.nbufs(this.address(), n2);
    }

    public IOURingBufRing resv1(long l2) {
        IOURingBufRing.nresv1(this.address(), l2);
        return this;
    }

    public IOURingBufRing resv2(int n2) {
        IOURingBufRing.nresv2(this.address(), n2);
        return this;
    }

    public IOURingBufRing resv3(short s2) {
        IOURingBufRing.nresv3(this.address(), s2);
        return this;
    }

    public IOURingBufRing tail(short s2) {
        IOURingBufRing.ntail(this.address(), s2);
        return this;
    }

    public IOURingBufRing bufs(IOURingBuf$Buffer iOURingBuf$Buffer) {
        IOURingBufRing.nbufs(this.address(), iOURingBuf$Buffer);
        return this;
    }

    public IOURingBufRing bufs(int n2, IOURingBuf iOURingBuf) {
        IOURingBufRing.nbufs(this.address(), n2, iOURingBuf);
        return this;
    }

    public IOURingBufRing bufs(Consumer consumer) {
        consumer.accept(this.bufs());
        return this;
    }

    public IOURingBufRing bufs(int n2, Consumer consumer) {
        consumer.accept(this.bufs(n2));
        return this;
    }

    public IOURingBufRing set(IOURingBufRing iOURingBufRing) {
        MemoryUtil.memCopy(iOURingBufRing.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOURingBufRing malloc() {
        return new IOURingBufRing(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static IOURingBufRing calloc() {
        return new IOURingBufRing(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static IOURingBufRing create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new IOURingBufRing(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static IOURingBufRing create(long l2) {
        return new IOURingBufRing(l2, null);
    }

    public static IOURingBufRing createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new IOURingBufRing(l2, null);
    }

    public static IOURingBufRing$Buffer malloc(int n2) {
        return new IOURingBufRing$Buffer(MemoryUtil.nmemAllocChecked(IOURingBufRing.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static IOURingBufRing$Buffer calloc(int n2) {
        return new IOURingBufRing$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static IOURingBufRing$Buffer create(int n2) {
        ByteBuffer byteBuffer = IOURingBufRing.__create(n2, SIZEOF);
        int n3 = n2;
        return new IOURingBufRing$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static IOURingBufRing$Buffer create(long l2, int n2) {
        return new IOURingBufRing$Buffer(l2, n2);
    }

    public static IOURingBufRing$Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new IOURingBufRing$Buffer(l2, n2);
    }

    public static IOURingBufRing malloc(MemoryStack memoryStack) {
        return new IOURingBufRing(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static IOURingBufRing calloc(MemoryStack memoryStack) {
        return new IOURingBufRing(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static IOURingBufRing$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new IOURingBufRing$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static IOURingBufRing$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new IOURingBufRing$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static long nresv1(long l2) {
        return UNSAFE.getLong(null, l2 + (long)RESV1);
    }

    public static int nresv2(long l2) {
        return UNSAFE.getInt(null, l2 + (long)RESV2);
    }

    public static short nresv3(long l2) {
        return UNSAFE.getShort(null, l2 + (long)RESV3);
    }

    public static short ntail(long l2) {
        return UNSAFE.getShort(null, l2 + (long)TAIL);
    }

    public static IOURingBuf$Buffer nbufs(long l2) {
        return IOURingBuf.create(l2 + (long)BUFS, 0);
    }

    public static IOURingBuf nbufs(long l2, int n2) {
        return IOURingBuf.create(l2 + (long)BUFS + Checks.check(n2, 0) * (long)IOURingBuf.SIZEOF);
    }

    public static void nresv1(long l2, long l3) {
        UNSAFE.putLong(null, l2 + (long)RESV1, l3);
    }

    public static void nresv2(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)RESV2, n2);
    }

    public static void nresv3(long l2, short s2) {
        UNSAFE.putShort(null, l2 + (long)RESV3, s2);
    }

    public static void ntail(long l2, short s2) {
        UNSAFE.putShort(null, l2 + (long)TAIL, s2);
    }

    public static void nbufs(long l2, IOURingBuf$Buffer iOURingBuf$Buffer) {
        if (Checks.CHECKS) {
            Checks.checkGT(iOURingBuf$Buffer, 0);
        }
        MemoryUtil.memCopy(((Pointer$Default)iOURingBuf$Buffer).address(), l2 + (long)BUFS, iOURingBuf$Buffer.remaining() * IOURingBuf.SIZEOF);
    }

    public static void nbufs(long l2, int n2, IOURingBuf iOURingBuf) {
        MemoryUtil.memCopy(iOURingBuf.address(), l2 + (long)BUFS + Checks.check(n2, 0) * (long)IOURingBuf.SIZEOF, IOURingBuf.SIZEOF);
    }

    static {
        Struct$Layout struct$Layout = IOURingBufRing.__struct(IOURingBufRing.__union(IOURingBufRing.__struct(IOURingBufRing.__member(8), IOURingBufRing.__member(4), IOURingBufRing.__member(2), IOURingBufRing.__member(2)), IOURingBufRing.__array(IOURingBuf.SIZEOF, IOURingBuf.ALIGNOF, 0)));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        RESV1 = struct$Layout.offsetof(2);
        RESV2 = struct$Layout.offsetof(3);
        RESV3 = struct$Layout.offsetof(4);
        TAIL = struct$Layout.offsetof(5);
        BUFS = struct$Layout.offsetof(6);
    }
}

