/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.liburing.IOURingBufReg$Buffer;

public class IOURingBufReg
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RING_ADDR;
    public static final int RING_ENTRIES;
    public static final int BGID;
    public static final int FLAGS;
    public static final int RESV;

    protected IOURingBufReg(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected IOURingBufReg create(long l2, ByteBuffer byteBuffer) {
        return new IOURingBufReg(l2, byteBuffer);
    }

    public IOURingBufReg(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), IOURingBufReg.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long ring_addr() {
        return IOURingBufReg.nring_addr(this.address());
    }

    public int ring_entries() {
        return IOURingBufReg.nring_entries(this.address());
    }

    public short bgid() {
        return IOURingBufReg.nbgid(this.address());
    }

    public short flags() {
        return IOURingBufReg.nflags(this.address());
    }

    public LongBuffer resv() {
        return IOURingBufReg.nresv(this.address());
    }

    public long resv(int n2) {
        return IOURingBufReg.nresv(this.address(), n2);
    }

    public IOURingBufReg ring_addr(long l2) {
        IOURingBufReg.nring_addr(this.address(), l2);
        return this;
    }

    public IOURingBufReg ring_entries(int n2) {
        IOURingBufReg.nring_entries(this.address(), n2);
        return this;
    }

    public IOURingBufReg bgid(short s2) {
        IOURingBufReg.nbgid(this.address(), s2);
        return this;
    }

    public IOURingBufReg flags(short s2) {
        IOURingBufReg.nflags(this.address(), s2);
        return this;
    }

    public IOURingBufReg resv(LongBuffer longBuffer) {
        IOURingBufReg.nresv(this.address(), longBuffer);
        return this;
    }

    public IOURingBufReg resv(int n2, long l2) {
        IOURingBufReg.nresv(this.address(), n2, l2);
        return this;
    }

    public IOURingBufReg set(long l2, int n2, short s2, short s3, LongBuffer longBuffer) {
        this.ring_addr(l2);
        this.ring_entries(n2);
        this.bgid(s2);
        this.flags(s3);
        this.resv(longBuffer);
        return this;
    }

    public IOURingBufReg set(IOURingBufReg iOURingBufReg) {
        MemoryUtil.memCopy(iOURingBufReg.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOURingBufReg malloc() {
        return new IOURingBufReg(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static IOURingBufReg calloc() {
        return new IOURingBufReg(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static IOURingBufReg create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new IOURingBufReg(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static IOURingBufReg create(long l2) {
        return new IOURingBufReg(l2, null);
    }

    public static IOURingBufReg createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new IOURingBufReg(l2, null);
    }

    public static IOURingBufReg$Buffer malloc(int n2) {
        return new IOURingBufReg$Buffer(MemoryUtil.nmemAllocChecked(IOURingBufReg.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static IOURingBufReg$Buffer calloc(int n2) {
        return new IOURingBufReg$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static IOURingBufReg$Buffer create(int n2) {
        ByteBuffer byteBuffer = IOURingBufReg.__create(n2, SIZEOF);
        int n3 = n2;
        return new IOURingBufReg$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static IOURingBufReg$Buffer create(long l2, int n2) {
        return new IOURingBufReg$Buffer(l2, n2);
    }

    public static IOURingBufReg$Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new IOURingBufReg$Buffer(l2, n2);
    }

    public static IOURingBufReg malloc(MemoryStack memoryStack) {
        return new IOURingBufReg(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static IOURingBufReg calloc(MemoryStack memoryStack) {
        return new IOURingBufReg(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static IOURingBufReg$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new IOURingBufReg$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static IOURingBufReg$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new IOURingBufReg$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static long nring_addr(long l2) {
        return UNSAFE.getLong(null, l2 + (long)RING_ADDR);
    }

    public static int nring_entries(long l2) {
        return UNSAFE.getInt(null, l2 + (long)RING_ENTRIES);
    }

    public static short nbgid(long l2) {
        return UNSAFE.getShort(null, l2 + (long)BGID);
    }

    public static short nflags(long l2) {
        return UNSAFE.getShort(null, l2 + (long)FLAGS);
    }

    public static LongBuffer nresv(long l2) {
        return MemoryUtil.memLongBuffer(l2 + (long)RESV, 3);
    }

    public static long nresv(long l2, int n2) {
        return UNSAFE.getLong(null, l2 + (long)RESV + (Checks.check(n2, 3) << 3));
    }

    public static void nring_addr(long l2, long l3) {
        UNSAFE.putLong(null, l2 + (long)RING_ADDR, l3);
    }

    public static void nring_entries(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)RING_ENTRIES, n2);
    }

    public static void nbgid(long l2, short s2) {
        UNSAFE.putShort(null, l2 + (long)BGID, s2);
    }

    public static void nflags(long l2, short s2) {
        UNSAFE.putShort(null, l2 + (long)FLAGS, s2);
    }

    public static void nresv(long l2, LongBuffer longBuffer) {
        if (Checks.CHECKS) {
            Checks.checkGT(longBuffer, 3);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(longBuffer), l2 + (long)RESV, longBuffer.remaining() << 3);
    }

    public static void nresv(long l2, int n2, long l3) {
        UNSAFE.putLong(null, l2 + (long)RESV + (Checks.check(n2, 3) << 3), l3);
    }

    static {
        Struct$Layout struct$Layout = IOURingBufReg.__struct(IOURingBufReg.__member(8), IOURingBufReg.__member(4), IOURingBufReg.__member(2), IOURingBufReg.__member(2), IOURingBufReg.__array(8, 3));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        RING_ADDR = struct$Layout.offsetof(0);
        RING_ENTRIES = struct$Layout.offsetof(1);
        BGID = struct$Layout.offsetof(2);
        FLAGS = struct$Layout.offsetof(3);
        RESV = struct$Layout.offsetof(4);
    }
}

