/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.XVisibilityEvent$Buffer;

public class XVisibilityEvent
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int SERIAL;
    public static final int SEND_EVENT;
    public static final int DISPLAY;
    public static final int WINDOW;
    public static final int STATE;

    protected XVisibilityEvent(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected XVisibilityEvent create(long l2, ByteBuffer byteBuffer) {
        return new XVisibilityEvent(l2, byteBuffer);
    }

    public XVisibilityEvent(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), XVisibilityEvent.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int type() {
        return XVisibilityEvent.ntype(this.address());
    }

    public long serial() {
        return XVisibilityEvent.nserial(this.address());
    }

    public boolean send_event() {
        return XVisibilityEvent.nsend_event(this.address()) != 0;
    }

    public long display() {
        return XVisibilityEvent.ndisplay(this.address());
    }

    public long window() {
        return XVisibilityEvent.nwindow(this.address());
    }

    public int state() {
        return XVisibilityEvent.nstate(this.address());
    }

    public XVisibilityEvent type(int n2) {
        XVisibilityEvent.ntype(this.address(), n2);
        return this;
    }

    public XVisibilityEvent serial(long l2) {
        XVisibilityEvent.nserial(this.address(), l2);
        return this;
    }

    public XVisibilityEvent send_event(boolean bl2) {
        XVisibilityEvent.nsend_event(this.address(), bl2 ? 1 : 0);
        return this;
    }

    public XVisibilityEvent display(long l2) {
        XVisibilityEvent.ndisplay(this.address(), l2);
        return this;
    }

    public XVisibilityEvent window(long l2) {
        XVisibilityEvent.nwindow(this.address(), l2);
        return this;
    }

    public XVisibilityEvent state(int n2) {
        XVisibilityEvent.nstate(this.address(), n2);
        return this;
    }

    public XVisibilityEvent set(int n2, long l2, boolean bl2, long l3, long l4, int n3) {
        this.type(n2);
        this.serial(l2);
        this.send_event(bl2);
        this.display(l3);
        this.window(l4);
        this.state(n3);
        return this;
    }

    public XVisibilityEvent set(XVisibilityEvent xVisibilityEvent) {
        MemoryUtil.memCopy(xVisibilityEvent.address(), this.address(), SIZEOF);
        return this;
    }

    public static XVisibilityEvent malloc() {
        return new XVisibilityEvent(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XVisibilityEvent calloc() {
        return new XVisibilityEvent(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XVisibilityEvent create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new XVisibilityEvent(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static XVisibilityEvent create(long l2) {
        return new XVisibilityEvent(l2, null);
    }

    public static XVisibilityEvent createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new XVisibilityEvent(l2, null);
    }

    public static XVisibilityEvent$Buffer malloc(int n2) {
        return new XVisibilityEvent$Buffer(MemoryUtil.nmemAllocChecked(XVisibilityEvent.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static XVisibilityEvent$Buffer calloc(int n2) {
        return new XVisibilityEvent$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static XVisibilityEvent$Buffer create(int n2) {
        ByteBuffer byteBuffer = XVisibilityEvent.__create(n2, SIZEOF);
        int n3 = n2;
        return new XVisibilityEvent$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static XVisibilityEvent$Buffer create(long l2, int n2) {
        return new XVisibilityEvent$Buffer(l2, n2);
    }

    public static XVisibilityEvent$Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new XVisibilityEvent$Buffer(l2, n2);
    }

    public static XVisibilityEvent mallocStack() {
        return XVisibilityEvent.malloc(MemoryStack.stackGet());
    }

    public static XVisibilityEvent callocStack() {
        return XVisibilityEvent.calloc(MemoryStack.stackGet());
    }

    public static XVisibilityEvent mallocStack(MemoryStack memoryStack) {
        return XVisibilityEvent.malloc(memoryStack);
    }

    public static XVisibilityEvent callocStack(MemoryStack memoryStack) {
        return XVisibilityEvent.calloc(memoryStack);
    }

    public static XVisibilityEvent$Buffer mallocStack(int n2) {
        return XVisibilityEvent.malloc(n2, MemoryStack.stackGet());
    }

    public static XVisibilityEvent$Buffer callocStack(int n2) {
        return XVisibilityEvent.calloc(n2, MemoryStack.stackGet());
    }

    public static XVisibilityEvent$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return XVisibilityEvent.malloc(n2, memoryStack);
    }

    public static XVisibilityEvent$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return XVisibilityEvent.calloc(n2, memoryStack);
    }

    public static XVisibilityEvent malloc(MemoryStack memoryStack) {
        return new XVisibilityEvent(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XVisibilityEvent calloc(MemoryStack memoryStack) {
        return new XVisibilityEvent(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static XVisibilityEvent$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new XVisibilityEvent$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static XVisibilityEvent$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new XVisibilityEvent$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int ntype(long l2) {
        return UNSAFE.getInt(null, l2 + (long)TYPE);
    }

    public static long nserial(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)SERIAL);
    }

    public static int nsend_event(long l2) {
        return UNSAFE.getInt(null, l2 + (long)SEND_EVENT);
    }

    public static long ndisplay(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)DISPLAY);
    }

    public static long nwindow(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)WINDOW);
    }

    public static int nstate(long l2) {
        return UNSAFE.getInt(null, l2 + (long)STATE);
    }

    public static void ntype(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)TYPE, n2);
    }

    public static void nserial(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)SERIAL, l3);
    }

    public static void nsend_event(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)SEND_EVENT, n2);
    }

    public static void ndisplay(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)DISPLAY, Checks.check(l3));
    }

    public static void nwindow(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)WINDOW, l3);
    }

    public static void nstate(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)STATE, n2);
    }

    public static void validate(long l2) {
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)DISPLAY));
    }

    static {
        Struct$Layout struct$Layout = XVisibilityEvent.__struct(XVisibilityEvent.__member(4), XVisibilityEvent.__member(CLONG_SIZE), XVisibilityEvent.__member(4), XVisibilityEvent.__member(POINTER_SIZE), XVisibilityEvent.__member(CLONG_SIZE), XVisibilityEvent.__member(4));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        TYPE = struct$Layout.offsetof(0);
        SERIAL = struct$Layout.offsetof(1);
        SEND_EVENT = struct$Layout.offsetof(2);
        DISPLAY = struct$Layout.offsetof(3);
        WINDOW = struct$Layout.offsetof(4);
        STATE = struct$Layout.offsetof(5);
    }
}

