/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.XUnmapEvent$Buffer;

public class XUnmapEvent
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int SERIAL;
    public static final int SEND_EVENT;
    public static final int DISPLAY;
    public static final int EVENT;
    public static final int WINDOW;
    public static final int FROM_CONFIGURE;

    protected XUnmapEvent(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected XUnmapEvent create(long l2, ByteBuffer byteBuffer) {
        return new XUnmapEvent(l2, byteBuffer);
    }

    public XUnmapEvent(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), XUnmapEvent.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int type() {
        return XUnmapEvent.ntype(this.address());
    }

    public long serial() {
        return XUnmapEvent.nserial(this.address());
    }

    public boolean send_event() {
        return XUnmapEvent.nsend_event(this.address()) != 0;
    }

    public long display() {
        return XUnmapEvent.ndisplay(this.address());
    }

    public long event() {
        return XUnmapEvent.nevent(this.address());
    }

    public long window() {
        return XUnmapEvent.nwindow(this.address());
    }

    public int from_configure() {
        return XUnmapEvent.nfrom_configure(this.address());
    }

    public XUnmapEvent type(int n2) {
        XUnmapEvent.ntype(this.address(), n2);
        return this;
    }

    public XUnmapEvent serial(long l2) {
        XUnmapEvent.nserial(this.address(), l2);
        return this;
    }

    public XUnmapEvent send_event(boolean bl2) {
        XUnmapEvent.nsend_event(this.address(), bl2 ? 1 : 0);
        return this;
    }

    public XUnmapEvent display(long l2) {
        XUnmapEvent.ndisplay(this.address(), l2);
        return this;
    }

    public XUnmapEvent event(long l2) {
        XUnmapEvent.nevent(this.address(), l2);
        return this;
    }

    public XUnmapEvent window(long l2) {
        XUnmapEvent.nwindow(this.address(), l2);
        return this;
    }

    public XUnmapEvent from_configure(int n2) {
        XUnmapEvent.nfrom_configure(this.address(), n2);
        return this;
    }

    public XUnmapEvent set(int n2, long l2, boolean bl2, long l3, long l4, long l5, int n3) {
        this.type(n2);
        this.serial(l2);
        this.send_event(bl2);
        this.display(l3);
        this.event(l4);
        this.window(l5);
        this.from_configure(n3);
        return this;
    }

    public XUnmapEvent set(XUnmapEvent xUnmapEvent) {
        MemoryUtil.memCopy(xUnmapEvent.address(), this.address(), SIZEOF);
        return this;
    }

    public static XUnmapEvent malloc() {
        return new XUnmapEvent(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XUnmapEvent calloc() {
        return new XUnmapEvent(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XUnmapEvent create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new XUnmapEvent(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static XUnmapEvent create(long l2) {
        return new XUnmapEvent(l2, null);
    }

    public static XUnmapEvent createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new XUnmapEvent(l2, null);
    }

    public static XUnmapEvent$Buffer malloc(int n2) {
        return new XUnmapEvent$Buffer(MemoryUtil.nmemAllocChecked(XUnmapEvent.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static XUnmapEvent$Buffer calloc(int n2) {
        return new XUnmapEvent$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static XUnmapEvent$Buffer create(int n2) {
        ByteBuffer byteBuffer = XUnmapEvent.__create(n2, SIZEOF);
        int n3 = n2;
        return new XUnmapEvent$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static XUnmapEvent$Buffer create(long l2, int n2) {
        return new XUnmapEvent$Buffer(l2, n2);
    }

    public static XUnmapEvent$Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new XUnmapEvent$Buffer(l2, n2);
    }

    public static XUnmapEvent mallocStack() {
        return XUnmapEvent.malloc(MemoryStack.stackGet());
    }

    public static XUnmapEvent callocStack() {
        return XUnmapEvent.calloc(MemoryStack.stackGet());
    }

    public static XUnmapEvent mallocStack(MemoryStack memoryStack) {
        return XUnmapEvent.malloc(memoryStack);
    }

    public static XUnmapEvent callocStack(MemoryStack memoryStack) {
        return XUnmapEvent.calloc(memoryStack);
    }

    public static XUnmapEvent$Buffer mallocStack(int n2) {
        return XUnmapEvent.malloc(n2, MemoryStack.stackGet());
    }

    public static XUnmapEvent$Buffer callocStack(int n2) {
        return XUnmapEvent.calloc(n2, MemoryStack.stackGet());
    }

    public static XUnmapEvent$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return XUnmapEvent.malloc(n2, memoryStack);
    }

    public static XUnmapEvent$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return XUnmapEvent.calloc(n2, memoryStack);
    }

    public static XUnmapEvent malloc(MemoryStack memoryStack) {
        return new XUnmapEvent(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XUnmapEvent calloc(MemoryStack memoryStack) {
        return new XUnmapEvent(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static XUnmapEvent$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new XUnmapEvent$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static XUnmapEvent$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new XUnmapEvent$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int ntype(long l2) {
        return UNSAFE.getInt(null, l2 + (long)TYPE);
    }

    public static long nserial(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)SERIAL);
    }

    public static int nsend_event(long l2) {
        return UNSAFE.getInt(null, l2 + (long)SEND_EVENT);
    }

    public static long ndisplay(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)DISPLAY);
    }

    public static long nevent(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)EVENT);
    }

    public static long nwindow(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)WINDOW);
    }

    public static int nfrom_configure(long l2) {
        return UNSAFE.getInt(null, l2 + (long)FROM_CONFIGURE);
    }

    public static void ntype(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)TYPE, n2);
    }

    public static void nserial(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)SERIAL, l3);
    }

    public static void nsend_event(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)SEND_EVENT, n2);
    }

    public static void ndisplay(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)DISPLAY, Checks.check(l3));
    }

    public static void nevent(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)EVENT, l3);
    }

    public static void nwindow(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)WINDOW, l3);
    }

    public static void nfrom_configure(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)FROM_CONFIGURE, n2);
    }

    public static void validate(long l2) {
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)DISPLAY));
    }

    static {
        Struct$Layout struct$Layout = XUnmapEvent.__struct(XUnmapEvent.__member(4), XUnmapEvent.__member(CLONG_SIZE), XUnmapEvent.__member(4), XUnmapEvent.__member(POINTER_SIZE), XUnmapEvent.__member(CLONG_SIZE), XUnmapEvent.__member(CLONG_SIZE), XUnmapEvent.__member(4));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        TYPE = struct$Layout.offsetof(0);
        SERIAL = struct$Layout.offsetof(1);
        SEND_EVENT = struct$Layout.offsetof(2);
        DISPLAY = struct$Layout.offsetof(3);
        EVENT = struct$Layout.offsetof(4);
        WINDOW = struct$Layout.offsetof(5);
        FROM_CONFIGURE = struct$Layout.offsetof(6);
    }
}

