/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.XSelectionRequestEvent$Buffer;

public class XSelectionRequestEvent
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int SERIAL;
    public static final int SEND_EVENT;
    public static final int DISPLAY;
    public static final int OWNER;
    public static final int REQUESTOR;
    public static final int SELECTION;
    public static final int TARGET;
    public static final int PROPERTY;
    public static final int TIME;

    protected XSelectionRequestEvent(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected XSelectionRequestEvent create(long l2, ByteBuffer byteBuffer) {
        return new XSelectionRequestEvent(l2, byteBuffer);
    }

    public XSelectionRequestEvent(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), XSelectionRequestEvent.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int type() {
        return XSelectionRequestEvent.ntype(this.address());
    }

    public long serial() {
        return XSelectionRequestEvent.nserial(this.address());
    }

    public boolean send_event() {
        return XSelectionRequestEvent.nsend_event(this.address()) != 0;
    }

    public long display() {
        return XSelectionRequestEvent.ndisplay(this.address());
    }

    public long owner() {
        return XSelectionRequestEvent.nowner(this.address());
    }

    public long requestor() {
        return XSelectionRequestEvent.nrequestor(this.address());
    }

    public long selection() {
        return XSelectionRequestEvent.nselection(this.address());
    }

    public long target() {
        return XSelectionRequestEvent.ntarget(this.address());
    }

    public long property() {
        return XSelectionRequestEvent.nproperty(this.address());
    }

    public long time() {
        return XSelectionRequestEvent.ntime(this.address());
    }

    public XSelectionRequestEvent type(int n2) {
        XSelectionRequestEvent.ntype(this.address(), n2);
        return this;
    }

    public XSelectionRequestEvent serial(long l2) {
        XSelectionRequestEvent.nserial(this.address(), l2);
        return this;
    }

    public XSelectionRequestEvent send_event(boolean bl2) {
        XSelectionRequestEvent.nsend_event(this.address(), bl2 ? 1 : 0);
        return this;
    }

    public XSelectionRequestEvent display(long l2) {
        XSelectionRequestEvent.ndisplay(this.address(), l2);
        return this;
    }

    public XSelectionRequestEvent owner(long l2) {
        XSelectionRequestEvent.nowner(this.address(), l2);
        return this;
    }

    public XSelectionRequestEvent requestor(long l2) {
        XSelectionRequestEvent.nrequestor(this.address(), l2);
        return this;
    }

    public XSelectionRequestEvent selection(long l2) {
        XSelectionRequestEvent.nselection(this.address(), l2);
        return this;
    }

    public XSelectionRequestEvent target(long l2) {
        XSelectionRequestEvent.ntarget(this.address(), l2);
        return this;
    }

    public XSelectionRequestEvent property(long l2) {
        XSelectionRequestEvent.nproperty(this.address(), l2);
        return this;
    }

    public XSelectionRequestEvent time(long l2) {
        XSelectionRequestEvent.ntime(this.address(), l2);
        return this;
    }

    public XSelectionRequestEvent set(int n2, long l2, boolean bl2, long l3, long l4, long l5, long l6, long l7, long l8, long l9) {
        this.type(n2);
        this.serial(l2);
        this.send_event(bl2);
        this.display(l3);
        this.owner(l4);
        this.requestor(l5);
        this.selection(l6);
        this.target(l7);
        this.property(l8);
        this.time(l9);
        return this;
    }

    public XSelectionRequestEvent set(XSelectionRequestEvent xSelectionRequestEvent) {
        MemoryUtil.memCopy(xSelectionRequestEvent.address(), this.address(), SIZEOF);
        return this;
    }

    public static XSelectionRequestEvent malloc() {
        return new XSelectionRequestEvent(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XSelectionRequestEvent calloc() {
        return new XSelectionRequestEvent(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XSelectionRequestEvent create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new XSelectionRequestEvent(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static XSelectionRequestEvent create(long l2) {
        return new XSelectionRequestEvent(l2, null);
    }

    public static XSelectionRequestEvent createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new XSelectionRequestEvent(l2, null);
    }

    public static XSelectionRequestEvent$Buffer malloc(int n2) {
        return new XSelectionRequestEvent$Buffer(MemoryUtil.nmemAllocChecked(XSelectionRequestEvent.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static XSelectionRequestEvent$Buffer calloc(int n2) {
        return new XSelectionRequestEvent$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static XSelectionRequestEvent$Buffer create(int n2) {
        ByteBuffer byteBuffer = XSelectionRequestEvent.__create(n2, SIZEOF);
        int n3 = n2;
        return new XSelectionRequestEvent$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static XSelectionRequestEvent$Buffer create(long l2, int n2) {
        return new XSelectionRequestEvent$Buffer(l2, n2);
    }

    public static XSelectionRequestEvent$Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new XSelectionRequestEvent$Buffer(l2, n2);
    }

    public static XSelectionRequestEvent mallocStack() {
        return XSelectionRequestEvent.malloc(MemoryStack.stackGet());
    }

    public static XSelectionRequestEvent callocStack() {
        return XSelectionRequestEvent.calloc(MemoryStack.stackGet());
    }

    public static XSelectionRequestEvent mallocStack(MemoryStack memoryStack) {
        return XSelectionRequestEvent.malloc(memoryStack);
    }

    public static XSelectionRequestEvent callocStack(MemoryStack memoryStack) {
        return XSelectionRequestEvent.calloc(memoryStack);
    }

    public static XSelectionRequestEvent$Buffer mallocStack(int n2) {
        return XSelectionRequestEvent.malloc(n2, MemoryStack.stackGet());
    }

    public static XSelectionRequestEvent$Buffer callocStack(int n2) {
        return XSelectionRequestEvent.calloc(n2, MemoryStack.stackGet());
    }

    public static XSelectionRequestEvent$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return XSelectionRequestEvent.malloc(n2, memoryStack);
    }

    public static XSelectionRequestEvent$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return XSelectionRequestEvent.calloc(n2, memoryStack);
    }

    public static XSelectionRequestEvent malloc(MemoryStack memoryStack) {
        return new XSelectionRequestEvent(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XSelectionRequestEvent calloc(MemoryStack memoryStack) {
        return new XSelectionRequestEvent(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static XSelectionRequestEvent$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new XSelectionRequestEvent$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static XSelectionRequestEvent$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new XSelectionRequestEvent$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int ntype(long l2) {
        return UNSAFE.getInt(null, l2 + (long)TYPE);
    }

    public static long nserial(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)SERIAL);
    }

    public static int nsend_event(long l2) {
        return UNSAFE.getInt(null, l2 + (long)SEND_EVENT);
    }

    public static long ndisplay(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)DISPLAY);
    }

    public static long nowner(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)OWNER);
    }

    public static long nrequestor(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)REQUESTOR);
    }

    public static long nselection(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)SELECTION);
    }

    public static long ntarget(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)TARGET);
    }

    public static long nproperty(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)PROPERTY);
    }

    public static long ntime(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)TIME);
    }

    public static void ntype(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)TYPE, n2);
    }

    public static void nserial(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)SERIAL, l3);
    }

    public static void nsend_event(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)SEND_EVENT, n2);
    }

    public static void ndisplay(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)DISPLAY, Checks.check(l3));
    }

    public static void nowner(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)OWNER, l3);
    }

    public static void nrequestor(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)REQUESTOR, l3);
    }

    public static void nselection(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)SELECTION, l3);
    }

    public static void ntarget(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)TARGET, l3);
    }

    public static void nproperty(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)PROPERTY, l3);
    }

    public static void ntime(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)TIME, l3);
    }

    public static void validate(long l2) {
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)DISPLAY));
    }

    static {
        Struct$Layout struct$Layout = XSelectionRequestEvent.__struct(XSelectionRequestEvent.__member(4), XSelectionRequestEvent.__member(CLONG_SIZE), XSelectionRequestEvent.__member(4), XSelectionRequestEvent.__member(POINTER_SIZE), XSelectionRequestEvent.__member(CLONG_SIZE), XSelectionRequestEvent.__member(CLONG_SIZE), XSelectionRequestEvent.__member(CLONG_SIZE), XSelectionRequestEvent.__member(CLONG_SIZE), XSelectionRequestEvent.__member(CLONG_SIZE), XSelectionRequestEvent.__member(CLONG_SIZE));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        TYPE = struct$Layout.offsetof(0);
        SERIAL = struct$Layout.offsetof(1);
        SEND_EVENT = struct$Layout.offsetof(2);
        DISPLAY = struct$Layout.offsetof(3);
        OWNER = struct$Layout.offsetof(4);
        REQUESTOR = struct$Layout.offsetof(5);
        SELECTION = struct$Layout.offsetof(6);
        TARGET = struct$Layout.offsetof(7);
        PROPERTY = struct$Layout.offsetof(8);
        TIME = struct$Layout.offsetof(9);
    }
}

