/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.XSelectionClearEvent$Buffer;

public class XSelectionClearEvent
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int SERIAL;
    public static final int SEND_EVENT;
    public static final int DISPLAY;
    public static final int WINDOW;
    public static final int SELECTION;
    public static final int TIME;

    protected XSelectionClearEvent(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected XSelectionClearEvent create(long l2, ByteBuffer byteBuffer) {
        return new XSelectionClearEvent(l2, byteBuffer);
    }

    public XSelectionClearEvent(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), XSelectionClearEvent.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int type() {
        return XSelectionClearEvent.ntype(this.address());
    }

    public long serial() {
        return XSelectionClearEvent.nserial(this.address());
    }

    public boolean send_event() {
        return XSelectionClearEvent.nsend_event(this.address()) != 0;
    }

    public long display() {
        return XSelectionClearEvent.ndisplay(this.address());
    }

    public long window() {
        return XSelectionClearEvent.nwindow(this.address());
    }

    public long selection() {
        return XSelectionClearEvent.nselection(this.address());
    }

    public long time() {
        return XSelectionClearEvent.ntime(this.address());
    }

    public XSelectionClearEvent type(int n2) {
        XSelectionClearEvent.ntype(this.address(), n2);
        return this;
    }

    public XSelectionClearEvent serial(long l2) {
        XSelectionClearEvent.nserial(this.address(), l2);
        return this;
    }

    public XSelectionClearEvent send_event(boolean bl2) {
        XSelectionClearEvent.nsend_event(this.address(), bl2 ? 1 : 0);
        return this;
    }

    public XSelectionClearEvent display(long l2) {
        XSelectionClearEvent.ndisplay(this.address(), l2);
        return this;
    }

    public XSelectionClearEvent window(long l2) {
        XSelectionClearEvent.nwindow(this.address(), l2);
        return this;
    }

    public XSelectionClearEvent selection(long l2) {
        XSelectionClearEvent.nselection(this.address(), l2);
        return this;
    }

    public XSelectionClearEvent time(long l2) {
        XSelectionClearEvent.ntime(this.address(), l2);
        return this;
    }

    public XSelectionClearEvent set(int n2, long l2, boolean bl2, long l3, long l4, long l5, long l6) {
        this.type(n2);
        this.serial(l2);
        this.send_event(bl2);
        this.display(l3);
        this.window(l4);
        this.selection(l5);
        this.time(l6);
        return this;
    }

    public XSelectionClearEvent set(XSelectionClearEvent xSelectionClearEvent) {
        MemoryUtil.memCopy(xSelectionClearEvent.address(), this.address(), SIZEOF);
        return this;
    }

    public static XSelectionClearEvent malloc() {
        return new XSelectionClearEvent(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XSelectionClearEvent calloc() {
        return new XSelectionClearEvent(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XSelectionClearEvent create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new XSelectionClearEvent(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static XSelectionClearEvent create(long l2) {
        return new XSelectionClearEvent(l2, null);
    }

    public static XSelectionClearEvent createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new XSelectionClearEvent(l2, null);
    }

    public static XSelectionClearEvent$Buffer malloc(int n2) {
        return new XSelectionClearEvent$Buffer(MemoryUtil.nmemAllocChecked(XSelectionClearEvent.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static XSelectionClearEvent$Buffer calloc(int n2) {
        return new XSelectionClearEvent$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static XSelectionClearEvent$Buffer create(int n2) {
        ByteBuffer byteBuffer = XSelectionClearEvent.__create(n2, SIZEOF);
        int n3 = n2;
        return new XSelectionClearEvent$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static XSelectionClearEvent$Buffer create(long l2, int n2) {
        return new XSelectionClearEvent$Buffer(l2, n2);
    }

    public static XSelectionClearEvent$Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new XSelectionClearEvent$Buffer(l2, n2);
    }

    public static XSelectionClearEvent mallocStack() {
        return XSelectionClearEvent.malloc(MemoryStack.stackGet());
    }

    public static XSelectionClearEvent callocStack() {
        return XSelectionClearEvent.calloc(MemoryStack.stackGet());
    }

    public static XSelectionClearEvent mallocStack(MemoryStack memoryStack) {
        return XSelectionClearEvent.malloc(memoryStack);
    }

    public static XSelectionClearEvent callocStack(MemoryStack memoryStack) {
        return XSelectionClearEvent.calloc(memoryStack);
    }

    public static XSelectionClearEvent$Buffer mallocStack(int n2) {
        return XSelectionClearEvent.malloc(n2, MemoryStack.stackGet());
    }

    public static XSelectionClearEvent$Buffer callocStack(int n2) {
        return XSelectionClearEvent.calloc(n2, MemoryStack.stackGet());
    }

    public static XSelectionClearEvent$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return XSelectionClearEvent.malloc(n2, memoryStack);
    }

    public static XSelectionClearEvent$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return XSelectionClearEvent.calloc(n2, memoryStack);
    }

    public static XSelectionClearEvent malloc(MemoryStack memoryStack) {
        return new XSelectionClearEvent(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XSelectionClearEvent calloc(MemoryStack memoryStack) {
        return new XSelectionClearEvent(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static XSelectionClearEvent$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new XSelectionClearEvent$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static XSelectionClearEvent$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new XSelectionClearEvent$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int ntype(long l2) {
        return UNSAFE.getInt(null, l2 + (long)TYPE);
    }

    public static long nserial(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)SERIAL);
    }

    public static int nsend_event(long l2) {
        return UNSAFE.getInt(null, l2 + (long)SEND_EVENT);
    }

    public static long ndisplay(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)DISPLAY);
    }

    public static long nwindow(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)WINDOW);
    }

    public static long nselection(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)SELECTION);
    }

    public static long ntime(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)TIME);
    }

    public static void ntype(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)TYPE, n2);
    }

    public static void nserial(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)SERIAL, l3);
    }

    public static void nsend_event(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)SEND_EVENT, n2);
    }

    public static void ndisplay(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)DISPLAY, Checks.check(l3));
    }

    public static void nwindow(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)WINDOW, l3);
    }

    public static void nselection(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)SELECTION, l3);
    }

    public static void ntime(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)TIME, l3);
    }

    public static void validate(long l2) {
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)DISPLAY));
    }

    static {
        Struct$Layout struct$Layout = XSelectionClearEvent.__struct(XSelectionClearEvent.__member(4), XSelectionClearEvent.__member(CLONG_SIZE), XSelectionClearEvent.__member(4), XSelectionClearEvent.__member(POINTER_SIZE), XSelectionClearEvent.__member(CLONG_SIZE), XSelectionClearEvent.__member(CLONG_SIZE), XSelectionClearEvent.__member(CLONG_SIZE));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        TYPE = struct$Layout.offsetof(0);
        SERIAL = struct$Layout.offsetof(1);
        SEND_EVENT = struct$Layout.offsetof(2);
        DISPLAY = struct$Layout.offsetof(3);
        WINDOW = struct$Layout.offsetof(4);
        SELECTION = struct$Layout.offsetof(5);
        TIME = struct$Layout.offsetof(6);
    }
}

