/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.XReparentEvent$Buffer;

public class XReparentEvent
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int SERIAL;
    public static final int SEND_EVENT;
    public static final int DISPLAY;
    public static final int EVENT;
    public static final int WINDOW;
    public static final int PARENT;
    public static final int X;
    public static final int Y;
    public static final int OVERRIDE_REDIRECT;

    protected XReparentEvent(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected XReparentEvent create(long l2, ByteBuffer byteBuffer) {
        return new XReparentEvent(l2, byteBuffer);
    }

    public XReparentEvent(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), XReparentEvent.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int type() {
        return XReparentEvent.ntype(this.address());
    }

    public long serial() {
        return XReparentEvent.nserial(this.address());
    }

    public boolean send_event() {
        return XReparentEvent.nsend_event(this.address()) != 0;
    }

    public long display() {
        return XReparentEvent.ndisplay(this.address());
    }

    public long event() {
        return XReparentEvent.nevent(this.address());
    }

    public long window() {
        return XReparentEvent.nwindow(this.address());
    }

    public long parent() {
        return XReparentEvent.nparent(this.address());
    }

    public int x() {
        return XReparentEvent.nx(this.address());
    }

    public int y() {
        return XReparentEvent.ny(this.address());
    }

    public int override_redirect() {
        return XReparentEvent.noverride_redirect(this.address());
    }

    public XReparentEvent type(int n2) {
        XReparentEvent.ntype(this.address(), n2);
        return this;
    }

    public XReparentEvent serial(long l2) {
        XReparentEvent.nserial(this.address(), l2);
        return this;
    }

    public XReparentEvent send_event(boolean bl2) {
        XReparentEvent.nsend_event(this.address(), bl2 ? 1 : 0);
        return this;
    }

    public XReparentEvent display(long l2) {
        XReparentEvent.ndisplay(this.address(), l2);
        return this;
    }

    public XReparentEvent event(long l2) {
        XReparentEvent.nevent(this.address(), l2);
        return this;
    }

    public XReparentEvent window(long l2) {
        XReparentEvent.nwindow(this.address(), l2);
        return this;
    }

    public XReparentEvent parent(long l2) {
        XReparentEvent.nparent(this.address(), l2);
        return this;
    }

    public XReparentEvent x(int n2) {
        XReparentEvent.nx(this.address(), n2);
        return this;
    }

    public XReparentEvent y(int n2) {
        XReparentEvent.ny(this.address(), n2);
        return this;
    }

    public XReparentEvent override_redirect(int n2) {
        XReparentEvent.noverride_redirect(this.address(), n2);
        return this;
    }

    public XReparentEvent set(int n2, long l2, boolean bl2, long l3, long l4, long l5, long l6, int n3, int n4, int n5) {
        this.type(n2);
        this.serial(l2);
        this.send_event(bl2);
        this.display(l3);
        this.event(l4);
        this.window(l5);
        this.parent(l6);
        this.x(n3);
        this.y(n4);
        this.override_redirect(n5);
        return this;
    }

    public XReparentEvent set(XReparentEvent xReparentEvent) {
        MemoryUtil.memCopy(xReparentEvent.address(), this.address(), SIZEOF);
        return this;
    }

    public static XReparentEvent malloc() {
        return new XReparentEvent(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XReparentEvent calloc() {
        return new XReparentEvent(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XReparentEvent create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new XReparentEvent(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static XReparentEvent create(long l2) {
        return new XReparentEvent(l2, null);
    }

    public static XReparentEvent createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new XReparentEvent(l2, null);
    }

    public static XReparentEvent$Buffer malloc(int n2) {
        return new XReparentEvent$Buffer(MemoryUtil.nmemAllocChecked(XReparentEvent.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static XReparentEvent$Buffer calloc(int n2) {
        return new XReparentEvent$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static XReparentEvent$Buffer create(int n2) {
        ByteBuffer byteBuffer = XReparentEvent.__create(n2, SIZEOF);
        int n3 = n2;
        return new XReparentEvent$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static XReparentEvent$Buffer create(long l2, int n2) {
        return new XReparentEvent$Buffer(l2, n2);
    }

    public static XReparentEvent$Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new XReparentEvent$Buffer(l2, n2);
    }

    public static XReparentEvent mallocStack() {
        return XReparentEvent.malloc(MemoryStack.stackGet());
    }

    public static XReparentEvent callocStack() {
        return XReparentEvent.calloc(MemoryStack.stackGet());
    }

    public static XReparentEvent mallocStack(MemoryStack memoryStack) {
        return XReparentEvent.malloc(memoryStack);
    }

    public static XReparentEvent callocStack(MemoryStack memoryStack) {
        return XReparentEvent.calloc(memoryStack);
    }

    public static XReparentEvent$Buffer mallocStack(int n2) {
        return XReparentEvent.malloc(n2, MemoryStack.stackGet());
    }

    public static XReparentEvent$Buffer callocStack(int n2) {
        return XReparentEvent.calloc(n2, MemoryStack.stackGet());
    }

    public static XReparentEvent$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return XReparentEvent.malloc(n2, memoryStack);
    }

    public static XReparentEvent$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return XReparentEvent.calloc(n2, memoryStack);
    }

    public static XReparentEvent malloc(MemoryStack memoryStack) {
        return new XReparentEvent(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XReparentEvent calloc(MemoryStack memoryStack) {
        return new XReparentEvent(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static XReparentEvent$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new XReparentEvent$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static XReparentEvent$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new XReparentEvent$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int ntype(long l2) {
        return UNSAFE.getInt(null, l2 + (long)TYPE);
    }

    public static long nserial(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)SERIAL);
    }

    public static int nsend_event(long l2) {
        return UNSAFE.getInt(null, l2 + (long)SEND_EVENT);
    }

    public static long ndisplay(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)DISPLAY);
    }

    public static long nevent(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)EVENT);
    }

    public static long nwindow(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)WINDOW);
    }

    public static long nparent(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)PARENT);
    }

    public static int nx(long l2) {
        return UNSAFE.getInt(null, l2 + (long)X);
    }

    public static int ny(long l2) {
        return UNSAFE.getInt(null, l2 + (long)Y);
    }

    public static int noverride_redirect(long l2) {
        return UNSAFE.getInt(null, l2 + (long)OVERRIDE_REDIRECT);
    }

    public static void ntype(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)TYPE, n2);
    }

    public static void nserial(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)SERIAL, l3);
    }

    public static void nsend_event(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)SEND_EVENT, n2);
    }

    public static void ndisplay(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)DISPLAY, Checks.check(l3));
    }

    public static void nevent(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)EVENT, l3);
    }

    public static void nwindow(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)WINDOW, l3);
    }

    public static void nparent(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)PARENT, l3);
    }

    public static void nx(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)X, n2);
    }

    public static void ny(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)Y, n2);
    }

    public static void noverride_redirect(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)OVERRIDE_REDIRECT, n2);
    }

    public static void validate(long l2) {
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)DISPLAY));
    }

    static {
        Struct$Layout struct$Layout = XReparentEvent.__struct(XReparentEvent.__member(4), XReparentEvent.__member(CLONG_SIZE), XReparentEvent.__member(4), XReparentEvent.__member(POINTER_SIZE), XReparentEvent.__member(CLONG_SIZE), XReparentEvent.__member(CLONG_SIZE), XReparentEvent.__member(CLONG_SIZE), XReparentEvent.__member(4), XReparentEvent.__member(4), XReparentEvent.__member(4));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        TYPE = struct$Layout.offsetof(0);
        SERIAL = struct$Layout.offsetof(1);
        SEND_EVENT = struct$Layout.offsetof(2);
        DISPLAY = struct$Layout.offsetof(3);
        EVENT = struct$Layout.offsetof(4);
        WINDOW = struct$Layout.offsetof(5);
        PARENT = struct$Layout.offsetof(6);
        X = struct$Layout.offsetof(7);
        Y = struct$Layout.offsetof(8);
        OVERRIDE_REDIRECT = struct$Layout.offsetof(9);
    }
}

