/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.XMapEvent$Buffer;

public class XMapEvent
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int SERIAL;
    public static final int SEND_EVENT;
    public static final int DISPLAY;
    public static final int EVENT;
    public static final int WINDOW;
    public static final int OVERRIDE_REDIRECT;

    protected XMapEvent(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected XMapEvent create(long l2, ByteBuffer byteBuffer) {
        return new XMapEvent(l2, byteBuffer);
    }

    public XMapEvent(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), XMapEvent.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int type() {
        return XMapEvent.ntype(this.address());
    }

    public long serial() {
        return XMapEvent.nserial(this.address());
    }

    public boolean send_event() {
        return XMapEvent.nsend_event(this.address()) != 0;
    }

    public long display() {
        return XMapEvent.ndisplay(this.address());
    }

    public long event() {
        return XMapEvent.nevent(this.address());
    }

    public long window() {
        return XMapEvent.nwindow(this.address());
    }

    public int override_redirect() {
        return XMapEvent.noverride_redirect(this.address());
    }

    public XMapEvent type(int n2) {
        XMapEvent.ntype(this.address(), n2);
        return this;
    }

    public XMapEvent serial(long l2) {
        XMapEvent.nserial(this.address(), l2);
        return this;
    }

    public XMapEvent send_event(boolean bl2) {
        XMapEvent.nsend_event(this.address(), bl2 ? 1 : 0);
        return this;
    }

    public XMapEvent display(long l2) {
        XMapEvent.ndisplay(this.address(), l2);
        return this;
    }

    public XMapEvent event(long l2) {
        XMapEvent.nevent(this.address(), l2);
        return this;
    }

    public XMapEvent window(long l2) {
        XMapEvent.nwindow(this.address(), l2);
        return this;
    }

    public XMapEvent override_redirect(int n2) {
        XMapEvent.noverride_redirect(this.address(), n2);
        return this;
    }

    public XMapEvent set(int n2, long l2, boolean bl2, long l3, long l4, long l5, int n3) {
        this.type(n2);
        this.serial(l2);
        this.send_event(bl2);
        this.display(l3);
        this.event(l4);
        this.window(l5);
        this.override_redirect(n3);
        return this;
    }

    public XMapEvent set(XMapEvent xMapEvent) {
        MemoryUtil.memCopy(xMapEvent.address(), this.address(), SIZEOF);
        return this;
    }

    public static XMapEvent malloc() {
        return new XMapEvent(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XMapEvent calloc() {
        return new XMapEvent(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XMapEvent create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new XMapEvent(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static XMapEvent create(long l2) {
        return new XMapEvent(l2, null);
    }

    public static XMapEvent createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new XMapEvent(l2, null);
    }

    public static XMapEvent$Buffer malloc(int n2) {
        return new XMapEvent$Buffer(MemoryUtil.nmemAllocChecked(XMapEvent.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static XMapEvent$Buffer calloc(int n2) {
        return new XMapEvent$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static XMapEvent$Buffer create(int n2) {
        ByteBuffer byteBuffer = XMapEvent.__create(n2, SIZEOF);
        int n3 = n2;
        return new XMapEvent$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static XMapEvent$Buffer create(long l2, int n2) {
        return new XMapEvent$Buffer(l2, n2);
    }

    public static XMapEvent$Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new XMapEvent$Buffer(l2, n2);
    }

    public static XMapEvent mallocStack() {
        return XMapEvent.malloc(MemoryStack.stackGet());
    }

    public static XMapEvent callocStack() {
        return XMapEvent.calloc(MemoryStack.stackGet());
    }

    public static XMapEvent mallocStack(MemoryStack memoryStack) {
        return XMapEvent.malloc(memoryStack);
    }

    public static XMapEvent callocStack(MemoryStack memoryStack) {
        return XMapEvent.calloc(memoryStack);
    }

    public static XMapEvent$Buffer mallocStack(int n2) {
        return XMapEvent.malloc(n2, MemoryStack.stackGet());
    }

    public static XMapEvent$Buffer callocStack(int n2) {
        return XMapEvent.calloc(n2, MemoryStack.stackGet());
    }

    public static XMapEvent$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return XMapEvent.malloc(n2, memoryStack);
    }

    public static XMapEvent$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return XMapEvent.calloc(n2, memoryStack);
    }

    public static XMapEvent malloc(MemoryStack memoryStack) {
        return new XMapEvent(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XMapEvent calloc(MemoryStack memoryStack) {
        return new XMapEvent(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static XMapEvent$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new XMapEvent$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static XMapEvent$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new XMapEvent$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int ntype(long l2) {
        return UNSAFE.getInt(null, l2 + (long)TYPE);
    }

    public static long nserial(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)SERIAL);
    }

    public static int nsend_event(long l2) {
        return UNSAFE.getInt(null, l2 + (long)SEND_EVENT);
    }

    public static long ndisplay(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)DISPLAY);
    }

    public static long nevent(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)EVENT);
    }

    public static long nwindow(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)WINDOW);
    }

    public static int noverride_redirect(long l2) {
        return UNSAFE.getInt(null, l2 + (long)OVERRIDE_REDIRECT);
    }

    public static void ntype(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)TYPE, n2);
    }

    public static void nserial(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)SERIAL, l3);
    }

    public static void nsend_event(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)SEND_EVENT, n2);
    }

    public static void ndisplay(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)DISPLAY, Checks.check(l3));
    }

    public static void nevent(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)EVENT, l3);
    }

    public static void nwindow(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)WINDOW, l3);
    }

    public static void noverride_redirect(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)OVERRIDE_REDIRECT, n2);
    }

    public static void validate(long l2) {
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)DISPLAY));
    }

    static {
        Struct$Layout struct$Layout = XMapEvent.__struct(XMapEvent.__member(4), XMapEvent.__member(CLONG_SIZE), XMapEvent.__member(4), XMapEvent.__member(POINTER_SIZE), XMapEvent.__member(CLONG_SIZE), XMapEvent.__member(CLONG_SIZE), XMapEvent.__member(4));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        TYPE = struct$Layout.offsetof(0);
        SERIAL = struct$Layout.offsetof(1);
        SEND_EVENT = struct$Layout.offsetof(2);
        DISPLAY = struct$Layout.offsetof(3);
        EVENT = struct$Layout.offsetof(4);
        WINDOW = struct$Layout.offsetof(5);
        OVERRIDE_REDIRECT = struct$Layout.offsetof(6);
    }
}

