/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.XGenericEvent$Buffer;

public class XGenericEvent
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int SERIAL;
    public static final int SEND_EVENT;
    public static final int DISPLAY;
    public static final int EXTENSION;
    public static final int EVTYPE;

    protected XGenericEvent(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected XGenericEvent create(long l2, ByteBuffer byteBuffer) {
        return new XGenericEvent(l2, byteBuffer);
    }

    public XGenericEvent(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), XGenericEvent.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int type() {
        return XGenericEvent.ntype(this.address());
    }

    public long serial() {
        return XGenericEvent.nserial(this.address());
    }

    public boolean send_event() {
        return XGenericEvent.nsend_event(this.address()) != 0;
    }

    public long display() {
        return XGenericEvent.ndisplay(this.address());
    }

    public int extension() {
        return XGenericEvent.nextension(this.address());
    }

    public int evtype() {
        return XGenericEvent.nevtype(this.address());
    }

    public XGenericEvent type(int n2) {
        XGenericEvent.ntype(this.address(), n2);
        return this;
    }

    public XGenericEvent serial(long l2) {
        XGenericEvent.nserial(this.address(), l2);
        return this;
    }

    public XGenericEvent send_event(boolean bl2) {
        XGenericEvent.nsend_event(this.address(), bl2 ? 1 : 0);
        return this;
    }

    public XGenericEvent display(long l2) {
        XGenericEvent.ndisplay(this.address(), l2);
        return this;
    }

    public XGenericEvent extension(int n2) {
        XGenericEvent.nextension(this.address(), n2);
        return this;
    }

    public XGenericEvent evtype(int n2) {
        XGenericEvent.nevtype(this.address(), n2);
        return this;
    }

    public XGenericEvent set(int n2, long l2, boolean bl2, long l3, int n3, int n4) {
        this.type(n2);
        this.serial(l2);
        this.send_event(bl2);
        this.display(l3);
        this.extension(n3);
        this.evtype(n4);
        return this;
    }

    public XGenericEvent set(XGenericEvent xGenericEvent) {
        MemoryUtil.memCopy(xGenericEvent.address(), this.address(), SIZEOF);
        return this;
    }

    public static XGenericEvent malloc() {
        return new XGenericEvent(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XGenericEvent calloc() {
        return new XGenericEvent(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XGenericEvent create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new XGenericEvent(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static XGenericEvent create(long l2) {
        return new XGenericEvent(l2, null);
    }

    public static XGenericEvent createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new XGenericEvent(l2, null);
    }

    public static XGenericEvent$Buffer malloc(int n2) {
        return new XGenericEvent$Buffer(MemoryUtil.nmemAllocChecked(XGenericEvent.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static XGenericEvent$Buffer calloc(int n2) {
        return new XGenericEvent$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static XGenericEvent$Buffer create(int n2) {
        ByteBuffer byteBuffer = XGenericEvent.__create(n2, SIZEOF);
        int n3 = n2;
        return new XGenericEvent$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static XGenericEvent$Buffer create(long l2, int n2) {
        return new XGenericEvent$Buffer(l2, n2);
    }

    public static XGenericEvent$Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new XGenericEvent$Buffer(l2, n2);
    }

    public static XGenericEvent mallocStack() {
        return XGenericEvent.malloc(MemoryStack.stackGet());
    }

    public static XGenericEvent callocStack() {
        return XGenericEvent.calloc(MemoryStack.stackGet());
    }

    public static XGenericEvent mallocStack(MemoryStack memoryStack) {
        return XGenericEvent.malloc(memoryStack);
    }

    public static XGenericEvent callocStack(MemoryStack memoryStack) {
        return XGenericEvent.calloc(memoryStack);
    }

    public static XGenericEvent$Buffer mallocStack(int n2) {
        return XGenericEvent.malloc(n2, MemoryStack.stackGet());
    }

    public static XGenericEvent$Buffer callocStack(int n2) {
        return XGenericEvent.calloc(n2, MemoryStack.stackGet());
    }

    public static XGenericEvent$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return XGenericEvent.malloc(n2, memoryStack);
    }

    public static XGenericEvent$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return XGenericEvent.calloc(n2, memoryStack);
    }

    public static XGenericEvent malloc(MemoryStack memoryStack) {
        return new XGenericEvent(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XGenericEvent calloc(MemoryStack memoryStack) {
        return new XGenericEvent(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static XGenericEvent$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new XGenericEvent$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static XGenericEvent$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new XGenericEvent$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int ntype(long l2) {
        return UNSAFE.getInt(null, l2 + (long)TYPE);
    }

    public static long nserial(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)SERIAL);
    }

    public static int nsend_event(long l2) {
        return UNSAFE.getInt(null, l2 + (long)SEND_EVENT);
    }

    public static long ndisplay(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)DISPLAY);
    }

    public static int nextension(long l2) {
        return UNSAFE.getInt(null, l2 + (long)EXTENSION);
    }

    public static int nevtype(long l2) {
        return UNSAFE.getInt(null, l2 + (long)EVTYPE);
    }

    public static void ntype(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)TYPE, n2);
    }

    public static void nserial(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)SERIAL, l3);
    }

    public static void nsend_event(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)SEND_EVENT, n2);
    }

    public static void ndisplay(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)DISPLAY, Checks.check(l3));
    }

    public static void nextension(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)EXTENSION, n2);
    }

    public static void nevtype(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)EVTYPE, n2);
    }

    public static void validate(long l2) {
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)DISPLAY));
    }

    static {
        Struct$Layout struct$Layout = XGenericEvent.__struct(XGenericEvent.__member(4), XGenericEvent.__member(CLONG_SIZE), XGenericEvent.__member(4), XGenericEvent.__member(POINTER_SIZE), XGenericEvent.__member(4), XGenericEvent.__member(4));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        TYPE = struct$Layout.offsetof(0);
        SERIAL = struct$Layout.offsetof(1);
        SEND_EVENT = struct$Layout.offsetof(2);
        DISPLAY = struct$Layout.offsetof(3);
        EXTENSION = struct$Layout.offsetof(4);
        EVTYPE = struct$Layout.offsetof(5);
    }
}

