/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.function.Consumer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.Statx$Buffer;
import org.lwjgl.system.linux.StatxTimestamp;

public class Statx
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STX_MASK;
    public static final int STX_BLKSIZE;
    public static final int STX_ATTRIBUTES;
    public static final int STX_NLINK;
    public static final int STX_UID;
    public static final int STX_GID;
    public static final int STX_MODE;
    public static final int __SPARE0;
    public static final int STX_INO;
    public static final int STX_SIZE;
    public static final int STX_BLOCKS;
    public static final int STX_ATTRIBUTES_MASK;
    public static final int STX_ATIME;
    public static final int STX_BTIME;
    public static final int STX_CTIME;
    public static final int STX_MTIME;
    public static final int STX_RDEV_MAJOR;
    public static final int STX_RDEV_MINOR;
    public static final int STX_DEV_MAJOR;
    public static final int STX_DEV_MINOR;
    public static final int STX_MNT_ID;
    public static final int __SPARE2;
    public static final int __SPARE3;

    protected Statx(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected Statx create(long l2, ByteBuffer byteBuffer) {
        return new Statx(l2, byteBuffer);
    }

    public Statx(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), Statx.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int stx_mask() {
        return Statx.nstx_mask(this.address());
    }

    public int stx_blksize() {
        return Statx.nstx_blksize(this.address());
    }

    public long stx_attributes() {
        return Statx.nstx_attributes(this.address());
    }

    public int stx_nlink() {
        return Statx.nstx_nlink(this.address());
    }

    public int stx_uid() {
        return Statx.nstx_uid(this.address());
    }

    public int stx_gid() {
        return Statx.nstx_gid(this.address());
    }

    public short stx_mode() {
        return Statx.nstx_mode(this.address());
    }

    public long stx_ino() {
        return Statx.nstx_ino(this.address());
    }

    public long stx_size() {
        return Statx.nstx_size(this.address());
    }

    public long stx_blocks() {
        return Statx.nstx_blocks(this.address());
    }

    public long stx_attributes_mask() {
        return Statx.nstx_attributes_mask(this.address());
    }

    public StatxTimestamp stx_atime() {
        return Statx.nstx_atime(this.address());
    }

    public StatxTimestamp stx_btime() {
        return Statx.nstx_btime(this.address());
    }

    public StatxTimestamp stx_ctime() {
        return Statx.nstx_ctime(this.address());
    }

    public StatxTimestamp stx_mtime() {
        return Statx.nstx_mtime(this.address());
    }

    public int stx_rdev_major() {
        return Statx.nstx_rdev_major(this.address());
    }

    public int stx_rdev_minor() {
        return Statx.nstx_rdev_minor(this.address());
    }

    public int stx_dev_major() {
        return Statx.nstx_dev_major(this.address());
    }

    public int stx_dev_minor() {
        return Statx.nstx_dev_minor(this.address());
    }

    public long stx_mnt_id() {
        return Statx.nstx_mnt_id(this.address());
    }

    public Statx stx_mask(int n2) {
        Statx.nstx_mask(this.address(), n2);
        return this;
    }

    public Statx stx_blksize(int n2) {
        Statx.nstx_blksize(this.address(), n2);
        return this;
    }

    public Statx stx_attributes(long l2) {
        Statx.nstx_attributes(this.address(), l2);
        return this;
    }

    public Statx stx_nlink(int n2) {
        Statx.nstx_nlink(this.address(), n2);
        return this;
    }

    public Statx stx_uid(int n2) {
        Statx.nstx_uid(this.address(), n2);
        return this;
    }

    public Statx stx_gid(int n2) {
        Statx.nstx_gid(this.address(), n2);
        return this;
    }

    public Statx stx_mode(short s2) {
        Statx.nstx_mode(this.address(), s2);
        return this;
    }

    public Statx stx_ino(long l2) {
        Statx.nstx_ino(this.address(), l2);
        return this;
    }

    public Statx stx_size(long l2) {
        Statx.nstx_size(this.address(), l2);
        return this;
    }

    public Statx stx_blocks(long l2) {
        Statx.nstx_blocks(this.address(), l2);
        return this;
    }

    public Statx stx_attributes_mask(long l2) {
        Statx.nstx_attributes_mask(this.address(), l2);
        return this;
    }

    public Statx stx_atime(StatxTimestamp statxTimestamp) {
        Statx.nstx_atime(this.address(), statxTimestamp);
        return this;
    }

    public Statx stx_atime(Consumer consumer) {
        consumer.accept(this.stx_atime());
        return this;
    }

    public Statx stx_btime(StatxTimestamp statxTimestamp) {
        Statx.nstx_btime(this.address(), statxTimestamp);
        return this;
    }

    public Statx stx_btime(Consumer consumer) {
        consumer.accept(this.stx_btime());
        return this;
    }

    public Statx stx_ctime(StatxTimestamp statxTimestamp) {
        Statx.nstx_ctime(this.address(), statxTimestamp);
        return this;
    }

    public Statx stx_ctime(Consumer consumer) {
        consumer.accept(this.stx_ctime());
        return this;
    }

    public Statx stx_mtime(StatxTimestamp statxTimestamp) {
        Statx.nstx_mtime(this.address(), statxTimestamp);
        return this;
    }

    public Statx stx_mtime(Consumer consumer) {
        consumer.accept(this.stx_mtime());
        return this;
    }

    public Statx stx_rdev_major(int n2) {
        Statx.nstx_rdev_major(this.address(), n2);
        return this;
    }

    public Statx stx_rdev_minor(int n2) {
        Statx.nstx_rdev_minor(this.address(), n2);
        return this;
    }

    public Statx stx_dev_major(int n2) {
        Statx.nstx_dev_major(this.address(), n2);
        return this;
    }

    public Statx stx_dev_minor(int n2) {
        Statx.nstx_dev_minor(this.address(), n2);
        return this;
    }

    public Statx stx_mnt_id(long l2) {
        Statx.nstx_mnt_id(this.address(), l2);
        return this;
    }

    public Statx set(int n2, int n3, long l2, int n4, int n5, int n6, short s2, long l3, long l4, long l5, long l6, StatxTimestamp statxTimestamp, StatxTimestamp statxTimestamp2, StatxTimestamp statxTimestamp3, StatxTimestamp statxTimestamp4, int n7, int n8, int n9, int n10, long l7) {
        this.stx_mask(n2);
        this.stx_blksize(n3);
        this.stx_attributes(l2);
        this.stx_nlink(n4);
        this.stx_uid(n5);
        this.stx_gid(n6);
        this.stx_mode(s2);
        this.stx_ino(l3);
        this.stx_size(l4);
        this.stx_blocks(l5);
        this.stx_attributes_mask(l6);
        this.stx_atime(statxTimestamp);
        this.stx_btime(statxTimestamp2);
        this.stx_ctime(statxTimestamp3);
        this.stx_mtime(statxTimestamp4);
        this.stx_rdev_major(n7);
        this.stx_rdev_minor(n8);
        this.stx_dev_major(n9);
        this.stx_dev_minor(n10);
        this.stx_mnt_id(l7);
        return this;
    }

    public Statx set(Statx statx) {
        MemoryUtil.memCopy(statx.address(), this.address(), SIZEOF);
        return this;
    }

    public static Statx malloc() {
        return new Statx(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static Statx calloc() {
        return new Statx(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static Statx create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new Statx(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static Statx create(long l2) {
        return new Statx(l2, null);
    }

    public static Statx createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new Statx(l2, null);
    }

    public static Statx$Buffer malloc(int n2) {
        return new Statx$Buffer(MemoryUtil.nmemAllocChecked(Statx.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static Statx$Buffer calloc(int n2) {
        return new Statx$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static Statx$Buffer create(int n2) {
        ByteBuffer byteBuffer = Statx.__create(n2, SIZEOF);
        int n3 = n2;
        return new Statx$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static Statx$Buffer create(long l2, int n2) {
        return new Statx$Buffer(l2, n2);
    }

    public static Statx$Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new Statx$Buffer(l2, n2);
    }

    public static Statx malloc(MemoryStack memoryStack) {
        return new Statx(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static Statx calloc(MemoryStack memoryStack) {
        return new Statx(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Statx$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new Statx$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static Statx$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new Statx$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int nstx_mask(long l2) {
        return UNSAFE.getInt(null, l2 + (long)STX_MASK);
    }

    public static int nstx_blksize(long l2) {
        return UNSAFE.getInt(null, l2 + (long)STX_BLKSIZE);
    }

    public static long nstx_attributes(long l2) {
        return UNSAFE.getLong(null, l2 + (long)STX_ATTRIBUTES);
    }

    public static int nstx_nlink(long l2) {
        return UNSAFE.getInt(null, l2 + (long)STX_NLINK);
    }

    public static int nstx_uid(long l2) {
        return UNSAFE.getInt(null, l2 + (long)STX_UID);
    }

    public static int nstx_gid(long l2) {
        return UNSAFE.getInt(null, l2 + (long)STX_GID);
    }

    public static short nstx_mode(long l2) {
        return UNSAFE.getShort(null, l2 + (long)STX_MODE);
    }

    public static ShortBuffer n__spare0(long l2) {
        return MemoryUtil.memShortBuffer(l2 + (long)__SPARE0, 1);
    }

    public static short n__spare0(long l2, int n2) {
        return UNSAFE.getShort(null, l2 + (long)__SPARE0 + (Checks.check(n2, 1) << 1));
    }

    public static long nstx_ino(long l2) {
        return UNSAFE.getLong(null, l2 + (long)STX_INO);
    }

    public static long nstx_size(long l2) {
        return UNSAFE.getLong(null, l2 + (long)STX_SIZE);
    }

    public static long nstx_blocks(long l2) {
        return UNSAFE.getLong(null, l2 + (long)STX_BLOCKS);
    }

    public static long nstx_attributes_mask(long l2) {
        return UNSAFE.getLong(null, l2 + (long)STX_ATTRIBUTES_MASK);
    }

    public static StatxTimestamp nstx_atime(long l2) {
        return StatxTimestamp.create(l2 + (long)STX_ATIME);
    }

    public static StatxTimestamp nstx_btime(long l2) {
        return StatxTimestamp.create(l2 + (long)STX_BTIME);
    }

    public static StatxTimestamp nstx_ctime(long l2) {
        return StatxTimestamp.create(l2 + (long)STX_CTIME);
    }

    public static StatxTimestamp nstx_mtime(long l2) {
        return StatxTimestamp.create(l2 + (long)STX_MTIME);
    }

    public static int nstx_rdev_major(long l2) {
        return UNSAFE.getInt(null, l2 + (long)STX_RDEV_MAJOR);
    }

    public static int nstx_rdev_minor(long l2) {
        return UNSAFE.getInt(null, l2 + (long)STX_RDEV_MINOR);
    }

    public static int nstx_dev_major(long l2) {
        return UNSAFE.getInt(null, l2 + (long)STX_DEV_MAJOR);
    }

    public static int nstx_dev_minor(long l2) {
        return UNSAFE.getInt(null, l2 + (long)STX_DEV_MINOR);
    }

    public static long nstx_mnt_id(long l2) {
        return UNSAFE.getLong(null, l2 + (long)STX_MNT_ID);
    }

    public static long n__spare2(long l2) {
        return UNSAFE.getLong(null, l2 + (long)__SPARE2);
    }

    public static LongBuffer n__spare3(long l2) {
        return MemoryUtil.memLongBuffer(l2 + (long)__SPARE3, 12);
    }

    public static long n__spare3(long l2, int n2) {
        return UNSAFE.getLong(null, l2 + (long)__SPARE3 + (Checks.check(n2, 12) << 3));
    }

    public static void nstx_mask(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)STX_MASK, n2);
    }

    public static void nstx_blksize(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)STX_BLKSIZE, n2);
    }

    public static void nstx_attributes(long l2, long l3) {
        UNSAFE.putLong(null, l2 + (long)STX_ATTRIBUTES, l3);
    }

    public static void nstx_nlink(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)STX_NLINK, n2);
    }

    public static void nstx_uid(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)STX_UID, n2);
    }

    public static void nstx_gid(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)STX_GID, n2);
    }

    public static void nstx_mode(long l2, short s2) {
        UNSAFE.putShort(null, l2 + (long)STX_MODE, s2);
    }

    public static void n__spare0(long l2, ShortBuffer shortBuffer) {
        if (Checks.CHECKS) {
            Checks.checkGT(shortBuffer, 1);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(shortBuffer), l2 + (long)__SPARE0, shortBuffer.remaining() << 1);
    }

    public static void n__spare0(long l2, int n2, short s2) {
        UNSAFE.putShort(null, l2 + (long)__SPARE0 + (Checks.check(n2, 1) << 1), s2);
    }

    public static void nstx_ino(long l2, long l3) {
        UNSAFE.putLong(null, l2 + (long)STX_INO, l3);
    }

    public static void nstx_size(long l2, long l3) {
        UNSAFE.putLong(null, l2 + (long)STX_SIZE, l3);
    }

    public static void nstx_blocks(long l2, long l3) {
        UNSAFE.putLong(null, l2 + (long)STX_BLOCKS, l3);
    }

    public static void nstx_attributes_mask(long l2, long l3) {
        UNSAFE.putLong(null, l2 + (long)STX_ATTRIBUTES_MASK, l3);
    }

    public static void nstx_atime(long l2, StatxTimestamp statxTimestamp) {
        MemoryUtil.memCopy(statxTimestamp.address(), l2 + (long)STX_ATIME, StatxTimestamp.SIZEOF);
    }

    public static void nstx_btime(long l2, StatxTimestamp statxTimestamp) {
        MemoryUtil.memCopy(statxTimestamp.address(), l2 + (long)STX_BTIME, StatxTimestamp.SIZEOF);
    }

    public static void nstx_ctime(long l2, StatxTimestamp statxTimestamp) {
        MemoryUtil.memCopy(statxTimestamp.address(), l2 + (long)STX_CTIME, StatxTimestamp.SIZEOF);
    }

    public static void nstx_mtime(long l2, StatxTimestamp statxTimestamp) {
        MemoryUtil.memCopy(statxTimestamp.address(), l2 + (long)STX_MTIME, StatxTimestamp.SIZEOF);
    }

    public static void nstx_rdev_major(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)STX_RDEV_MAJOR, n2);
    }

    public static void nstx_rdev_minor(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)STX_RDEV_MINOR, n2);
    }

    public static void nstx_dev_major(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)STX_DEV_MAJOR, n2);
    }

    public static void nstx_dev_minor(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)STX_DEV_MINOR, n2);
    }

    public static void nstx_mnt_id(long l2, long l3) {
        UNSAFE.putLong(null, l2 + (long)STX_MNT_ID, l3);
    }

    public static void n__spare2(long l2, long l3) {
        UNSAFE.putLong(null, l2 + (long)__SPARE2, l3);
    }

    public static void n__spare3(long l2, LongBuffer longBuffer) {
        if (Checks.CHECKS) {
            Checks.checkGT(longBuffer, 12);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(longBuffer), l2 + (long)__SPARE3, longBuffer.remaining() << 3);
    }

    public static void n__spare3(long l2, int n2, long l3) {
        UNSAFE.putLong(null, l2 + (long)__SPARE3 + (Checks.check(n2, 12) << 3), l3);
    }

    static {
        Struct$Layout struct$Layout = Statx.__struct(Statx.__member(4), Statx.__member(4), Statx.__member(8), Statx.__member(4), Statx.__member(4), Statx.__member(4), Statx.__member(2), Statx.__array(2, 1), Statx.__member(8), Statx.__member(8), Statx.__member(8), Statx.__member(8), Statx.__member(StatxTimestamp.SIZEOF, StatxTimestamp.ALIGNOF), Statx.__member(StatxTimestamp.SIZEOF, StatxTimestamp.ALIGNOF), Statx.__member(StatxTimestamp.SIZEOF, StatxTimestamp.ALIGNOF), Statx.__member(StatxTimestamp.SIZEOF, StatxTimestamp.ALIGNOF), Statx.__member(4), Statx.__member(4), Statx.__member(4), Statx.__member(4), Statx.__member(8), Statx.__member(8), Statx.__array(8, 12));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        STX_MASK = struct$Layout.offsetof(0);
        STX_BLKSIZE = struct$Layout.offsetof(1);
        STX_ATTRIBUTES = struct$Layout.offsetof(2);
        STX_NLINK = struct$Layout.offsetof(3);
        STX_UID = struct$Layout.offsetof(4);
        STX_GID = struct$Layout.offsetof(5);
        STX_MODE = struct$Layout.offsetof(6);
        __SPARE0 = struct$Layout.offsetof(7);
        STX_INO = struct$Layout.offsetof(8);
        STX_SIZE = struct$Layout.offsetof(9);
        STX_BLOCKS = struct$Layout.offsetof(10);
        STX_ATTRIBUTES_MASK = struct$Layout.offsetof(11);
        STX_ATIME = struct$Layout.offsetof(12);
        STX_BTIME = struct$Layout.offsetof(13);
        STX_CTIME = struct$Layout.offsetof(14);
        STX_MTIME = struct$Layout.offsetof(15);
        STX_RDEV_MAJOR = struct$Layout.offsetof(16);
        STX_RDEV_MINOR = struct$Layout.offsetof(17);
        STX_DEV_MAJOR = struct$Layout.offsetof(18);
        STX_DEV_MINOR = struct$Layout.offsetof(19);
        STX_MNT_ID = struct$Layout.offsetof(20);
        __SPARE2 = struct$Layout.offsetof(21);
        __SPARE3 = struct$Layout.offsetof(22);
    }
}

