/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.OpenHow$Buffer;

public class OpenHow
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int MODE;
    public static final int RESOLVE;

    protected OpenHow(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected OpenHow create(long l2, ByteBuffer byteBuffer) {
        return new OpenHow(l2, byteBuffer);
    }

    public OpenHow(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), OpenHow.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long flags() {
        return OpenHow.nflags(this.address());
    }

    public long mode() {
        return OpenHow.nmode(this.address());
    }

    public long resolve() {
        return OpenHow.nresolve(this.address());
    }

    public OpenHow flags(long l2) {
        OpenHow.nflags(this.address(), l2);
        return this;
    }

    public OpenHow mode(long l2) {
        OpenHow.nmode(this.address(), l2);
        return this;
    }

    public OpenHow resolve(long l2) {
        OpenHow.nresolve(this.address(), l2);
        return this;
    }

    public OpenHow set(long l2, long l3, long l4) {
        this.flags(l2);
        this.mode(l3);
        this.resolve(l4);
        return this;
    }

    public OpenHow set(OpenHow openHow) {
        MemoryUtil.memCopy(openHow.address(), this.address(), SIZEOF);
        return this;
    }

    public static OpenHow malloc() {
        return new OpenHow(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static OpenHow calloc() {
        return new OpenHow(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static OpenHow create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new OpenHow(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static OpenHow create(long l2) {
        return new OpenHow(l2, null);
    }

    public static OpenHow createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new OpenHow(l2, null);
    }

    public static OpenHow$Buffer malloc(int n2) {
        return new OpenHow$Buffer(MemoryUtil.nmemAllocChecked(OpenHow.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static OpenHow$Buffer calloc(int n2) {
        return new OpenHow$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static OpenHow$Buffer create(int n2) {
        ByteBuffer byteBuffer = OpenHow.__create(n2, SIZEOF);
        int n3 = n2;
        return new OpenHow$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static OpenHow$Buffer create(long l2, int n2) {
        return new OpenHow$Buffer(l2, n2);
    }

    public static OpenHow$Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new OpenHow$Buffer(l2, n2);
    }

    public static OpenHow malloc(MemoryStack memoryStack) {
        return new OpenHow(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OpenHow calloc(MemoryStack memoryStack) {
        return new OpenHow(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static OpenHow$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new OpenHow$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static OpenHow$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new OpenHow$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static long nflags(long l2) {
        return UNSAFE.getLong(null, l2 + (long)FLAGS);
    }

    public static long nmode(long l2) {
        return UNSAFE.getLong(null, l2 + (long)MODE);
    }

    public static long nresolve(long l2) {
        return UNSAFE.getLong(null, l2 + (long)RESOLVE);
    }

    public static void nflags(long l2, long l3) {
        UNSAFE.putLong(null, l2 + (long)FLAGS, l3);
    }

    public static void nmode(long l2, long l3) {
        UNSAFE.putLong(null, l2 + (long)MODE, l3);
    }

    public static void nresolve(long l2, long l3) {
        UNSAFE.putLong(null, l2 + (long)RESOLVE, l3);
    }

    static {
        Struct$Layout struct$Layout = OpenHow.__struct(OpenHow.__member(8), OpenHow.__member(8), OpenHow.__member(8));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        FLAGS = struct$Layout.offsetof(0);
        MODE = struct$Layout.offsetof(1);
        RESOLVE = struct$Layout.offsetof(2);
    }
}

