/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.CMsghdr$Buffer;

public class CMsghdr
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CMSG_LEN;
    public static final int CMSG_LEVEL;
    public static final int CMSG_TYPE;
    public static final int CMSG_DATA;

    protected CMsghdr(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected CMsghdr create(long l2, ByteBuffer byteBuffer) {
        return new CMsghdr(l2, byteBuffer);
    }

    public CMsghdr(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), CMsghdr.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int cmsg_len() {
        return CMsghdr.ncmsg_len(this.address());
    }

    public int cmsg_level() {
        return CMsghdr.ncmsg_level(this.address());
    }

    public int cmsg_type() {
        return CMsghdr.ncmsg_type(this.address());
    }

    public ByteBuffer cmsg_data() {
        return CMsghdr.ncmsg_data(this.address());
    }

    public byte cmsg_data(int n2) {
        return CMsghdr.ncmsg_data(this.address(), n2);
    }

    public CMsghdr cmsg_len(int n2) {
        CMsghdr.ncmsg_len(this.address(), n2);
        return this;
    }

    public CMsghdr cmsg_level(int n2) {
        CMsghdr.ncmsg_level(this.address(), n2);
        return this;
    }

    public CMsghdr cmsg_type(int n2) {
        CMsghdr.ncmsg_type(this.address(), n2);
        return this;
    }

    public CMsghdr cmsg_data(ByteBuffer byteBuffer) {
        CMsghdr.ncmsg_data(this.address(), byteBuffer);
        return this;
    }

    public CMsghdr cmsg_data(int n2, byte by2) {
        CMsghdr.ncmsg_data(this.address(), n2, by2);
        return this;
    }

    public CMsghdr set(int n2, int n3, int n4, ByteBuffer byteBuffer) {
        this.cmsg_len(n2);
        this.cmsg_level(n3);
        this.cmsg_type(n4);
        this.cmsg_data(byteBuffer);
        return this;
    }

    public CMsghdr set(CMsghdr cMsghdr) {
        MemoryUtil.memCopy(cMsghdr.address(), this.address(), SIZEOF);
        return this;
    }

    public static CMsghdr malloc() {
        return new CMsghdr(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static CMsghdr calloc() {
        return new CMsghdr(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static CMsghdr create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new CMsghdr(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static CMsghdr create(long l2) {
        return new CMsghdr(l2, null);
    }

    public static CMsghdr createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new CMsghdr(l2, null);
    }

    public static CMsghdr$Buffer malloc(int n2) {
        return new CMsghdr$Buffer(MemoryUtil.nmemAllocChecked(CMsghdr.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static CMsghdr$Buffer calloc(int n2) {
        return new CMsghdr$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static CMsghdr$Buffer create(int n2) {
        ByteBuffer byteBuffer = CMsghdr.__create(n2, SIZEOF);
        int n3 = n2;
        return new CMsghdr$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static CMsghdr$Buffer create(long l2, int n2) {
        return new CMsghdr$Buffer(l2, n2);
    }

    public static CMsghdr$Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new CMsghdr$Buffer(l2, n2);
    }

    public static CMsghdr malloc(MemoryStack memoryStack) {
        return new CMsghdr(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CMsghdr calloc(MemoryStack memoryStack) {
        return new CMsghdr(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static CMsghdr$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new CMsghdr$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static CMsghdr$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new CMsghdr$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int ncmsg_len(long l2) {
        return UNSAFE.getInt(null, l2 + (long)CMSG_LEN);
    }

    public static int ncmsg_level(long l2) {
        return UNSAFE.getInt(null, l2 + (long)CMSG_LEVEL);
    }

    public static int ncmsg_type(long l2) {
        return UNSAFE.getInt(null, l2 + (long)CMSG_TYPE);
    }

    public static ByteBuffer ncmsg_data(long l2) {
        return MemoryUtil.memByteBuffer(l2 + (long)CMSG_DATA, 0);
    }

    public static byte ncmsg_data(long l2, int n2) {
        return UNSAFE.getByte(null, l2 + (long)CMSG_DATA + Checks.check(n2, 0));
    }

    public static void ncmsg_len(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)CMSG_LEN, n2);
    }

    public static void ncmsg_level(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)CMSG_LEVEL, n2);
    }

    public static void ncmsg_type(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)CMSG_TYPE, n2);
    }

    public static void ncmsg_data(long l2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkGT(byteBuffer, 0);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(byteBuffer), l2 + (long)CMSG_DATA, byteBuffer.remaining());
    }

    public static void ncmsg_data(long l2, int n2, byte by2) {
        UNSAFE.putByte(null, l2 + (long)CMSG_DATA + Checks.check(n2, 0), by2);
    }

    static {
        Struct$Layout struct$Layout = CMsghdr.__struct(CMsghdr.__member(4), CMsghdr.__member(4), CMsghdr.__member(4), CMsghdr.__array(1, 0));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        CMSG_LEN = struct$Layout.offsetof(0);
        CMSG_LEVEL = struct$Layout.offsetof(1);
        CMSG_TYPE = struct$Layout.offsetof(2);
        CMSG_DATA = struct$Layout.offsetof(3);
    }
}

