/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.libffi;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.libffi.FFIType$Buffer;

public class FFIType
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SIZE;
    public static final int ALIGNMENT;
    public static final int TYPE;
    public static final int ELEMENTS;

    protected FFIType(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected FFIType create(long l2, ByteBuffer byteBuffer) {
        return new FFIType(l2, byteBuffer);
    }

    public FFIType(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), FFIType.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long size() {
        return FFIType.nsize(this.address());
    }

    public short alignment() {
        return FFIType.nalignment(this.address());
    }

    public short type() {
        return FFIType.ntype(this.address());
    }

    public PointerBuffer elements(int n2) {
        return FFIType.nelements(this.address(), n2);
    }

    public FFIType size(long l2) {
        FFIType.nsize(this.address(), l2);
        return this;
    }

    public FFIType alignment(short s2) {
        FFIType.nalignment(this.address(), s2);
        return this;
    }

    public FFIType type(short s2) {
        FFIType.ntype(this.address(), s2);
        return this;
    }

    public FFIType elements(PointerBuffer pointerBuffer) {
        FFIType.nelements(this.address(), pointerBuffer);
        return this;
    }

    public FFIType set(long l2, short s2, short s3, PointerBuffer pointerBuffer) {
        this.size(l2);
        this.alignment(s2);
        this.type(s3);
        this.elements(pointerBuffer);
        return this;
    }

    public FFIType set(FFIType fFIType) {
        MemoryUtil.memCopy(fFIType.address(), this.address(), SIZEOF);
        return this;
    }

    public static FFIType malloc() {
        return new FFIType(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static FFIType calloc() {
        return new FFIType(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static FFIType create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new FFIType(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static FFIType create(long l2) {
        return new FFIType(l2, null);
    }

    public static FFIType createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new FFIType(l2, null);
    }

    public static FFIType$Buffer malloc(int n2) {
        return new FFIType$Buffer(MemoryUtil.nmemAllocChecked(FFIType.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static FFIType$Buffer calloc(int n2) {
        return new FFIType$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static FFIType$Buffer create(int n2) {
        ByteBuffer byteBuffer = FFIType.__create(n2, SIZEOF);
        int n3 = n2;
        return new FFIType$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static FFIType$Buffer create(long l2, int n2) {
        return new FFIType$Buffer(l2, n2);
    }

    public static FFIType$Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new FFIType$Buffer(l2, n2);
    }

    public static FFIType malloc(MemoryStack memoryStack) {
        return new FFIType(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static FFIType calloc(MemoryStack memoryStack) {
        return new FFIType(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static FFIType$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new FFIType$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static FFIType$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new FFIType$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static long nsize(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)SIZE);
    }

    public static short nalignment(long l2) {
        return UNSAFE.getShort(null, l2 + (long)ALIGNMENT);
    }

    public static short ntype(long l2) {
        return UNSAFE.getShort(null, l2 + (long)TYPE);
    }

    public static PointerBuffer nelements(long l2, int n2) {
        return MemoryUtil.memPointerBufferSafe(MemoryUtil.memGetAddress(l2 + (long)ELEMENTS), n2);
    }

    public static void nsize(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)SIZE, l3);
    }

    public static void nalignment(long l2, short s2) {
        UNSAFE.putShort(null, l2 + (long)ALIGNMENT, s2);
    }

    public static void ntype(long l2, short s2) {
        UNSAFE.putShort(null, l2 + (long)TYPE, s2);
    }

    public static void nelements(long l2, PointerBuffer pointerBuffer) {
        MemoryUtil.memPutAddress(l2 + (long)ELEMENTS, MemoryUtil.memAddressSafe(pointerBuffer));
    }

    static {
        Struct$Layout struct$Layout = FFIType.__struct(FFIType.__member(POINTER_SIZE), FFIType.__member(2), FFIType.__member(2), FFIType.__member(POINTER_SIZE));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        SIZE = struct$Layout.offsetof(0);
        ALIGNMENT = struct$Layout.offsetof(1);
        TYPE = struct$Layout.offsetof(2);
        ELEMENTS = struct$Layout.offsetof(3);
    }
}

