/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.jni;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer$Default;
import org.lwjgl.system.Struct;
import org.lwjgl.system.jni.JNINativeMethod;
import org.lwjgl.system.jni.JNINativeMethod$Buffer;

public class JNINativeInterface {
    public static final int JNI_VERSION_1_1 = 65537;
    public static final int JNI_VERSION_1_2 = 65538;
    public static final int JNI_VERSION_1_4 = 65540;
    public static final int JNI_VERSION_1_6 = 65542;
    public static final int JNI_VERSION_1_8 = 65544;
    public static final int JNI_VERSION_9 = 589824;
    public static final int JNI_VERSION_10 = 655360;
    public static final int JNI_VERSION_19 = 0x130000;
    public static final int JNI_VERSION_20 = 0x140000;
    public static final int JNI_VERSION_21 = 0x150000;
    public static final int JNIInvalidRefType = 0;
    public static final int JNILocalRefType = 1;
    public static final int JNIGlobalRefType = 2;
    public static final int JNIWeakGlobalRefType = 3;
    public static final int JNI_FALSE = 0;
    public static final int JNI_TRUE = 1;
    public static final int JNI_OK = 0;
    public static final int JNI_ERR = -1;
    public static final int JNI_EDETACHED = -2;
    public static final int JNI_EVERSION = -3;
    public static final int JNI_ENOMEM = -4;
    public static final int JNI_EEXIST = -5;
    public static final int JNI_EINVAL = -6;
    public static final int JNI_COMMIT = 1;
    public static final int JNI_ABORT = 2;

    protected JNINativeInterface() {
        throw new UnsupportedOperationException();
    }

    public static native int GetVersion();

    public static native long FromReflectedMethod(Method var0);

    public static native long FromReflectedField(Field var0);

    public static native Method nToReflectedMethod(Class var0, long var1, boolean var3);

    public static Method ToReflectedMethod(Class clazz, long l2, boolean bl2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNINativeInterface.nToReflectedMethod(clazz, l2, bl2);
    }

    public static native Field nToReflectedField(Class var0, long var1, boolean var3);

    public static Field ToReflectedField(Class clazz, long l2, boolean bl2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNINativeInterface.nToReflectedField(clazz, l2, bl2);
    }

    public static native long NewGlobalRef(Object var0);

    public static native void nDeleteGlobalRef(long var0);

    public static void DeleteGlobalRef(long l2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNINativeInterface.nDeleteGlobalRef(l2);
    }

    public static native long nGetBooleanArrayElements(byte[] var0, long var1);

    public static ByteBuffer GetBooleanArrayElements(byte[] byArray, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)byteBuffer, 1);
        }
        return MemoryUtil.memByteBufferSafe(JNINativeInterface.nGetBooleanArrayElements(byArray, MemoryUtil.memAddressSafe(byteBuffer)), byArray.length);
    }

    public static native void nReleaseBooleanArrayElements(byte[] var0, long var1, int var3);

    public static void ReleaseBooleanArrayElements(byte[] byArray, ByteBuffer byteBuffer, int n2) {
        JNINativeInterface.nReleaseBooleanArrayElements(byArray, MemoryUtil.memAddress(byteBuffer), n2);
    }

    public static native long nGetByteArrayElements(byte[] var0, long var1);

    public static ByteBuffer GetByteArrayElements(byte[] byArray, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)byteBuffer, 1);
        }
        return MemoryUtil.memByteBufferSafe(JNINativeInterface.nGetByteArrayElements(byArray, MemoryUtil.memAddressSafe(byteBuffer)), byArray.length);
    }

    public static native void nReleaseByteArrayElements(byte[] var0, long var1, int var3);

    public static void ReleaseByteArrayElements(byte[] byArray, ByteBuffer byteBuffer, int n2) {
        JNINativeInterface.nReleaseByteArrayElements(byArray, MemoryUtil.memAddress(byteBuffer), n2);
    }

    public static native long nGetCharArrayElements(char[] var0, long var1);

    public static ShortBuffer GetCharArrayElements(char[] cArray, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)byteBuffer, 1);
        }
        return MemoryUtil.memShortBufferSafe(JNINativeInterface.nGetCharArrayElements(cArray, MemoryUtil.memAddressSafe(byteBuffer)), cArray.length);
    }

    public static native void nReleaseCharArrayElements(char[] var0, long var1, int var3);

    public static void ReleaseCharArrayElements(char[] cArray, ShortBuffer shortBuffer, int n2) {
        JNINativeInterface.nReleaseCharArrayElements(cArray, MemoryUtil.memAddress(shortBuffer), n2);
    }

    public static native long nGetShortArrayElements(short[] var0, long var1);

    public static ShortBuffer GetShortArrayElements(short[] sArray, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)byteBuffer, 1);
        }
        return MemoryUtil.memShortBufferSafe(JNINativeInterface.nGetShortArrayElements(sArray, MemoryUtil.memAddressSafe(byteBuffer)), sArray.length);
    }

    public static native void nReleaseShortArrayElements(short[] var0, long var1, int var3);

    public static void ReleaseShortArrayElements(short[] sArray, ShortBuffer shortBuffer, int n2) {
        JNINativeInterface.nReleaseShortArrayElements(sArray, MemoryUtil.memAddress(shortBuffer), n2);
    }

    public static native long nGetIntArrayElements(int[] var0, long var1);

    public static IntBuffer GetIntArrayElements(int[] nArray, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)byteBuffer, 1);
        }
        return MemoryUtil.memIntBufferSafe(JNINativeInterface.nGetIntArrayElements(nArray, MemoryUtil.memAddressSafe(byteBuffer)), nArray.length);
    }

    public static native void nReleaseIntArrayElements(int[] var0, long var1, int var3);

    public static void ReleaseIntArrayElements(int[] nArray, IntBuffer intBuffer, int n2) {
        JNINativeInterface.nReleaseIntArrayElements(nArray, MemoryUtil.memAddress(intBuffer), n2);
    }

    public static native long nGetLongArrayElements(long[] var0, long var1);

    public static LongBuffer GetLongArrayElements(long[] lArray, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)byteBuffer, 1);
        }
        return MemoryUtil.memLongBufferSafe(JNINativeInterface.nGetLongArrayElements(lArray, MemoryUtil.memAddressSafe(byteBuffer)), lArray.length);
    }

    public static native void nReleaseLongArrayElements(long[] var0, long var1, int var3);

    public static void ReleaseLongArrayElements(long[] lArray, LongBuffer longBuffer, int n2) {
        JNINativeInterface.nReleaseLongArrayElements(lArray, MemoryUtil.memAddress(longBuffer), n2);
    }

    public static native long nGetFloatArrayElements(float[] var0, long var1);

    public static FloatBuffer GetFloatArrayElements(float[] fArray, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)byteBuffer, 1);
        }
        return MemoryUtil.memFloatBufferSafe(JNINativeInterface.nGetFloatArrayElements(fArray, MemoryUtil.memAddressSafe(byteBuffer)), fArray.length);
    }

    public static native void nReleaseFloatArrayElements(float[] var0, long var1, int var3);

    public static void ReleaseFloatArrayElements(float[] fArray, FloatBuffer floatBuffer, int n2) {
        JNINativeInterface.nReleaseFloatArrayElements(fArray, MemoryUtil.memAddress(floatBuffer), n2);
    }

    public static native long nGetDoubleArrayElements(double[] var0, long var1);

    public static DoubleBuffer GetDoubleArrayElements(double[] dArray, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)byteBuffer, 1);
        }
        return MemoryUtil.memDoubleBufferSafe(JNINativeInterface.nGetDoubleArrayElements(dArray, MemoryUtil.memAddressSafe(byteBuffer)), dArray.length);
    }

    public static native void nReleaseDoubleArrayElements(double[] var0, long var1, int var3);

    public static void ReleaseDoubleArrayElements(double[] dArray, DoubleBuffer doubleBuffer, int n2) {
        JNINativeInterface.nReleaseDoubleArrayElements(dArray, MemoryUtil.memAddress(doubleBuffer), n2);
    }

    public static native void nGetBooleanArrayRegion(byte[] var0, int var1, int var2, long var3);

    public static void GetBooleanArrayRegion(byte[] byArray, int n2, ByteBuffer byteBuffer) {
        JNINativeInterface.nGetBooleanArrayRegion(byArray, n2, byteBuffer.remaining(), MemoryUtil.memAddress(byteBuffer));
    }

    public static native void nSetBooleanArrayRegion(byte[] var0, int var1, int var2, long var3);

    public static void SetBooleanArrayRegion(byte[] byArray, int n2, ByteBuffer byteBuffer) {
        JNINativeInterface.nSetBooleanArrayRegion(byArray, n2, byteBuffer.remaining(), MemoryUtil.memAddress(byteBuffer));
    }

    public static native void nGetByteArrayRegion(byte[] var0, int var1, int var2, long var3);

    public static void GetByteArrayRegion(byte[] byArray, int n2, ByteBuffer byteBuffer) {
        JNINativeInterface.nGetByteArrayRegion(byArray, n2, byteBuffer.remaining(), MemoryUtil.memAddress(byteBuffer));
    }

    public static native void nSetByteArrayRegion(byte[] var0, int var1, int var2, long var3);

    public static void SetByteArrayRegion(byte[] byArray, int n2, ByteBuffer byteBuffer) {
        JNINativeInterface.nSetByteArrayRegion(byArray, n2, byteBuffer.remaining(), MemoryUtil.memAddress(byteBuffer));
    }

    public static native void nGetCharArrayRegion(char[] var0, int var1, int var2, long var3);

    public static void GetCharArrayRegion(char[] cArray, int n2, ShortBuffer shortBuffer) {
        JNINativeInterface.nGetCharArrayRegion(cArray, n2, shortBuffer.remaining(), MemoryUtil.memAddress(shortBuffer));
    }

    public static native void nSetCharArrayRegion(char[] var0, int var1, int var2, long var3);

    public static void SetCharArrayRegion(char[] cArray, int n2, ShortBuffer shortBuffer) {
        JNINativeInterface.nSetCharArrayRegion(cArray, n2, shortBuffer.remaining(), MemoryUtil.memAddress(shortBuffer));
    }

    public static native void nGetShortArrayRegion(short[] var0, int var1, int var2, long var3);

    public static void GetShortArrayRegion(short[] sArray, int n2, ShortBuffer shortBuffer) {
        JNINativeInterface.nGetShortArrayRegion(sArray, n2, shortBuffer.remaining(), MemoryUtil.memAddress(shortBuffer));
    }

    public static native void nSetShortArrayRegion(short[] var0, int var1, int var2, long var3);

    public static void SetShortArrayRegion(short[] sArray, int n2, ShortBuffer shortBuffer) {
        JNINativeInterface.nSetShortArrayRegion(sArray, n2, shortBuffer.remaining(), MemoryUtil.memAddress(shortBuffer));
    }

    public static native void nGetIntArrayRegion(int[] var0, int var1, int var2, long var3);

    public static void GetIntArrayRegion(int[] nArray, int n2, IntBuffer intBuffer) {
        JNINativeInterface.nGetIntArrayRegion(nArray, n2, intBuffer.remaining(), MemoryUtil.memAddress(intBuffer));
    }

    public static native void nSetIntArrayRegion(int[] var0, int var1, int var2, long var3);

    public static void SetIntArrayRegion(int[] nArray, int n2, IntBuffer intBuffer) {
        JNINativeInterface.nSetIntArrayRegion(nArray, n2, intBuffer.remaining(), MemoryUtil.memAddress(intBuffer));
    }

    public static native void nGetLongArrayRegion(long[] var0, int var1, int var2, long var3);

    public static void GetLongArrayRegion(long[] lArray, int n2, LongBuffer longBuffer) {
        JNINativeInterface.nGetLongArrayRegion(lArray, n2, longBuffer.remaining(), MemoryUtil.memAddress(longBuffer));
    }

    public static native void nSetLongArrayRegion(long[] var0, int var1, int var2, long var3);

    public static void SetLongArrayRegion(long[] lArray, int n2, LongBuffer longBuffer) {
        JNINativeInterface.nSetLongArrayRegion(lArray, n2, longBuffer.remaining(), MemoryUtil.memAddress(longBuffer));
    }

    public static native void nGetFloatArrayRegion(float[] var0, int var1, int var2, long var3);

    public static void GetFloatArrayRegion(float[] fArray, int n2, FloatBuffer floatBuffer) {
        JNINativeInterface.nGetFloatArrayRegion(fArray, n2, floatBuffer.remaining(), MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nSetFloatArrayRegion(float[] var0, int var1, int var2, long var3);

    public static void SetFloatArrayRegion(float[] fArray, int n2, FloatBuffer floatBuffer) {
        JNINativeInterface.nSetFloatArrayRegion(fArray, n2, floatBuffer.remaining(), MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nGetDoubleArrayRegion(double[] var0, int var1, int var2, long var3);

    public static void GetDoubleArrayRegion(double[] dArray, int n2, DoubleBuffer doubleBuffer) {
        JNINativeInterface.nGetDoubleArrayRegion(dArray, n2, doubleBuffer.remaining(), MemoryUtil.memAddress(doubleBuffer));
    }

    public static native void nSetDoubleArrayRegion(double[] var0, int var1, int var2, long var3);

    public static void SetDoubleArrayRegion(double[] dArray, int n2, DoubleBuffer doubleBuffer) {
        JNINativeInterface.nSetDoubleArrayRegion(dArray, n2, doubleBuffer.remaining(), MemoryUtil.memAddress(doubleBuffer));
    }

    public static native int nRegisterNatives(Class var0, long var1, int var3);

    public static int RegisterNatives(Class clazz, JNINativeMethod$Buffer jNINativeMethod$Buffer) {
        if (Checks.CHECKS) {
            Struct.validate(((Pointer$Default)jNINativeMethod$Buffer).address(), jNINativeMethod$Buffer.remaining(), JNINativeMethod.SIZEOF, JNINativeMethod::validate);
        }
        return JNINativeInterface.nRegisterNatives(clazz, ((Pointer$Default)jNINativeMethod$Buffer).address(), jNINativeMethod$Buffer.remaining());
    }

    public static native int UnregisterNatives(Class var0);

    public static native int nGetJavaVM(long var0);

    public static int GetJavaVM(PointerBuffer pointerBuffer) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pointerBuffer, 1);
        }
        return JNINativeInterface.nGetJavaVM(MemoryUtil.memAddress(pointerBuffer));
    }

    public static native void nGetStringRegion(String var0, int var1, int var2, long var3);

    public static void GetStringRegion(String string, int n2, ByteBuffer byteBuffer) {
        JNINativeInterface.nGetStringRegion(string, n2, byteBuffer.remaining() >> 1, MemoryUtil.memAddress(byteBuffer));
    }

    public static native void nGetStringUTFRegion(String var0, int var1, int var2, long var3);

    public static void GetStringUTFRegion(String string, int n2, int n3, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)byteBuffer, n3);
        }
        JNINativeInterface.nGetStringUTFRegion(string, n2, n3, MemoryUtil.memAddress(byteBuffer));
    }

    public static native long NewWeakGlobalRef(Object var0);

    public static native void nDeleteWeakGlobalRef(long var0);

    public static void DeleteWeakGlobalRef(long l2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNINativeInterface.nDeleteWeakGlobalRef(l2);
    }

    public static native ByteBuffer nNewDirectByteBuffer(long var0, long var2);

    public static ByteBuffer NewDirectByteBuffer(long l2, long l3) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNINativeInterface.nNewDirectByteBuffer(l2, l3);
    }

    public static native long GetDirectBufferAddress(Buffer var0);

    public static native int GetObjectRefType(Object var0);

    public static native void noop();

    static {
        Library.initialize();
    }
}

