/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.jemalloc;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Platform;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.jemalloc.JEmalloc$Functions;
import org.lwjgl.system.jemalloc.MallocMessageCallbackI;

public class JEmalloc {
    private static final SharedLibrary JEMALLOC = Library.loadNative(JEmalloc.class, "org.lwjgl.jemalloc", (String)Configuration.JEMALLOC_LIBRARY_NAME.get(Platform.mapLibraryNameBundled("jemalloc")), true);
    public static final int JEMALLOC_VERSION_MAJOR = 5;
    public static final int JEMALLOC_VERSION_MINOR = 2;
    public static final int JEMALLOC_VERSION_BUGFIX = 1;
    public static final int JEMALLOC_VERSION_NREV = 0;
    public static final String JEMALLOC_VERSION_GID = "ea6b3e973b477b8061e0076bb257dbd7f3faa756";
    public static final String JEMALLOC_VERSION = "5.2.1-0-gea6b3e973b477b8061e0076bb257dbd7f3faa756";
    public static final int MALLOCX_ZERO = 64;
    public static final int MALLOCX_TCACHE_NONE = JEmalloc.MALLOCX_TCACHE(-1);
    public static final int MALLCTL_ARENAS_ALL = 4096;
    public static final int MALLCTL_ARENAS_DESTROYED = 4097;

    public static SharedLibrary getLibrary() {
        return JEMALLOC;
    }

    protected JEmalloc() {
        throw new UnsupportedOperationException();
    }

    public static PointerBuffer je_malloc_message() {
        return MemoryUtil.memPointerBuffer(JEmalloc$Functions.malloc_message, 1);
    }

    public static long nje_malloc(long l2) {
        long l3 = JEmalloc$Functions.malloc;
        return JNI.invokePP(l2, l3);
    }

    public static ByteBuffer je_malloc(long l2) {
        return MemoryUtil.memByteBufferSafe(JEmalloc.nje_malloc(l2), (int)l2);
    }

    public static long nje_calloc(long l2, long l3) {
        long l4 = JEmalloc$Functions.calloc;
        return JNI.invokePPP(l2, l3, l4);
    }

    public static ByteBuffer je_calloc(long l2, long l3) {
        return MemoryUtil.memByteBufferSafe(JEmalloc.nje_calloc(l2, l3), (int)l2 * (int)l3);
    }

    public static int nje_posix_memalign(long l2, long l3, long l4) {
        long l5 = JEmalloc$Functions.posix_memalign;
        return JNI.invokePPPI(l2, l3, l4, l5);
    }

    public static int je_posix_memalign(PointerBuffer pointerBuffer, long l2, long l3) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pointerBuffer, 1);
        }
        return JEmalloc.nje_posix_memalign(MemoryUtil.memAddress(pointerBuffer), l2, l3);
    }

    public static long nje_aligned_alloc(long l2, long l3) {
        long l4 = JEmalloc$Functions.aligned_alloc;
        return JNI.invokePPP(l2, l3, l4);
    }

    public static ByteBuffer je_aligned_alloc(long l2, long l3) {
        return MemoryUtil.memByteBufferSafe(JEmalloc.nje_aligned_alloc(l2, l3), (int)l3);
    }

    public static long nje_realloc(long l2, long l3) {
        long l4 = JEmalloc$Functions.realloc;
        return JNI.invokePPP(l2, l3, l4);
    }

    public static ByteBuffer je_realloc(ByteBuffer byteBuffer, long l2) {
        return MemoryUtil.memByteBufferSafe(JEmalloc.nje_realloc(MemoryUtil.memAddressSafe(byteBuffer), l2), (int)l2);
    }

    public static void nje_free(long l2) {
        long l3 = JEmalloc$Functions.free;
        JNI.invokePV(l2, l3);
    }

    public static void je_free(ByteBuffer byteBuffer) {
        JEmalloc.nje_free(MemoryUtil.memAddressSafe(byteBuffer));
    }

    public static void je_free(ShortBuffer shortBuffer) {
        JEmalloc.nje_free(MemoryUtil.memAddressSafe(shortBuffer));
    }

    public static void je_free(IntBuffer intBuffer) {
        JEmalloc.nje_free(MemoryUtil.memAddressSafe(intBuffer));
    }

    public static void je_free(LongBuffer longBuffer) {
        JEmalloc.nje_free(MemoryUtil.memAddressSafe(longBuffer));
    }

    public static void je_free(FloatBuffer floatBuffer) {
        JEmalloc.nje_free(MemoryUtil.memAddressSafe(floatBuffer));
    }

    public static void je_free(DoubleBuffer doubleBuffer) {
        JEmalloc.nje_free(MemoryUtil.memAddressSafe(doubleBuffer));
    }

    public static void je_free(PointerBuffer pointerBuffer) {
        JEmalloc.nje_free(MemoryUtil.memAddressSafe(pointerBuffer));
    }

    public static void nje_free_sized(long l2, long l3) {
        long l4 = JEmalloc$Functions.free_sized;
        JNI.invokePPV(l2, l3, l4);
    }

    public static void je_free_sized(ByteBuffer byteBuffer) {
        JEmalloc.nje_free_sized(MemoryUtil.memAddressSafe(byteBuffer), Checks.remainingSafe(byteBuffer));
    }

    public static void je_free_sized(ShortBuffer shortBuffer) {
        JEmalloc.nje_free_sized(MemoryUtil.memAddressSafe(shortBuffer), Integer.toUnsignedLong(Checks.remainingSafe(shortBuffer)) << 1);
    }

    public static void je_free_sized(IntBuffer intBuffer) {
        JEmalloc.nje_free_sized(MemoryUtil.memAddressSafe(intBuffer), Integer.toUnsignedLong(Checks.remainingSafe(intBuffer)) << 2);
    }

    public static void je_free_sized(LongBuffer longBuffer) {
        JEmalloc.nje_free_sized(MemoryUtil.memAddressSafe(longBuffer), Integer.toUnsignedLong(Checks.remainingSafe(longBuffer)) << 3);
    }

    public static void je_free_sized(FloatBuffer floatBuffer) {
        JEmalloc.nje_free_sized(MemoryUtil.memAddressSafe(floatBuffer), Integer.toUnsignedLong(Checks.remainingSafe(floatBuffer)) << 2);
    }

    public static void je_free_sized(DoubleBuffer doubleBuffer) {
        JEmalloc.nje_free_sized(MemoryUtil.memAddressSafe(doubleBuffer), Integer.toUnsignedLong(Checks.remainingSafe(doubleBuffer)) << 3);
    }

    public static void je_free_sized(PointerBuffer pointerBuffer) {
        JEmalloc.nje_free_sized(MemoryUtil.memAddressSafe(pointerBuffer), Integer.toUnsignedLong(Checks.remainingSafe(pointerBuffer)) << MemoryStack.POINTER_SHIFT);
    }

    public static void nje_free_aligned_sized(long l2, long l3, long l4) {
        long l5 = JEmalloc$Functions.free_aligned_sized;
        JNI.invokePPPV(l2, l3, l4, l5);
    }

    public static void je_free_aligned_sized(ByteBuffer byteBuffer, long l2) {
        JEmalloc.nje_free_aligned_sized(MemoryUtil.memAddressSafe(byteBuffer), l2, Checks.remainingSafe(byteBuffer));
    }

    public static void je_free_aligned_sized(ShortBuffer shortBuffer, long l2) {
        JEmalloc.nje_free_aligned_sized(MemoryUtil.memAddressSafe(shortBuffer), l2, Integer.toUnsignedLong(Checks.remainingSafe(shortBuffer)) << 1);
    }

    public static void je_free_aligned_sized(IntBuffer intBuffer, long l2) {
        JEmalloc.nje_free_aligned_sized(MemoryUtil.memAddressSafe(intBuffer), l2, Integer.toUnsignedLong(Checks.remainingSafe(intBuffer)) << 2);
    }

    public static void je_free_aligned_sized(LongBuffer longBuffer, long l2) {
        JEmalloc.nje_free_aligned_sized(MemoryUtil.memAddressSafe(longBuffer), l2, Integer.toUnsignedLong(Checks.remainingSafe(longBuffer)) << 3);
    }

    public static void je_free_aligned_sized(FloatBuffer floatBuffer, long l2) {
        JEmalloc.nje_free_aligned_sized(MemoryUtil.memAddressSafe(floatBuffer), l2, Integer.toUnsignedLong(Checks.remainingSafe(floatBuffer)) << 2);
    }

    public static void je_free_aligned_sized(DoubleBuffer doubleBuffer, long l2) {
        JEmalloc.nje_free_aligned_sized(MemoryUtil.memAddressSafe(doubleBuffer), l2, Integer.toUnsignedLong(Checks.remainingSafe(doubleBuffer)) << 3);
    }

    public static void je_free_aligned_sized(PointerBuffer pointerBuffer, long l2) {
        JEmalloc.nje_free_aligned_sized(MemoryUtil.memAddressSafe(pointerBuffer), l2, Integer.toUnsignedLong(Checks.remainingSafe(pointerBuffer)) << MemoryStack.POINTER_SHIFT);
    }

    public static long nje_mallocx(long l2, int n2) {
        long l3 = JEmalloc$Functions.mallocx;
        return JNI.invokePP(l2, n2, l3);
    }

    public static ByteBuffer je_mallocx(long l2, int n2) {
        return MemoryUtil.memByteBufferSafe(JEmalloc.nje_mallocx(l2, n2), (int)l2);
    }

    public static long nje_rallocx(long l2, long l3, int n2) {
        long l4 = JEmalloc$Functions.rallocx;
        return JNI.invokePPP(l2, l3, n2, l4);
    }

    public static ByteBuffer je_rallocx(ByteBuffer byteBuffer, long l2, int n2) {
        return MemoryUtil.memByteBufferSafe(JEmalloc.nje_rallocx(MemoryUtil.memAddressSafe(byteBuffer), l2, n2), (int)l2);
    }

    public static long nje_xallocx(long l2, long l3, long l4, int n2) {
        long l5 = JEmalloc$Functions.xallocx;
        return JNI.invokePPPP(l2, l3, l4, n2, l5);
    }

    public static long je_xallocx(ByteBuffer byteBuffer, long l2, long l3, int n2) {
        return JEmalloc.nje_xallocx(MemoryUtil.memAddressSafe(byteBuffer), l2, l3, n2);
    }

    public static long nje_sallocx(long l2, int n2) {
        long l3 = JEmalloc$Functions.sallocx;
        return JNI.invokePP(l2, n2, l3);
    }

    public static long je_sallocx(ByteBuffer byteBuffer, int n2) {
        return JEmalloc.nje_sallocx(MemoryUtil.memAddress(byteBuffer), n2);
    }

    public static void nje_dallocx(long l2, int n2) {
        long l3 = JEmalloc$Functions.dallocx;
        JNI.invokePV(l2, n2, l3);
    }

    public static void je_dallocx(ByteBuffer byteBuffer, int n2) {
        JEmalloc.nje_dallocx(MemoryUtil.memAddress(byteBuffer), n2);
    }

    public static void je_dallocx(ShortBuffer shortBuffer, int n2) {
        JEmalloc.nje_dallocx(MemoryUtil.memAddress(shortBuffer), n2);
    }

    public static void je_dallocx(IntBuffer intBuffer, int n2) {
        JEmalloc.nje_dallocx(MemoryUtil.memAddress(intBuffer), n2);
    }

    public static void je_dallocx(LongBuffer longBuffer, int n2) {
        JEmalloc.nje_dallocx(MemoryUtil.memAddress(longBuffer), n2);
    }

    public static void je_dallocx(FloatBuffer floatBuffer, int n2) {
        JEmalloc.nje_dallocx(MemoryUtil.memAddress(floatBuffer), n2);
    }

    public static void je_dallocx(DoubleBuffer doubleBuffer, int n2) {
        JEmalloc.nje_dallocx(MemoryUtil.memAddress(doubleBuffer), n2);
    }

    public static void je_dallocx(PointerBuffer pointerBuffer, int n2) {
        JEmalloc.nje_dallocx(MemoryUtil.memAddress(pointerBuffer), n2);
    }

    public static void nje_sdallocx(long l2, long l3, int n2) {
        long l4 = JEmalloc$Functions.sdallocx;
        JNI.invokePPV(l2, l3, n2, l4);
    }

    public static void je_sdallocx(ByteBuffer byteBuffer, int n2) {
        JEmalloc.nje_sdallocx(MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining(), n2);
    }

    public static void je_sdallocx(ShortBuffer shortBuffer, int n2) {
        JEmalloc.nje_sdallocx(MemoryUtil.memAddress(shortBuffer), Integer.toUnsignedLong(shortBuffer.remaining()) << 1, n2);
    }

    public static void je_sdallocx(IntBuffer intBuffer, int n2) {
        JEmalloc.nje_sdallocx(MemoryUtil.memAddress(intBuffer), Integer.toUnsignedLong(intBuffer.remaining()) << 2, n2);
    }

    public static void je_sdallocx(LongBuffer longBuffer, int n2) {
        JEmalloc.nje_sdallocx(MemoryUtil.memAddress(longBuffer), Integer.toUnsignedLong(longBuffer.remaining()) << 3, n2);
    }

    public static void je_sdallocx(FloatBuffer floatBuffer, int n2) {
        JEmalloc.nje_sdallocx(MemoryUtil.memAddress(floatBuffer), Integer.toUnsignedLong(floatBuffer.remaining()) << 2, n2);
    }

    public static void je_sdallocx(DoubleBuffer doubleBuffer, int n2) {
        JEmalloc.nje_sdallocx(MemoryUtil.memAddress(doubleBuffer), Integer.toUnsignedLong(doubleBuffer.remaining()) << 3, n2);
    }

    public static void je_sdallocx(PointerBuffer pointerBuffer, int n2) {
        JEmalloc.nje_sdallocx(MemoryUtil.memAddress(pointerBuffer), Integer.toUnsignedLong(pointerBuffer.remaining()) << MemoryStack.POINTER_SHIFT, n2);
    }

    public static long nje_nallocx(long l2, int n2) {
        long l3 = JEmalloc$Functions.nallocx;
        return JNI.invokePP(l2, n2, l3);
    }

    public static ByteBuffer je_nallocx(long l2, int n2) {
        return MemoryUtil.memByteBufferSafe(JEmalloc.nje_nallocx(l2, n2), (int)l2);
    }

    public static int nje_mallctl(long l2, long l3, long l4, long l5, long l6) {
        long l7 = JEmalloc$Functions.mallctl;
        return JNI.invokePPPPPI(l2, l3, l4, l5, l6, l7);
    }

    public static int je_mallctl(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, PointerBuffer pointerBuffer, ByteBuffer byteBuffer3) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
            Checks.checkSafe((CustomBuffer)pointerBuffer, 1);
        }
        return JEmalloc.nje_mallctl(MemoryUtil.memAddress(byteBuffer), MemoryUtil.memAddressSafe(byteBuffer2), MemoryUtil.memAddressSafe(pointerBuffer), MemoryUtil.memAddressSafe(byteBuffer3), Checks.remainingSafe(byteBuffer3));
    }

    public static int je_mallctl(CharSequence charSequence, ByteBuffer byteBuffer, PointerBuffer pointerBuffer, ByteBuffer byteBuffer2) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)pointerBuffer, 1);
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nASCII(charSequence, true);
            int n3 = JEmalloc.nje_mallctl(memoryStack.getPointerAddress(), MemoryUtil.memAddressSafe(byteBuffer), MemoryUtil.memAddressSafe(pointerBuffer), MemoryUtil.memAddressSafe(byteBuffer2), Checks.remainingSafe(byteBuffer2));
            return n3;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static int nje_mallctlnametomib(long l2, long l3, long l4) {
        long l5 = JEmalloc$Functions.mallctlnametomib;
        return JNI.invokePPPI(l2, l3, l4, l5);
    }

    public static int je_mallctlnametomib(ByteBuffer byteBuffer, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
            Checks.check((CustomBuffer)pointerBuffer2, 1);
            PointerBuffer pointerBuffer3 = pointerBuffer2;
            Checks.check((CustomBuffer)pointerBuffer, pointerBuffer3.get(pointerBuffer3.position()));
        }
        return JEmalloc.nje_mallctlnametomib(MemoryUtil.memAddress(byteBuffer), MemoryUtil.memAddress(pointerBuffer), MemoryUtil.memAddress(pointerBuffer2));
    }

    public static int je_mallctlnametomib(CharSequence charSequence, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pointerBuffer2, 1);
            PointerBuffer pointerBuffer3 = pointerBuffer2;
            Checks.check((CustomBuffer)pointerBuffer, pointerBuffer3.get(pointerBuffer3.position()));
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nASCII(charSequence, true);
            int n3 = JEmalloc.nje_mallctlnametomib(memoryStack.getPointerAddress(), MemoryUtil.memAddress(pointerBuffer), MemoryUtil.memAddress(pointerBuffer2));
            return n3;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static int nje_mallctlbymib(long l2, long l3, long l4, long l5, long l6, long l7) {
        long l8 = JEmalloc$Functions.mallctlbymib;
        return JNI.invokePPPPPPI(l2, l3, l4, l5, l6, l7, l8);
    }

    public static int je_mallctlbymib(PointerBuffer pointerBuffer, ByteBuffer byteBuffer, PointerBuffer pointerBuffer2, ByteBuffer byteBuffer2) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)pointerBuffer2, 1);
        }
        return JEmalloc.nje_mallctlbymib(MemoryUtil.memAddress(pointerBuffer), pointerBuffer.remaining(), MemoryUtil.memAddressSafe(byteBuffer), MemoryUtil.memAddressSafe(pointerBuffer2), MemoryUtil.memAddressSafe(byteBuffer2), Checks.remainingSafe(byteBuffer2));
    }

    public static void nje_malloc_stats_print(long l2, long l3, long l4) {
        long l5 = JEmalloc$Functions.malloc_stats_print;
        JNI.invokePPPV(l2, l3, l4, l5);
    }

    public static void je_malloc_stats_print(MallocMessageCallbackI mallocMessageCallbackI, long l2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(byteBuffer);
        }
        JEmalloc.nje_malloc_stats_print(MemoryUtil.memAddressSafe(mallocMessageCallbackI), l2, MemoryUtil.memAddressSafe(byteBuffer));
    }

    public static void je_malloc_stats_print(MallocMessageCallbackI mallocMessageCallbackI, long l2, CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nASCIISafe(charSequence, true);
            long l3 = charSequence == null ? 0L : memoryStack.getPointerAddress();
            JEmalloc.nje_malloc_stats_print(MemoryUtil.memAddressSafe(mallocMessageCallbackI), l2, l3);
            return;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nje_malloc_usable_size(long l2) {
        long l3 = JEmalloc$Functions.malloc_usable_size;
        return JNI.invokePP(l2, l3);
    }

    public static long je_malloc_usable_size(ByteBuffer byteBuffer) {
        return JEmalloc.nje_malloc_usable_size(MemoryUtil.memAddress(byteBuffer));
    }

    public static int MALLOCX_LG_ALIGN(int n2) {
        return n2;
    }

    public static int MALLOCX_ALIGN(int n2) {
        return Integer.numberOfTrailingZeros(n2);
    }

    public static int MALLOCX_TCACHE(int n2) {
        return n2 + 2 << 8;
    }

    public static int MALLOCX_ARENA(int n2) {
        return n2 + 1 << 20;
    }

    static /* synthetic */ SharedLibrary access$000() {
        return JEMALLOC;
    }

    static {
        if (Platform.get() == Platform.WINDOWS) {
            JNI.invokePV(JNI.invokePP(8L, APIUtil.apiGetFunctionAddress(JEMALLOC, "je_malloc")), APIUtil.apiGetFunctionAddress(JEMALLOC, "je_free"));
        }
    }
}

