/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.jemalloc;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.jemalloc.ExtentAlloc;
import org.lwjgl.system.jemalloc.ExtentAllocI;
import org.lwjgl.system.jemalloc.ExtentCommit;
import org.lwjgl.system.jemalloc.ExtentCommitI;
import org.lwjgl.system.jemalloc.ExtentDalloc;
import org.lwjgl.system.jemalloc.ExtentDallocI;
import org.lwjgl.system.jemalloc.ExtentDecommit;
import org.lwjgl.system.jemalloc.ExtentDecommitI;
import org.lwjgl.system.jemalloc.ExtentDestroy;
import org.lwjgl.system.jemalloc.ExtentDestroyI;
import org.lwjgl.system.jemalloc.ExtentMerge;
import org.lwjgl.system.jemalloc.ExtentMergeI;
import org.lwjgl.system.jemalloc.ExtentPurge;
import org.lwjgl.system.jemalloc.ExtentPurgeI;
import org.lwjgl.system.jemalloc.ExtentSplit;
import org.lwjgl.system.jemalloc.ExtentSplitI;

public class ExtentHooks
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ALLOC;
    public static final int DALLOC;
    public static final int DESTROY;
    public static final int COMMIT;
    public static final int DECOMMIT;
    public static final int PURGE_LAZY;
    public static final int PURGE_FORCED;
    public static final int SPLIT;
    public static final int MERGE;

    protected ExtentHooks(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected ExtentHooks create(long l2, ByteBuffer byteBuffer) {
        return new ExtentHooks(l2, byteBuffer);
    }

    public ExtentHooks(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), ExtentHooks.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public ExtentAlloc alloc() {
        return ExtentHooks.nalloc(this.address());
    }

    public ExtentDalloc dalloc() {
        return ExtentHooks.ndalloc(this.address());
    }

    public ExtentDestroy destroy() {
        return ExtentHooks.ndestroy(this.address());
    }

    public ExtentCommit commit() {
        return ExtentHooks.ncommit(this.address());
    }

    public ExtentDecommit decommit() {
        return ExtentHooks.ndecommit(this.address());
    }

    public ExtentPurge purge_lazy() {
        return ExtentHooks.npurge_lazy(this.address());
    }

    public ExtentPurge purge_forced() {
        return ExtentHooks.npurge_forced(this.address());
    }

    public ExtentSplit split() {
        return ExtentHooks.nsplit(this.address());
    }

    public ExtentMerge merge() {
        return ExtentHooks.nmerge(this.address());
    }

    public ExtentHooks alloc(ExtentAllocI extentAllocI) {
        ExtentHooks.nalloc(this.address(), extentAllocI);
        return this;
    }

    public ExtentHooks dalloc(ExtentDallocI extentDallocI) {
        ExtentHooks.ndalloc(this.address(), extentDallocI);
        return this;
    }

    public ExtentHooks destroy(ExtentDestroyI extentDestroyI) {
        ExtentHooks.ndestroy(this.address(), extentDestroyI);
        return this;
    }

    public ExtentHooks commit(ExtentCommitI extentCommitI) {
        ExtentHooks.ncommit(this.address(), extentCommitI);
        return this;
    }

    public ExtentHooks decommit(ExtentDecommitI extentDecommitI) {
        ExtentHooks.ndecommit(this.address(), extentDecommitI);
        return this;
    }

    public ExtentHooks purge_lazy(ExtentPurgeI extentPurgeI) {
        ExtentHooks.npurge_lazy(this.address(), extentPurgeI);
        return this;
    }

    public ExtentHooks purge_forced(ExtentPurgeI extentPurgeI) {
        ExtentHooks.npurge_forced(this.address(), extentPurgeI);
        return this;
    }

    public ExtentHooks split(ExtentSplitI extentSplitI) {
        ExtentHooks.nsplit(this.address(), extentSplitI);
        return this;
    }

    public ExtentHooks merge(ExtentMergeI extentMergeI) {
        ExtentHooks.nmerge(this.address(), extentMergeI);
        return this;
    }

    public ExtentHooks set(ExtentAllocI extentAllocI, ExtentDallocI extentDallocI, ExtentDestroyI extentDestroyI, ExtentCommitI extentCommitI, ExtentDecommitI extentDecommitI, ExtentPurgeI extentPurgeI, ExtentPurgeI extentPurgeI2, ExtentSplitI extentSplitI, ExtentMergeI extentMergeI) {
        this.alloc(extentAllocI);
        this.dalloc(extentDallocI);
        this.destroy(extentDestroyI);
        this.commit(extentCommitI);
        this.decommit(extentDecommitI);
        this.purge_lazy(extentPurgeI);
        this.purge_forced(extentPurgeI2);
        this.split(extentSplitI);
        this.merge(extentMergeI);
        return this;
    }

    public ExtentHooks set(ExtentHooks extentHooks) {
        MemoryUtil.memCopy(extentHooks.address(), this.address(), SIZEOF);
        return this;
    }

    public static ExtentHooks malloc() {
        return new ExtentHooks(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static ExtentHooks calloc() {
        return new ExtentHooks(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static ExtentHooks create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new ExtentHooks(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static ExtentHooks create(long l2) {
        return new ExtentHooks(l2, null);
    }

    public static ExtentHooks createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new ExtentHooks(l2, null);
    }

    public static ExtentHooks mallocStack() {
        return ExtentHooks.malloc(MemoryStack.stackGet());
    }

    public static ExtentHooks callocStack() {
        return ExtentHooks.calloc(MemoryStack.stackGet());
    }

    public static ExtentHooks mallocStack(MemoryStack memoryStack) {
        return ExtentHooks.malloc(memoryStack);
    }

    public static ExtentHooks callocStack(MemoryStack memoryStack) {
        return ExtentHooks.calloc(memoryStack);
    }

    public static ExtentHooks malloc(MemoryStack memoryStack) {
        return new ExtentHooks(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static ExtentHooks calloc(MemoryStack memoryStack) {
        return new ExtentHooks(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static ExtentAlloc nalloc(long l2) {
        return ExtentAlloc.create(MemoryUtil.memGetAddress(l2 + (long)ALLOC));
    }

    public static ExtentDalloc ndalloc(long l2) {
        return ExtentDalloc.createSafe(MemoryUtil.memGetAddress(l2 + (long)DALLOC));
    }

    public static ExtentDestroy ndestroy(long l2) {
        return ExtentDestroy.createSafe(MemoryUtil.memGetAddress(l2 + (long)DESTROY));
    }

    public static ExtentCommit ncommit(long l2) {
        return ExtentCommit.createSafe(MemoryUtil.memGetAddress(l2 + (long)COMMIT));
    }

    public static ExtentDecommit ndecommit(long l2) {
        return ExtentDecommit.createSafe(MemoryUtil.memGetAddress(l2 + (long)DECOMMIT));
    }

    public static ExtentPurge npurge_lazy(long l2) {
        return ExtentPurge.createSafe(MemoryUtil.memGetAddress(l2 + (long)PURGE_LAZY));
    }

    public static ExtentPurge npurge_forced(long l2) {
        return ExtentPurge.createSafe(MemoryUtil.memGetAddress(l2 + (long)PURGE_FORCED));
    }

    public static ExtentSplit nsplit(long l2) {
        return ExtentSplit.createSafe(MemoryUtil.memGetAddress(l2 + (long)SPLIT));
    }

    public static ExtentMerge nmerge(long l2) {
        return ExtentMerge.createSafe(MemoryUtil.memGetAddress(l2 + (long)MERGE));
    }

    public static void nalloc(long l2, ExtentAllocI extentAllocI) {
        MemoryUtil.memPutAddress(l2 + (long)ALLOC, extentAllocI.address());
    }

    public static void ndalloc(long l2, ExtentDallocI extentDallocI) {
        MemoryUtil.memPutAddress(l2 + (long)DALLOC, MemoryUtil.memAddressSafe(extentDallocI));
    }

    public static void ndestroy(long l2, ExtentDestroyI extentDestroyI) {
        MemoryUtil.memPutAddress(l2 + (long)DESTROY, MemoryUtil.memAddressSafe(extentDestroyI));
    }

    public static void ncommit(long l2, ExtentCommitI extentCommitI) {
        MemoryUtil.memPutAddress(l2 + (long)COMMIT, MemoryUtil.memAddressSafe(extentCommitI));
    }

    public static void ndecommit(long l2, ExtentDecommitI extentDecommitI) {
        MemoryUtil.memPutAddress(l2 + (long)DECOMMIT, MemoryUtil.memAddressSafe(extentDecommitI));
    }

    public static void npurge_lazy(long l2, ExtentPurgeI extentPurgeI) {
        MemoryUtil.memPutAddress(l2 + (long)PURGE_LAZY, MemoryUtil.memAddressSafe(extentPurgeI));
    }

    public static void npurge_forced(long l2, ExtentPurgeI extentPurgeI) {
        MemoryUtil.memPutAddress(l2 + (long)PURGE_FORCED, MemoryUtil.memAddressSafe(extentPurgeI));
    }

    public static void nsplit(long l2, ExtentSplitI extentSplitI) {
        MemoryUtil.memPutAddress(l2 + (long)SPLIT, MemoryUtil.memAddressSafe(extentSplitI));
    }

    public static void nmerge(long l2, ExtentMergeI extentMergeI) {
        MemoryUtil.memPutAddress(l2 + (long)MERGE, MemoryUtil.memAddressSafe(extentMergeI));
    }

    public static void validate(long l2) {
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)ALLOC));
    }

    static {
        Struct$Layout struct$Layout = ExtentHooks.__struct(ExtentHooks.__member(POINTER_SIZE), ExtentHooks.__member(POINTER_SIZE), ExtentHooks.__member(POINTER_SIZE), ExtentHooks.__member(POINTER_SIZE), ExtentHooks.__member(POINTER_SIZE), ExtentHooks.__member(POINTER_SIZE), ExtentHooks.__member(POINTER_SIZE), ExtentHooks.__member(POINTER_SIZE), ExtentHooks.__member(POINTER_SIZE));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        ALLOC = struct$Layout.offsetof(0);
        DALLOC = struct$Layout.offsetof(1);
        DESTROY = struct$Layout.offsetof(2);
        COMMIT = struct$Layout.offsetof(3);
        DECOMMIT = struct$Layout.offsetof(4);
        PURGE_LAZY = struct$Layout.offsetof(5);
        PURGE_FORCED = struct$Layout.offsetof(6);
        SPLIT = struct$Layout.offsetof(7);
        MERGE = struct$Layout.offsetof(8);
    }
}

