/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.LongPredicate;
import org.lwjgl.CLongBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.Library;
import org.lwjgl.system.MathUtil;
import org.lwjgl.system.MemoryManage$DebugAllocator;
import org.lwjgl.system.MemoryUtil$LazyInit;
import org.lwjgl.system.MemoryUtil$MemoryAllocationReport;
import org.lwjgl.system.MemoryUtil$MemoryAllocationReport$Aggregate;
import org.lwjgl.system.MemoryUtil$MemoryAllocator;
import org.lwjgl.system.MultiReleaseMemCopy;
import org.lwjgl.system.MultiReleaseTextDecoding;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Pointer$Default;
import org.lwjgl.system.Struct;
import org.lwjgl.system.jni.JNINativeInterface;
import org.lwjgl.system.libc.LibCString;
import sun.misc.Unsafe;

public final class MemoryUtil {
    public static final long NULL = 0L;
    public static final int PAGE_SIZE;
    public static final int CACHE_LINE_SIZE;
    static final int ARRAY_TLC_SIZE;
    static final ThreadLocal ARRAY_TLC_BYTE;
    static final ThreadLocal ARRAY_TLC_CHAR;
    static final Unsafe UNSAFE;
    static final ByteOrder NATIVE_ORDER;
    private static final Charset UTF16;
    static final Class BUFFER_BYTE;
    static final Class BUFFER_SHORT;
    static final Class BUFFER_CHAR;
    static final Class BUFFER_INT;
    static final Class BUFFER_LONG;
    static final Class BUFFER_FLOAT;
    static final Class BUFFER_DOUBLE;
    private static final long MARK;
    private static final long POSITION;
    private static final long LIMIT;
    private static final long CAPACITY;
    private static final long ADDRESS;
    private static final long PARENT_BYTE;
    private static final long PARENT_SHORT;
    private static final long PARENT_CHAR;
    private static final long PARENT_INT;
    private static final long PARENT_LONG;
    private static final long PARENT_FLOAT;
    private static final long PARENT_DOUBLE;
    private static final int FILL_PATTERN_32;
    private static final long FILL_PATTERN_64;
    private static final int MAGIC_CAPACITY = 219540062;
    private static final int MAGIC_POSITION = 16435934;

    private MemoryUtil() {
    }

    public static MemoryUtil$MemoryAllocator getAllocator() {
        return MemoryUtil.getAllocator(false);
    }

    public static MemoryUtil$MemoryAllocator getAllocator(boolean bl2) {
        if (bl2) {
            return MemoryUtil$LazyInit.ALLOCATOR;
        }
        return MemoryUtil$LazyInit.ALLOCATOR_IMPL;
    }

    public static long nmemAlloc(long l2) {
        return MemoryUtil$LazyInit.ALLOCATOR.malloc(l2);
    }

    public static long nmemAllocChecked(long l2) {
        long l3 = MemoryUtil.nmemAlloc(l2 != 0L ? l2 : 1L);
        if (Checks.CHECKS && l3 == 0L) {
            throw new OutOfMemoryError();
        }
        return l3;
    }

    private static long getAllocationSize(int n2, int n3) {
        int n4 = n2;
        return APIUtil.apiCheckAllocation(n4, Integer.toUnsignedLong(n4) << n3, Pointer.BITS64 ? Long.MAX_VALUE : 0xFFFFFFFFL);
    }

    public static ByteBuffer memAlloc(int n2) {
        return ((ByteBuffer)MemoryUtil.wrap(BUFFER_BYTE, MemoryUtil.nmemAllocChecked(n2), n2)).order(NATIVE_ORDER);
    }

    public static ShortBuffer memAllocShort(int n2) {
        return (ShortBuffer)MemoryUtil.wrap(BUFFER_SHORT, MemoryUtil.nmemAllocChecked(MemoryUtil.getAllocationSize(n2, 1)), n2);
    }

    public static IntBuffer memAllocInt(int n2) {
        return (IntBuffer)MemoryUtil.wrap(BUFFER_INT, MemoryUtil.nmemAllocChecked(MemoryUtil.getAllocationSize(n2, 2)), n2);
    }

    public static FloatBuffer memAllocFloat(int n2) {
        return (FloatBuffer)MemoryUtil.wrap(BUFFER_FLOAT, MemoryUtil.nmemAllocChecked(MemoryUtil.getAllocationSize(n2, 2)), n2);
    }

    public static LongBuffer memAllocLong(int n2) {
        return (LongBuffer)MemoryUtil.wrap(BUFFER_LONG, MemoryUtil.nmemAllocChecked(MemoryUtil.getAllocationSize(n2, 3)), n2);
    }

    public static CLongBuffer memAllocCLong(int n2) {
        return CLongBuffer.create(MemoryUtil.nmemAllocChecked(MemoryUtil.getAllocationSize(n2, Pointer.CLONG_SHIFT)), n2);
    }

    public static DoubleBuffer memAllocDouble(int n2) {
        return (DoubleBuffer)MemoryUtil.wrap(BUFFER_DOUBLE, MemoryUtil.nmemAllocChecked(MemoryUtil.getAllocationSize(n2, 3)), n2);
    }

    public static PointerBuffer memAllocPointer(int n2) {
        return PointerBuffer.create(MemoryUtil.nmemAllocChecked(MemoryUtil.getAllocationSize(n2, Pointer.POINTER_SHIFT)), n2);
    }

    public static void nmemFree(long l2) {
        MemoryUtil$LazyInit.ALLOCATOR.free(l2);
    }

    public static void memFree(Buffer buffer) {
        if (buffer != null) {
            MemoryUtil.nmemFree(UNSAFE.getLong(buffer, ADDRESS));
        }
    }

    public static void memFree(CustomBuffer customBuffer) {
        if (customBuffer != null) {
            MemoryUtil.nmemFree(customBuffer.address);
        }
    }

    public static long nmemCalloc(long l2, long l3) {
        return MemoryUtil$LazyInit.ALLOCATOR.calloc(l2, l3);
    }

    public static long nmemCallocChecked(long l2, long l3) {
        if (l2 == 0L || l3 == 0L) {
            l2 = 1L;
            l3 = 1L;
        }
        long l4 = MemoryUtil.nmemCalloc(l2, l3);
        if (Checks.CHECKS && l4 == 0L) {
            throw new OutOfMemoryError();
        }
        return l4;
    }

    public static ByteBuffer memCalloc(int n2, int n3) {
        return ((ByteBuffer)MemoryUtil.wrap(BUFFER_BYTE, MemoryUtil.nmemCallocChecked(n2, n3), n2 * n3)).order(NATIVE_ORDER);
    }

    public static ByteBuffer memCalloc(int n2) {
        return ((ByteBuffer)MemoryUtil.wrap(BUFFER_BYTE, MemoryUtil.nmemCallocChecked(n2, 1L), n2)).order(NATIVE_ORDER);
    }

    public static ShortBuffer memCallocShort(int n2) {
        return (ShortBuffer)MemoryUtil.wrap(BUFFER_SHORT, MemoryUtil.nmemCallocChecked(n2, 2L), n2);
    }

    public static IntBuffer memCallocInt(int n2) {
        return (IntBuffer)MemoryUtil.wrap(BUFFER_INT, MemoryUtil.nmemCallocChecked(n2, 4L), n2);
    }

    public static FloatBuffer memCallocFloat(int n2) {
        return (FloatBuffer)MemoryUtil.wrap(BUFFER_FLOAT, MemoryUtil.nmemCallocChecked(n2, 4L), n2);
    }

    public static LongBuffer memCallocLong(int n2) {
        return (LongBuffer)MemoryUtil.wrap(BUFFER_LONG, MemoryUtil.nmemCallocChecked(n2, 8L), n2);
    }

    public static CLongBuffer memCallocCLong(int n2) {
        return CLongBuffer.create(MemoryUtil.nmemCallocChecked(n2, Pointer.CLONG_SIZE), n2);
    }

    public static DoubleBuffer memCallocDouble(int n2) {
        return (DoubleBuffer)MemoryUtil.wrap(BUFFER_DOUBLE, MemoryUtil.nmemCallocChecked(n2, 8L), n2);
    }

    public static PointerBuffer memCallocPointer(int n2) {
        return PointerBuffer.create(MemoryUtil.nmemCallocChecked(n2, Pointer.POINTER_SIZE), n2);
    }

    public static long nmemRealloc(long l2, long l3) {
        return MemoryUtil$LazyInit.ALLOCATOR.realloc(l2, l3);
    }

    public static long nmemReallocChecked(long l2, long l3) {
        long l4 = MemoryUtil.nmemRealloc(l2, l3 != 0L ? l3 : 1L);
        if (Checks.CHECKS && l4 == 0L) {
            throw new OutOfMemoryError();
        }
        return l4;
    }

    private static Buffer realloc(Buffer buffer, Buffer buffer2, int n2) {
        if (buffer != null) {
            buffer2.position(Math.min(buffer.position(), n2));
        }
        return buffer2;
    }

    public static ByteBuffer memRealloc(ByteBuffer byteBuffer, int n2) {
        ByteBuffer byteBuffer2 = byteBuffer;
        return (ByteBuffer)MemoryUtil.realloc(byteBuffer2, MemoryUtil.memByteBuffer(MemoryUtil.nmemReallocChecked(byteBuffer2 == null ? 0L : UNSAFE.getLong(byteBuffer, ADDRESS), n2), n2), n2);
    }

    public static ShortBuffer memRealloc(ShortBuffer shortBuffer, int n2) {
        ShortBuffer shortBuffer2 = shortBuffer;
        return (ShortBuffer)MemoryUtil.realloc(shortBuffer2, MemoryUtil.memShortBuffer(MemoryUtil.nmemReallocChecked(shortBuffer2 == null ? 0L : UNSAFE.getLong(shortBuffer, ADDRESS), MemoryUtil.getAllocationSize(n2, 1)), n2), n2);
    }

    public static IntBuffer memRealloc(IntBuffer intBuffer, int n2) {
        IntBuffer intBuffer2 = intBuffer;
        return (IntBuffer)MemoryUtil.realloc(intBuffer2, MemoryUtil.memIntBuffer(MemoryUtil.nmemReallocChecked(intBuffer2 == null ? 0L : UNSAFE.getLong(intBuffer, ADDRESS), MemoryUtil.getAllocationSize(n2, 2)), n2), n2);
    }

    public static LongBuffer memRealloc(LongBuffer longBuffer, int n2) {
        LongBuffer longBuffer2 = longBuffer;
        return (LongBuffer)MemoryUtil.realloc(longBuffer2, MemoryUtil.memLongBuffer(MemoryUtil.nmemReallocChecked(longBuffer2 == null ? 0L : UNSAFE.getLong(longBuffer, ADDRESS), MemoryUtil.getAllocationSize(n2, 3)), n2), n2);
    }

    public static CLongBuffer memRealloc(CLongBuffer cLongBuffer, int n2) {
        CLongBuffer cLongBuffer2 = MemoryUtil.memCLongBuffer(MemoryUtil.nmemReallocChecked(cLongBuffer == null ? 0L : cLongBuffer.address, MemoryUtil.getAllocationSize(n2, Pointer.CLONG_SIZE)), n2);
        if (cLongBuffer != null) {
            cLongBuffer2.position(Math.min(cLongBuffer.position(), n2));
        }
        return cLongBuffer2;
    }

    public static FloatBuffer memRealloc(FloatBuffer floatBuffer, int n2) {
        FloatBuffer floatBuffer2 = floatBuffer;
        return (FloatBuffer)MemoryUtil.realloc(floatBuffer2, MemoryUtil.memFloatBuffer(MemoryUtil.nmemReallocChecked(floatBuffer2 == null ? 0L : UNSAFE.getLong(floatBuffer, ADDRESS), MemoryUtil.getAllocationSize(n2, 2)), n2), n2);
    }

    public static DoubleBuffer memRealloc(DoubleBuffer doubleBuffer, int n2) {
        DoubleBuffer doubleBuffer2 = doubleBuffer;
        return (DoubleBuffer)MemoryUtil.realloc(doubleBuffer2, MemoryUtil.memDoubleBuffer(MemoryUtil.nmemReallocChecked(doubleBuffer2 == null ? 0L : UNSAFE.getLong(doubleBuffer, ADDRESS), MemoryUtil.getAllocationSize(n2, 3)), n2), n2);
    }

    public static PointerBuffer memRealloc(PointerBuffer pointerBuffer, int n2) {
        PointerBuffer pointerBuffer2 = MemoryUtil.memPointerBuffer(MemoryUtil.nmemReallocChecked(pointerBuffer == null ? 0L : pointerBuffer.address, MemoryUtil.getAllocationSize(n2, Pointer.POINTER_SHIFT)), n2);
        if (pointerBuffer != null) {
            pointerBuffer2.position(Math.min(pointerBuffer.position(), n2));
        }
        return pointerBuffer2;
    }

    public static long nmemAlignedAlloc(long l2, long l3) {
        return MemoryUtil$LazyInit.ALLOCATOR.aligned_alloc(l2, l3);
    }

    public static long nmemAlignedAllocChecked(long l2, long l3) {
        long l4 = MemoryUtil.nmemAlignedAlloc(l2, l3 != 0L ? l3 : 1L);
        if (Checks.CHECKS && l4 == 0L) {
            throw new OutOfMemoryError();
        }
        return l4;
    }

    public static ByteBuffer memAlignedAlloc(int n2, int n3) {
        return ((ByteBuffer)MemoryUtil.wrap(BUFFER_BYTE, MemoryUtil.nmemAlignedAllocChecked(n2, n3), n3)).order(NATIVE_ORDER);
    }

    public static void nmemAlignedFree(long l2) {
        MemoryUtil$LazyInit.ALLOCATOR.aligned_free(l2);
    }

    public static void memAlignedFree(ByteBuffer byteBuffer) {
        if (byteBuffer != null) {
            MemoryUtil.nmemAlignedFree(UNSAFE.getLong(byteBuffer, ADDRESS));
        }
    }

    public static void memReport(MemoryUtil$MemoryAllocationReport memoryUtil$MemoryAllocationReport) {
        MemoryManage$DebugAllocator.report(memoryUtil$MemoryAllocationReport);
    }

    public static void memReport(MemoryUtil$MemoryAllocationReport memoryUtil$MemoryAllocationReport, MemoryUtil$MemoryAllocationReport$Aggregate memoryUtil$MemoryAllocationReport$Aggregate, boolean bl2) {
        MemoryManage$DebugAllocator.report(memoryUtil$MemoryAllocationReport, memoryUtil$MemoryAllocationReport$Aggregate, bl2);
    }

    public static long memAddress0(Buffer buffer) {
        return UNSAFE.getLong(buffer, ADDRESS);
    }

    public static long memAddress(ByteBuffer byteBuffer) {
        return (long)byteBuffer.position() + MemoryUtil.memAddress0(byteBuffer);
    }

    public static long memAddress(ByteBuffer byteBuffer, int n2) {
        Objects.requireNonNull(byteBuffer);
        return MemoryUtil.memAddress0(byteBuffer) + Integer.toUnsignedLong(n2);
    }

    private static long address(int n2, int n3, long l2) {
        return l2 + (((long)n2 & 0xFFFFFFFFL) << n3);
    }

    public static long memAddress(ShortBuffer shortBuffer) {
        return MemoryUtil.address(shortBuffer.position(), 1, MemoryUtil.memAddress0(shortBuffer));
    }

    public static long memAddress(ShortBuffer shortBuffer, int n2) {
        Objects.requireNonNull(shortBuffer);
        return MemoryUtil.address(n2, 1, MemoryUtil.memAddress0(shortBuffer));
    }

    public static long memAddress(CharBuffer charBuffer) {
        return MemoryUtil.address(charBuffer.position(), 1, MemoryUtil.memAddress0(charBuffer));
    }

    public static long memAddress(CharBuffer charBuffer, int n2) {
        Objects.requireNonNull(charBuffer);
        return MemoryUtil.address(n2, 1, MemoryUtil.memAddress0(charBuffer));
    }

    public static long memAddress(IntBuffer intBuffer) {
        return MemoryUtil.address(intBuffer.position(), 2, MemoryUtil.memAddress0(intBuffer));
    }

    public static long memAddress(IntBuffer intBuffer, int n2) {
        Objects.requireNonNull(intBuffer);
        return MemoryUtil.address(n2, 2, MemoryUtil.memAddress0(intBuffer));
    }

    public static long memAddress(FloatBuffer floatBuffer) {
        return MemoryUtil.address(floatBuffer.position(), 2, MemoryUtil.memAddress0(floatBuffer));
    }

    public static long memAddress(FloatBuffer floatBuffer, int n2) {
        Objects.requireNonNull(floatBuffer);
        return MemoryUtil.address(n2, 2, MemoryUtil.memAddress0(floatBuffer));
    }

    public static long memAddress(LongBuffer longBuffer) {
        return MemoryUtil.address(longBuffer.position(), 3, MemoryUtil.memAddress0(longBuffer));
    }

    public static long memAddress(LongBuffer longBuffer, int n2) {
        Objects.requireNonNull(longBuffer);
        return MemoryUtil.address(n2, 3, MemoryUtil.memAddress0(longBuffer));
    }

    public static long memAddress(DoubleBuffer doubleBuffer) {
        return MemoryUtil.address(doubleBuffer.position(), 3, MemoryUtil.memAddress0(doubleBuffer));
    }

    public static long memAddress(DoubleBuffer doubleBuffer, int n2) {
        Objects.requireNonNull(doubleBuffer);
        return MemoryUtil.address(n2, 3, MemoryUtil.memAddress0(doubleBuffer));
    }

    public static long memAddress(Buffer buffer) {
        int n2 = buffer instanceof ByteBuffer ? 0 : (buffer instanceof ShortBuffer || buffer instanceof CharBuffer ? 1 : (buffer instanceof IntBuffer || buffer instanceof FloatBuffer ? 2 : 3));
        return MemoryUtil.address(buffer.position(), n2, MemoryUtil.memAddress0(buffer));
    }

    public static long memAddress(CustomBuffer customBuffer) {
        return ((Pointer$Default)customBuffer).address();
    }

    public static long memAddress(CustomBuffer customBuffer, int n2) {
        return customBuffer.address(n2);
    }

    public static long memAddressSafe(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return 0L;
        }
        return MemoryUtil.memAddress0(byteBuffer) + (long)byteBuffer.position();
    }

    public static long memAddressSafe(ShortBuffer shortBuffer) {
        if (shortBuffer == null) {
            return 0L;
        }
        return MemoryUtil.address(shortBuffer.position(), 1, MemoryUtil.memAddress0(shortBuffer));
    }

    public static long memAddressSafe(CharBuffer charBuffer) {
        if (charBuffer == null) {
            return 0L;
        }
        return MemoryUtil.address(charBuffer.position(), 1, MemoryUtil.memAddress0(charBuffer));
    }

    public static long memAddressSafe(IntBuffer intBuffer) {
        if (intBuffer == null) {
            return 0L;
        }
        return MemoryUtil.address(intBuffer.position(), 2, MemoryUtil.memAddress0(intBuffer));
    }

    public static long memAddressSafe(FloatBuffer floatBuffer) {
        if (floatBuffer == null) {
            return 0L;
        }
        return MemoryUtil.address(floatBuffer.position(), 2, MemoryUtil.memAddress0(floatBuffer));
    }

    public static long memAddressSafe(LongBuffer longBuffer) {
        if (longBuffer == null) {
            return 0L;
        }
        return MemoryUtil.address(longBuffer.position(), 3, MemoryUtil.memAddress0(longBuffer));
    }

    public static long memAddressSafe(DoubleBuffer doubleBuffer) {
        if (doubleBuffer == null) {
            return 0L;
        }
        return MemoryUtil.address(doubleBuffer.position(), 3, MemoryUtil.memAddress0(doubleBuffer));
    }

    public static long memAddressSafe(Pointer pointer) {
        if (pointer == null) {
            return 0L;
        }
        return pointer.address();
    }

    public static ByteBuffer memByteBuffer(long l2, int n2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return ((ByteBuffer)MemoryUtil.wrap(BUFFER_BYTE, l2, n2)).order(NATIVE_ORDER);
    }

    public static ByteBuffer memByteBufferSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return ((ByteBuffer)MemoryUtil.wrap(BUFFER_BYTE, l2, n2)).order(NATIVE_ORDER);
    }

    public static ByteBuffer memByteBuffer(ShortBuffer shortBuffer) {
        if (Checks.CHECKS && 0x3FFFFFFF < shortBuffer.remaining()) {
            throw new IllegalArgumentException("The source buffer range is too wide");
        }
        return ((ByteBuffer)MemoryUtil.wrap(BUFFER_BYTE, MemoryUtil.memAddress(shortBuffer), shortBuffer.remaining() << 1)).order(NATIVE_ORDER);
    }

    public static ByteBuffer memByteBuffer(CharBuffer charBuffer) {
        if (Checks.CHECKS && 0x3FFFFFFF < charBuffer.remaining()) {
            throw new IllegalArgumentException("The source buffer range is too wide");
        }
        return ((ByteBuffer)MemoryUtil.wrap(BUFFER_BYTE, MemoryUtil.memAddress(charBuffer), charBuffer.remaining() << 1)).order(NATIVE_ORDER);
    }

    public static ByteBuffer memByteBuffer(IntBuffer intBuffer) {
        if (Checks.CHECKS && 0x1FFFFFFF < intBuffer.remaining()) {
            throw new IllegalArgumentException("The source buffer range is too wide");
        }
        return ((ByteBuffer)MemoryUtil.wrap(BUFFER_BYTE, MemoryUtil.memAddress(intBuffer), intBuffer.remaining() << 2)).order(NATIVE_ORDER);
    }

    public static ByteBuffer memByteBuffer(LongBuffer longBuffer) {
        if (Checks.CHECKS && 0xFFFFFFF < longBuffer.remaining()) {
            throw new IllegalArgumentException("The source buffer range is too wide");
        }
        return ((ByteBuffer)MemoryUtil.wrap(BUFFER_BYTE, MemoryUtil.memAddress(longBuffer), longBuffer.remaining() << 3)).order(NATIVE_ORDER);
    }

    public static ByteBuffer memByteBuffer(FloatBuffer floatBuffer) {
        if (Checks.CHECKS && 0x1FFFFFFF < floatBuffer.remaining()) {
            throw new IllegalArgumentException("The source buffer range is too wide");
        }
        return ((ByteBuffer)MemoryUtil.wrap(BUFFER_BYTE, MemoryUtil.memAddress(floatBuffer), floatBuffer.remaining() << 2)).order(NATIVE_ORDER);
    }

    public static ByteBuffer memByteBuffer(DoubleBuffer doubleBuffer) {
        if (Checks.CHECKS && 0xFFFFFFF < doubleBuffer.remaining()) {
            throw new IllegalArgumentException("The source buffer range is too wide");
        }
        return ((ByteBuffer)MemoryUtil.wrap(BUFFER_BYTE, MemoryUtil.memAddress(doubleBuffer), doubleBuffer.remaining() << 3)).order(NATIVE_ORDER);
    }

    public static ByteBuffer memByteBuffer(CustomBuffer customBuffer) {
        if (Checks.CHECKS && Integer.MAX_VALUE / customBuffer.sizeof() < customBuffer.remaining()) {
            throw new IllegalArgumentException("The source buffer range is too wide");
        }
        return ((ByteBuffer)MemoryUtil.wrap(BUFFER_BYTE, MemoryUtil.memAddress(customBuffer), customBuffer.remaining() * customBuffer.sizeof())).order(NATIVE_ORDER);
    }

    public static ByteBuffer memByteBuffer(Struct struct) {
        return ((ByteBuffer)MemoryUtil.wrap(BUFFER_BYTE, struct.address, struct.sizeof())).order(NATIVE_ORDER);
    }

    public static ShortBuffer memShortBuffer(long l2, int n2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return (ShortBuffer)MemoryUtil.wrap(BUFFER_SHORT, l2, n2);
    }

    public static ShortBuffer memShortBufferSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return (ShortBuffer)MemoryUtil.wrap(BUFFER_SHORT, l2, n2);
    }

    public static CharBuffer memCharBuffer(long l2, int n2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return (CharBuffer)MemoryUtil.wrap(BUFFER_CHAR, l2, n2);
    }

    public static CharBuffer memCharBufferSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return (CharBuffer)MemoryUtil.wrap(BUFFER_CHAR, l2, n2);
    }

    public static IntBuffer memIntBuffer(long l2, int n2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return (IntBuffer)MemoryUtil.wrap(BUFFER_INT, l2, n2);
    }

    public static IntBuffer memIntBufferSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return (IntBuffer)MemoryUtil.wrap(BUFFER_INT, l2, n2);
    }

    public static LongBuffer memLongBuffer(long l2, int n2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return (LongBuffer)MemoryUtil.wrap(BUFFER_LONG, l2, n2);
    }

    public static LongBuffer memLongBufferSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return (LongBuffer)MemoryUtil.wrap(BUFFER_LONG, l2, n2);
    }

    public static CLongBuffer memCLongBuffer(long l2, int n2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return CLongBuffer.create(l2, n2);
    }

    public static CLongBuffer memCLongBufferSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return CLongBuffer.create(l2, n2);
    }

    public static FloatBuffer memFloatBuffer(long l2, int n2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return (FloatBuffer)MemoryUtil.wrap(BUFFER_FLOAT, l2, n2);
    }

    public static FloatBuffer memFloatBufferSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return (FloatBuffer)MemoryUtil.wrap(BUFFER_FLOAT, l2, n2);
    }

    public static DoubleBuffer memDoubleBuffer(long l2, int n2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return (DoubleBuffer)MemoryUtil.wrap(BUFFER_DOUBLE, l2, n2);
    }

    public static DoubleBuffer memDoubleBufferSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return (DoubleBuffer)MemoryUtil.wrap(BUFFER_DOUBLE, l2, n2);
    }

    public static PointerBuffer memPointerBuffer(long l2, int n2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return PointerBuffer.create(l2, n2);
    }

    public static PointerBuffer memPointerBufferSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return PointerBuffer.create(l2, n2);
    }

    public static ByteBuffer memDuplicate(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2;
        try {
            byteBuffer2 = (ByteBuffer)UNSAFE.allocateInstance(BUFFER_BYTE);
        }
        catch (InstantiationException instantiationException) {
            throw new UnsupportedOperationException(instantiationException);
        }
        UNSAFE.putLong(byteBuffer2, ADDRESS, UNSAFE.getLong(byteBuffer, ADDRESS));
        UNSAFE.putInt(byteBuffer2, MARK, UNSAFE.getInt(byteBuffer, MARK));
        UNSAFE.putInt(byteBuffer2, POSITION, UNSAFE.getInt(byteBuffer, POSITION));
        UNSAFE.putInt(byteBuffer2, LIMIT, UNSAFE.getInt(byteBuffer, LIMIT));
        UNSAFE.putInt(byteBuffer2, CAPACITY, UNSAFE.getInt(byteBuffer, CAPACITY));
        Object object = UNSAFE.getObject(byteBuffer, PARENT_BYTE);
        UNSAFE.putObject(byteBuffer2, PARENT_BYTE, object == null ? byteBuffer : object);
        return byteBuffer2.order(byteBuffer.order());
    }

    public static ShortBuffer memDuplicate(ShortBuffer shortBuffer) {
        return (ShortBuffer)MemoryUtil.duplicate(BUFFER_SHORT, shortBuffer, PARENT_SHORT);
    }

    public static CharBuffer memDuplicate(CharBuffer charBuffer) {
        return (CharBuffer)MemoryUtil.duplicate(BUFFER_CHAR, charBuffer, PARENT_CHAR);
    }

    public static IntBuffer memDuplicate(IntBuffer intBuffer) {
        return (IntBuffer)MemoryUtil.duplicate(BUFFER_INT, intBuffer, PARENT_INT);
    }

    public static LongBuffer memDuplicate(LongBuffer longBuffer) {
        return (LongBuffer)MemoryUtil.duplicate(BUFFER_LONG, longBuffer, PARENT_LONG);
    }

    public static FloatBuffer memDuplicate(FloatBuffer floatBuffer) {
        return (FloatBuffer)MemoryUtil.duplicate(BUFFER_FLOAT, floatBuffer, PARENT_FLOAT);
    }

    public static DoubleBuffer memDuplicate(DoubleBuffer doubleBuffer) {
        return (DoubleBuffer)MemoryUtil.duplicate(BUFFER_DOUBLE, doubleBuffer, PARENT_DOUBLE);
    }

    public static ByteBuffer memSlice(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = byteBuffer;
        return MemoryUtil.slice(byteBuffer2, MemoryUtil.memAddress0(byteBuffer2) + (long)byteBuffer.position(), byteBuffer.remaining());
    }

    public static ShortBuffer memSlice(ShortBuffer shortBuffer) {
        ShortBuffer shortBuffer2 = shortBuffer;
        return (ShortBuffer)MemoryUtil.slice(BUFFER_SHORT, shortBuffer2, MemoryUtil.address(shortBuffer2.position(), 1, MemoryUtil.memAddress0(shortBuffer)), shortBuffer.remaining(), PARENT_SHORT);
    }

    public static CharBuffer memSlice(CharBuffer charBuffer) {
        CharBuffer charBuffer2 = charBuffer;
        return (CharBuffer)MemoryUtil.slice(BUFFER_CHAR, charBuffer2, MemoryUtil.address(charBuffer2.position(), 1, MemoryUtil.memAddress0(charBuffer)), charBuffer.remaining(), PARENT_CHAR);
    }

    public static IntBuffer memSlice(IntBuffer intBuffer) {
        IntBuffer intBuffer2 = intBuffer;
        return (IntBuffer)MemoryUtil.slice(BUFFER_INT, intBuffer2, MemoryUtil.address(intBuffer2.position(), 2, MemoryUtil.memAddress0(intBuffer)), intBuffer.remaining(), PARENT_INT);
    }

    public static LongBuffer memSlice(LongBuffer longBuffer) {
        LongBuffer longBuffer2 = longBuffer;
        return (LongBuffer)MemoryUtil.slice(BUFFER_LONG, longBuffer2, MemoryUtil.address(longBuffer2.position(), 3, MemoryUtil.memAddress0(longBuffer)), longBuffer.remaining(), PARENT_LONG);
    }

    public static FloatBuffer memSlice(FloatBuffer floatBuffer) {
        FloatBuffer floatBuffer2 = floatBuffer;
        return (FloatBuffer)MemoryUtil.slice(BUFFER_FLOAT, floatBuffer2, MemoryUtil.address(floatBuffer2.position(), 2, MemoryUtil.memAddress0(floatBuffer)), floatBuffer.remaining(), PARENT_FLOAT);
    }

    public static DoubleBuffer memSlice(DoubleBuffer doubleBuffer) {
        DoubleBuffer doubleBuffer2 = doubleBuffer;
        return (DoubleBuffer)MemoryUtil.slice(BUFFER_DOUBLE, doubleBuffer2, MemoryUtil.address(doubleBuffer2.position(), 3, MemoryUtil.memAddress0(doubleBuffer)), doubleBuffer.remaining(), PARENT_DOUBLE);
    }

    public static ByteBuffer memSlice(ByteBuffer byteBuffer, int n2, int n3) {
        int n4 = byteBuffer.position() + n2;
        if (n2 < 0 || byteBuffer.limit() < n4) {
            throw new IllegalArgumentException();
        }
        if (n3 < 0 || byteBuffer.capacity() - n4 < n3) {
            throw new IllegalArgumentException();
        }
        ByteBuffer byteBuffer2 = byteBuffer;
        return MemoryUtil.slice(byteBuffer2, MemoryUtil.memAddress0(byteBuffer2) + (long)n4, n3);
    }

    public static ShortBuffer memSlice(ShortBuffer shortBuffer, int n2, int n3) {
        int n4 = shortBuffer.position() + n2;
        if (n2 < 0 || shortBuffer.limit() < n4) {
            throw new IllegalArgumentException();
        }
        if (n3 < 0 || shortBuffer.capacity() - n4 < n3) {
            throw new IllegalArgumentException();
        }
        return (ShortBuffer)MemoryUtil.slice(BUFFER_SHORT, shortBuffer, MemoryUtil.address(n4, 1, MemoryUtil.memAddress0(shortBuffer)), n3, PARENT_SHORT);
    }

    public static CharBuffer memSlice(CharBuffer charBuffer, int n2, int n3) {
        int n4 = charBuffer.position() + n2;
        if (n2 < 0 || charBuffer.limit() < n4) {
            throw new IllegalArgumentException();
        }
        if (n3 < 0 || charBuffer.capacity() - n4 < n3) {
            throw new IllegalArgumentException();
        }
        return (CharBuffer)MemoryUtil.slice(BUFFER_CHAR, charBuffer, MemoryUtil.address(n4, 1, MemoryUtil.memAddress0(charBuffer)), n3, PARENT_CHAR);
    }

    public static IntBuffer memSlice(IntBuffer intBuffer, int n2, int n3) {
        int n4 = intBuffer.position() + n2;
        if (n2 < 0 || intBuffer.limit() < n4) {
            throw new IllegalArgumentException();
        }
        if (n3 < 0 || intBuffer.capacity() - n4 < n3) {
            throw new IllegalArgumentException();
        }
        return (IntBuffer)MemoryUtil.slice(BUFFER_INT, intBuffer, MemoryUtil.address(n4, 2, MemoryUtil.memAddress0(intBuffer)), n3, PARENT_INT);
    }

    public static LongBuffer memSlice(LongBuffer longBuffer, int n2, int n3) {
        int n4 = longBuffer.position() + n2;
        if (n2 < 0 || longBuffer.limit() < n4) {
            throw new IllegalArgumentException();
        }
        if (n3 < 0 || longBuffer.capacity() - n4 < n3) {
            throw new IllegalArgumentException();
        }
        return (LongBuffer)MemoryUtil.slice(BUFFER_LONG, longBuffer, MemoryUtil.address(n4, 3, MemoryUtil.memAddress0(longBuffer)), n3, PARENT_LONG);
    }

    public static FloatBuffer memSlice(FloatBuffer floatBuffer, int n2, int n3) {
        int n4 = floatBuffer.position() + n2;
        if (n2 < 0 || floatBuffer.limit() < n4) {
            throw new IllegalArgumentException();
        }
        if (n3 < 0 || floatBuffer.capacity() - n4 < n3) {
            throw new IllegalArgumentException();
        }
        return (FloatBuffer)MemoryUtil.slice(BUFFER_FLOAT, floatBuffer, MemoryUtil.address(n4, 2, MemoryUtil.memAddress0(floatBuffer)), n3, PARENT_FLOAT);
    }

    public static DoubleBuffer memSlice(DoubleBuffer doubleBuffer, int n2, int n3) {
        int n4 = doubleBuffer.position() + n2;
        if (n2 < 0 || doubleBuffer.limit() < n4) {
            throw new IllegalArgumentException();
        }
        if (n3 < 0 || doubleBuffer.capacity() - n4 < n3) {
            throw new IllegalArgumentException();
        }
        return (DoubleBuffer)MemoryUtil.slice(BUFFER_DOUBLE, doubleBuffer, MemoryUtil.address(n4, 3, MemoryUtil.memAddress0(doubleBuffer)), n3, PARENT_DOUBLE);
    }

    public static CustomBuffer memSlice(CustomBuffer customBuffer, int n2, int n3) {
        return customBuffer.slice(n2, n3);
    }

    public static void memSet(ByteBuffer byteBuffer, int n2) {
        MemoryUtil.memSet(MemoryUtil.memAddress(byteBuffer), n2, byteBuffer.remaining());
    }

    public static void memSet(ShortBuffer shortBuffer, int n2) {
        MemoryUtil.memSet(MemoryUtil.memAddress(shortBuffer), n2, APIUtil.apiGetBytes(shortBuffer.remaining(), 1));
    }

    public static void memSet(CharBuffer charBuffer, int n2) {
        MemoryUtil.memSet(MemoryUtil.memAddress(charBuffer), n2, APIUtil.apiGetBytes(charBuffer.remaining(), 1));
    }

    public static void memSet(IntBuffer intBuffer, int n2) {
        MemoryUtil.memSet(MemoryUtil.memAddress(intBuffer), n2, APIUtil.apiGetBytes(intBuffer.remaining(), 2));
    }

    public static void memSet(LongBuffer longBuffer, int n2) {
        MemoryUtil.memSet(MemoryUtil.memAddress(longBuffer), n2, APIUtil.apiGetBytes(longBuffer.remaining(), 3));
    }

    public static void memSet(FloatBuffer floatBuffer, int n2) {
        MemoryUtil.memSet(MemoryUtil.memAddress(floatBuffer), n2, APIUtil.apiGetBytes(floatBuffer.remaining(), 2));
    }

    public static void memSet(DoubleBuffer doubleBuffer, int n2) {
        MemoryUtil.memSet(MemoryUtil.memAddress(doubleBuffer), n2, APIUtil.apiGetBytes(doubleBuffer.remaining(), 3));
    }

    public static void memSet(CustomBuffer customBuffer, int n2) {
        MemoryUtil.memSet(MemoryUtil.memAddress(customBuffer), n2, Integer.toUnsignedLong(customBuffer.remaining()) * (long)customBuffer.sizeof());
    }

    public static void memSet(Struct struct, int n2) {
        MemoryUtil.memSet(struct.address, n2, struct.sizeof());
    }

    public static void memCopy(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)byteBuffer2, byteBuffer.remaining());
        }
        MultiReleaseMemCopy.copy(MemoryUtil.memAddress(byteBuffer), MemoryUtil.memAddress(byteBuffer2), byteBuffer.remaining());
    }

    public static void memCopy(ShortBuffer shortBuffer, ShortBuffer shortBuffer2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)shortBuffer2, shortBuffer.remaining());
        }
        MultiReleaseMemCopy.copy(MemoryUtil.memAddress(shortBuffer), MemoryUtil.memAddress(shortBuffer2), APIUtil.apiGetBytes(shortBuffer.remaining(), 1));
    }

    public static void memCopy(CharBuffer charBuffer, CharBuffer charBuffer2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)charBuffer2, charBuffer.remaining());
        }
        MultiReleaseMemCopy.copy(MemoryUtil.memAddress(charBuffer), MemoryUtil.memAddress(charBuffer2), APIUtil.apiGetBytes(charBuffer.remaining(), 1));
    }

    public static void memCopy(IntBuffer intBuffer, IntBuffer intBuffer2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer2, intBuffer.remaining());
        }
        MultiReleaseMemCopy.copy(MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(intBuffer2), APIUtil.apiGetBytes(intBuffer.remaining(), 2));
    }

    public static void memCopy(LongBuffer longBuffer, LongBuffer longBuffer2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)longBuffer2, longBuffer.remaining());
        }
        MultiReleaseMemCopy.copy(MemoryUtil.memAddress(longBuffer), MemoryUtil.memAddress(longBuffer2), APIUtil.apiGetBytes(longBuffer.remaining(), 3));
    }

    public static void memCopy(FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)floatBuffer2, floatBuffer.remaining());
        }
        MultiReleaseMemCopy.copy(MemoryUtil.memAddress(floatBuffer), MemoryUtil.memAddress(floatBuffer2), APIUtil.apiGetBytes(floatBuffer.remaining(), 2));
    }

    public static void memCopy(DoubleBuffer doubleBuffer, DoubleBuffer doubleBuffer2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)doubleBuffer2, doubleBuffer.remaining());
        }
        MultiReleaseMemCopy.copy(MemoryUtil.memAddress(doubleBuffer), MemoryUtil.memAddress(doubleBuffer2), APIUtil.apiGetBytes(doubleBuffer.remaining(), 3));
    }

    public static void memCopy(CustomBuffer customBuffer, CustomBuffer customBuffer2) {
        if (Checks.CHECKS) {
            Checks.check(customBuffer2, customBuffer.remaining());
        }
        MultiReleaseMemCopy.copy(MemoryUtil.memAddress(customBuffer), MemoryUtil.memAddress(customBuffer2), Integer.toUnsignedLong(customBuffer.remaining()) * (long)customBuffer.sizeof());
    }

    public static void memCopy(Struct struct, Struct struct2) {
        MultiReleaseMemCopy.copy(struct.address, struct2.address, struct.sizeof());
    }

    public static void memSet(long l2, int n2, long l3) {
        if (Checks.DEBUG && (l2 == 0L || l3 < 0L)) {
            throw new IllegalArgumentException();
        }
        if (l3 < 256L) {
            int n3 = (int)l2;
            if (Pointer.BITS64) {
                if ((n3 & 7) == 0) {
                    MemoryUtil.memSet64(l2, n2, (int)l3 & 0xFF);
                    return;
                }
            } else if ((n3 & 3) == 0) {
                MemoryUtil.memSet32(n3, n2, (int)l3 & 0xFF);
                return;
            }
        }
        LibCString.nmemset(l2, n2, l3);
    }

    private static void memSet64(long l2, int n2, int n3) {
        byte by2;
        byte by3 = n3 & 0xFFFFFFF8;
        long l3 = (long)(n2 & 0xFF) * FILL_PATTERN_64;
        for (by2 = 0; by2 < by3; by2 += 8) {
            UNSAFE.putLong(null, l2 + (long)by2, l3);
        }
        by2 = (byte)n2;
        for (n2 = by3; n2 < n3; ++n2) {
            UNSAFE.putByte(null, l2 + (long)n2, by2);
        }
    }

    private static void memSet32(int n2, int n3, int n4) {
        byte by2;
        byte by3 = n4 & 0xFFFFFFFC;
        int n5 = (n3 & 0xFF) * FILL_PATTERN_32;
        for (by2 = 0; by2 < by3; by2 += 4) {
            UNSAFE.putInt(null, (long)(n2 + by2) & 0xFFFFFFFFL, n5);
        }
        by2 = (byte)n3;
        for (n3 = by3; n3 < n4; ++n3) {
            UNSAFE.putByte(null, (long)(n2 + n3) & 0xFFFFFFFFL, by2);
        }
    }

    public static void memCopy(long l2, long l3, long l4) {
        if (Checks.DEBUG && (l2 == 0L || l3 == 0L || l4 < 0L)) {
            throw new IllegalArgumentException();
        }
        MultiReleaseMemCopy.copy(l2, l3, l4);
    }

    static void memCopyAligned64(long l2, long l3, int n2) {
        int n3;
        int n4 = n2 & 0xFFFFFFF8;
        for (n3 = 0; n3 < n4; n3 += 8) {
            UNSAFE.putLong(null, l3 + (long)n3, UNSAFE.getLong(null, l2 + (long)n3));
        }
        for (n3 = n4; n3 < n2; ++n3) {
            UNSAFE.putByte(null, l3 + (long)n3, UNSAFE.getByte(null, l2 + (long)n3));
        }
    }

    static void memCopyAligned32(int n2, int n3, int n4) {
        int n5;
        int n6 = n4 & 0xFFFFFFFC;
        for (n5 = 0; n5 < n6; n5 += 4) {
            UNSAFE.putInt(null, (long)(n3 + n5) & 0xFFFFFFFFL, UNSAFE.getInt(null, (long)(n2 + n5) & 0xFFFFFFFFL));
        }
        for (n5 = n6; n5 < n4; ++n5) {
            UNSAFE.putByte(null, (long)(n3 + n5) & 0xFFFFFFFFL, UNSAFE.getByte(null, (long)(n2 + n5) & 0xFFFFFFFFL));
        }
    }

    public static boolean memGetBoolean(long l2) {
        return UNSAFE.getByte(null, l2) != 0;
    }

    public static byte memGetByte(long l2) {
        return UNSAFE.getByte(null, l2);
    }

    public static short memGetShort(long l2) {
        return UNSAFE.getShort(null, l2);
    }

    public static int memGetInt(long l2) {
        return UNSAFE.getInt(null, l2);
    }

    public static long memGetLong(long l2) {
        return UNSAFE.getLong(null, l2);
    }

    public static float memGetFloat(long l2) {
        return UNSAFE.getFloat(null, l2);
    }

    public static double memGetDouble(long l2) {
        return UNSAFE.getDouble(null, l2);
    }

    public static long memGetCLong(long l2) {
        if (Pointer.CLONG_SIZE == 8) {
            return UNSAFE.getLong(null, l2);
        }
        return UNSAFE.getInt(null, l2);
    }

    public static long memGetAddress(long l2) {
        if (Pointer.BITS64) {
            return UNSAFE.getLong(null, l2);
        }
        return (long)UNSAFE.getInt(null, l2) & 0xFFFFFFFFL;
    }

    public static void memPutByte(long l2, byte by2) {
        UNSAFE.putByte(null, l2, by2);
    }

    public static void memPutShort(long l2, short s2) {
        UNSAFE.putShort(null, l2, s2);
    }

    public static void memPutInt(long l2, int n2) {
        UNSAFE.putInt(null, l2, n2);
    }

    public static void memPutLong(long l2, long l3) {
        UNSAFE.putLong(null, l2, l3);
    }

    public static void memPutFloat(long l2, float f2) {
        UNSAFE.putFloat(null, l2, f2);
    }

    public static void memPutDouble(long l2, double d2) {
        UNSAFE.putDouble(null, l2, d2);
    }

    public static void memPutCLong(long l2, long l3) {
        if (Pointer.CLONG_SIZE == 8) {
            UNSAFE.putLong(null, l2, l3);
            return;
        }
        UNSAFE.putInt(null, l2, (int)l3);
    }

    public static void memPutAddress(long l2, long l3) {
        if (Pointer.BITS64) {
            UNSAFE.putLong(null, l2, l3);
            return;
        }
        UNSAFE.putInt(null, l2, (int)l3);
    }

    public static native Object memGlobalRefToObject(long var0);

    private static int write8(long l2, int n2, int n3) {
        UNSAFE.putByte(null, l2 + Integer.toUnsignedLong(n2), (byte)n3);
        return n2 + 1;
    }

    private static int write8Safe(long l2, int n2, int n3, int n4) {
        if (n2 == n3) {
            throw new BufferOverflowException();
        }
        UNSAFE.putByte(null, l2 + Integer.toUnsignedLong(n2), (byte)n4);
        return n2 + 1;
    }

    private static int write16(long l2, int n2, char c2) {
        UNSAFE.putShort(null, l2 + Integer.toUnsignedLong(n2), (short)c2);
        return n2 + 2;
    }

    public static ByteBuffer memASCII(CharSequence charSequence) {
        return MemoryUtil.memASCII(charSequence, true);
    }

    public static ByteBuffer memASCIISafe(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        return MemoryUtil.memASCII(charSequence, true);
    }

    public static ByteBuffer memASCII(CharSequence charSequence, boolean bl2) {
        int n2 = MemoryUtil.memLengthASCII(charSequence, bl2);
        long l2 = MemoryUtil.nmemAlloc(n2);
        if (Checks.CHECKS && l2 == 0L) {
            throw new OutOfMemoryError();
        }
        MemoryUtil.encodeASCIIUnsafe(charSequence, bl2, l2);
        return ((ByteBuffer)MemoryUtil.wrap(BUFFER_BYTE, l2, n2)).order(NATIVE_ORDER);
    }

    public static ByteBuffer memASCIISafe(CharSequence charSequence, boolean bl2) {
        if (charSequence == null) {
            return null;
        }
        return MemoryUtil.memASCII(charSequence, bl2);
    }

    public static int memASCII(CharSequence charSequence, boolean bl2, ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() < MemoryUtil.memLengthASCII(charSequence, bl2)) {
            throw new BufferOverflowException();
        }
        long l2 = MemoryUtil.memAddress(byteBuffer);
        return MemoryUtil.encodeASCIIUnsafe(charSequence, bl2, l2);
    }

    public static int memASCII(CharSequence charSequence, boolean bl2, ByteBuffer byteBuffer, int n2) {
        if (byteBuffer.capacity() - n2 < MemoryUtil.memLengthASCII(charSequence, bl2)) {
            throw new BufferOverflowException();
        }
        return MemoryUtil.encodeASCIIUnsafe(charSequence, bl2, MemoryUtil.memAddress(byteBuffer, n2));
    }

    static int encodeASCIIUnsafe(CharSequence charSequence, boolean bl2, long l2) {
        int n2 = 0;
        int n3 = charSequence.length();
        while (n2 < n3) {
            n2 = MemoryUtil.write8(l2, n2, charSequence.charAt(n2));
        }
        if (bl2) {
            n2 = MemoryUtil.write8(l2, n2, 0);
        }
        return n2;
    }

    public static int memLengthASCII(CharSequence charSequence, boolean bl2) {
        int n2 = charSequence.length() + (bl2 ? 1 : 0);
        if (n2 < 0) {
            throw new BufferOverflowException();
        }
        return n2;
    }

    public static ByteBuffer memUTF8(CharSequence charSequence) {
        return MemoryUtil.memUTF8(charSequence, true);
    }

    public static ByteBuffer memUTF8Safe(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        return MemoryUtil.memUTF8(charSequence, true);
    }

    public static ByteBuffer memUTF8(CharSequence charSequence, boolean bl2) {
        int n2 = MemoryUtil.memLengthUTF8(charSequence, bl2);
        long l2 = MemoryUtil.nmemAlloc(n2);
        if (Checks.CHECKS && l2 == 0L) {
            throw new OutOfMemoryError();
        }
        MemoryUtil.encodeUTF8Unsafe(charSequence, bl2, l2);
        return ((ByteBuffer)MemoryUtil.wrap(BUFFER_BYTE, l2, n2)).order(NATIVE_ORDER);
    }

    public static ByteBuffer memUTF8Safe(CharSequence charSequence, boolean bl2) {
        if (charSequence == null) {
            return null;
        }
        return MemoryUtil.memUTF8(charSequence, bl2);
    }

    public static int memUTF8(CharSequence charSequence, boolean bl2, ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() < MemoryUtil.memLengthASCII(charSequence, bl2)) {
            throw new BufferOverflowException();
        }
        return MemoryUtil.encodeUTF8Safe(charSequence, bl2, MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining());
    }

    public static int memUTF8(CharSequence charSequence, boolean bl2, ByteBuffer byteBuffer, int n2) {
        if (byteBuffer.capacity() - n2 < MemoryUtil.memLengthASCII(charSequence, bl2)) {
            throw new BufferOverflowException();
        }
        return MemoryUtil.encodeUTF8Safe(charSequence, bl2, MemoryUtil.memAddress(byteBuffer, n2), byteBuffer.capacity() - n2);
    }

    static int encodeUTF8Unsafe(CharSequence charSequence, boolean bl2, long l2) {
        int n2 = 0;
        int n3 = 0;
        int n4 = charSequence.length();
        while (n3 < n4) {
            int n5;
            if ((n5 = charSequence.charAt(n3++)) < 128) {
                n2 = MemoryUtil.write8(l2, n2, n5);
                continue;
            }
            int n6 = n5;
            if (n5 < 2048) {
                n2 = MemoryUtil.write8(l2, n2, 0xC0 | n6 >> 6);
            } else {
                if (!Character.isHighSurrogate((char)n5)) {
                    n2 = MemoryUtil.write8(l2, n2, 0xE0 | n6 >> 12);
                } else {
                    n6 = Character.toCodePoint((char)n5, charSequence.charAt(n3++));
                    n2 = MemoryUtil.write8(l2, n2, 0xF0 | n6 >> 18);
                    n2 = MemoryUtil.write8(l2, n2, 0x80 | n6 >> 12 & 0x3F);
                }
                n2 = MemoryUtil.write8(l2, n2, 0x80 | n6 >> 6 & 0x3F);
            }
            n2 = MemoryUtil.write8(l2, n2, 0x80 | n6 & 0x3F);
        }
        if (bl2) {
            n2 = MemoryUtil.write8(l2, n2, 0);
        }
        return n2;
    }

    static int encodeUTF8Safe(CharSequence charSequence, boolean bl2, long l2, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        int n6 = charSequence.length();
        for (n4 = 0; n4 < n6 && 128 > (n3 = charSequence.charAt(n4)); ++n4) {
            n5 = MemoryUtil.write8(l2, n5, n3);
        }
        while (n4 < n6) {
            if ((n3 = charSequence.charAt(n4++)) < 128) {
                n5 = MemoryUtil.write8Safe(l2, n5, n2, n3);
                continue;
            }
            int n7 = n3;
            if (n3 < 2048) {
                n5 = MemoryUtil.write8Safe(l2, n5, n2, 0xC0 | n7 >> 6);
            } else {
                if (!Character.isHighSurrogate((char)n3)) {
                    n5 = MemoryUtil.write8Safe(l2, n5, n2, 0xE0 | n7 >> 12);
                } else {
                    n7 = Character.toCodePoint((char)n3, charSequence.charAt(n4++));
                    n5 = MemoryUtil.write8Safe(l2, n5, n2, 0xF0 | n7 >> 18);
                    n5 = MemoryUtil.write8Safe(l2, n5, n2, 0x80 | n7 >> 12 & 0x3F);
                }
                n5 = MemoryUtil.write8Safe(l2, n5, n2, 0x80 | n7 >> 6 & 0x3F);
            }
            n5 = MemoryUtil.write8Safe(l2, n5, n2, 0x80 | n7 & 0x3F);
        }
        if (bl2) {
            n5 = MemoryUtil.write8Safe(l2, n5, n2, 0);
        }
        return n5;
    }

    public static int memLengthUTF8(CharSequence charSequence, boolean n2) {
        int n3 = charSequence.length();
        n2 = n3 + (n2 != 0 ? 1 : 0);
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 < '\u0080') continue;
            if (c2 < '\u0800') {
                n2 += 127 - c2 >>> 31;
            } else {
                n2 += 2;
                if (Character.isHighSurrogate(c2)) {
                    ++i2;
                }
            }
            if (n2 >= 0) continue;
            throw new BufferOverflowException();
        }
        if (n2 < 0) {
            throw new BufferOverflowException();
        }
        return n2;
    }

    public static ByteBuffer memUTF16(CharSequence charSequence) {
        return MemoryUtil.memUTF16(charSequence, true);
    }

    public static ByteBuffer memUTF16Safe(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        return MemoryUtil.memUTF16(charSequence, true);
    }

    public static ByteBuffer memUTF16(CharSequence charSequence, boolean bl2) {
        int n2 = MemoryUtil.memLengthUTF16(charSequence, bl2);
        long l2 = MemoryUtil.nmemAlloc(n2);
        if (Checks.CHECKS && l2 == 0L) {
            throw new OutOfMemoryError();
        }
        MemoryUtil.encodeUTF16Unsafe(charSequence, bl2, l2);
        return ((ByteBuffer)MemoryUtil.wrap(BUFFER_BYTE, l2, n2)).order(NATIVE_ORDER);
    }

    public static ByteBuffer memUTF16Safe(CharSequence charSequence, boolean bl2) {
        if (charSequence == null) {
            return null;
        }
        return MemoryUtil.memUTF16(charSequence, bl2);
    }

    public static int memUTF16(CharSequence charSequence, boolean bl2, ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() < MemoryUtil.memLengthUTF16(charSequence, bl2)) {
            throw new BufferOverflowException();
        }
        long l2 = MemoryUtil.memAddress(byteBuffer);
        return MemoryUtil.encodeUTF16Unsafe(charSequence, bl2, l2);
    }

    public static int memUTF16(CharSequence charSequence, boolean bl2, ByteBuffer byteBuffer, int n2) {
        if (byteBuffer.capacity() - n2 < MemoryUtil.memLengthUTF16(charSequence, bl2)) {
            throw new BufferOverflowException();
        }
        long l2 = MemoryUtil.memAddress(byteBuffer, n2);
        return MemoryUtil.encodeUTF16Unsafe(charSequence, bl2, l2);
    }

    static int encodeUTF16Unsafe(CharSequence charSequence, boolean bl2, long l2) {
        int n2 = 0;
        int n3 = 0;
        int n4 = charSequence.length();
        while (n3 < n4) {
            n2 = MemoryUtil.write16(l2, n2, charSequence.charAt(n3++));
        }
        if (bl2) {
            n2 = MemoryUtil.write16(l2, n2, '\u0000');
        }
        return n2;
    }

    public static int memLengthUTF16(CharSequence charSequence, boolean bl2) {
        int n2 = charSequence.length() + (bl2 ? 1 : 0);
        if (n2 < 0 || 0x3FFFFFFF < n2) {
            throw new BufferOverflowException();
        }
        return n2 << 1;
    }

    private static int memLengthNT1(long l2, int n2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        if (Pointer.BITS64) {
            return MemoryUtil.strlen64NT1(l2, n2);
        }
        return MemoryUtil.strlen32NT1(l2, n2);
    }

    private static int strlen64NT1(long l2, int n2) {
        int n3;
        if (8 <= n2) {
            int n4 = (int)l2 & 7;
            if (n4 != 0) {
                n4 = 8 - n4;
                for (n3 = 0; n3 < n4; ++n3) {
                    if (UNSAFE.getByte(null, l2 + (long)n3) != 0) continue;
                    return n3;
                }
            }
            while (n3 <= n2 - 8 && !MathUtil.mathHasZeroByte(UNSAFE.getLong(null, l2 + (long)n3))) {
                n3 += 8;
            }
        }
        while (n3 < n2 && UNSAFE.getByte(null, l2 + (long)n3) != 0) {
            ++n3;
        }
        return n3;
    }

    private static int strlen32NT1(long l2, int n2) {
        int n3;
        if (4 <= n2) {
            int n4 = (int)l2 & 3;
            if (n4 != 0) {
                n4 = 4 - n4;
                for (n3 = 0; n3 < n4; ++n3) {
                    if (UNSAFE.getByte(null, l2 + (long)n3) != 0) continue;
                    return n3;
                }
            }
            while (n3 <= n2 - 4 && !MathUtil.mathHasZeroByte(UNSAFE.getInt(null, l2 + (long)n3))) {
                n3 += 4;
            }
        }
        while (n3 < n2 && UNSAFE.getByte(null, l2 + (long)n3) != 0) {
            ++n3;
        }
        return n3;
    }

    public static int memLengthNT1(ByteBuffer byteBuffer) {
        return MemoryUtil.memLengthNT1(MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining());
    }

    private static int memLengthNT2(long l2, int n2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        if (Pointer.BITS64) {
            return MemoryUtil.strlen64NT2(l2, n2);
        }
        return MemoryUtil.strlen32NT2((int)l2, n2);
    }

    private static int strlen64NT2(long l2, int n2) {
        int n3;
        if (8 <= n2) {
            int n4 = (int)l2 & 7;
            if (n4 != 0) {
                n4 = 8 - n4;
                for (n3 = 0; n3 < n4; n3 += 2) {
                    if (UNSAFE.getShort(null, l2 + (long)n3) != 0) continue;
                    return n3;
                }
            }
            while (n3 <= n2 - 8 && !MathUtil.mathHasZeroShort(UNSAFE.getLong(null, l2 + (long)n3))) {
                n3 += 8;
            }
        }
        while (n3 < n2 && UNSAFE.getShort(null, l2 + (long)n3) != 0) {
            n3 += 2;
        }
        return n3;
    }

    private static int strlen32NT2(long l2, int n2) {
        int n3;
        if (4 <= n2) {
            int n4 = (int)l2 & 3;
            if (n4 != 0) {
                n4 = 4 - n4;
                for (n3 = 0; n3 < n4; n3 += 2) {
                    if (UNSAFE.getShort(null, l2 + (long)n3) != 0) continue;
                    return n3;
                }
            }
            while (n3 <= n2 - 4 && !MathUtil.mathHasZeroShort(UNSAFE.getInt(null, l2 + (long)n3))) {
                n3 += 4;
            }
        }
        while (n3 < n2 && UNSAFE.getShort(null, l2 + (long)n3) != 0) {
            n3 += 2;
        }
        return n3;
    }

    public static int memLengthNT2(ByteBuffer byteBuffer) {
        return MemoryUtil.memLengthNT2(MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining());
    }

    public static ByteBuffer memByteBufferNT1(long l2) {
        long l3 = l2;
        return MemoryUtil.memByteBuffer(l3, MemoryUtil.memLengthNT1(l3, Integer.MAX_VALUE));
    }

    public static ByteBuffer memByteBufferNT1(long l2, int n2) {
        long l3 = l2;
        return MemoryUtil.memByteBuffer(l3, MemoryUtil.memLengthNT1(l3, n2));
    }

    public static ByteBuffer memByteBufferNT1Safe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        long l3 = l2;
        return MemoryUtil.memByteBuffer(l3, MemoryUtil.memLengthNT1(l3, Integer.MAX_VALUE));
    }

    public static ByteBuffer memByteBufferNT1Safe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        long l3 = l2;
        return MemoryUtil.memByteBuffer(l3, MemoryUtil.memLengthNT1(l3, n2));
    }

    public static ByteBuffer memByteBufferNT2(long l2) {
        return MemoryUtil.memByteBufferNT2(l2, 0x7FFFFFFE);
    }

    public static ByteBuffer memByteBufferNT2(long l2, int n2) {
        if (Checks.DEBUG && (n2 & 1) != 0) {
            throw new IllegalArgumentException("The maximum length must be an even number.");
        }
        long l3 = l2;
        return MemoryUtil.memByteBuffer(l3, MemoryUtil.memLengthNT2(l3, n2));
    }

    public static ByteBuffer memByteBufferNT2Safe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return MemoryUtil.memByteBufferNT2(l2, 0x7FFFFFFE);
    }

    public static ByteBuffer memByteBufferNT2Safe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return MemoryUtil.memByteBufferNT2(l2, n2);
    }

    public static String memASCII(long l2) {
        long l3 = l2;
        return MemoryUtil.memASCII(l3, MemoryUtil.memLengthNT1(l3, Integer.MAX_VALUE));
    }

    public static String memASCII(long l2, int n2) {
        if (n2 <= 0) {
            return "";
        }
        byte[] byArray = n2 <= ARRAY_TLC_SIZE ? (byte[])ARRAY_TLC_BYTE.get() : new byte[n2];
        MemoryUtil.memByteBuffer(l2, n2).get(byArray, 0, n2);
        return new String(byArray, 0, 0, n2);
    }

    public static String memASCII(ByteBuffer byteBuffer) {
        return MemoryUtil.memASCII(MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining());
    }

    public static String memASCIISafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        long l3 = l2;
        return MemoryUtil.memASCII(l3, MemoryUtil.memLengthNT1(l3, Integer.MAX_VALUE));
    }

    public static String memASCIISafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return MemoryUtil.memASCII(l2, n2);
    }

    public static String memASCIISafe(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        return MemoryUtil.memASCII(MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining());
    }

    public static String memASCII(ByteBuffer byteBuffer, int n2) {
        return MemoryUtil.memASCII(MemoryUtil.memAddress(byteBuffer), n2);
    }

    public static String memASCII(ByteBuffer byteBuffer, int n2, int n3) {
        return MemoryUtil.memASCII(MemoryUtil.memAddress(byteBuffer, n3), n2);
    }

    public static String memUTF8(long l2) {
        long l3 = l2;
        return MultiReleaseTextDecoding.decodeUTF8(l3, MemoryUtil.memLengthNT1(l3, Integer.MAX_VALUE));
    }

    public static String memUTF8(long l2, int n2) {
        return MultiReleaseTextDecoding.decodeUTF8(l2, n2);
    }

    public static String memUTF8(ByteBuffer byteBuffer) {
        return MultiReleaseTextDecoding.decodeUTF8(MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining());
    }

    public static String memUTF8Safe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        long l3 = l2;
        return MultiReleaseTextDecoding.decodeUTF8(l3, MemoryUtil.memLengthNT1(l3, Integer.MAX_VALUE));
    }

    public static String memUTF8Safe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return MultiReleaseTextDecoding.decodeUTF8(l2, n2);
    }

    public static String memUTF8Safe(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        return MultiReleaseTextDecoding.decodeUTF8(MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining());
    }

    public static String memUTF8(ByteBuffer byteBuffer, int n2) {
        return MultiReleaseTextDecoding.decodeUTF8(MemoryUtil.memAddress(byteBuffer), n2);
    }

    public static String memUTF8(ByteBuffer byteBuffer, int n2, int n3) {
        return MultiReleaseTextDecoding.decodeUTF8(MemoryUtil.memAddress(byteBuffer, n3), n2);
    }

    public static String memUTF16(long l2) {
        long l3 = l2;
        return MemoryUtil.memUTF16(l3, MemoryUtil.memLengthNT2(l3, 0x7FFFFFFE) >> 1);
    }

    public static String memUTF16(long l2, int n2) {
        if (n2 <= 0) {
            return "";
        }
        if (Checks.DEBUG) {
            int n3 = n2 << 1;
            byte[] byArray = n3 <= ARRAY_TLC_SIZE ? (byte[])ARRAY_TLC_BYTE.get() : new byte[n3];
            MemoryUtil.memByteBuffer(l2, n3).get(byArray, 0, n3);
            return new String(byArray, 0, n3, UTF16);
        }
        char[] cArray = n2 <= ARRAY_TLC_SIZE ? (char[])ARRAY_TLC_CHAR.get() : new char[n2];
        MemoryUtil.memCharBuffer(l2, n2).get(cArray, 0, n2);
        return new String(cArray, 0, n2);
    }

    public static String memUTF16(ByteBuffer byteBuffer) {
        return MemoryUtil.memUTF16(MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining() >> 1);
    }

    public static String memUTF16Safe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        long l3 = l2;
        return MemoryUtil.memUTF16(l3, MemoryUtil.memLengthNT2(l3, 0x7FFFFFFE) >> 1);
    }

    public static String memUTF16Safe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return MemoryUtil.memUTF16(l2, n2);
    }

    public static String memUTF16Safe(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        return MemoryUtil.memUTF16(MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining() >> 1);
    }

    public static String memUTF16(ByteBuffer byteBuffer, int n2) {
        return MemoryUtil.memUTF16(MemoryUtil.memAddress(byteBuffer), n2);
    }

    public static String memUTF16(ByteBuffer byteBuffer, int n2, int n3) {
        return MemoryUtil.memUTF16(MemoryUtil.memAddress(byteBuffer, n3), n2);
    }

    private static Unsafe getUnsafeInstance() {
        for (Field field : Unsafe.class.getDeclaredFields()) {
            int n2;
            if (!field.getType().equals(Unsafe.class) || !Modifier.isStatic(n2 = field.getModifiers()) || !Modifier.isFinal(n2)) continue;
            try {
                field.setAccessible(true);
                return (Unsafe)field.get(null);
            }
            catch (Exception exception) {
                break;
            }
        }
        throw new UnsupportedOperationException("LWJGL requires sun.misc.Unsafe to be available.");
    }

    private static long getFieldOffset(Class clazz, Class clazz2, LongPredicate longPredicate) {
        while (clazz != Object.class) {
            for (Field field : clazz.getDeclaredFields()) {
                long l2;
                if (!field.getType().isAssignableFrom(clazz2) || Modifier.isStatic(field.getModifiers()) || field.isSynthetic() || !longPredicate.test(l2 = UNSAFE.objectFieldOffset(field))) continue;
                return l2;
            }
            clazz = clazz.getSuperclass();
        }
        throw new UnsupportedOperationException("Failed to find field offset in class.");
    }

    private static long getFieldOffsetInt(Object object, int n2) {
        return MemoryUtil.getFieldOffset(object.getClass(), Integer.TYPE, l2 -> UNSAFE.getInt(object, l2) == n2);
    }

    private static long getFieldOffsetObject(Object object, Object object2) {
        return MemoryUtil.getFieldOffset(object.getClass(), object2.getClass(), l2 -> UNSAFE.getObject(object, l2) == object2);
    }

    private static long getAddressOffset() {
        long l2 = 0xDEADBEEF8BADF00DL & (Pointer.BITS32 ? 0xFFFFFFFFL : -1L);
        ByteBuffer byteBuffer = Objects.requireNonNull(JNINativeInterface.NewDirectByteBuffer(l2, 0L));
        return MemoryUtil.getFieldOffset(byteBuffer.getClass(), Long.TYPE, l3 -> UNSAFE.getLong(byteBuffer, l3) == l2);
    }

    private static long getMarkOffset() {
        return MemoryUtil.getFieldOffsetInt(Objects.requireNonNull(JNINativeInterface.NewDirectByteBuffer(1L, 0L)), -1);
    }

    private static long getPositionOffset() {
        ByteBuffer byteBuffer = Objects.requireNonNull(JNINativeInterface.NewDirectByteBuffer(-1L, 219540062L));
        byteBuffer.position(16435934);
        return MemoryUtil.getFieldOffsetInt(byteBuffer, 16435934);
    }

    private static long getLimitOffset() {
        ByteBuffer byteBuffer = Objects.requireNonNull(JNINativeInterface.NewDirectByteBuffer(-1L, 219540062L));
        byteBuffer.limit(16435934);
        return MemoryUtil.getFieldOffsetInt(byteBuffer, 16435934);
    }

    private static long getCapacityOffset() {
        ByteBuffer byteBuffer = Objects.requireNonNull(JNINativeInterface.NewDirectByteBuffer(-1L, 219540062L));
        byteBuffer.limit(0);
        return MemoryUtil.getFieldOffsetInt(byteBuffer, 219540062);
    }

    static Buffer wrap(Class object, long l2, int n2) {
        try {
            object = (Buffer)UNSAFE.allocateInstance((Class<?>)object);
        }
        catch (InstantiationException instantiationException) {
            throw new UnsupportedOperationException(instantiationException);
        }
        UNSAFE.putLong(object, ADDRESS, l2);
        UNSAFE.putInt(object, MARK, -1);
        UNSAFE.putInt(object, LIMIT, n2);
        UNSAFE.putInt(object, CAPACITY, n2);
        return object;
    }

    static ByteBuffer slice(ByteBuffer byteBuffer, long l2, int n2) {
        ByteBuffer byteBuffer2;
        try {
            byteBuffer2 = (ByteBuffer)UNSAFE.allocateInstance(BUFFER_BYTE);
        }
        catch (InstantiationException instantiationException) {
            throw new UnsupportedOperationException(instantiationException);
        }
        UNSAFE.putLong(byteBuffer2, ADDRESS, l2);
        UNSAFE.putInt(byteBuffer2, MARK, -1);
        UNSAFE.putInt(byteBuffer2, LIMIT, n2);
        UNSAFE.putInt(byteBuffer2, CAPACITY, n2);
        Object object = UNSAFE.getObject(byteBuffer, PARENT_BYTE);
        UNSAFE.putObject(byteBuffer2, PARENT_BYTE, object == null ? byteBuffer : object);
        return byteBuffer2.order(byteBuffer.order());
    }

    static Buffer slice(Class object, Buffer buffer, long l2, int n2, long l3) {
        try {
            object = (Buffer)UNSAFE.allocateInstance((Class<?>)object);
        }
        catch (InstantiationException instantiationException) {
            throw new UnsupportedOperationException(instantiationException);
        }
        UNSAFE.putLong(object, ADDRESS, l2);
        UNSAFE.putInt(object, MARK, -1);
        UNSAFE.putInt(object, LIMIT, n2);
        UNSAFE.putInt(object, CAPACITY, n2);
        UNSAFE.putObject(object, l3, UNSAFE.getObject(buffer, l3));
        return object;
    }

    static Buffer duplicate(Class object, Buffer buffer, long l2) {
        try {
            object = (Buffer)UNSAFE.allocateInstance((Class<?>)object);
        }
        catch (InstantiationException instantiationException) {
            throw new UnsupportedOperationException(instantiationException);
        }
        UNSAFE.putLong(object, ADDRESS, UNSAFE.getLong(buffer, ADDRESS));
        UNSAFE.putInt(object, MARK, UNSAFE.getInt(buffer, MARK));
        UNSAFE.putInt(object, POSITION, UNSAFE.getInt(buffer, POSITION));
        UNSAFE.putInt(object, LIMIT, UNSAFE.getInt(buffer, LIMIT));
        UNSAFE.putInt(object, CAPACITY, UNSAFE.getInt(buffer, CAPACITY));
        UNSAFE.putObject(object, l2, UNSAFE.getObject(buffer, l2));
        return object;
    }

    static {
        ARRAY_TLC_SIZE = (Integer)Configuration.ARRAY_TLC_SIZE.get(8192);
        ARRAY_TLC_BYTE = ThreadLocal.withInitial(() -> new byte[ARRAY_TLC_SIZE]);
        ARRAY_TLC_CHAR = ThreadLocal.withInitial(() -> new char[ARRAY_TLC_SIZE]);
        NATIVE_ORDER = ByteOrder.nativeOrder();
        UTF16 = NATIVE_ORDER == ByteOrder.LITTLE_ENDIAN ? StandardCharsets.UTF_16LE : StandardCharsets.UTF_16BE;
        Library.initialize();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(0).order(NATIVE_ORDER);
        BUFFER_BYTE = byteBuffer.getClass();
        BUFFER_SHORT = byteBuffer.asShortBuffer().getClass();
        BUFFER_CHAR = byteBuffer.asCharBuffer().getClass();
        BUFFER_INT = byteBuffer.asIntBuffer().getClass();
        BUFFER_LONG = byteBuffer.asLongBuffer().getClass();
        BUFFER_FLOAT = byteBuffer.asFloatBuffer().getClass();
        BUFFER_DOUBLE = byteBuffer.asDoubleBuffer().getClass();
        UNSAFE = MemoryUtil.getUnsafeInstance();
        try {
            MARK = MemoryUtil.getMarkOffset();
            POSITION = MemoryUtil.getPositionOffset();
            LIMIT = MemoryUtil.getLimitOffset();
            CAPACITY = MemoryUtil.getCapacityOffset();
            ADDRESS = MemoryUtil.getAddressOffset();
            PARENT_BYTE = MemoryUtil.getFieldOffsetObject(byteBuffer.duplicate().order(byteBuffer.order()), byteBuffer);
            PARENT_SHORT = MemoryUtil.getFieldOffsetObject(byteBuffer.asShortBuffer(), byteBuffer);
            PARENT_CHAR = MemoryUtil.getFieldOffsetObject(byteBuffer.asCharBuffer(), byteBuffer);
            PARENT_INT = MemoryUtil.getFieldOffsetObject(byteBuffer.asIntBuffer(), byteBuffer);
            PARENT_LONG = MemoryUtil.getFieldOffsetObject(byteBuffer.asLongBuffer(), byteBuffer);
            PARENT_FLOAT = MemoryUtil.getFieldOffsetObject(byteBuffer.asFloatBuffer(), byteBuffer);
            PARENT_DOUBLE = MemoryUtil.getFieldOffsetObject(byteBuffer.asDoubleBuffer(), byteBuffer);
        }
        catch (Throwable throwable) {
            throw new UnsupportedOperationException(throwable);
        }
        PAGE_SIZE = UNSAFE.pageSize();
        CACHE_LINE_SIZE = 64;
        FILL_PATTERN_32 = Integer.divideUnsigned(-1, 255);
        FILL_PATTERN_64 = Long.divideUnsigned(-1L, 255L);
    }
}

