/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Callback;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.MemoryManage$DebugAllocator$1;
import org.lwjgl.system.MemoryManage$DebugAllocator$2;
import org.lwjgl.system.MemoryManage$DebugAllocator$3;
import org.lwjgl.system.MemoryManage$DebugAllocator$4;
import org.lwjgl.system.MemoryManage$DebugAllocator$5;
import org.lwjgl.system.MemoryManage$DebugAllocator$6;
import org.lwjgl.system.MemoryManage$DebugAllocator$Allocation;
import org.lwjgl.system.MemoryManage$DebugAllocator$AllocationKey;
import org.lwjgl.system.MemoryUtil$MemoryAllocationReport;
import org.lwjgl.system.MemoryUtil$MemoryAllocationReport$Aggregate;
import org.lwjgl.system.MemoryUtil$MemoryAllocator;
import org.lwjgl.system.StackWalkUtil;

class MemoryManage$DebugAllocator
implements MemoryUtil$MemoryAllocator {
    private static final ConcurrentMap ALLOCATIONS = new ConcurrentHashMap();
    private static final ConcurrentMap THREADS = new ConcurrentHashMap();
    private final MemoryUtil$MemoryAllocator allocator;
    private final long[] callbacks;

    MemoryManage$DebugAllocator(MemoryUtil$MemoryAllocator memoryUtil$MemoryAllocator) {
        this.allocator = memoryUtil$MemoryAllocator;
        this.callbacks = new long[]{new MemoryManage$DebugAllocator$1(this).address(), new MemoryManage$DebugAllocator$2(this).address(), new MemoryManage$DebugAllocator$3(this).address(), new MemoryManage$DebugAllocator$4(this).address(), new MemoryManage$DebugAllocator$5(this).address(), new MemoryManage$DebugAllocator$6(this).address()};
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            long[] lArray = this.callbacks;
            int n2 = this.callbacks.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Callback.free(lArray[i2]);
            }
            if (ALLOCATIONS.isEmpty()) {
                return;
            }
            boolean bl2 = false;
            for (StackTraceElement[] stackTraceElementArray : ALLOCATIONS.keySet()) {
                StringBuilder stringBuilder = new StringBuilder(512);
                stringBuilder.append("[LWJGL] ").append(stackTraceElementArray.size).append(" bytes leaked, thread ").append(stackTraceElementArray.threadId).append(" (").append((String)THREADS.get(stackTraceElementArray.threadId)).append("), address: 0x").append(Long.toHexString(stackTraceElementArray.address).toUpperCase()).append("\n");
                StackTraceElement[] stackTraceElementArray2 = MemoryManage$DebugAllocator$Allocation.access$100((MemoryManage$DebugAllocator$Allocation)stackTraceElementArray);
                if (stackTraceElementArray2 != null) {
                    stackTraceElementArray = stackTraceElementArray2;
                    int n3 = stackTraceElementArray2.length;
                    for (int i3 = 0; i3 < n3; ++i3) {
                        StackTraceElement stackTraceElement = stackTraceElementArray[i3];
                        stringBuilder.append("\tat ").append(((Object)stackTraceElement).toString()).append("\n");
                    }
                } else {
                    bl2 = true;
                }
                APIUtil.DEBUG_STREAM.print(stringBuilder);
            }
            if (bl2) {
                APIUtil.DEBUG_STREAM.print("[LWJGL] Reminder: disable Configuration.DEBUG_MEMORY_ALLOCATOR_FAST to get stacktraces of leaking allocations.\n");
            }
        }));
    }

    @Override
    public long getMalloc() {
        return this.callbacks[0];
    }

    @Override
    public long getCalloc() {
        return this.callbacks[1];
    }

    @Override
    public long getRealloc() {
        return this.callbacks[2];
    }

    @Override
    public long getFree() {
        return this.callbacks[3];
    }

    @Override
    public long getAlignedAlloc() {
        return this.callbacks[4];
    }

    @Override
    public long getAlignedFree() {
        return this.callbacks[5];
    }

    @Override
    public long malloc(long l2) {
        return MemoryManage$DebugAllocator.track(this.allocator.malloc(l2), l2);
    }

    @Override
    public long calloc(long l2, long l3) {
        return MemoryManage$DebugAllocator.track(this.allocator.calloc(l2, l3), l2 * l3);
    }

    @Override
    public long realloc(long l2, long l3) {
        long l4 = MemoryManage$DebugAllocator.untrack(l2);
        long l5 = this.allocator.realloc(l2, l3);
        if (l5 != 0L) {
            MemoryManage$DebugAllocator.track(l5, l3);
        } else if (l3 != 0L) {
            MemoryManage$DebugAllocator.track(l2, l4);
        }
        return l5;
    }

    @Override
    public void free(long l2) {
        MemoryManage$DebugAllocator.untrack(l2);
        this.allocator.free(l2);
    }

    @Override
    public long aligned_alloc(long l2, long l3) {
        return MemoryManage$DebugAllocator.track(this.allocator.aligned_alloc(l2, l3), l3);
    }

    @Override
    public void aligned_free(long l2) {
        MemoryManage$DebugAllocator.untrack(l2);
        this.allocator.aligned_free(l2);
    }

    static long track(long l2, long l3) {
        if (l2 != 0L) {
            MemoryManage$DebugAllocator$Allocation memoryManage$DebugAllocator$Allocation;
            Thread thread = Thread.currentThread();
            THREADS.putIfAbsent(thread.getId(), thread.getName());
            MemoryManage$DebugAllocator$Allocation memoryManage$DebugAllocator$Allocation2 = memoryManage$DebugAllocator$Allocation = new MemoryManage$DebugAllocator$Allocation(l2, l3, thread.getId(), (Boolean)Configuration.DEBUG_MEMORY_ALLOCATOR_FAST.get(Boolean.FALSE) != false ? null : StackWalkUtil.stackWalkGetTrace());
            MemoryManage$DebugAllocator$Allocation memoryManage$DebugAllocator$Allocation3 = ALLOCATIONS.put(memoryManage$DebugAllocator$Allocation2, memoryManage$DebugAllocator$Allocation2);
            if (memoryManage$DebugAllocator$Allocation3 != null) {
                MemoryManage$DebugAllocator.trackAbort(l2, memoryManage$DebugAllocator$Allocation3, memoryManage$DebugAllocator$Allocation);
            }
        }
        return l2;
    }

    private static void trackAbort(long l2, MemoryManage$DebugAllocator$Allocation memoryManage$DebugAllocator$Allocation, MemoryManage$DebugAllocator$Allocation memoryManage$DebugAllocator$Allocation2) {
        String string = Long.toHexString(l2).toUpperCase();
        MemoryManage$DebugAllocator.trackAbortPrint(memoryManage$DebugAllocator$Allocation, "Old", string);
        MemoryManage$DebugAllocator.trackAbortPrint(memoryManage$DebugAllocator$Allocation2, "New", string);
        throw new IllegalStateException("The memory address specified is already being tracked: 0x".concat(String.valueOf(string)));
    }

    private static void trackAbortPrint(MemoryManage$DebugAllocator$Allocation stackTraceElementArray, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(512);
        stringBuilder.append("[LWJGL] ").append(string).append(" allocation with size ").append(stackTraceElementArray.size).append(", thread ").append(stackTraceElementArray.threadId).append(" (").append((String)THREADS.get(stackTraceElementArray.threadId)).append("), address: 0x").append(string2).append("\n");
        stackTraceElementArray = MemoryManage$DebugAllocator$Allocation.access$100((MemoryManage$DebugAllocator$Allocation)stackTraceElementArray);
        if (stackTraceElementArray != null) {
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                stringBuilder.append("\tat ").append(((Object)stackTraceElement).toString()).append("\n");
            }
        }
        APIUtil.DEBUG_STREAM.print(stringBuilder);
    }

    static long untrack(long l2) {
        if (l2 == 0L) {
            return 0L;
        }
        MemoryManage$DebugAllocator$Allocation memoryManage$DebugAllocator$Allocation = (MemoryManage$DebugAllocator$Allocation)ALLOCATIONS.remove(new MemoryManage$DebugAllocator$Allocation(l2, 0L, 0L, null));
        if (memoryManage$DebugAllocator$Allocation == null) {
            MemoryManage$DebugAllocator.untrackAbort(l2);
        }
        return memoryManage$DebugAllocator$Allocation.size;
    }

    private static void untrackAbort(long l2) {
        String string = Long.toHexString(l2).toUpperCase();
        throw new IllegalStateException("The memory address specified is not being tracked: 0x".concat(String.valueOf(string)));
    }

    static void report(MemoryUtil$MemoryAllocationReport memoryUtil$MemoryAllocationReport) {
        for (MemoryManage$DebugAllocator$Allocation memoryManage$DebugAllocator$Allocation : ALLOCATIONS.keySet()) {
            memoryUtil$MemoryAllocationReport.invoke(memoryManage$DebugAllocator$Allocation.address, memoryManage$DebugAllocator$Allocation.size, memoryManage$DebugAllocator$Allocation.threadId, (String)THREADS.get(memoryManage$DebugAllocator$Allocation.threadId), MemoryManage$DebugAllocator$Allocation.access$100(memoryManage$DebugAllocator$Allocation));
        }
    }

    private static void aggregate(Object object2, long l2, Map map) {
        AtomicLong atomicLong = map.computeIfAbsent(object2, object -> new AtomicLong());
        atomicLong.set(atomicLong.get() + l2);
    }

    static void report(MemoryUtil$MemoryAllocationReport memoryUtil$MemoryAllocationReport, MemoryUtil$MemoryAllocationReport$Aggregate memoryUtil$MemoryAllocationReport$Aggregate, boolean bl2) {
        switch (memoryUtil$MemoryAllocationReport$Aggregate) {
            case ALL: {
                MemoryManage$DebugAllocator.reportAll(memoryUtil$MemoryAllocationReport, bl2);
                return;
            }
            case GROUP_BY_METHOD: {
                MemoryManage$DebugAllocator.reportByMethod(memoryUtil$MemoryAllocationReport, bl2);
                return;
            }
            case GROUP_BY_STACKTRACE: {
                MemoryManage$DebugAllocator.reportByStacktrace(memoryUtil$MemoryAllocationReport, bl2);
            }
        }
    }

    private static void reportAll(MemoryUtil$MemoryAllocationReport memoryUtil$MemoryAllocationReport, boolean bl2) {
        if (bl2) {
            HashMap hashMap = new HashMap();
            for (MemoryManage$DebugAllocator$Allocation memoryManage$DebugAllocator$Allocation : ALLOCATIONS.values()) {
                MemoryManage$DebugAllocator.aggregate(memoryManage$DebugAllocator$Allocation.threadId, memoryManage$DebugAllocator$Allocation.size, hashMap);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                memoryUtil$MemoryAllocationReport.invoke(0L, ((AtomicLong)entry.getValue()).get(), (Long)entry.getKey(), (String)THREADS.get(entry.getKey()), null);
            }
            return;
        }
        long l2 = 0L;
        for (MemoryManage$DebugAllocator$Allocation memoryManage$DebugAllocator$Allocation : ALLOCATIONS.values()) {
            l2 += memoryManage$DebugAllocator$Allocation.size;
        }
        memoryUtil$MemoryAllocationReport.invoke(0L, l2, 0L, null, null);
    }

    private static void reportByMethod(MemoryUtil$MemoryAllocationReport memoryUtil$MemoryAllocationReport, boolean bl2) {
        if (bl2) {
            Object object = new HashMap<Long, Map>();
            for (MemoryManage$DebugAllocator$Allocation object2 : ALLOCATIONS.keySet()) {
                StackTraceElement[] stackTraceElementArray = MemoryManage$DebugAllocator$Allocation.access$100(object2);
                if (stackTraceElementArray == null) continue;
                Map map = object.computeIfAbsent(object2.threadId, l2 -> new HashMap());
                MemoryManage$DebugAllocator.aggregate(stackTraceElementArray[0], object2.size, map);
            }
            for (Map.Entry entry : object.entrySet()) {
                long l3 = (Long)entry.getKey();
                object = (String)THREADS.get(l3);
                for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                    memoryUtil$MemoryAllocationReport.invoke(0L, ((AtomicLong)entry2.getValue()).get(), l3, (String)object, (StackTraceElement)entry2.getKey());
                }
            }
            return;
        }
        HashMap hashMap = new HashMap();
        for (MemoryManage$DebugAllocator$Allocation memoryManage$DebugAllocator$Allocation : ALLOCATIONS.keySet()) {
            StackTraceElement[] stackTraceElementArray = MemoryManage$DebugAllocator$Allocation.access$100(memoryManage$DebugAllocator$Allocation);
            if (stackTraceElementArray == null) continue;
            MemoryManage$DebugAllocator.aggregate(stackTraceElementArray[0], memoryManage$DebugAllocator$Allocation.size, hashMap);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            memoryUtil$MemoryAllocationReport.invoke(0L, ((AtomicLong)entry.getValue()).get(), 0L, null, (StackTraceElement)entry.getKey());
        }
    }

    private static void reportByStacktrace(MemoryUtil$MemoryAllocationReport memoryUtil$MemoryAllocationReport, boolean bl2) {
        if (bl2) {
            Object object = new HashMap<Long, Map>();
            for (MemoryManage$DebugAllocator$Allocation object2 : ALLOCATIONS.keySet()) {
                StackTraceElement[] stackTraceElementArray = MemoryManage$DebugAllocator$Allocation.access$100(object2);
                if (stackTraceElementArray == null) continue;
                Map map = object.computeIfAbsent(object2.threadId, l2 -> new HashMap());
                MemoryManage$DebugAllocator.aggregate(new MemoryManage$DebugAllocator$AllocationKey(stackTraceElementArray), object2.size, map);
            }
            for (Map.Entry entry : object.entrySet()) {
                long l3 = (Long)entry.getKey();
                object = ((Map)entry.getValue()).entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry entry2 = (Map.Entry)object.next();
                    memoryUtil$MemoryAllocationReport.invoke(0L, ((AtomicLong)entry2.getValue()).get(), l3, (String)THREADS.get(l3), ((MemoryManage$DebugAllocator$AllocationKey)entry2.getKey()).elements);
                }
            }
            return;
        }
        HashMap hashMap = new HashMap();
        for (MemoryManage$DebugAllocator$Allocation memoryManage$DebugAllocator$Allocation : ALLOCATIONS.keySet()) {
            StackTraceElement[] stackTraceElementArray = MemoryManage$DebugAllocator$Allocation.access$100(memoryManage$DebugAllocator$Allocation);
            if (stackTraceElementArray == null) continue;
            MemoryManage$DebugAllocator.aggregate(new MemoryManage$DebugAllocator$AllocationKey(stackTraceElementArray), memoryManage$DebugAllocator$Allocation.size, hashMap);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            memoryUtil$MemoryAllocationReport.invoke(0L, ((AtomicLong)entry.getValue()).get(), 0L, null, ((MemoryManage$DebugAllocator$AllocationKey)entry.getKey()).elements);
        }
    }
}

