/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.lwjgl.Version;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.Platform;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.SharedLibraryLoader;

public final class Library {
    public static final String JNI_LIBRARY_NAME = (String)Configuration.LIBRARY_NAME.get(Platform.mapLibraryNameBundled("lwjgl"));
    static final String JAVA_LIBRARY_PATH = "java.library.path";
    private static final Pattern PATH_SEPARATOR = Pattern.compile(File.pathSeparator);
    private static final Pattern NATIVES_JAR = Pattern.compile("/[\\w-]+?-natives-\\w+.jar!/");

    private Library() {
    }

    public static void initialize() {
    }

    public static void loadSystem(String string, String string2) {
        Library.loadSystem(System::load, System::loadLibrary, Library.class, string, string2);
    }

    public static void loadSystem(Consumer consumer, Consumer consumer2, Class clazz, String string, String string2) {
        Object object;
        boolean bl2;
        String string3;
        block28: {
            if (Checks.DEBUG) {
                APIUtil.DEBUG_STREAM.print("[LWJGL] Loading JNI library: " + string2 + "\n\tModule: " + string + "\n");
            }
            if (Paths.get(string2, new String[0]).isAbsolute()) {
                consumer.accept(string2);
                APIUtil.apiLogMore("Success");
                return;
            }
            string3 = Platform.get().mapLibraryName(string2);
            Serializable serializable = Library.findResource(clazz, string, string3, bl2 = string2.contains("lwjgl"));
            if (serializable == null) {
                if (Library.loadSystemFromLibraryPath(consumer, clazz, string, string3, bl2)) {
                    return;
                }
            } else {
                boolean bl3 = (Boolean)Configuration.DEBUG_LOADER.get(Boolean.FALSE);
                try {
                    block26: {
                        block27: {
                            if (!((Boolean)Configuration.SHARED_LIBRARY_EXTRACT_FORCE.get(Boolean.FALSE)).booleanValue() && (object = Library.getRegularFilePath((URL)serializable)) != null) {
                                consumer.accept(object);
                                APIUtil.apiLogMore("Loaded from classpath: ".concat(String.valueOf(object)));
                                return;
                            }
                            if (bl3) {
                                APIUtil.apiLogMore("Using SharedLibraryLoader...");
                            }
                            object = SharedLibraryLoader.load(string2, string3, (URL)serializable, consumer);
                            serializable = null;
                            try {
                                if (!Library.loadSystemFromLibraryPath(consumer, clazz, string, string3, bl2)) break block26;
                                if (object == null) break block27;
                            }
                            catch (Throwable throwable) {
                                try {
                                    Throwable throwable2 = throwable;
                                    serializable = throwable;
                                    throw throwable2;
                                }
                                catch (Throwable throwable3) {
                                    if (object != null) {
                                        if (serializable != null) {
                                            try {
                                                ((AbstractInterruptibleChannel)object).close();
                                            }
                                            catch (Throwable throwable4) {
                                                ((Throwable)serializable).addSuppressed(throwable4);
                                            }
                                        } else {
                                            ((AbstractInterruptibleChannel)object).close();
                                        }
                                    }
                                    throw throwable3;
                                }
                            }
                            ((AbstractInterruptibleChannel)object).close();
                        }
                        return;
                    }
                    if (object != null) {
                        ((AbstractInterruptibleChannel)object).close();
                    }
                }
                catch (Exception exception) {
                    if (!bl3) break block28;
                    exception.printStackTrace(APIUtil.DEBUG_STREAM);
                }
            }
        }
        String string4 = System.getProperty(JAVA_LIBRARY_PATH);
        if (bl2 && string4 != null) {
            String string5 = string;
            if (Library.loadSystem(consumer, clazz, string5, Library.getBundledPath(string5, string3), false, JAVA_LIBRARY_PATH, string4)) {
                return;
            }
        }
        try {
            consumer2.accept(string2);
            object = string4 == null ? null : Library.findFile(string4, string, string3, bl2);
            if (object != null) {
                APIUtil.apiLogMore(String.format("Loaded from %s: %s", JAVA_LIBRARY_PATH, object));
                if (bl2) {
                    Library.checkHash(clazz, (Path)object, string, string3);
                    return;
                }
            } else {
                APIUtil.apiLogMore("Loaded from a ClassLoader provided path.");
            }
            return;
        }
        catch (Throwable throwable) {
            APIUtil.apiLogMore(string3 + " not found in java.library.path");
            Library.detectPlatformMismatch(clazz, string);
            Library.printError(true);
            throw new UnsatisfiedLinkError("Failed to locate library: ".concat(String.valueOf(string3)));
        }
    }

    private static boolean loadSystemFromLibraryPath(Consumer consumer, Class clazz, String string, String string2, boolean bl2) {
        String string3 = (String)Configuration.LIBRARY_PATH.get();
        return string3 != null && Library.loadSystem(consumer, clazz, string, string2, bl2, Configuration.LIBRARY_PATH.getProperty(), string3);
    }

    private static boolean loadSystem(Consumer consumer, Class clazz, String string, String string2, boolean bl2, String string3, String string4) {
        Path path = Library.findFile(string4, string, string2, bl2);
        if (path == null) {
            APIUtil.apiLogMore(string2 + " not found in " + string3 + "=" + string4);
            return false;
        }
        consumer.accept(path.toAbsolutePath().toString());
        APIUtil.apiLogMore("Loaded from " + string3 + ": " + path);
        if (bl2) {
            Library.checkHash(clazz, path, string, string2);
        }
        return true;
    }

    public static SharedLibrary loadNative(String string, String string2) {
        return Library.loadNative(Library.class, string, string2);
    }

    public static SharedLibrary loadNative(Class clazz, String string, String string2) {
        return Library.loadNative(clazz, string, string2, false);
    }

    public static SharedLibrary loadNative(Class clazz, String string, String string2, boolean bl2) {
        return Library.loadNative(clazz, string, string2, bl2, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SharedLibrary loadNative(Class clazz, String string, String string2, boolean bl2, boolean bl3) {
        String string3;
        Object object;
        Object object2;
        String string4;
        block25: {
            if (Checks.DEBUG) {
                APIUtil.DEBUG_STREAM.print("[LWJGL] Loading library: " + string2 + "\n\tModule: " + string + "\n");
            }
            if (Paths.get(string2, new String[0]).isAbsolute()) {
                SharedLibrary sharedLibrary = APIUtil.apiCreateLibrary(string2);
                APIUtil.apiLogMore("Success");
                return sharedLibrary;
            }
            string4 = Platform.get().mapLibraryName(string2);
            object2 = Library.findResource(clazz, string, string4, bl2);
            if (object2 == null) {
                object2 = Library.loadNativeFromLibraryPath(clazz, string, string4, bl2);
                if (object2 != null) {
                    return object2;
                }
            } else {
                boolean bl4 = (Boolean)Configuration.DEBUG_LOADER.get(Boolean.FALSE);
                try {
                    block24: {
                        if (!((Boolean)Configuration.SHARED_LIBRARY_EXTRACT_FORCE.get(Boolean.FALSE)).booleanValue() && (object = Library.getRegularFilePath((URL)object2)) != null) {
                            object2 = APIUtil.apiCreateLibrary((String)object);
                            APIUtil.apiLogMore("Loaded from classpath: ".concat(String.valueOf(object)));
                            return object2;
                        }
                        if (bl4) {
                            APIUtil.apiLogMore("Using SharedLibraryLoader...");
                        }
                        object = SharedLibraryLoader.load(string2, string4, (URL)object2, null);
                        Throwable throwable = null;
                        try {
                            object2 = Library.loadNativeFromLibraryPath(clazz, string, string4, bl2);
                            if (object2 == null) break block24;
                            if (object == null) return object2;
                        }
                        catch (Throwable throwable2) {
                            try {
                                object2 = throwable2;
                                throwable = throwable2;
                                throw object2;
                            }
                            catch (Throwable throwable3) {
                                if (object == null) throw throwable3;
                                if (throwable == null) {
                                    ((AbstractInterruptibleChannel)object).close();
                                    throw throwable3;
                                }
                                try {
                                    ((AbstractInterruptibleChannel)object).close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                        }
                        ((AbstractInterruptibleChannel)object).close();
                        return object2;
                    }
                    if (object != null) {
                        ((AbstractInterruptibleChannel)object).close();
                    }
                }
                catch (Exception exception) {
                    if (!bl4) break block25;
                    exception.printStackTrace(APIUtil.DEBUG_STREAM);
                }
            }
        }
        if (!bl2 && (object2 = Library.loadNativeFromSystem(string4)) != null) {
            return object2;
        }
        if (((Boolean)Configuration.EMULATE_SYSTEM_LOADLIBRARY.get(Boolean.FALSE)).booleanValue()) {
            try {
                Method method = ClassLoader.class.getDeclaredMethod("findLibrary", String.class);
                method.setAccessible(true);
                object = (String)method.invoke((Object)clazz.getClassLoader(), string2);
                if (object != null) {
                    object2 = APIUtil.apiCreateLibrary((String)object);
                    APIUtil.apiLogMore("Loaded from ClassLoader provided path: ".concat(String.valueOf(object)));
                    return object2;
                }
            }
            catch (Exception exception) {}
        }
        if ((string3 = System.getProperty(JAVA_LIBRARY_PATH)) != null && (object2 = Library.loadNative(clazz, string, string4, bl2, JAVA_LIBRARY_PATH, string3)) != null) {
            return object2;
        }
        if (bl2 && (object2 = Library.loadNativeFromSystem(string4)) != null) {
            return object2;
        }
        if (!bl3) throw new UnsatisfiedLinkError("Failed to locate library: ".concat(String.valueOf(string4)));
        Library.detectPlatformMismatch(clazz, string);
        Library.printError(bl2);
        throw new UnsatisfiedLinkError("Failed to locate library: ".concat(String.valueOf(string4)));
    }

    private static SharedLibrary loadNativeFromSystem(String string) {
        SharedLibrary sharedLibrary;
        try {
            sharedLibrary = APIUtil.apiCreateLibrary(string);
            String string2 = sharedLibrary.getPath();
            APIUtil.apiLogMore(string2 == null ? "Loaded from system paths" : "Loaded from system paths: ".concat(String.valueOf(string2)));
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            sharedLibrary = null;
            APIUtil.apiLogMore(string + " not found in system paths");
        }
        return sharedLibrary;
    }

    private static SharedLibrary loadNativeFromLibraryPath(Class clazz, String string, String string2, boolean bl2) {
        String string3 = (String)Configuration.LIBRARY_PATH.get();
        if (string3 == null) {
            return null;
        }
        return Library.loadNative(clazz, string, string2, bl2, Configuration.LIBRARY_PATH.getProperty(), string3);
    }

    private static SharedLibrary loadNative(Class clazz, String string, String string2, boolean bl2, String string3, String object) {
        Path path = Library.findFile((String)object, string, string2, bl2);
        if (path == null) {
            APIUtil.apiLogMore(string2 + " not found in " + string3 + "=" + (String)object);
            return null;
        }
        object = APIUtil.apiCreateLibrary(path.toAbsolutePath().toString());
        APIUtil.apiLogMore("Loaded from " + string3 + ": " + path);
        if (bl2) {
            Library.checkHash(clazz, path, string, string2);
        }
        return object;
    }

    public static SharedLibrary loadNative(Class clazz, String string, Configuration configuration, String ... stringArray) {
        return Library.loadNative(clazz, string, configuration, null, stringArray);
    }

    public static SharedLibrary loadNative(Class clazz, String string, Configuration object, Supplier supplier, String ... stringArray) {
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("No default names specified.");
        }
        if (object != null && (object = (String)((Configuration)object).get()) != null) {
            return Library.loadNative(clazz, string, (String)object);
        }
        if (supplier == null && stringArray.length <= 1) {
            return Library.loadNative(clazz, string, stringArray[0]);
        }
        try {
            return Library.loadNative(clazz, string, stringArray[0], false, false);
        }
        catch (Throwable throwable) {
            for (int i2 = 1; i2 < stringArray.length; ++i2) {
                try {
                    return Library.loadNative(clazz, string, stringArray[i2], false, supplier == null && i2 == stringArray.length - 1);
                }
                catch (Throwable throwable2) {
                    continue;
                }
            }
            if (supplier != null) {
                return (SharedLibrary)supplier.get();
            }
            throw throwable;
        }
    }

    private static String getBundledPath(String string, String string2) {
        return Platform.mapLibraryPathBundled(string.replace('.', '/') + "/" + string2);
    }

    static URL findResource(Class clazz, String string, String string2, boolean bl2) {
        URL uRL = null;
        if (bl2 && !(string = Library.getBundledPath(string, string2)).equals(string2)) {
            uRL = clazz.getClassLoader().getResource(string);
        }
        if (uRL == null) {
            return clazz.getClassLoader().getResource(string2);
        }
        return uRL;
    }

    static String getRegularFilePath(URL object) {
        if (((URL)object).getProtocol().equals("file")) {
            try {
                object = Paths.get(((URL)object).toURI());
                if (object.isAbsolute() && Files.isReadable((Path)object)) {
                    return object.toString();
                }
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return null;
    }

    static Path findFile(String string, String object, String string2, boolean bl2) {
        if (bl2 && !((String)(object = Library.getBundledPath((String)object, string2))).equals(string2) && (object = Library.findFile(string, (String)object)) != null) {
            return object;
        }
        return Library.findFile(string, string2);
    }

    private static Path findFile(String stringArray, String string) {
        stringArray = PATH_SEPARATOR.split((CharSequence)stringArray);
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Path path = Paths.get(stringArray[i2], string);
            if (!Files.isReadable(path)) continue;
            return path;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void detectPlatformMismatch(Class enumeration, String string) {
        if (!string.startsWith("org.lwjgl")) {
            return;
        }
        String string2 = string.equals("org.lwjgl") ? "lwjgl" : "lwjgl-" + string.substring(10);
        ArrayList<Object> arrayList = new ArrayList<Object>(8);
        try {
            enumeration = ((Class)((Object)enumeration)).getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (enumeration.hasMoreElements()) {
                Object object;
                InputStream inputStream = enumeration.nextElement().openStream();
                Throwable throwable = null;
                try {
                    object = new Manifest(inputStream).getMainAttributes();
                    if (string2.equals(((Attributes)object).getValue("Implementation-Title")) && (object = ((Attributes)object).getValue("LWJGL-Platform")) != null) {
                        arrayList.add(object);
                    }
                    if (inputStream == null) continue;
                }
                catch (Throwable throwable2) {
                    try {
                        object = throwable2;
                        throwable = throwable2;
                        throw object;
                    }
                    catch (Throwable throwable3) {
                        if (inputStream == null) throw throwable3;
                        if (throwable == null) {
                            inputStream.close();
                            throw throwable3;
                        }
                        try {
                            inputStream.close();
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                            throw throwable3;
                        }
                    }
                }
                inputStream.close();
            }
        }
        catch (IOException iOException) {}
        if (arrayList.isEmpty()) return;
        APIUtil.DEBUG_STREAM.print("[LWJGL] Platform/architecture mismatch detected for module: " + string + "\n\tJVM platform:\t\t" + Platform.get().getName() + " " + System.getProperty("os.arch") + " " + System.getProperty("java.version") + "\n\t\t" + System.getProperty("java.vm.name") + " v" + System.getProperty("java.vm.version") + " by " + System.getProperty("java.vm.vendor") + "\n\tPlatform" + (arrayList.size() == 1 ? "" : "s") + " available on classpath:\n\t\t" + String.join((CharSequence)"\n\t\t", arrayList) + "\n");
    }

    private static void printError(boolean bl2) {
        Library.printError("[LWJGL] Failed to load a library. Possible solutions:\n" + (bl2 ? "\ta) Add the directory that contains the shared library to -Djava.library.path or -Dorg.lwjgl.librarypath.\n\tb) Add the JAR that contains the shared library to the classpath." : "\ta) Install the library or the driver that provides the library.\n\tb) Ensure that the library is accessible from the system library paths."));
    }

    static void printError(String charSequence) {
        charSequence = new StringBuilder((String)charSequence);
        ((StringBuilder)charSequence).append("\n");
        if (!Checks.DEBUG) {
            ((StringBuilder)charSequence).append("[LWJGL] Enable debug mode with -Dorg.lwjgl.util.Debug=true for better diagnostics.\n");
            if (!((Boolean)Configuration.DEBUG_LOADER.get(Boolean.FALSE)).booleanValue()) {
                ((StringBuilder)charSequence).append("[LWJGL] Enable the SharedLibraryLoader debug mode with -Dorg.lwjgl.util.DebugLoader=true for better diagnostics.\n");
            }
        }
        APIUtil.DEBUG_STREAM.print(charSequence);
    }

    private static void checkHash(Class object, Path path, String object2, String string) {
        if (!Checks.CHECKS) {
            return;
        }
        try {
            Object object3 = null;
            Object object4 = null;
            object = ((Class)object).getClassLoader().getResources("META-INF/" + Library.getBundledPath((String)object2, string) + ".sha1");
            while (object.hasMoreElements()) {
                object2 = (URL)object.nextElement();
                if (NATIVES_JAR.matcher(((URL)object2).toExternalForm()).find()) {
                    object4 = object2;
                    continue;
                }
                object3 = object2;
            }
            if (object3 == null) {
                return;
            }
            object2 = Library.getSHA1(object3);
            if (!Arrays.equals((byte[])object2, (byte[])(object = (Object)(Checks.DEBUG || object4 == null ? Library.getSHA1(path) : Library.getSHA1(object4))))) {
                APIUtil.DEBUG_STREAM.println("[LWJGL] [ERROR] Incompatible Java and native library versions detected.\nPossible reasons:\n\ta) -Djava.library.path is set to a folder containing shared libraries of an older LWJGL version.\n\tb) The classpath contains jar files of an older LWJGL version.\nPossible solutions:\n\ta) Make sure to not set -Djava.library.path (it is not needed for developing with LWJGL 3) or make\n\t   sure the folder it points to contains the shared libraries of the correct LWJGL version.\n\tb) Check the classpath and make sure to only have jar files of the same LWJGL version in it.");
            }
            return;
        }
        catch (Throwable throwable) {
            if (Checks.DEBUG) {
                APIUtil.apiLog("Failed to verify native library.");
                throwable.printStackTrace();
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static byte[] getSHA1(URL object) {
        byte[] byArray = new byte[20];
        object = ((URL)object).openStream();
        Throwable throwable = null;
        try {
            for (int i2 = 0; i2 < 20; ++i2) {
                byArray[i2] = (byte)(Character.digit(((InputStream)object).read(), 16) << 4 | Character.digit(((InputStream)object).read(), 16));
            }
            if (object == null) return byArray;
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (object == null) throw throwable4;
                if (throwable != null) {
                    try {
                        ((InputStream)object).close();
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable4;
                } else {
                    ((InputStream)object).close();
                }
                throw throwable4;
            }
        }
        ((InputStream)object).close();
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static byte[] getSHA1(Path object) {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        object = Files.newInputStream((Path)object, new OpenOption[0]);
        Throwable throwable = null;
        try {
            int n2;
            byte[] byArray = new byte[8192];
            while ((n2 = ((InputStream)object).read(byArray)) != -1) {
                messageDigest.update(byArray, 0, n2);
            }
            if (object == null) return messageDigest.digest();
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (object == null) throw throwable4;
                if (throwable != null) {
                    try {
                        ((InputStream)object).close();
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable4;
                } else {
                    ((InputStream)object).close();
                }
                throw throwable4;
            }
        }
        ((InputStream)object).close();
        return messageDigest.digest();
    }

    static {
        if (Checks.DEBUG) {
            APIUtil.DEBUG_STREAM.print("[LWJGL] Version: " + Version.getVersion() + "\n\t OS: " + System.getProperty("os.name") + " v" + System.getProperty("os.version") + "\n\tJRE: " + Platform.get().getName() + " " + System.getProperty("os.arch") + " " + System.getProperty("java.version") + "\n\tJVM: " + System.getProperty("java.vm.name") + " v" + System.getProperty("java.vm.version") + " by " + System.getProperty("java.vm.vendor") + "\n");
        }
        Library.loadSystem("org.lwjgl", JNI_LIBRARY_NAME);
    }
}

