/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.stb.STBTTVertex$Buffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;

public class STBTTVertex
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int CX;
    public static final int CY;
    public static final int CX1;
    public static final int CY1;
    public static final int TYPE;

    protected STBTTVertex(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected STBTTVertex create(long l2, ByteBuffer byteBuffer) {
        return new STBTTVertex(l2, byteBuffer);
    }

    public STBTTVertex(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), STBTTVertex.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public short x() {
        return STBTTVertex.nx(this.address());
    }

    public short y() {
        return STBTTVertex.ny(this.address());
    }

    public short cx() {
        return STBTTVertex.ncx(this.address());
    }

    public short cy() {
        return STBTTVertex.ncy(this.address());
    }

    public short cx1() {
        return STBTTVertex.ncx1(this.address());
    }

    public short cy1() {
        return STBTTVertex.ncy1(this.address());
    }

    public byte type() {
        return STBTTVertex.ntype(this.address());
    }

    public static STBTTVertex malloc() {
        return new STBTTVertex(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static STBTTVertex calloc() {
        return new STBTTVertex(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static STBTTVertex create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new STBTTVertex(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static STBTTVertex create(long l2) {
        return new STBTTVertex(l2, null);
    }

    public static STBTTVertex createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new STBTTVertex(l2, null);
    }

    public static STBTTVertex$Buffer malloc(int n2) {
        return new STBTTVertex$Buffer(MemoryUtil.nmemAllocChecked(STBTTVertex.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static STBTTVertex$Buffer calloc(int n2) {
        return new STBTTVertex$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static STBTTVertex$Buffer create(int n2) {
        ByteBuffer byteBuffer = STBTTVertex.__create(n2, SIZEOF);
        int n3 = n2;
        return new STBTTVertex$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static STBTTVertex$Buffer create(long l2, int n2) {
        return new STBTTVertex$Buffer(l2, n2);
    }

    public static STBTTVertex$Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new STBTTVertex$Buffer(l2, n2);
    }

    public static STBTTVertex mallocStack() {
        return STBTTVertex.malloc(MemoryStack.stackGet());
    }

    public static STBTTVertex callocStack() {
        return STBTTVertex.calloc(MemoryStack.stackGet());
    }

    public static STBTTVertex mallocStack(MemoryStack memoryStack) {
        return STBTTVertex.malloc(memoryStack);
    }

    public static STBTTVertex callocStack(MemoryStack memoryStack) {
        return STBTTVertex.calloc(memoryStack);
    }

    public static STBTTVertex$Buffer mallocStack(int n2) {
        return STBTTVertex.malloc(n2, MemoryStack.stackGet());
    }

    public static STBTTVertex$Buffer callocStack(int n2) {
        return STBTTVertex.calloc(n2, MemoryStack.stackGet());
    }

    public static STBTTVertex$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return STBTTVertex.malloc(n2, memoryStack);
    }

    public static STBTTVertex$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return STBTTVertex.calloc(n2, memoryStack);
    }

    public static STBTTVertex malloc(MemoryStack memoryStack) {
        return new STBTTVertex(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static STBTTVertex calloc(MemoryStack memoryStack) {
        return new STBTTVertex(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static STBTTVertex$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new STBTTVertex$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static STBTTVertex$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new STBTTVertex$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static short nx(long l2) {
        return UNSAFE.getShort(null, l2 + (long)X);
    }

    public static short ny(long l2) {
        return UNSAFE.getShort(null, l2 + (long)Y);
    }

    public static short ncx(long l2) {
        return UNSAFE.getShort(null, l2 + (long)CX);
    }

    public static short ncy(long l2) {
        return UNSAFE.getShort(null, l2 + (long)CY);
    }

    public static short ncx1(long l2) {
        return UNSAFE.getShort(null, l2 + (long)CX1);
    }

    public static short ncy1(long l2) {
        return UNSAFE.getShort(null, l2 + (long)CY1);
    }

    public static byte ntype(long l2) {
        return UNSAFE.getByte(null, l2 + (long)TYPE);
    }

    static {
        Struct$Layout struct$Layout = STBTTVertex.__struct(STBTTVertex.__member(2), STBTTVertex.__member(2), STBTTVertex.__member(2), STBTTVertex.__member(2), STBTTVertex.__member(2), STBTTVertex.__member(2), STBTTVertex.__member(1));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        X = struct$Layout.offsetof(0);
        Y = struct$Layout.offsetof(1);
        CX = struct$Layout.offsetof(2);
        CY = struct$Layout.offsetof(3);
        CX1 = struct$Layout.offsetof(4);
        CY1 = struct$Layout.offsetof(5);
        TYPE = struct$Layout.offsetof(6);
    }
}

