/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.stb.STBTTBakedChar$Buffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;

public class STBTTBakedChar
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X0;
    public static final int Y0;
    public static final int X1;
    public static final int Y1;
    public static final int XOFF;
    public static final int YOFF;
    public static final int XADVANCE;

    protected STBTTBakedChar(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected STBTTBakedChar create(long l2, ByteBuffer byteBuffer) {
        return new STBTTBakedChar(l2, byteBuffer);
    }

    public STBTTBakedChar(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), STBTTBakedChar.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public short x0() {
        return STBTTBakedChar.nx0(this.address());
    }

    public short y0() {
        return STBTTBakedChar.ny0(this.address());
    }

    public short x1() {
        return STBTTBakedChar.nx1(this.address());
    }

    public short y1() {
        return STBTTBakedChar.ny1(this.address());
    }

    public float xoff() {
        return STBTTBakedChar.nxoff(this.address());
    }

    public float yoff() {
        return STBTTBakedChar.nyoff(this.address());
    }

    public float xadvance() {
        return STBTTBakedChar.nxadvance(this.address());
    }

    public static STBTTBakedChar malloc() {
        return new STBTTBakedChar(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static STBTTBakedChar calloc() {
        return new STBTTBakedChar(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static STBTTBakedChar create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new STBTTBakedChar(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static STBTTBakedChar create(long l2) {
        return new STBTTBakedChar(l2, null);
    }

    public static STBTTBakedChar createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new STBTTBakedChar(l2, null);
    }

    public static STBTTBakedChar$Buffer malloc(int n2) {
        return new STBTTBakedChar$Buffer(MemoryUtil.nmemAllocChecked(STBTTBakedChar.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static STBTTBakedChar$Buffer calloc(int n2) {
        return new STBTTBakedChar$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static STBTTBakedChar$Buffer create(int n2) {
        ByteBuffer byteBuffer = STBTTBakedChar.__create(n2, SIZEOF);
        int n3 = n2;
        return new STBTTBakedChar$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static STBTTBakedChar$Buffer create(long l2, int n2) {
        return new STBTTBakedChar$Buffer(l2, n2);
    }

    public static STBTTBakedChar$Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new STBTTBakedChar$Buffer(l2, n2);
    }

    public static STBTTBakedChar mallocStack() {
        return STBTTBakedChar.malloc(MemoryStack.stackGet());
    }

    public static STBTTBakedChar callocStack() {
        return STBTTBakedChar.calloc(MemoryStack.stackGet());
    }

    public static STBTTBakedChar mallocStack(MemoryStack memoryStack) {
        return STBTTBakedChar.malloc(memoryStack);
    }

    public static STBTTBakedChar callocStack(MemoryStack memoryStack) {
        return STBTTBakedChar.calloc(memoryStack);
    }

    public static STBTTBakedChar$Buffer mallocStack(int n2) {
        return STBTTBakedChar.malloc(n2, MemoryStack.stackGet());
    }

    public static STBTTBakedChar$Buffer callocStack(int n2) {
        return STBTTBakedChar.calloc(n2, MemoryStack.stackGet());
    }

    public static STBTTBakedChar$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return STBTTBakedChar.malloc(n2, memoryStack);
    }

    public static STBTTBakedChar$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return STBTTBakedChar.calloc(n2, memoryStack);
    }

    public static STBTTBakedChar malloc(MemoryStack memoryStack) {
        return new STBTTBakedChar(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static STBTTBakedChar calloc(MemoryStack memoryStack) {
        return new STBTTBakedChar(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static STBTTBakedChar$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new STBTTBakedChar$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static STBTTBakedChar$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new STBTTBakedChar$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static short nx0(long l2) {
        return UNSAFE.getShort(null, l2 + (long)X0);
    }

    public static short ny0(long l2) {
        return UNSAFE.getShort(null, l2 + (long)Y0);
    }

    public static short nx1(long l2) {
        return UNSAFE.getShort(null, l2 + (long)X1);
    }

    public static short ny1(long l2) {
        return UNSAFE.getShort(null, l2 + (long)Y1);
    }

    public static float nxoff(long l2) {
        return UNSAFE.getFloat(null, l2 + (long)XOFF);
    }

    public static float nyoff(long l2) {
        return UNSAFE.getFloat(null, l2 + (long)YOFF);
    }

    public static float nxadvance(long l2) {
        return UNSAFE.getFloat(null, l2 + (long)XADVANCE);
    }

    static {
        Struct$Layout struct$Layout = STBTTBakedChar.__struct(STBTTBakedChar.__member(2), STBTTBakedChar.__member(2), STBTTBakedChar.__member(2), STBTTBakedChar.__member(2), STBTTBakedChar.__member(4), STBTTBakedChar.__member(4), STBTTBakedChar.__member(4));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        X0 = struct$Layout.offsetof(0);
        Y0 = struct$Layout.offsetof(1);
        X1 = struct$Layout.offsetof(2);
        Y1 = struct$Layout.offsetof(3);
        XOFF = struct$Layout.offsetof(4);
        YOFF = struct$Layout.offsetof(5);
        XADVANCE = struct$Layout.offsetof(6);
    }
}

