/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.stb.STBTTAlignedQuad$Buffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;

public class STBTTAlignedQuad
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X0;
    public static final int Y0;
    public static final int S0;
    public static final int T0;
    public static final int X1;
    public static final int Y1;
    public static final int S1;
    public static final int T1;

    protected STBTTAlignedQuad(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected STBTTAlignedQuad create(long l2, ByteBuffer byteBuffer) {
        return new STBTTAlignedQuad(l2, byteBuffer);
    }

    public STBTTAlignedQuad(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), STBTTAlignedQuad.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float x0() {
        return STBTTAlignedQuad.nx0(this.address());
    }

    public float y0() {
        return STBTTAlignedQuad.ny0(this.address());
    }

    public float s0() {
        return STBTTAlignedQuad.ns0(this.address());
    }

    public float t0() {
        return STBTTAlignedQuad.nt0(this.address());
    }

    public float x1() {
        return STBTTAlignedQuad.nx1(this.address());
    }

    public float y1() {
        return STBTTAlignedQuad.ny1(this.address());
    }

    public float s1() {
        return STBTTAlignedQuad.ns1(this.address());
    }

    public float t1() {
        return STBTTAlignedQuad.nt1(this.address());
    }

    public static STBTTAlignedQuad malloc() {
        return new STBTTAlignedQuad(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static STBTTAlignedQuad calloc() {
        return new STBTTAlignedQuad(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static STBTTAlignedQuad create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new STBTTAlignedQuad(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static STBTTAlignedQuad create(long l2) {
        return new STBTTAlignedQuad(l2, null);
    }

    public static STBTTAlignedQuad createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new STBTTAlignedQuad(l2, null);
    }

    public static STBTTAlignedQuad$Buffer malloc(int n2) {
        return new STBTTAlignedQuad$Buffer(MemoryUtil.nmemAllocChecked(STBTTAlignedQuad.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static STBTTAlignedQuad$Buffer calloc(int n2) {
        return new STBTTAlignedQuad$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static STBTTAlignedQuad$Buffer create(int n2) {
        ByteBuffer byteBuffer = STBTTAlignedQuad.__create(n2, SIZEOF);
        int n3 = n2;
        return new STBTTAlignedQuad$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static STBTTAlignedQuad$Buffer create(long l2, int n2) {
        return new STBTTAlignedQuad$Buffer(l2, n2);
    }

    public static STBTTAlignedQuad$Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new STBTTAlignedQuad$Buffer(l2, n2);
    }

    public static STBTTAlignedQuad mallocStack() {
        return STBTTAlignedQuad.malloc(MemoryStack.stackGet());
    }

    public static STBTTAlignedQuad callocStack() {
        return STBTTAlignedQuad.calloc(MemoryStack.stackGet());
    }

    public static STBTTAlignedQuad mallocStack(MemoryStack memoryStack) {
        return STBTTAlignedQuad.malloc(memoryStack);
    }

    public static STBTTAlignedQuad callocStack(MemoryStack memoryStack) {
        return STBTTAlignedQuad.calloc(memoryStack);
    }

    public static STBTTAlignedQuad$Buffer mallocStack(int n2) {
        return STBTTAlignedQuad.malloc(n2, MemoryStack.stackGet());
    }

    public static STBTTAlignedQuad$Buffer callocStack(int n2) {
        return STBTTAlignedQuad.calloc(n2, MemoryStack.stackGet());
    }

    public static STBTTAlignedQuad$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return STBTTAlignedQuad.malloc(n2, memoryStack);
    }

    public static STBTTAlignedQuad$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return STBTTAlignedQuad.calloc(n2, memoryStack);
    }

    public static STBTTAlignedQuad malloc(MemoryStack memoryStack) {
        return new STBTTAlignedQuad(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static STBTTAlignedQuad calloc(MemoryStack memoryStack) {
        return new STBTTAlignedQuad(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static STBTTAlignedQuad$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new STBTTAlignedQuad$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static STBTTAlignedQuad$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new STBTTAlignedQuad$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static float nx0(long l2) {
        return UNSAFE.getFloat(null, l2 + (long)X0);
    }

    public static float ny0(long l2) {
        return UNSAFE.getFloat(null, l2 + (long)Y0);
    }

    public static float ns0(long l2) {
        return UNSAFE.getFloat(null, l2 + (long)S0);
    }

    public static float nt0(long l2) {
        return UNSAFE.getFloat(null, l2 + (long)T0);
    }

    public static float nx1(long l2) {
        return UNSAFE.getFloat(null, l2 + (long)X1);
    }

    public static float ny1(long l2) {
        return UNSAFE.getFloat(null, l2 + (long)Y1);
    }

    public static float ns1(long l2) {
        return UNSAFE.getFloat(null, l2 + (long)S1);
    }

    public static float nt1(long l2) {
        return UNSAFE.getFloat(null, l2 + (long)T1);
    }

    static {
        Struct$Layout struct$Layout = STBTTAlignedQuad.__struct(STBTTAlignedQuad.__member(4), STBTTAlignedQuad.__member(4), STBTTAlignedQuad.__member(4), STBTTAlignedQuad.__member(4), STBTTAlignedQuad.__member(4), STBTTAlignedQuad.__member(4), STBTTAlignedQuad.__member(4), STBTTAlignedQuad.__member(4));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        X0 = struct$Layout.offsetof(0);
        Y0 = struct$Layout.offsetof(1);
        S0 = struct$Layout.offsetof(2);
        T0 = struct$Layout.offsetof(3);
        X1 = struct$Layout.offsetof(4);
        Y1 = struct$Layout.offsetof(5);
        S1 = struct$Layout.offsetof(6);
        T1 = struct$Layout.offsetof(7);
    }
}

