/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.stb.STBRPRect$Buffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;

public class STBRPRect
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ID;
    public static final int W;
    public static final int H;
    public static final int X;
    public static final int Y;
    public static final int WAS_PACKED;

    protected STBRPRect(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected STBRPRect create(long l2, ByteBuffer byteBuffer) {
        return new STBRPRect(l2, byteBuffer);
    }

    public STBRPRect(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), STBRPRect.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int id() {
        return STBRPRect.nid(this.address());
    }

    public int w() {
        return STBRPRect.nw(this.address());
    }

    public int h() {
        return STBRPRect.nh(this.address());
    }

    public int x() {
        return STBRPRect.nx(this.address());
    }

    public int y() {
        return STBRPRect.ny(this.address());
    }

    public boolean was_packed() {
        return STBRPRect.nwas_packed(this.address()) != 0;
    }

    public STBRPRect id(int n2) {
        STBRPRect.nid(this.address(), n2);
        return this;
    }

    public STBRPRect w(int n2) {
        STBRPRect.nw(this.address(), n2);
        return this;
    }

    public STBRPRect h(int n2) {
        STBRPRect.nh(this.address(), n2);
        return this;
    }

    public STBRPRect x(int n2) {
        STBRPRect.nx(this.address(), n2);
        return this;
    }

    public STBRPRect y(int n2) {
        STBRPRect.ny(this.address(), n2);
        return this;
    }

    public STBRPRect was_packed(boolean bl2) {
        STBRPRect.nwas_packed(this.address(), bl2 ? 1 : 0);
        return this;
    }

    public STBRPRect set(int n2, int n3, int n4, int n5, int n6, boolean bl2) {
        this.id(n2);
        this.w(n3);
        this.h(n4);
        this.x(n5);
        this.y(n6);
        this.was_packed(bl2);
        return this;
    }

    public STBRPRect set(STBRPRect sTBRPRect) {
        MemoryUtil.memCopy(sTBRPRect.address(), this.address(), SIZEOF);
        return this;
    }

    public static STBRPRect malloc() {
        return new STBRPRect(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static STBRPRect calloc() {
        return new STBRPRect(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static STBRPRect create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new STBRPRect(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static STBRPRect create(long l2) {
        return new STBRPRect(l2, null);
    }

    public static STBRPRect createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new STBRPRect(l2, null);
    }

    public static STBRPRect$Buffer malloc(int n2) {
        return new STBRPRect$Buffer(MemoryUtil.nmemAllocChecked(STBRPRect.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static STBRPRect$Buffer calloc(int n2) {
        return new STBRPRect$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static STBRPRect$Buffer create(int n2) {
        ByteBuffer byteBuffer = STBRPRect.__create(n2, SIZEOF);
        int n3 = n2;
        return new STBRPRect$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static STBRPRect$Buffer create(long l2, int n2) {
        return new STBRPRect$Buffer(l2, n2);
    }

    public static STBRPRect$Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new STBRPRect$Buffer(l2, n2);
    }

    public static STBRPRect mallocStack() {
        return STBRPRect.malloc(MemoryStack.stackGet());
    }

    public static STBRPRect callocStack() {
        return STBRPRect.calloc(MemoryStack.stackGet());
    }

    public static STBRPRect mallocStack(MemoryStack memoryStack) {
        return STBRPRect.malloc(memoryStack);
    }

    public static STBRPRect callocStack(MemoryStack memoryStack) {
        return STBRPRect.calloc(memoryStack);
    }

    public static STBRPRect$Buffer mallocStack(int n2) {
        return STBRPRect.malloc(n2, MemoryStack.stackGet());
    }

    public static STBRPRect$Buffer callocStack(int n2) {
        return STBRPRect.calloc(n2, MemoryStack.stackGet());
    }

    public static STBRPRect$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return STBRPRect.malloc(n2, memoryStack);
    }

    public static STBRPRect$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return STBRPRect.calloc(n2, memoryStack);
    }

    public static STBRPRect malloc(MemoryStack memoryStack) {
        return new STBRPRect(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static STBRPRect calloc(MemoryStack memoryStack) {
        return new STBRPRect(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static STBRPRect$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new STBRPRect$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static STBRPRect$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new STBRPRect$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int nid(long l2) {
        return UNSAFE.getInt(null, l2 + (long)ID);
    }

    public static int nw(long l2) {
        return UNSAFE.getInt(null, l2 + (long)W);
    }

    public static int nh(long l2) {
        return UNSAFE.getInt(null, l2 + (long)H);
    }

    public static int nx(long l2) {
        return UNSAFE.getInt(null, l2 + (long)X);
    }

    public static int ny(long l2) {
        return UNSAFE.getInt(null, l2 + (long)Y);
    }

    public static int nwas_packed(long l2) {
        return UNSAFE.getInt(null, l2 + (long)WAS_PACKED);
    }

    public static void nid(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)ID, n2);
    }

    public static void nw(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)W, n2);
    }

    public static void nh(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)H, n2);
    }

    public static void nx(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)X, n2);
    }

    public static void ny(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)Y, n2);
    }

    public static void nwas_packed(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)WAS_PACKED, n2);
    }

    static {
        Struct$Layout struct$Layout = STBRPRect.__struct(STBRPRect.__member(4), STBRPRect.__member(4), STBRPRect.__member(4), STBRPRect.__member(4), STBRPRect.__member(4), STBRPRect.__member(4));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        ID = struct$Layout.offsetof(0);
        W = struct$Layout.offsetof(1);
        H = struct$Layout.offsetof(2);
        X = struct$Layout.offsetof(3);
        Y = struct$Layout.offsetof(4);
        WAS_PACKED = struct$Layout.offsetof(5);
    }
}

