/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.stb.STBRPNode$Buffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;

public class STBRPNode
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int NEXT;

    protected STBRPNode(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected STBRPNode create(long l2, ByteBuffer byteBuffer) {
        return new STBRPNode(l2, byteBuffer);
    }

    public STBRPNode(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), STBRPNode.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int x() {
        return STBRPNode.nx(this.address());
    }

    public int y() {
        return STBRPNode.ny(this.address());
    }

    public STBRPNode next() {
        return STBRPNode.nnext(this.address());
    }

    public static STBRPNode malloc() {
        return new STBRPNode(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static STBRPNode calloc() {
        return new STBRPNode(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static STBRPNode create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new STBRPNode(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static STBRPNode create(long l2) {
        return new STBRPNode(l2, null);
    }

    public static STBRPNode createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new STBRPNode(l2, null);
    }

    public static STBRPNode$Buffer malloc(int n2) {
        return new STBRPNode$Buffer(MemoryUtil.nmemAllocChecked(STBRPNode.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static STBRPNode$Buffer calloc(int n2) {
        return new STBRPNode$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static STBRPNode$Buffer create(int n2) {
        ByteBuffer byteBuffer = STBRPNode.__create(n2, SIZEOF);
        int n3 = n2;
        return new STBRPNode$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static STBRPNode$Buffer create(long l2, int n2) {
        return new STBRPNode$Buffer(l2, n2);
    }

    public static STBRPNode$Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new STBRPNode$Buffer(l2, n2);
    }

    public static STBRPNode mallocStack() {
        return STBRPNode.malloc(MemoryStack.stackGet());
    }

    public static STBRPNode callocStack() {
        return STBRPNode.calloc(MemoryStack.stackGet());
    }

    public static STBRPNode mallocStack(MemoryStack memoryStack) {
        return STBRPNode.malloc(memoryStack);
    }

    public static STBRPNode callocStack(MemoryStack memoryStack) {
        return STBRPNode.calloc(memoryStack);
    }

    public static STBRPNode$Buffer mallocStack(int n2) {
        return STBRPNode.malloc(n2, MemoryStack.stackGet());
    }

    public static STBRPNode$Buffer callocStack(int n2) {
        return STBRPNode.calloc(n2, MemoryStack.stackGet());
    }

    public static STBRPNode$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return STBRPNode.malloc(n2, memoryStack);
    }

    public static STBRPNode$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return STBRPNode.calloc(n2, memoryStack);
    }

    public static STBRPNode malloc(MemoryStack memoryStack) {
        return new STBRPNode(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static STBRPNode calloc(MemoryStack memoryStack) {
        return new STBRPNode(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static STBRPNode$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new STBRPNode$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static STBRPNode$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new STBRPNode$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int nx(long l2) {
        return UNSAFE.getInt(null, l2 + (long)X);
    }

    public static int ny(long l2) {
        return UNSAFE.getInt(null, l2 + (long)Y);
    }

    public static STBRPNode nnext(long l2) {
        return STBRPNode.createSafe(MemoryUtil.memGetAddress(l2 + (long)NEXT));
    }

    static {
        Struct$Layout struct$Layout = STBRPNode.__struct(STBRPNode.__member(4), STBRPNode.__member(4), STBRPNode.__member(POINTER_SIZE));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        X = struct$Layout.offsetof(0);
        Y = struct$Layout.offsetof(1);
        NEXT = struct$Layout.offsetof(2);
    }
}

