/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.stb.LibSTB;
import org.lwjgl.stb.STBIIOCallbacks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class STBImage {
    public static final int STBI_default = 0;
    public static final int STBI_grey = 1;
    public static final int STBI_grey_alpha = 2;
    public static final int STBI_rgb = 3;
    public static final int STBI_rgb_alpha = 4;

    protected STBImage() {
        throw new UnsupportedOperationException();
    }

    public static native long nstbi_load(long var0, long var2, long var4, long var6, int var8);

    public static ByteBuffer stbi_load(ByteBuffer byteBuffer, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3, int n2) {
        int n3;
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
            Checks.check((Buffer)intBuffer, 1);
            Checks.check((Buffer)intBuffer2, 1);
            Checks.check((Buffer)intBuffer3, 1);
        }
        long l2 = STBImage.nstbi_load(MemoryUtil.memAddress(byteBuffer), MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(intBuffer2), MemoryUtil.memAddress(intBuffer3), n2);
        IntBuffer intBuffer4 = intBuffer;
        IntBuffer intBuffer5 = intBuffer2;
        int n4 = intBuffer4.get(intBuffer4.position()) * intBuffer5.get(intBuffer5.position());
        if (n2 != 0) {
            n3 = n2;
        } else {
            IntBuffer intBuffer6 = intBuffer3;
            n3 = intBuffer6.get(intBuffer6.position());
        }
        return MemoryUtil.memByteBufferSafe(l2, n4 * n3);
    }

    public static ByteBuffer stbi_load(CharSequence object, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3, int n2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
            Checks.check((Buffer)intBuffer2, 1);
            Checks.check((Buffer)intBuffer3, 1);
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            int n4;
            memoryStack.nUTF8((CharSequence)object, true);
            long l2 = STBImage.nstbi_load(memoryStack.getPointerAddress(), MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(intBuffer2), MemoryUtil.memAddress(intBuffer3), n2);
            IntBuffer intBuffer4 = intBuffer;
            IntBuffer intBuffer5 = intBuffer2;
            int n5 = intBuffer4.get(intBuffer4.position()) * intBuffer5.get(intBuffer5.position());
            if (n2 != 0) {
                n4 = n2;
            } else {
                IntBuffer intBuffer6 = intBuffer3;
                n4 = intBuffer6.get(intBuffer6.position());
            }
            object = MemoryUtil.memByteBufferSafe(l2, n5 * n4);
            return object;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native long nstbi_load_from_memory(long var0, int var2, long var3, long var5, long var7, int var9);

    public static ByteBuffer stbi_load_from_memory(ByteBuffer byteBuffer, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3, int n2) {
        int n3;
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
            Checks.check((Buffer)intBuffer2, 1);
            Checks.check((Buffer)intBuffer3, 1);
        }
        long l2 = STBImage.nstbi_load_from_memory(MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining(), MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(intBuffer2), MemoryUtil.memAddress(intBuffer3), n2);
        IntBuffer intBuffer4 = intBuffer;
        IntBuffer intBuffer5 = intBuffer2;
        int n4 = intBuffer4.get(intBuffer4.position()) * intBuffer5.get(intBuffer5.position());
        if (n2 != 0) {
            n3 = n2;
        } else {
            IntBuffer intBuffer6 = intBuffer3;
            n3 = intBuffer6.get(intBuffer6.position());
        }
        return MemoryUtil.memByteBufferSafe(l2, n4 * n3);
    }

    public static native long nstbi_load_from_callbacks(long var0, long var2, long var4, long var6, long var8, int var10);

    public static ByteBuffer stbi_load_from_callbacks(STBIIOCallbacks sTBIIOCallbacks, long l2, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3, int n2) {
        int n3;
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
            Checks.check((Buffer)intBuffer2, 1);
            Checks.check((Buffer)intBuffer3, 1);
            STBIIOCallbacks.validate(sTBIIOCallbacks.address());
        }
        long l3 = STBImage.nstbi_load_from_callbacks(sTBIIOCallbacks.address(), l2, MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(intBuffer2), MemoryUtil.memAddress(intBuffer3), n2);
        IntBuffer intBuffer4 = intBuffer;
        IntBuffer intBuffer5 = intBuffer2;
        int n4 = intBuffer4.get(intBuffer4.position()) * intBuffer5.get(intBuffer5.position());
        if (n2 != 0) {
            n3 = n2;
        } else {
            IntBuffer intBuffer6 = intBuffer3;
            n3 = intBuffer6.get(intBuffer6.position());
        }
        return MemoryUtil.memByteBufferSafe(l3, n4 * n3);
    }

    public static native long nstbi_load_gif_from_memory(long var0, int var2, long var3, long var5, long var7, long var9, long var11, int var13);

    public static ByteBuffer stbi_load_gif_from_memory(ByteBuffer byteBuffer, PointerBuffer pointerBuffer, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3, IntBuffer intBuffer4, int n2) {
        int n3;
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pointerBuffer, 1);
            Checks.check((Buffer)intBuffer, 1);
            Checks.check((Buffer)intBuffer2, 1);
            Checks.check((Buffer)intBuffer3, 1);
            Checks.check((Buffer)intBuffer4, 1);
        }
        long l2 = STBImage.nstbi_load_gif_from_memory(MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining(), MemoryUtil.memAddress(pointerBuffer), MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(intBuffer2), MemoryUtil.memAddress(intBuffer3), MemoryUtil.memAddress(intBuffer4), n2);
        IntBuffer intBuffer5 = intBuffer;
        IntBuffer intBuffer6 = intBuffer2;
        IntBuffer intBuffer7 = intBuffer3;
        int n4 = intBuffer5.get(intBuffer5.position()) * intBuffer6.get(intBuffer6.position()) * intBuffer7.get(intBuffer7.position());
        if (n2 != 0) {
            n3 = n2;
        } else {
            IntBuffer intBuffer8 = intBuffer4;
            n3 = intBuffer8.get(intBuffer8.position());
        }
        return MemoryUtil.memByteBufferSafe(l2, n4 * n3);
    }

    public static native long nstbi_load_16(long var0, long var2, long var4, long var6, int var8);

    public static ShortBuffer stbi_load_16(ByteBuffer byteBuffer, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3, int n2) {
        int n3;
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
            Checks.check((Buffer)intBuffer, 1);
            Checks.check((Buffer)intBuffer2, 1);
            Checks.check((Buffer)intBuffer3, 1);
        }
        long l2 = STBImage.nstbi_load_16(MemoryUtil.memAddress(byteBuffer), MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(intBuffer2), MemoryUtil.memAddress(intBuffer3), n2);
        IntBuffer intBuffer4 = intBuffer;
        IntBuffer intBuffer5 = intBuffer2;
        int n4 = intBuffer4.get(intBuffer4.position()) * intBuffer5.get(intBuffer5.position());
        if (n2 != 0) {
            n3 = n2;
        } else {
            IntBuffer intBuffer6 = intBuffer3;
            n3 = intBuffer6.get(intBuffer6.position());
        }
        return MemoryUtil.memShortBufferSafe(l2, n4 * n3);
    }

    public static ShortBuffer stbi_load_16(CharSequence object, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3, int n2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
            Checks.check((Buffer)intBuffer2, 1);
            Checks.check((Buffer)intBuffer3, 1);
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            int n4;
            memoryStack.nUTF8((CharSequence)object, true);
            long l2 = STBImage.nstbi_load_16(memoryStack.getPointerAddress(), MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(intBuffer2), MemoryUtil.memAddress(intBuffer3), n2);
            IntBuffer intBuffer4 = intBuffer;
            IntBuffer intBuffer5 = intBuffer2;
            int n5 = intBuffer4.get(intBuffer4.position()) * intBuffer5.get(intBuffer5.position());
            if (n2 != 0) {
                n4 = n2;
            } else {
                IntBuffer intBuffer6 = intBuffer3;
                n4 = intBuffer6.get(intBuffer6.position());
            }
            object = MemoryUtil.memShortBufferSafe(l2, n5 * n4);
            return object;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native long nstbi_load_16_from_memory(long var0, int var2, long var3, long var5, long var7, int var9);

    public static ShortBuffer stbi_load_16_from_memory(ByteBuffer byteBuffer, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3, int n2) {
        int n3;
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
            Checks.check((Buffer)intBuffer2, 1);
            Checks.check((Buffer)intBuffer3, 1);
        }
        long l2 = STBImage.nstbi_load_16_from_memory(MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining(), MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(intBuffer2), MemoryUtil.memAddress(intBuffer3), n2);
        IntBuffer intBuffer4 = intBuffer;
        IntBuffer intBuffer5 = intBuffer2;
        int n4 = intBuffer4.get(intBuffer4.position()) * intBuffer5.get(intBuffer5.position());
        if (n2 != 0) {
            n3 = n2;
        } else {
            IntBuffer intBuffer6 = intBuffer3;
            n3 = intBuffer6.get(intBuffer6.position());
        }
        return MemoryUtil.memShortBufferSafe(l2, n4 * n3);
    }

    public static native long nstbi_load_16_from_callbacks(long var0, long var2, long var4, long var6, long var8, int var10);

    public static ShortBuffer stbi_load_16_from_callbacks(STBIIOCallbacks sTBIIOCallbacks, long l2, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3, int n2) {
        int n3;
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
            Checks.check((Buffer)intBuffer2, 1);
            Checks.check((Buffer)intBuffer3, 1);
            STBIIOCallbacks.validate(sTBIIOCallbacks.address());
        }
        long l3 = STBImage.nstbi_load_16_from_callbacks(sTBIIOCallbacks.address(), l2, MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(intBuffer2), MemoryUtil.memAddress(intBuffer3), n2);
        IntBuffer intBuffer4 = intBuffer;
        IntBuffer intBuffer5 = intBuffer2;
        int n4 = intBuffer4.get(intBuffer4.position()) * intBuffer5.get(intBuffer5.position());
        if (n2 != 0) {
            n3 = n2;
        } else {
            IntBuffer intBuffer6 = intBuffer3;
            n3 = intBuffer6.get(intBuffer6.position());
        }
        return MemoryUtil.memShortBufferSafe(l3, n4 * n3);
    }

    public static native long nstbi_loadf(long var0, long var2, long var4, long var6, int var8);

    public static FloatBuffer stbi_loadf(ByteBuffer byteBuffer, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3, int n2) {
        int n3;
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
            Checks.check((Buffer)intBuffer, 1);
            Checks.check((Buffer)intBuffer2, 1);
            Checks.check((Buffer)intBuffer3, 1);
        }
        long l2 = STBImage.nstbi_loadf(MemoryUtil.memAddress(byteBuffer), MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(intBuffer2), MemoryUtil.memAddress(intBuffer3), n2);
        IntBuffer intBuffer4 = intBuffer;
        IntBuffer intBuffer5 = intBuffer2;
        int n4 = intBuffer4.get(intBuffer4.position()) * intBuffer5.get(intBuffer5.position());
        if (n2 != 0) {
            n3 = n2;
        } else {
            IntBuffer intBuffer6 = intBuffer3;
            n3 = intBuffer6.get(intBuffer6.position());
        }
        return MemoryUtil.memFloatBufferSafe(l2, n4 * n3);
    }

    public static FloatBuffer stbi_loadf(CharSequence object, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3, int n2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
            Checks.check((Buffer)intBuffer2, 1);
            Checks.check((Buffer)intBuffer3, 1);
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            int n4;
            memoryStack.nUTF8((CharSequence)object, true);
            long l2 = STBImage.nstbi_loadf(memoryStack.getPointerAddress(), MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(intBuffer2), MemoryUtil.memAddress(intBuffer3), n2);
            IntBuffer intBuffer4 = intBuffer;
            IntBuffer intBuffer5 = intBuffer2;
            int n5 = intBuffer4.get(intBuffer4.position()) * intBuffer5.get(intBuffer5.position());
            if (n2 != 0) {
                n4 = n2;
            } else {
                IntBuffer intBuffer6 = intBuffer3;
                n4 = intBuffer6.get(intBuffer6.position());
            }
            object = MemoryUtil.memFloatBufferSafe(l2, n5 * n4);
            return object;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native long nstbi_loadf_from_memory(long var0, int var2, long var3, long var5, long var7, int var9);

    public static FloatBuffer stbi_loadf_from_memory(ByteBuffer byteBuffer, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3, int n2) {
        int n3;
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
            Checks.check((Buffer)intBuffer2, 1);
            Checks.check((Buffer)intBuffer3, 1);
        }
        long l2 = STBImage.nstbi_loadf_from_memory(MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining(), MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(intBuffer2), MemoryUtil.memAddress(intBuffer3), n2);
        IntBuffer intBuffer4 = intBuffer;
        IntBuffer intBuffer5 = intBuffer2;
        int n4 = intBuffer4.get(intBuffer4.position()) * intBuffer5.get(intBuffer5.position());
        if (n2 != 0) {
            n3 = n2;
        } else {
            IntBuffer intBuffer6 = intBuffer3;
            n3 = intBuffer6.get(intBuffer6.position());
        }
        return MemoryUtil.memFloatBufferSafe(l2, n4 * n3);
    }

    public static native long nstbi_loadf_from_callbacks(long var0, long var2, long var4, long var6, long var8, int var10);

    public static FloatBuffer stbi_loadf_from_callbacks(STBIIOCallbacks sTBIIOCallbacks, long l2, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3, int n2) {
        int n3;
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
            Checks.check((Buffer)intBuffer2, 1);
            Checks.check((Buffer)intBuffer3, 1);
            STBIIOCallbacks.validate(sTBIIOCallbacks.address());
        }
        long l3 = STBImage.nstbi_loadf_from_callbacks(sTBIIOCallbacks.address(), l2, MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(intBuffer2), MemoryUtil.memAddress(intBuffer3), n2);
        IntBuffer intBuffer4 = intBuffer;
        IntBuffer intBuffer5 = intBuffer2;
        int n4 = intBuffer4.get(intBuffer4.position()) * intBuffer5.get(intBuffer5.position());
        if (n2 != 0) {
            n3 = n2;
        } else {
            IntBuffer intBuffer6 = intBuffer3;
            n3 = intBuffer6.get(intBuffer6.position());
        }
        return MemoryUtil.memFloatBufferSafe(l3, n4 * n3);
    }

    public static native void stbi_hdr_to_ldr_gamma(float var0);

    public static native void stbi_hdr_to_ldr_scale(float var0);

    public static native void stbi_ldr_to_hdr_gamma(float var0);

    public static native void stbi_ldr_to_hdr_scale(float var0);

    public static native int nstbi_is_hdr(long var0);

    public static boolean stbi_is_hdr(ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return STBImage.nstbi_is_hdr(MemoryUtil.memAddress(byteBuffer)) != 0;
    }

    public static boolean stbi_is_hdr(CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            boolean bl2 = STBImage.nstbi_is_hdr(memoryStack.getPointerAddress()) != 0;
            return bl2;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static native int nstbi_is_hdr_from_memory(long var0, int var2);

    public static boolean stbi_is_hdr_from_memory(ByteBuffer byteBuffer) {
        return STBImage.nstbi_is_hdr_from_memory(MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining()) != 0;
    }

    public static native int nstbi_is_hdr_from_callbacks(long var0, long var2);

    public static boolean stbi_is_hdr_from_callbacks(STBIIOCallbacks sTBIIOCallbacks, long l2) {
        if (Checks.CHECKS) {
            STBIIOCallbacks.validate(sTBIIOCallbacks.address());
        }
        return STBImage.nstbi_is_hdr_from_callbacks(sTBIIOCallbacks.address(), l2) != 0;
    }

    public static native long nstbi_failure_reason();

    public static String stbi_failure_reason() {
        return MemoryUtil.memASCIISafe(STBImage.nstbi_failure_reason());
    }

    public static native void nstbi_image_free(long var0);

    public static void stbi_image_free(ByteBuffer byteBuffer) {
        STBImage.nstbi_image_free(MemoryUtil.memAddress(byteBuffer));
    }

    public static void stbi_image_free(ShortBuffer shortBuffer) {
        STBImage.nstbi_image_free(MemoryUtil.memAddress(shortBuffer));
    }

    public static void stbi_image_free(FloatBuffer floatBuffer) {
        STBImage.nstbi_image_free(MemoryUtil.memAddress(floatBuffer));
    }

    public static native int nstbi_info(long var0, long var2, long var4, long var6);

    public static boolean stbi_info(ByteBuffer byteBuffer, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
            Checks.check((Buffer)intBuffer, 1);
            Checks.check((Buffer)intBuffer2, 1);
            Checks.check((Buffer)intBuffer3, 1);
        }
        return STBImage.nstbi_info(MemoryUtil.memAddress(byteBuffer), MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(intBuffer2), MemoryUtil.memAddress(intBuffer3)) != 0;
    }

    public static boolean stbi_info(CharSequence charSequence, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
            Checks.check((Buffer)intBuffer2, 1);
            Checks.check((Buffer)intBuffer3, 1);
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            boolean bl2 = STBImage.nstbi_info(memoryStack.getPointerAddress(), MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(intBuffer2), MemoryUtil.memAddress(intBuffer3)) != 0;
            return bl2;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static native int nstbi_info_from_memory(long var0, int var2, long var3, long var5, long var7);

    public static boolean stbi_info_from_memory(ByteBuffer byteBuffer, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
            Checks.check((Buffer)intBuffer2, 1);
            Checks.check((Buffer)intBuffer3, 1);
        }
        return STBImage.nstbi_info_from_memory(MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining(), MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(intBuffer2), MemoryUtil.memAddress(intBuffer3)) != 0;
    }

    public static native int nstbi_info_from_callbacks(long var0, long var2, long var4, long var6, long var8);

    public static boolean stbi_info_from_callbacks(STBIIOCallbacks sTBIIOCallbacks, long l2, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
            Checks.check((Buffer)intBuffer2, 1);
            Checks.check((Buffer)intBuffer3, 1);
            STBIIOCallbacks.validate(sTBIIOCallbacks.address());
        }
        return STBImage.nstbi_info_from_callbacks(sTBIIOCallbacks.address(), l2, MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(intBuffer2), MemoryUtil.memAddress(intBuffer3)) != 0;
    }

    public static native int nstbi_is_16_bit(long var0);

    public static boolean stbi_is_16_bit(ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return STBImage.nstbi_is_16_bit(MemoryUtil.memAddress(byteBuffer)) != 0;
    }

    public static boolean stbi_is_16_bit(CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            boolean bl2 = STBImage.nstbi_is_16_bit(memoryStack.getPointerAddress()) != 0;
            return bl2;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static native int nstbi_is_16_bit_from_memory(long var0, int var2);

    public static boolean stbi_is_16_bit_from_memory(ByteBuffer byteBuffer) {
        return STBImage.nstbi_is_16_bit_from_memory(MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining()) != 0;
    }

    public static native int nstbi_is_16_bit_from_callbacks(long var0, long var2);

    public static boolean stbi_is_16_bit_from_callbacks(STBIIOCallbacks sTBIIOCallbacks, long l2) {
        if (Checks.CHECKS) {
            STBIIOCallbacks.validate(sTBIIOCallbacks.address());
        }
        return STBImage.nstbi_is_16_bit_from_callbacks(sTBIIOCallbacks.address(), l2) != 0;
    }

    public static native void nstbi_set_unpremultiply_on_load(int var0);

    public static void stbi_set_unpremultiply_on_load(boolean bl2) {
        STBImage.nstbi_set_unpremultiply_on_load(bl2 ? 1 : 0);
    }

    public static native void nstbi_convert_iphone_png_to_rgb(int var0);

    public static void stbi_convert_iphone_png_to_rgb(boolean bl2) {
        STBImage.nstbi_convert_iphone_png_to_rgb(bl2 ? 1 : 0);
    }

    public static native void nstbi_set_flip_vertically_on_load(int var0);

    public static void stbi_set_flip_vertically_on_load(boolean bl2) {
        STBImage.nstbi_set_flip_vertically_on_load(bl2 ? 1 : 0);
    }

    public static native void nstbi_set_unpremultiply_on_load_thread(int var0);

    public static void stbi_set_unpremultiply_on_load_thread(boolean bl2) {
        STBImage.nstbi_set_unpremultiply_on_load_thread(bl2 ? 1 : 0);
    }

    public static native void nstbi_convert_iphone_png_to_rgb_thread(int var0);

    public static void stbi_convert_iphone_png_to_rgb_thread(boolean bl2) {
        STBImage.nstbi_convert_iphone_png_to_rgb_thread(bl2 ? 1 : 0);
    }

    public static native void stbi_set_flip_vertically_on_load_thread(int var0);

    public static native long nstbi_zlib_decode_malloc_guesssize(long var0, int var2, int var3, long var4);

    public static ByteBuffer stbi_zlib_decode_malloc_guesssize(ByteBuffer byteBuffer, int n2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.callocInt(1);
            byteBuffer = MemoryUtil.memByteBufferSafe(STBImage.nstbi_zlib_decode_malloc_guesssize(MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining(), n2, MemoryUtil.memAddress(intBuffer)), intBuffer.get(0));
            return byteBuffer;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native long nstbi_zlib_decode_malloc_guesssize_headerflag(long var0, int var2, int var3, long var4, int var6);

    public static ByteBuffer stbi_zlib_decode_malloc_guesssize_headerflag(ByteBuffer byteBuffer, int n2, boolean bl2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.callocInt(1);
            byteBuffer = MemoryUtil.memByteBufferSafe(STBImage.nstbi_zlib_decode_malloc_guesssize_headerflag(MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining(), n2, MemoryUtil.memAddress(intBuffer), bl2 ? 1 : 0), intBuffer.get(0));
            return byteBuffer;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native long nstbi_zlib_decode_malloc(long var0, int var2, long var3);

    public static ByteBuffer stbi_zlib_decode_malloc(ByteBuffer byteBuffer) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.callocInt(1);
            byteBuffer = MemoryUtil.memByteBufferSafe(STBImage.nstbi_zlib_decode_malloc(MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining(), MemoryUtil.memAddress(intBuffer)), intBuffer.get(0));
            return byteBuffer;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static native int nstbi_zlib_decode_buffer(long var0, int var2, long var3, int var5);

    public static int stbi_zlib_decode_buffer(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        return STBImage.nstbi_zlib_decode_buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining(), MemoryUtil.memAddress(byteBuffer2), byteBuffer2.remaining());
    }

    public static native long nstbi_zlib_decode_noheader_malloc(long var0, int var2, long var3);

    public static ByteBuffer stbi_zlib_decode_noheader_malloc(ByteBuffer byteBuffer) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.callocInt(1);
            byteBuffer = MemoryUtil.memByteBufferSafe(STBImage.nstbi_zlib_decode_noheader_malloc(MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining(), MemoryUtil.memAddress(intBuffer)), intBuffer.get(0));
            return byteBuffer;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static native int nstbi_zlib_decode_noheader_buffer(long var0, int var2, long var3, int var5);

    public static int stbi_zlib_decode_noheader_buffer(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        return STBImage.nstbi_zlib_decode_noheader_buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining(), MemoryUtil.memAddress(byteBuffer2), byteBuffer2.remaining());
    }

    public static native long nstbi_load(long var0, int[] var2, int[] var3, int[] var4, int var5);

    public static ByteBuffer stbi_load(ByteBuffer byteBuffer, int[] nArray, int[] nArray2, int[] nArray3, int n2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
            Checks.check(nArray, 1);
            Checks.check(nArray2, 1);
            Checks.check(nArray3, 1);
        }
        return MemoryUtil.memByteBufferSafe(STBImage.nstbi_load(MemoryUtil.memAddress(byteBuffer), nArray, nArray2, nArray3, n2), nArray[0] * nArray2[0] * (n2 != 0 ? n2 : nArray3[0]));
    }

    public static ByteBuffer stbi_load(CharSequence object, int[] nArray, int[] nArray2, int[] nArray3, int n2) {
        if (Checks.CHECKS) {
            Checks.check(nArray, 1);
            Checks.check(nArray2, 1);
            Checks.check(nArray3, 1);
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8((CharSequence)object, true);
            object = MemoryUtil.memByteBufferSafe(STBImage.nstbi_load(memoryStack.getPointerAddress(), nArray, nArray2, nArray3, n2), nArray[0] * nArray2[0] * (n2 != 0 ? n2 : nArray3[0]));
            return object;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native long nstbi_load_from_memory(long var0, int var2, int[] var3, int[] var4, int[] var5, int var6);

    public static ByteBuffer stbi_load_from_memory(ByteBuffer byteBuffer, int[] nArray, int[] nArray2, int[] nArray3, int n2) {
        if (Checks.CHECKS) {
            Checks.check(nArray, 1);
            Checks.check(nArray2, 1);
            Checks.check(nArray3, 1);
        }
        return MemoryUtil.memByteBufferSafe(STBImage.nstbi_load_from_memory(MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining(), nArray, nArray2, nArray3, n2), nArray[0] * nArray2[0] * (n2 != 0 ? n2 : nArray3[0]));
    }

    public static native long nstbi_load_from_callbacks(long var0, long var2, int[] var4, int[] var5, int[] var6, int var7);

    public static ByteBuffer stbi_load_from_callbacks(STBIIOCallbacks sTBIIOCallbacks, long l2, int[] nArray, int[] nArray2, int[] nArray3, int n2) {
        if (Checks.CHECKS) {
            Checks.check(nArray, 1);
            Checks.check(nArray2, 1);
            Checks.check(nArray3, 1);
            STBIIOCallbacks.validate(sTBIIOCallbacks.address());
        }
        return MemoryUtil.memByteBufferSafe(STBImage.nstbi_load_from_callbacks(sTBIIOCallbacks.address(), l2, nArray, nArray2, nArray3, n2), nArray[0] * nArray2[0] * (n2 != 0 ? n2 : nArray3[0]));
    }

    public static native long nstbi_load_gif_from_memory(long var0, int var2, long var3, int[] var5, int[] var6, int[] var7, int[] var8, int var9);

    public static ByteBuffer stbi_load_gif_from_memory(ByteBuffer byteBuffer, PointerBuffer pointerBuffer, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n2) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pointerBuffer, 1);
            Checks.check(nArray, 1);
            Checks.check(nArray2, 1);
            Checks.check(nArray3, 1);
            Checks.check(nArray4, 1);
        }
        return MemoryUtil.memByteBufferSafe(STBImage.nstbi_load_gif_from_memory(MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining(), MemoryUtil.memAddress(pointerBuffer), nArray, nArray2, nArray3, nArray4, n2), nArray[0] * nArray2[0] * nArray3[0] * (n2 != 0 ? n2 : nArray4[0]));
    }

    public static native long nstbi_load_16(long var0, int[] var2, int[] var3, int[] var4, int var5);

    public static ShortBuffer stbi_load_16(ByteBuffer byteBuffer, int[] nArray, int[] nArray2, int[] nArray3, int n2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
            Checks.check(nArray, 1);
            Checks.check(nArray2, 1);
            Checks.check(nArray3, 1);
        }
        return MemoryUtil.memShortBufferSafe(STBImage.nstbi_load_16(MemoryUtil.memAddress(byteBuffer), nArray, nArray2, nArray3, n2), nArray[0] * nArray2[0] * (n2 != 0 ? n2 : nArray3[0]));
    }

    public static ShortBuffer stbi_load_16(CharSequence object, int[] nArray, int[] nArray2, int[] nArray3, int n2) {
        if (Checks.CHECKS) {
            Checks.check(nArray, 1);
            Checks.check(nArray2, 1);
            Checks.check(nArray3, 1);
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8((CharSequence)object, true);
            object = MemoryUtil.memShortBufferSafe(STBImage.nstbi_load_16(memoryStack.getPointerAddress(), nArray, nArray2, nArray3, n2), nArray[0] * nArray2[0] * (n2 != 0 ? n2 : nArray3[0]));
            return object;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native long nstbi_load_16_from_memory(long var0, int var2, int[] var3, int[] var4, int[] var5, int var6);

    public static ShortBuffer stbi_load_16_from_memory(ByteBuffer byteBuffer, int[] nArray, int[] nArray2, int[] nArray3, int n2) {
        if (Checks.CHECKS) {
            Checks.check(nArray, 1);
            Checks.check(nArray2, 1);
            Checks.check(nArray3, 1);
        }
        return MemoryUtil.memShortBufferSafe(STBImage.nstbi_load_16_from_memory(MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining(), nArray, nArray2, nArray3, n2), nArray[0] * nArray2[0] * (n2 != 0 ? n2 : nArray3[0]));
    }

    public static native long nstbi_load_16_from_callbacks(long var0, long var2, int[] var4, int[] var5, int[] var6, int var7);

    public static ShortBuffer stbi_load_16_from_callbacks(STBIIOCallbacks sTBIIOCallbacks, long l2, int[] nArray, int[] nArray2, int[] nArray3, int n2) {
        if (Checks.CHECKS) {
            Checks.check(nArray, 1);
            Checks.check(nArray2, 1);
            Checks.check(nArray3, 1);
            STBIIOCallbacks.validate(sTBIIOCallbacks.address());
        }
        return MemoryUtil.memShortBufferSafe(STBImage.nstbi_load_16_from_callbacks(sTBIIOCallbacks.address(), l2, nArray, nArray2, nArray3, n2), nArray[0] * nArray2[0] * (n2 != 0 ? n2 : nArray3[0]));
    }

    public static native long nstbi_loadf(long var0, int[] var2, int[] var3, int[] var4, int var5);

    public static FloatBuffer stbi_loadf(ByteBuffer byteBuffer, int[] nArray, int[] nArray2, int[] nArray3, int n2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
            Checks.check(nArray, 1);
            Checks.check(nArray2, 1);
            Checks.check(nArray3, 1);
        }
        return MemoryUtil.memFloatBufferSafe(STBImage.nstbi_loadf(MemoryUtil.memAddress(byteBuffer), nArray, nArray2, nArray3, n2), nArray[0] * nArray2[0] * (n2 != 0 ? n2 : nArray3[0]));
    }

    public static FloatBuffer stbi_loadf(CharSequence object, int[] nArray, int[] nArray2, int[] nArray3, int n2) {
        if (Checks.CHECKS) {
            Checks.check(nArray, 1);
            Checks.check(nArray2, 1);
            Checks.check(nArray3, 1);
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8((CharSequence)object, true);
            object = MemoryUtil.memFloatBufferSafe(STBImage.nstbi_loadf(memoryStack.getPointerAddress(), nArray, nArray2, nArray3, n2), nArray[0] * nArray2[0] * (n2 != 0 ? n2 : nArray3[0]));
            return object;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native long nstbi_loadf_from_memory(long var0, int var2, int[] var3, int[] var4, int[] var5, int var6);

    public static FloatBuffer stbi_loadf_from_memory(ByteBuffer byteBuffer, int[] nArray, int[] nArray2, int[] nArray3, int n2) {
        if (Checks.CHECKS) {
            Checks.check(nArray, 1);
            Checks.check(nArray2, 1);
            Checks.check(nArray3, 1);
        }
        return MemoryUtil.memFloatBufferSafe(STBImage.nstbi_loadf_from_memory(MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining(), nArray, nArray2, nArray3, n2), nArray[0] * nArray2[0] * (n2 != 0 ? n2 : nArray3[0]));
    }

    public static native long nstbi_loadf_from_callbacks(long var0, long var2, int[] var4, int[] var5, int[] var6, int var7);

    public static FloatBuffer stbi_loadf_from_callbacks(STBIIOCallbacks sTBIIOCallbacks, long l2, int[] nArray, int[] nArray2, int[] nArray3, int n2) {
        if (Checks.CHECKS) {
            Checks.check(nArray, 1);
            Checks.check(nArray2, 1);
            Checks.check(nArray3, 1);
            STBIIOCallbacks.validate(sTBIIOCallbacks.address());
        }
        return MemoryUtil.memFloatBufferSafe(STBImage.nstbi_loadf_from_callbacks(sTBIIOCallbacks.address(), l2, nArray, nArray2, nArray3, n2), nArray[0] * nArray2[0] * (n2 != 0 ? n2 : nArray3[0]));
    }

    public static native int nstbi_info(long var0, int[] var2, int[] var3, int[] var4);

    public static boolean stbi_info(ByteBuffer byteBuffer, int[] nArray, int[] nArray2, int[] nArray3) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
            Checks.check(nArray, 1);
            Checks.check(nArray2, 1);
            Checks.check(nArray3, 1);
        }
        return STBImage.nstbi_info(MemoryUtil.memAddress(byteBuffer), nArray, nArray2, nArray3) != 0;
    }

    public static boolean stbi_info(CharSequence charSequence, int[] nArray, int[] nArray2, int[] nArray3) {
        if (Checks.CHECKS) {
            Checks.check(nArray, 1);
            Checks.check(nArray2, 1);
            Checks.check(nArray3, 1);
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            boolean bl2 = STBImage.nstbi_info(memoryStack.getPointerAddress(), nArray, nArray2, nArray3) != 0;
            return bl2;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static native int nstbi_info_from_memory(long var0, int var2, int[] var3, int[] var4, int[] var5);

    public static boolean stbi_info_from_memory(ByteBuffer byteBuffer, int[] nArray, int[] nArray2, int[] nArray3) {
        if (Checks.CHECKS) {
            Checks.check(nArray, 1);
            Checks.check(nArray2, 1);
            Checks.check(nArray3, 1);
        }
        return STBImage.nstbi_info_from_memory(MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining(), nArray, nArray2, nArray3) != 0;
    }

    public static native int nstbi_info_from_callbacks(long var0, long var2, int[] var4, int[] var5, int[] var6);

    public static boolean stbi_info_from_callbacks(STBIIOCallbacks sTBIIOCallbacks, long l2, int[] nArray, int[] nArray2, int[] nArray3) {
        if (Checks.CHECKS) {
            Checks.check(nArray, 1);
            Checks.check(nArray2, 1);
            Checks.check(nArray3, 1);
            STBIIOCallbacks.validate(sTBIIOCallbacks.address());
        }
        return STBImage.nstbi_info_from_callbacks(sTBIIOCallbacks.address(), l2, nArray, nArray2, nArray3) != 0;
    }

    static {
        LibSTB.initialize();
    }
}

