/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.stb.STBIEOFCallback;
import org.lwjgl.stb.STBIEOFCallbackI;
import org.lwjgl.stb.STBIIOCallbacks$Buffer;
import org.lwjgl.stb.STBIReadCallback;
import org.lwjgl.stb.STBIReadCallbackI;
import org.lwjgl.stb.STBISkipCallback;
import org.lwjgl.stb.STBISkipCallbackI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;

public class STBIIOCallbacks
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int READ;
    public static final int SKIP;
    public static final int EOF;

    protected STBIIOCallbacks(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected STBIIOCallbacks create(long l2, ByteBuffer byteBuffer) {
        return new STBIIOCallbacks(l2, byteBuffer);
    }

    public STBIIOCallbacks(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), STBIIOCallbacks.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public STBIReadCallback read() {
        return STBIIOCallbacks.nread(this.address());
    }

    public STBISkipCallback skip() {
        return STBIIOCallbacks.nskip(this.address());
    }

    public STBIEOFCallback eof() {
        return STBIIOCallbacks.neof(this.address());
    }

    public STBIIOCallbacks read(STBIReadCallbackI sTBIReadCallbackI) {
        STBIIOCallbacks.nread(this.address(), sTBIReadCallbackI);
        return this;
    }

    public STBIIOCallbacks skip(STBISkipCallbackI sTBISkipCallbackI) {
        STBIIOCallbacks.nskip(this.address(), sTBISkipCallbackI);
        return this;
    }

    public STBIIOCallbacks eof(STBIEOFCallbackI sTBIEOFCallbackI) {
        STBIIOCallbacks.neof(this.address(), sTBIEOFCallbackI);
        return this;
    }

    public STBIIOCallbacks set(STBIReadCallbackI sTBIReadCallbackI, STBISkipCallbackI sTBISkipCallbackI, STBIEOFCallbackI sTBIEOFCallbackI) {
        this.read(sTBIReadCallbackI);
        this.skip(sTBISkipCallbackI);
        this.eof(sTBIEOFCallbackI);
        return this;
    }

    public STBIIOCallbacks set(STBIIOCallbacks sTBIIOCallbacks) {
        MemoryUtil.memCopy(sTBIIOCallbacks.address(), this.address(), SIZEOF);
        return this;
    }

    public static STBIIOCallbacks malloc() {
        return new STBIIOCallbacks(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static STBIIOCallbacks calloc() {
        return new STBIIOCallbacks(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static STBIIOCallbacks create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new STBIIOCallbacks(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static STBIIOCallbacks create(long l2) {
        return new STBIIOCallbacks(l2, null);
    }

    public static STBIIOCallbacks createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new STBIIOCallbacks(l2, null);
    }

    public static STBIIOCallbacks$Buffer malloc(int n2) {
        return new STBIIOCallbacks$Buffer(MemoryUtil.nmemAllocChecked(STBIIOCallbacks.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static STBIIOCallbacks$Buffer calloc(int n2) {
        return new STBIIOCallbacks$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static STBIIOCallbacks$Buffer create(int n2) {
        ByteBuffer byteBuffer = STBIIOCallbacks.__create(n2, SIZEOF);
        int n3 = n2;
        return new STBIIOCallbacks$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static STBIIOCallbacks$Buffer create(long l2, int n2) {
        return new STBIIOCallbacks$Buffer(l2, n2);
    }

    public static STBIIOCallbacks$Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new STBIIOCallbacks$Buffer(l2, n2);
    }

    public static STBIIOCallbacks mallocStack() {
        return STBIIOCallbacks.malloc(MemoryStack.stackGet());
    }

    public static STBIIOCallbacks callocStack() {
        return STBIIOCallbacks.calloc(MemoryStack.stackGet());
    }

    public static STBIIOCallbacks mallocStack(MemoryStack memoryStack) {
        return STBIIOCallbacks.malloc(memoryStack);
    }

    public static STBIIOCallbacks callocStack(MemoryStack memoryStack) {
        return STBIIOCallbacks.calloc(memoryStack);
    }

    public static STBIIOCallbacks$Buffer mallocStack(int n2) {
        return STBIIOCallbacks.malloc(n2, MemoryStack.stackGet());
    }

    public static STBIIOCallbacks$Buffer callocStack(int n2) {
        return STBIIOCallbacks.calloc(n2, MemoryStack.stackGet());
    }

    public static STBIIOCallbacks$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return STBIIOCallbacks.malloc(n2, memoryStack);
    }

    public static STBIIOCallbacks$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return STBIIOCallbacks.calloc(n2, memoryStack);
    }

    public static STBIIOCallbacks malloc(MemoryStack memoryStack) {
        return new STBIIOCallbacks(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static STBIIOCallbacks calloc(MemoryStack memoryStack) {
        return new STBIIOCallbacks(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static STBIIOCallbacks$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new STBIIOCallbacks$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static STBIIOCallbacks$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new STBIIOCallbacks$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static STBIReadCallback nread(long l2) {
        return STBIReadCallback.create(MemoryUtil.memGetAddress(l2 + (long)READ));
    }

    public static STBISkipCallback nskip(long l2) {
        return STBISkipCallback.create(MemoryUtil.memGetAddress(l2 + (long)SKIP));
    }

    public static STBIEOFCallback neof(long l2) {
        return STBIEOFCallback.create(MemoryUtil.memGetAddress(l2 + (long)EOF));
    }

    public static void nread(long l2, STBIReadCallbackI sTBIReadCallbackI) {
        MemoryUtil.memPutAddress(l2 + (long)READ, sTBIReadCallbackI.address());
    }

    public static void nskip(long l2, STBISkipCallbackI sTBISkipCallbackI) {
        MemoryUtil.memPutAddress(l2 + (long)SKIP, sTBISkipCallbackI.address());
    }

    public static void neof(long l2, STBIEOFCallbackI sTBIEOFCallbackI) {
        MemoryUtil.memPutAddress(l2 + (long)EOF, sTBIEOFCallbackI.address());
    }

    public static void validate(long l2) {
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)READ));
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)SKIP));
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)EOF));
    }

    static {
        Struct$Layout struct$Layout = STBIIOCallbacks.__struct(STBIIOCallbacks.__member(POINTER_SIZE), STBIIOCallbacks.__member(POINTER_SIZE), STBIIOCallbacks.__member(POINTER_SIZE));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        READ = struct$Layout.offsetof(0);
        SKIP = struct$Layout.offsetof(1);
        EOF = struct$Layout.offsetof(2);
    }
}

