/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class QCOMDriverControl {
    protected QCOMDriverControl() {
        throw new UnsupportedOperationException();
    }

    public static native void nglGetDriverControlsQCOM(long var0, int var2, long var3);

    public static void glGetDriverControlsQCOM(IntBuffer intBuffer, IntBuffer intBuffer2) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer, 1);
        }
        QCOMDriverControl.nglGetDriverControlsQCOM(MemoryUtil.memAddressSafe(intBuffer), Checks.remainingSafe(intBuffer2), MemoryUtil.memAddressSafe(intBuffer2));
    }

    public static native void nglGetDriverControlStringQCOM(int var0, int var1, long var2, long var4);

    public static void glGetDriverControlStringQCOM(int n2, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer, 1);
        }
        QCOMDriverControl.nglGetDriverControlStringQCOM(n2, Checks.remainingSafe(byteBuffer), MemoryUtil.memAddressSafe(intBuffer), MemoryUtil.memAddressSafe(byteBuffer));
    }

    public static String glGetDriverControlStringQCOM(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.ints(0);
            ByteBuffer byteBuffer = memoryStack.malloc(n3);
            QCOMDriverControl.nglGetDriverControlStringQCOM(n2, n3, MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(byteBuffer));
            String string = MemoryUtil.memASCII(byteBuffer, intBuffer.get(0));
            return string;
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static native void glEnableDriverControlQCOM(int var0);

    public static native void glDisableDriverControlQCOM(int var0);

    public static void glGetDriverControlsQCOM(int[] nArray, int[] nArray2) {
        long l2 = GLES.getICD().glGetDriverControlsQCOM;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.checkSafe(nArray, 1);
        }
        JNI.callPPV(nArray, Checks.lengthSafe(nArray2), nArray2, l2);
    }

    public static void glGetDriverControlStringQCOM(int n2, int[] nArray, ByteBuffer byteBuffer) {
        long l2 = GLES.getICD().glGetDriverControlStringQCOM;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.checkSafe(nArray, 1);
        }
        JNI.callPPV(n2, Checks.remainingSafe(byteBuffer), nArray, MemoryUtil.memAddressSafe(byteBuffer), l2);
    }

    static {
        GLES.initialize();
    }
}

