/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.OESDrawBuffersIndexed;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class OESViewportArray {
    public static final int GL_MAX_VIEWPORTS_OES = 33371;
    public static final int GL_VIEWPORT_SUBPIXEL_BITS_OES = 33372;
    public static final int GL_VIEWPORT_BOUNDS_RANGE_OES = 33373;
    public static final int GL_VIEWPORT_INDEX_PROVOKING_VERTEX_OES = 33375;

    protected OESViewportArray() {
        throw new UnsupportedOperationException();
    }

    public static native void nglViewportArrayvOES(int var0, int var1, long var2);

    public static void glViewportArrayvOES(int n2, FloatBuffer floatBuffer) {
        OESViewportArray.nglViewportArrayvOES(n2, floatBuffer.remaining() >> 2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void glViewportIndexedfOES(int var0, float var1, float var2, float var3, float var4);

    public static native void nglViewportIndexedfvOES(int var0, long var1);

    public static void glViewportIndexedfvOES(int n2, FloatBuffer floatBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)floatBuffer, 4);
        }
        OESViewportArray.nglViewportIndexedfvOES(n2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nglScissorArrayvOES(int var0, int var1, long var2);

    public static void glScissorArrayvOES(int n2, IntBuffer intBuffer) {
        OESViewportArray.nglScissorArrayvOES(n2, intBuffer.remaining() >> 2, MemoryUtil.memAddress(intBuffer));
    }

    public static native void glScissorIndexedOES(int var0, int var1, int var2, int var3, int var4);

    public static native void nglScissorIndexedvOES(int var0, long var1);

    public static void glScissorIndexedvOES(int n2, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 4);
        }
        OESViewportArray.nglScissorIndexedvOES(n2, MemoryUtil.memAddress(intBuffer));
    }

    public static native void nglDepthRangeArrayfvOES(int var0, int var1, long var2);

    public static void glDepthRangeArrayfvOES(int n2, FloatBuffer floatBuffer) {
        OESViewportArray.nglDepthRangeArrayfvOES(n2, floatBuffer.remaining() >> 1, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void glDepthRangeIndexedfOES(int var0, float var1, float var2);

    public static native void nglGetFloati_vOES(int var0, int var1, long var2);

    public static void glGetFloati_vOES(int n2, int n3, FloatBuffer floatBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)floatBuffer, 1);
        }
        OESViewportArray.nglGetFloati_vOES(n2, n3, MemoryUtil.memAddress(floatBuffer));
    }

    public static float glGetFloatiOES(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            FloatBuffer floatBuffer = memoryStack.callocFloat(1);
            OESViewportArray.nglGetFloati_vOES(n2, n3, MemoryUtil.memAddress(floatBuffer));
            float f2 = floatBuffer.get(0);
            return f2;
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static void glEnableiOES(int n2, int n3) {
        OESDrawBuffersIndexed.glEnableiOES(n2, n3);
    }

    public static void glDisableiOES(int n2, int n3) {
        OESDrawBuffersIndexed.glDisableiOES(n2, n3);
    }

    public static boolean glIsEnablediOES(int n2, int n3) {
        return OESDrawBuffersIndexed.glIsEnablediOES(n2, n3);
    }

    public static void glViewportArrayvOES(int n2, float[] fArray) {
        long l2 = GLES.getICD().glViewportArrayvOES;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, fArray.length >> 2, fArray, l2);
    }

    public static void glViewportIndexedfvOES(int n2, float[] fArray) {
        long l2 = GLES.getICD().glViewportIndexedfvOES;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(fArray, 4);
        }
        JNI.callPV(n2, fArray, l2);
    }

    public static void glScissorArrayvOES(int n2, int[] nArray) {
        long l2 = GLES.getICD().glScissorArrayvOES;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, nArray.length >> 2, nArray, l2);
    }

    public static void glScissorIndexedvOES(int n2, int[] nArray) {
        long l2 = GLES.getICD().glScissorIndexedvOES;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(nArray, 4);
        }
        JNI.callPV(n2, nArray, l2);
    }

    public static void glDepthRangeArrayfvOES(int n2, float[] fArray) {
        long l2 = GLES.getICD().glDepthRangeArrayfvOES;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, fArray.length >> 1, fArray, l2);
    }

    public static void glGetFloati_vOES(int n2, int n3, float[] fArray) {
        long l2 = GLES.getICD().glGetFloati_vOES;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(fArray, 1);
        }
        JNI.callPV(n2, n3, fArray, l2);
    }

    static {
        GLES.initialize();
    }
}

