/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.ByteBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLES20;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class OESMapbuffer {
    public static final int GL_WRITE_ONLY_OES = 35001;
    public static final int GL_BUFFER_ACCESS_OES = 35003;
    public static final int GL_BUFFER_MAPPED_OES = 35004;
    public static final int GL_BUFFER_MAP_POINTER_OES = 35005;

    protected OESMapbuffer() {
        throw new UnsupportedOperationException();
    }

    public static native long nglMapBufferOES(int var0, int var1);

    public static ByteBuffer glMapBufferOES(int n2, int n3) {
        return MemoryUtil.memByteBufferSafe(OESMapbuffer.nglMapBufferOES(n2, n3), GLES20.glGetBufferParameteri(n2, 34660));
    }

    public static ByteBuffer glMapBufferOES(int n2, int n3, ByteBuffer byteBuffer) {
        long l2 = OESMapbuffer.nglMapBufferOES(n2, n3);
        n2 = GLES20.glGetBufferParameteri(n2, 34660);
        return APIUtil.apiGetMappedBuffer(byteBuffer, l2, n2);
    }

    public static ByteBuffer glMapBufferOES(int n2, int n3, long l2, ByteBuffer byteBuffer) {
        long l3 = OESMapbuffer.nglMapBufferOES(n2, n3);
        return APIUtil.apiGetMappedBuffer(byteBuffer, l3, (int)l2);
    }

    public static native boolean glUnmapBufferOES(int var0);

    public static native void nglGetBufferPointervOES(int var0, int var1, long var2);

    public static void glGetBufferPointervOES(int n2, int n3, PointerBuffer pointerBuffer) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pointerBuffer, 1);
        }
        OESMapbuffer.nglGetBufferPointervOES(n2, n3, MemoryUtil.memAddress(pointerBuffer));
    }

    public static long glGetBufferPointerOES(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            PointerBuffer pointerBuffer = memoryStack.callocPointer(1);
            OESMapbuffer.nglGetBufferPointervOES(n2, n3, MemoryUtil.memAddress(pointerBuffer));
            long l2 = pointerBuffer.get(0);
            return l2;
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    static {
        GLES.initialize();
    }
}

