/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class NVViewportArray {
    public static final int GL_MAX_VIEWPORTS_NV = 33371;
    public static final int GL_VIEWPORT_SUBPIXEL_BITS_NV = 33372;
    public static final int GL_VIEWPORT_BOUNDS_RANGE_NV = 33373;
    public static final int GL_VIEWPORT_INDEX_PROVOKING_VERTEX_NV = 33375;

    protected NVViewportArray() {
        throw new UnsupportedOperationException();
    }

    public static native void nglViewportArrayvNV(int var0, int var1, long var2);

    public static void glViewportArrayvNV(int n2, FloatBuffer floatBuffer) {
        NVViewportArray.nglViewportArrayvNV(n2, floatBuffer.remaining() >> 2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void glViewportIndexedfNV(int var0, float var1, float var2, float var3, float var4);

    public static native void nglViewportIndexedfvNV(int var0, long var1);

    public static void glViewportIndexedfvNV(int n2, FloatBuffer floatBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)floatBuffer, 4);
        }
        NVViewportArray.nglViewportIndexedfvNV(n2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nglScissorArrayvNV(int var0, int var1, long var2);

    public static void glScissorArrayvNV(int n2, IntBuffer intBuffer) {
        NVViewportArray.nglScissorArrayvNV(n2, intBuffer.remaining() >> 2, MemoryUtil.memAddress(intBuffer));
    }

    public static native void glScissorIndexedNV(int var0, int var1, int var2, int var3, int var4);

    public static native void nglScissorIndexedvNV(int var0, long var1);

    public static void glScissorIndexedvNV(int n2, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 4);
        }
        NVViewportArray.nglScissorIndexedvNV(n2, MemoryUtil.memAddress(intBuffer));
    }

    public static native void nglDepthRangeArrayfvNV(int var0, int var1, long var2);

    public static void glDepthRangeArrayfvNV(int n2, FloatBuffer floatBuffer) {
        NVViewportArray.nglDepthRangeArrayfvNV(n2, floatBuffer.remaining() >> 1, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void glDepthRangeIndexedfNV(int var0, float var1, float var2);

    public static native void nglGetFloati_vNV(int var0, int var1, long var2);

    public static void glGetFloati_vNV(int n2, int n3, FloatBuffer floatBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)floatBuffer, 1);
        }
        NVViewportArray.nglGetFloati_vNV(n2, n3, MemoryUtil.memAddress(floatBuffer));
    }

    public static float glGetFloatiNV(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            FloatBuffer floatBuffer = memoryStack.callocFloat(1);
            NVViewportArray.nglGetFloati_vNV(n2, n3, MemoryUtil.memAddress(floatBuffer));
            float f2 = floatBuffer.get(0);
            return f2;
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static native void glEnableiNV(int var0, int var1);

    public static native void glDisableiNV(int var0, int var1);

    public static native boolean glIsEnablediNV(int var0, int var1);

    public static void glViewportArrayvNV(int n2, float[] fArray) {
        long l2 = GLES.getICD().glViewportArrayvNV;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, fArray.length >> 2, fArray, l2);
    }

    public static void glViewportIndexedfvNV(int n2, float[] fArray) {
        long l2 = GLES.getICD().glViewportIndexedfvNV;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(fArray, 4);
        }
        JNI.callPV(n2, fArray, l2);
    }

    public static void glScissorArrayvNV(int n2, int[] nArray) {
        long l2 = GLES.getICD().glScissorArrayvNV;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, nArray.length >> 2, nArray, l2);
    }

    public static void glScissorIndexedvNV(int n2, int[] nArray) {
        long l2 = GLES.getICD().glScissorIndexedvNV;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(nArray, 4);
        }
        JNI.callPV(n2, nArray, l2);
    }

    public static void glDepthRangeArrayfvNV(int n2, float[] fArray) {
        long l2 = GLES.getICD().glDepthRangeArrayfvNV;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, fArray.length >> 1, fArray, l2);
    }

    public static void glGetFloati_vNV(int n2, int n3, float[] fArray) {
        long l2 = GLES.getICD().glGetFloati_vNV;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(fArray, 1);
        }
        JNI.callPV(n2, n3, fArray, l2);
    }

    static {
        GLES.initialize();
    }
}

