/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class KHRRobustness {
    public static final int GL_GUILTY_CONTEXT_RESET_KHR = 33363;
    public static final int GL_INNOCENT_CONTEXT_RESET_KHR = 33364;
    public static final int GL_UNKNOWN_CONTEXT_RESET_KHR = 33365;
    public static final int GL_CONTEXT_ROBUST_ACCESS_KHR = 37107;
    public static final int GL_RESET_NOTIFICATION_STRATEGY_KHR = 33366;
    public static final int GL_LOSE_CONTEXT_ON_RESET_KHR = 33362;
    public static final int GL_NO_RESET_NOTIFICATION_KHR = 33377;
    public static final int GL_CONTEXT_LOST_KHR = 1287;

    protected KHRRobustness() {
        throw new UnsupportedOperationException();
    }

    public static native int glGetGraphicsResetStatusKHR();

    public static native void nglReadnPixelsKHR(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7);

    public static void glReadnPixelsKHR(int n2, int n3, int n4, int n5, int n6, int n7, int n8, long l2) {
        KHRRobustness.nglReadnPixelsKHR(n2, n3, n4, n5, n6, n7, n8, l2);
    }

    public static void glReadnPixelsKHR(int n2, int n3, int n4, int n5, int n6, int n7, ByteBuffer byteBuffer) {
        KHRRobustness.nglReadnPixelsKHR(n2, n3, n4, n5, n6, n7, byteBuffer.remaining(), MemoryUtil.memAddress(byteBuffer));
    }

    public static void glReadnPixelsKHR(int n2, int n3, int n4, int n5, int n6, int n7, ShortBuffer shortBuffer) {
        KHRRobustness.nglReadnPixelsKHR(n2, n3, n4, n5, n6, n7, shortBuffer.remaining() << 1, MemoryUtil.memAddress(shortBuffer));
    }

    public static void glReadnPixelsKHR(int n2, int n3, int n4, int n5, int n6, int n7, IntBuffer intBuffer) {
        KHRRobustness.nglReadnPixelsKHR(n2, n3, n4, n5, n6, n7, intBuffer.remaining() << 2, MemoryUtil.memAddress(intBuffer));
    }

    public static void glReadnPixelsKHR(int n2, int n3, int n4, int n5, int n6, int n7, FloatBuffer floatBuffer) {
        KHRRobustness.nglReadnPixelsKHR(n2, n3, n4, n5, n6, n7, floatBuffer.remaining() << 2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nglGetnUniformfvKHR(int var0, int var1, int var2, long var3);

    public static void glGetnUniformfvKHR(int n2, int n3, FloatBuffer floatBuffer) {
        KHRRobustness.nglGetnUniformfvKHR(n2, n3, floatBuffer.remaining(), MemoryUtil.memAddress(floatBuffer));
    }

    public static float glGetnUniformfKHR(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            FloatBuffer floatBuffer = memoryStack.callocFloat(1);
            KHRRobustness.nglGetnUniformfvKHR(n2, n3, 1, MemoryUtil.memAddress(floatBuffer));
            float f2 = floatBuffer.get(0);
            return f2;
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static native void nglGetnUniformivKHR(int var0, int var1, int var2, long var3);

    public static void glGetnUniformivKHR(int n2, int n3, FloatBuffer floatBuffer) {
        KHRRobustness.nglGetnUniformivKHR(n2, n3, floatBuffer.remaining(), MemoryUtil.memAddress(floatBuffer));
    }

    public static float glGetnUniformiKHR(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            FloatBuffer floatBuffer = memoryStack.callocFloat(1);
            KHRRobustness.nglGetnUniformivKHR(n2, n3, 1, MemoryUtil.memAddress(floatBuffer));
            float f2 = floatBuffer.get(0);
            return f2;
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static native void nglGetnUniformuivKHR(int var0, int var1, int var2, long var3);

    public static void glGetnUniformuivKHR(int n2, int n3, FloatBuffer floatBuffer) {
        KHRRobustness.nglGetnUniformuivKHR(n2, n3, floatBuffer.remaining(), MemoryUtil.memAddress(floatBuffer));
    }

    public static float glGetnUniformuiKHR(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            FloatBuffer floatBuffer = memoryStack.callocFloat(1);
            KHRRobustness.nglGetnUniformuivKHR(n2, n3, 1, MemoryUtil.memAddress(floatBuffer));
            float f2 = floatBuffer.get(0);
            return f2;
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static void glReadnPixelsKHR(int n2, int n3, int n4, int n5, int n6, int n7, short[] sArray) {
        long l2 = GLES.getICD().glReadnPixelsKHR;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, n4, n5, n6, n7, sArray.length << 1, sArray, l2);
    }

    public static void glReadnPixelsKHR(int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        long l2 = GLES.getICD().glReadnPixelsKHR;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, n4, n5, n6, n7, nArray.length << 2, nArray, l2);
    }

    public static void glReadnPixelsKHR(int n2, int n3, int n4, int n5, int n6, int n7, float[] fArray) {
        long l2 = GLES.getICD().glReadnPixelsKHR;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, n4, n5, n6, n7, fArray.length << 2, fArray, l2);
    }

    public static void glGetnUniformfvKHR(int n2, int n3, float[] fArray) {
        long l2 = GLES.getICD().glGetnUniformfvKHR;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, fArray.length, fArray, l2);
    }

    public static void glGetnUniformivKHR(int n2, int n3, float[] fArray) {
        long l2 = GLES.getICD().glGetnUniformivKHR;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, fArray.length, fArray, l2);
    }

    public static void glGetnUniformuivKHR(int n2, int n3, float[] fArray) {
        long l2 = GLES.getICD().glGetnUniformuivKHR;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, fArray.length, fArray, l2);
    }

    static {
        GLES.initialize();
    }
}

