/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.GLDebugMessageKHRCallbackI;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLES20;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class KHRDebug {
    public static final int GL_DEBUG_OUTPUT_KHR = 37600;
    public static final int GL_DEBUG_OUTPUT_SYNCHRONOUS_KHR = 33346;
    public static final int GL_CONTEXT_FLAG_DEBUG_BIT_KHR = 2;
    public static final int GL_MAX_DEBUG_MESSAGE_LENGTH_KHR = 37187;
    public static final int GL_MAX_DEBUG_LOGGED_MESSAGES_KHR = 37188;
    public static final int GL_DEBUG_LOGGED_MESSAGES_KHR = 37189;
    public static final int GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_KHR = 33347;
    public static final int GL_MAX_DEBUG_GROUP_STACK_DEPTH_KHR = 33388;
    public static final int GL_DEBUG_GROUP_STACK_DEPTH_KHR = 33389;
    public static final int GL_MAX_LABEL_LENGTH_KHR = 33512;
    public static final int GL_DEBUG_CALLBACK_FUNCTION_KHR = 33348;
    public static final int GL_DEBUG_CALLBACK_USER_PARAM_KHR = 33349;
    public static final int GL_DEBUG_SOURCE_API_KHR = 33350;
    public static final int GL_DEBUG_SOURCE_WINDOW_SYSTEM_KHR = 33351;
    public static final int GL_DEBUG_SOURCE_SHADER_COMPILER_KHR = 33352;
    public static final int GL_DEBUG_SOURCE_THIRD_PARTY_KHR = 33353;
    public static final int GL_DEBUG_SOURCE_APPLICATION_KHR = 33354;
    public static final int GL_DEBUG_SOURCE_OTHER_KHR = 33355;
    public static final int GL_DEBUG_TYPE_ERROR_KHR = 33356;
    public static final int GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_KHR = 33357;
    public static final int GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_KHR = 33358;
    public static final int GL_DEBUG_TYPE_PORTABILITY_KHR = 33359;
    public static final int GL_DEBUG_TYPE_PERFORMANCE_KHR = 33360;
    public static final int GL_DEBUG_TYPE_OTHER_KHR = 33361;
    public static final int GL_DEBUG_TYPE_MARKER_KHR = 33384;
    public static final int GL_DEBUG_TYPE_PUSH_GROUP_KHR = 33385;
    public static final int GL_DEBUG_TYPE_POP_GROUP_KHR = 33386;
    public static final int GL_DEBUG_SEVERITY_HIGH_KHR = 37190;
    public static final int GL_DEBUG_SEVERITY_MEDIUM_KHR = 37191;
    public static final int GL_DEBUG_SEVERITY_LOW_KHR = 37192;
    public static final int GL_DEBUG_SEVERITY_NOTIFICATION_KHR = 33387;
    public static final int GL_STACK_UNDERFLOW_KHR = 1284;
    public static final int GL_STACK_OVERFLOW_KHR = 1283;
    public static final int GL_BUFFER_KHR = 33504;
    public static final int GL_SHADER_KHR = 33505;
    public static final int GL_PROGRAM_KHR = 33506;
    public static final int GL_QUERY_KHR = 33507;
    public static final int GL_PROGRAM_PIPELINE_KHR = 33508;
    public static final int GL_SAMPLER_KHR = 33510;

    protected KHRDebug() {
        throw new UnsupportedOperationException();
    }

    public static native void nglDebugMessageControlKHR(int var0, int var1, int var2, int var3, long var4, boolean var6);

    public static void glDebugMessageControlKHR(int n2, int n3, int n4, IntBuffer intBuffer, boolean bl2) {
        KHRDebug.nglDebugMessageControlKHR(n2, n3, n4, Checks.remainingSafe(intBuffer), MemoryUtil.memAddressSafe(intBuffer), bl2);
    }

    public static void glDebugMessageControlKHR(int n2, int n3, int n4, int n5, boolean bl2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n6 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.ints(n5);
            KHRDebug.nglDebugMessageControlKHR(n2, n3, n4, 1, MemoryUtil.memAddress(intBuffer), bl2);
            return;
        }
        finally {
            memoryStack.setPointer(n6);
        }
    }

    public static native void nglDebugMessageInsertKHR(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glDebugMessageInsertKHR(int n2, int n3, int n4, int n5, ByteBuffer byteBuffer) {
        KHRDebug.nglDebugMessageInsertKHR(n2, n3, n4, n5, byteBuffer.remaining(), MemoryUtil.memAddress(byteBuffer));
    }

    public static void glDebugMessageInsertKHR(int n2, int n3, int n4, int n5, CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n6 = memoryStack.getPointer();
        try {
            int n7 = memoryStack.nUTF8(charSequence, false);
            long l2 = memoryStack.getPointerAddress();
            KHRDebug.nglDebugMessageInsertKHR(n2, n3, n4, n5, n7, l2);
            return;
        }
        finally {
            memoryStack.setPointer(n6);
        }
    }

    public static native void nglDebugMessageCallbackKHR(long var0, long var2);

    public static void glDebugMessageCallbackKHR(GLDebugMessageKHRCallbackI gLDebugMessageKHRCallbackI, long l2) {
        KHRDebug.nglDebugMessageCallbackKHR(MemoryUtil.memAddressSafe(gLDebugMessageKHRCallbackI), l2);
    }

    public static native int nglGetDebugMessageLogKHR(int var0, int var1, long var2, long var4, long var6, long var8, long var10, long var12);

    public static int glGetDebugMessageLogKHR(int n2, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3, IntBuffer intBuffer4, IntBuffer intBuffer5, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer, n2);
            Checks.checkSafe((Buffer)intBuffer2, n2);
            Checks.checkSafe((Buffer)intBuffer3, n2);
            Checks.checkSafe((Buffer)intBuffer4, n2);
            Checks.checkSafe((Buffer)intBuffer5, n2);
        }
        return KHRDebug.nglGetDebugMessageLogKHR(n2, Checks.remainingSafe(byteBuffer), MemoryUtil.memAddressSafe(intBuffer), MemoryUtil.memAddressSafe(intBuffer2), MemoryUtil.memAddressSafe(intBuffer3), MemoryUtil.memAddressSafe(intBuffer4), MemoryUtil.memAddressSafe(intBuffer5), MemoryUtil.memAddressSafe(byteBuffer));
    }

    public static native void nglGetPointervKHR(int var0, long var1);

    public static void glGetPointervKHR(int n2, PointerBuffer pointerBuffer) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pointerBuffer, 1);
        }
        KHRDebug.nglGetPointervKHR(n2, MemoryUtil.memAddress(pointerBuffer));
    }

    public static long glGetPointerKHR(int n2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            PointerBuffer pointerBuffer = memoryStack.callocPointer(1);
            KHRDebug.nglGetPointervKHR(n2, MemoryUtil.memAddress(pointerBuffer));
            long l2 = pointerBuffer.get(0);
            return l2;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native void nglPushDebugGroupKHR(int var0, int var1, int var2, long var3);

    public static void glPushDebugGroupKHR(int n2, int n3, ByteBuffer byteBuffer) {
        KHRDebug.nglPushDebugGroupKHR(n2, n3, byteBuffer.remaining(), MemoryUtil.memAddress(byteBuffer));
    }

    public static void glPushDebugGroupKHR(int n2, int n3, CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            int n5 = memoryStack.nUTF8(charSequence, false);
            long l2 = memoryStack.getPointerAddress();
            KHRDebug.nglPushDebugGroupKHR(n2, n3, n5, l2);
            return;
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static native void glPopDebugGroupKHR();

    public static native void nglObjectLabelKHR(int var0, int var1, int var2, long var3);

    public static void glObjectLabelKHR(int n2, int n3, ByteBuffer byteBuffer) {
        KHRDebug.nglObjectLabelKHR(n2, n3, byteBuffer.remaining(), MemoryUtil.memAddress(byteBuffer));
    }

    public static void glObjectLabelKHR(int n2, int n3, CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            int n5 = memoryStack.nUTF8(charSequence, false);
            long l2 = memoryStack.getPointerAddress();
            KHRDebug.nglObjectLabelKHR(n2, n3, n5, l2);
            return;
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static native void nglGetObjectLabelKHR(int var0, int var1, int var2, long var3, long var5);

    public static void glGetObjectLabelKHR(int n2, int n3, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer, 1);
        }
        KHRDebug.nglGetObjectLabelKHR(n2, n3, byteBuffer.remaining(), MemoryUtil.memAddressSafe(intBuffer), MemoryUtil.memAddress(byteBuffer));
    }

    public static String glGetObjectLabelKHR(int n2, int n3, int n4) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n5 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.ints(0);
            ByteBuffer byteBuffer = memoryStack.malloc(n4);
            KHRDebug.nglGetObjectLabelKHR(n2, n3, n4, MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(byteBuffer));
            String string = MemoryUtil.memUTF8(byteBuffer, intBuffer.get(0));
            return string;
        }
        finally {
            memoryStack.setPointer(n5);
        }
    }

    public static String glGetObjectLabelKHR(int n2, int n3) {
        return KHRDebug.glGetObjectLabelKHR(n2, n3, GLES20.glGetInteger(33512));
    }

    public static native void nglObjectPtrLabelKHR(long var0, int var2, long var3);

    public static void glObjectPtrLabelKHR(long l2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        KHRDebug.nglObjectPtrLabelKHR(l2, byteBuffer.remaining(), MemoryUtil.memAddress(byteBuffer));
    }

    public static void glObjectPtrLabelKHR(long l2, CharSequence charSequence) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            int n3 = memoryStack.nUTF8(charSequence, false);
            long l3 = memoryStack.getPointerAddress();
            KHRDebug.nglObjectPtrLabelKHR(l2, n3, l3);
            return;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static native void nglGetObjectPtrLabelKHR(long var0, int var2, long var3, long var5);

    public static void glGetObjectPtrLabelKHR(long l2, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.checkSafe((Buffer)intBuffer, 1);
        }
        KHRDebug.nglGetObjectPtrLabelKHR(l2, byteBuffer.remaining(), MemoryUtil.memAddressSafe(intBuffer), MemoryUtil.memAddress(byteBuffer));
    }

    public static String glGetObjectPtrLabelKHR(long l2, int n2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.ints(0);
            ByteBuffer byteBuffer = memoryStack.malloc(n2);
            KHRDebug.nglGetObjectPtrLabelKHR(l2, n2, MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(byteBuffer));
            String string = MemoryUtil.memUTF8(byteBuffer, intBuffer.get(0));
            return string;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static String glGetObjectPtrLabelKHR(long l2) {
        return KHRDebug.glGetObjectPtrLabelKHR(l2, GLES20.glGetInteger(33512));
    }

    public static void glDebugMessageControlKHR(int n2, int n3, int n4, int[] nArray, boolean bl2) {
        long l2 = GLES.getICD().glDebugMessageControlKHR;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, n4, Checks.lengthSafe(nArray), nArray, bl2, l2);
    }

    public static int glGetDebugMessageLogKHR(int n2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, ByteBuffer byteBuffer) {
        long l2 = GLES.getICD().glGetDebugMessageLogKHR;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.checkSafe(nArray, n2);
            Checks.checkSafe(nArray2, n2);
            Checks.checkSafe(nArray3, n2);
            Checks.checkSafe(nArray4, n2);
            Checks.checkSafe(nArray5, n2);
        }
        return JNI.callPPPPPPI(n2, Checks.remainingSafe(byteBuffer), nArray, nArray2, nArray3, nArray4, nArray5, MemoryUtil.memAddressSafe(byteBuffer), l2);
    }

    public static void glGetObjectLabelKHR(int n2, int n3, int[] nArray, ByteBuffer byteBuffer) {
        long l2 = GLES.getICD().glGetObjectLabelKHR;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.checkSafe(nArray, 1);
        }
        JNI.callPPV(n2, n3, byteBuffer.remaining(), nArray, MemoryUtil.memAddress(byteBuffer), l2);
    }

    public static void glGetObjectPtrLabelKHR(long l2, int[] nArray, ByteBuffer byteBuffer) {
        long l3 = GLES.getICD().glGetObjectPtrLabelKHR;
        if (Checks.CHECKS) {
            Checks.check(l3);
            Checks.check(l2);
            Checks.checkSafe(nArray, 1);
        }
        JNI.callPPPV(l2, byteBuffer.remaining(), nArray, MemoryUtil.memAddress(byteBuffer), l3);
    }

    static {
        GLES.initialize();
    }
}

