/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLES30;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class GLES31
extends GLES30 {
    public static final int GL_COMPUTE_SHADER = 37305;
    public static final int GL_MAX_COMPUTE_UNIFORM_BLOCKS = 37307;
    public static final int GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS = 37308;
    public static final int GL_MAX_COMPUTE_IMAGE_UNIFORMS = 37309;
    public static final int GL_MAX_COMPUTE_SHARED_MEMORY_SIZE = 33378;
    public static final int GL_MAX_COMPUTE_UNIFORM_COMPONENTS = 33379;
    public static final int GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS = 33380;
    public static final int GL_MAX_COMPUTE_ATOMIC_COUNTERS = 33381;
    public static final int GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS = 33382;
    public static final int GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS = 37099;
    public static final int GL_MAX_COMPUTE_WORK_GROUP_COUNT = 37310;
    public static final int GL_MAX_COMPUTE_WORK_GROUP_SIZE = 37311;
    public static final int GL_COMPUTE_WORK_GROUP_SIZE = 33383;
    public static final int GL_DISPATCH_INDIRECT_BUFFER = 37102;
    public static final int GL_DISPATCH_INDIRECT_BUFFER_BINDING = 37103;
    public static final int GL_COMPUTE_SHADER_BIT = 32;
    public static final int GL_DRAW_INDIRECT_BUFFER = 36671;
    public static final int GL_DRAW_INDIRECT_BUFFER_BINDING = 36675;
    public static final int GL_MAX_UNIFORM_LOCATIONS = 33390;
    public static final int GL_FRAMEBUFFER_DEFAULT_WIDTH = 37648;
    public static final int GL_FRAMEBUFFER_DEFAULT_HEIGHT = 37649;
    public static final int GL_FRAMEBUFFER_DEFAULT_SAMPLES = 37651;
    public static final int GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS = 37652;
    public static final int GL_MAX_FRAMEBUFFER_WIDTH = 37653;
    public static final int GL_MAX_FRAMEBUFFER_HEIGHT = 37654;
    public static final int GL_MAX_FRAMEBUFFER_SAMPLES = 37656;
    public static final int GL_UNIFORM = 37601;
    public static final int GL_UNIFORM_BLOCK = 37602;
    public static final int GL_PROGRAM_INPUT = 37603;
    public static final int GL_PROGRAM_OUTPUT = 37604;
    public static final int GL_BUFFER_VARIABLE = 37605;
    public static final int GL_SHADER_STORAGE_BLOCK = 37606;
    public static final int GL_ATOMIC_COUNTER_BUFFER = 37568;
    public static final int GL_TRANSFORM_FEEDBACK_VARYING = 37620;
    public static final int GL_ACTIVE_RESOURCES = 37621;
    public static final int GL_MAX_NAME_LENGTH = 37622;
    public static final int GL_MAX_NUM_ACTIVE_VARIABLES = 37623;
    public static final int GL_NAME_LENGTH = 37625;
    public static final int GL_TYPE = 37626;
    public static final int GL_ARRAY_SIZE = 37627;
    public static final int GL_OFFSET = 37628;
    public static final int GL_BLOCK_INDEX = 37629;
    public static final int GL_ARRAY_STRIDE = 37630;
    public static final int GL_MATRIX_STRIDE = 37631;
    public static final int GL_IS_ROW_MAJOR = 37632;
    public static final int GL_ATOMIC_COUNTER_BUFFER_INDEX = 37633;
    public static final int GL_BUFFER_BINDING = 37634;
    public static final int GL_BUFFER_DATA_SIZE = 37635;
    public static final int GL_NUM_ACTIVE_VARIABLES = 37636;
    public static final int GL_ACTIVE_VARIABLES = 37637;
    public static final int GL_REFERENCED_BY_VERTEX_SHADER = 37638;
    public static final int GL_REFERENCED_BY_FRAGMENT_SHADER = 37642;
    public static final int GL_REFERENCED_BY_COMPUTE_SHADER = 37643;
    public static final int GL_TOP_LEVEL_ARRAY_SIZE = 37644;
    public static final int GL_TOP_LEVEL_ARRAY_STRIDE = 37645;
    public static final int GL_LOCATION = 37646;
    public static final int GL_VERTEX_SHADER_BIT = 1;
    public static final int GL_FRAGMENT_SHADER_BIT = 2;
    public static final int GL_ALL_SHADER_BITS = -1;
    public static final int GL_PROGRAM_SEPARABLE = 33368;
    public static final int GL_ACTIVE_PROGRAM = 33369;
    public static final int GL_PROGRAM_PIPELINE_BINDING = 33370;
    public static final int GL_ATOMIC_COUNTER_BUFFER_BINDING = 37569;
    public static final int GL_ATOMIC_COUNTER_BUFFER_START = 37570;
    public static final int GL_ATOMIC_COUNTER_BUFFER_SIZE = 37571;
    public static final int GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS = 37580;
    public static final int GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS = 37584;
    public static final int GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS = 37585;
    public static final int GL_MAX_VERTEX_ATOMIC_COUNTERS = 37586;
    public static final int GL_MAX_FRAGMENT_ATOMIC_COUNTERS = 37590;
    public static final int GL_MAX_COMBINED_ATOMIC_COUNTERS = 37591;
    public static final int GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE = 37592;
    public static final int GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS = 37596;
    public static final int GL_ACTIVE_ATOMIC_COUNTER_BUFFERS = 37593;
    public static final int GL_UNSIGNED_INT_ATOMIC_COUNTER = 37595;
    public static final int GL_MAX_IMAGE_UNITS = 36664;
    public static final int GL_MAX_VERTEX_IMAGE_UNIFORMS = 37066;
    public static final int GL_MAX_FRAGMENT_IMAGE_UNIFORMS = 37070;
    public static final int GL_MAX_COMBINED_IMAGE_UNIFORMS = 37071;
    public static final int GL_IMAGE_BINDING_NAME = 36666;
    public static final int GL_IMAGE_BINDING_LEVEL = 36667;
    public static final int GL_IMAGE_BINDING_LAYERED = 36668;
    public static final int GL_IMAGE_BINDING_LAYER = 36669;
    public static final int GL_IMAGE_BINDING_ACCESS = 36670;
    public static final int GL_IMAGE_BINDING_FORMAT = 36974;
    public static final int GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT = 1;
    public static final int GL_ELEMENT_ARRAY_BARRIER_BIT = 2;
    public static final int GL_UNIFORM_BARRIER_BIT = 4;
    public static final int GL_TEXTURE_FETCH_BARRIER_BIT = 8;
    public static final int GL_SHADER_IMAGE_ACCESS_BARRIER_BIT = 32;
    public static final int GL_COMMAND_BARRIER_BIT = 64;
    public static final int GL_PIXEL_BUFFER_BARRIER_BIT = 128;
    public static final int GL_TEXTURE_UPDATE_BARRIER_BIT = 256;
    public static final int GL_BUFFER_UPDATE_BARRIER_BIT = 512;
    public static final int GL_FRAMEBUFFER_BARRIER_BIT = 1024;
    public static final int GL_TRANSFORM_FEEDBACK_BARRIER_BIT = 2048;
    public static final int GL_ATOMIC_COUNTER_BARRIER_BIT = 4096;
    public static final int GL_ALL_BARRIER_BITS = -1;
    public static final int GL_IMAGE_2D = 36941;
    public static final int GL_IMAGE_3D = 36942;
    public static final int GL_IMAGE_CUBE = 36944;
    public static final int GL_IMAGE_2D_ARRAY = 36947;
    public static final int GL_INT_IMAGE_2D = 36952;
    public static final int GL_INT_IMAGE_3D = 36953;
    public static final int GL_INT_IMAGE_CUBE = 36955;
    public static final int GL_INT_IMAGE_2D_ARRAY = 36958;
    public static final int GL_UNSIGNED_INT_IMAGE_2D = 36963;
    public static final int GL_UNSIGNED_INT_IMAGE_3D = 36964;
    public static final int GL_UNSIGNED_INT_IMAGE_CUBE = 36966;
    public static final int GL_UNSIGNED_INT_IMAGE_2D_ARRAY = 36969;
    public static final int GL_IMAGE_FORMAT_COMPATIBILITY_TYPE = 37063;
    public static final int GL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE = 37064;
    public static final int GL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS = 37065;
    public static final int GL_READ_ONLY = 35000;
    public static final int GL_WRITE_ONLY = 35001;
    public static final int GL_READ_WRITE = 35002;
    public static final int GL_SHADER_STORAGE_BUFFER = 37074;
    public static final int GL_SHADER_STORAGE_BUFFER_BINDING = 37075;
    public static final int GL_SHADER_STORAGE_BUFFER_START = 37076;
    public static final int GL_SHADER_STORAGE_BUFFER_SIZE = 37077;
    public static final int GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS = 37078;
    public static final int GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS = 37082;
    public static final int GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS = 37083;
    public static final int GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS = 37084;
    public static final int GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS = 37085;
    public static final int GL_MAX_SHADER_STORAGE_BLOCK_SIZE = 37086;
    public static final int GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT = 37087;
    public static final int GL_SHADER_STORAGE_BARRIER_BIT = 8192;
    public static final int GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES = 36665;
    public static final int GL_DEPTH_STENCIL_TEXTURE_MODE = 37098;
    public static final int GL_STENCIL_INDEX = 6401;
    public static final int GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET = 36446;
    public static final int GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET = 36447;
    public static final int GL_SAMPLE_POSITION = 36432;
    public static final int GL_SAMPLE_MASK = 36433;
    public static final int GL_SAMPLE_MASK_VALUE = 36434;
    public static final int GL_TEXTURE_2D_MULTISAMPLE = 37120;
    public static final int GL_MAX_SAMPLE_MASK_WORDS = 36441;
    public static final int GL_MAX_COLOR_TEXTURE_SAMPLES = 37134;
    public static final int GL_MAX_DEPTH_TEXTURE_SAMPLES = 37135;
    public static final int GL_MAX_INTEGER_SAMPLES = 37136;
    public static final int GL_TEXTURE_BINDING_2D_MULTISAMPLE = 37124;
    public static final int GL_TEXTURE_SAMPLES = 37126;
    public static final int GL_TEXTURE_FIXED_SAMPLE_LOCATIONS = 37127;
    public static final int GL_TEXTURE_WIDTH = 4096;
    public static final int GL_TEXTURE_HEIGHT = 4097;
    public static final int GL_TEXTURE_DEPTH = 32881;
    public static final int GL_TEXTURE_INTERNAL_FORMAT = 4099;
    public static final int GL_TEXTURE_RED_SIZE = 32860;
    public static final int GL_TEXTURE_GREEN_SIZE = 32861;
    public static final int GL_TEXTURE_BLUE_SIZE = 32862;
    public static final int GL_TEXTURE_ALPHA_SIZE = 32863;
    public static final int GL_TEXTURE_DEPTH_SIZE = 34890;
    public static final int GL_TEXTURE_STENCIL_SIZE = 35057;
    public static final int GL_TEXTURE_SHARED_SIZE = 35903;
    public static final int GL_TEXTURE_RED_TYPE = 35856;
    public static final int GL_TEXTURE_GREEN_TYPE = 35857;
    public static final int GL_TEXTURE_BLUE_TYPE = 35858;
    public static final int GL_TEXTURE_ALPHA_TYPE = 35859;
    public static final int GL_TEXTURE_DEPTH_TYPE = 35862;
    public static final int GL_TEXTURE_COMPRESSED = 34465;
    public static final int GL_SAMPLER_2D_MULTISAMPLE = 37128;
    public static final int GL_INT_SAMPLER_2D_MULTISAMPLE = 37129;
    public static final int GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE = 37130;
    public static final int GL_VERTEX_ATTRIB_BINDING = 33492;
    public static final int GL_VERTEX_ATTRIB_RELATIVE_OFFSET = 33493;
    public static final int GL_VERTEX_BINDING_DIVISOR = 33494;
    public static final int GL_VERTEX_BINDING_OFFSET = 33495;
    public static final int GL_VERTEX_BINDING_STRIDE = 33496;
    public static final int GL_VERTEX_BINDING_BUFFER = 36687;
    public static final int GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET = 33497;
    public static final int GL_MAX_VERTEX_ATTRIB_BINDINGS = 33498;
    public static final int GL_MAX_VERTEX_ATTRIB_STRIDE = 33509;

    protected GLES31() {
        throw new UnsupportedOperationException();
    }

    public static native void glDispatchCompute(int var0, int var1, int var2);

    public static native void glDispatchComputeIndirect(long var0);

    public static native void nglDrawArraysIndirect(int var0, long var1);

    public static void glDrawArraysIndirect(int n2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)byteBuffer, 16);
        }
        GLES31.nglDrawArraysIndirect(n2, MemoryUtil.memAddress(byteBuffer));
    }

    public static void glDrawArraysIndirect(int n2, long l2) {
        GLES31.nglDrawArraysIndirect(n2, l2);
    }

    public static void glDrawArraysIndirect(int n2, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 4);
        }
        GLES31.nglDrawArraysIndirect(n2, MemoryUtil.memAddress(intBuffer));
    }

    public static native void nglDrawElementsIndirect(int var0, int var1, long var2);

    public static void glDrawElementsIndirect(int n2, int n3, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)byteBuffer, 20);
        }
        GLES31.nglDrawElementsIndirect(n2, n3, MemoryUtil.memAddress(byteBuffer));
    }

    public static void glDrawElementsIndirect(int n2, int n3, long l2) {
        GLES31.nglDrawElementsIndirect(n2, n3, l2);
    }

    public static void glDrawElementsIndirect(int n2, int n3, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 5);
        }
        GLES31.nglDrawElementsIndirect(n2, n3, MemoryUtil.memAddress(intBuffer));
    }

    public static native void glFramebufferParameteri(int var0, int var1, int var2);

    public static native void nglGetFramebufferParameteriv(int var0, int var1, long var2);

    public static void glGetFramebufferParameteriv(int n2, int n3, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
        }
        GLES31.nglGetFramebufferParameteriv(n2, n3, MemoryUtil.memAddress(intBuffer));
    }

    public static int glGetFramebufferParameteri(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.callocInt(1);
            GLES31.nglGetFramebufferParameteriv(n2, n3, MemoryUtil.memAddress(intBuffer));
            n2 = intBuffer.get(0);
            return n2;
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static native void nglGetProgramInterfaceiv(int var0, int var1, int var2, long var3);

    public static void glGetProgramInterfaceiv(int n2, int n3, int n4, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
        }
        GLES31.nglGetProgramInterfaceiv(n2, n3, n4, MemoryUtil.memAddress(intBuffer));
    }

    public static int glGetProgramInterfacei(int n2, int n3, int n4) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n5 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.callocInt(1);
            GLES31.nglGetProgramInterfaceiv(n2, n3, n4, MemoryUtil.memAddress(intBuffer));
            n2 = intBuffer.get(0);
            return n2;
        }
        finally {
            memoryStack.setPointer(n5);
        }
    }

    public static native int nglGetProgramResourceIndex(int var0, int var1, long var2);

    public static int glGetProgramResourceIndex(int n2, int n3, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return GLES31.nglGetProgramResourceIndex(n2, n3, MemoryUtil.memAddress(byteBuffer));
    }

    public static int glGetProgramResourceIndex(int n2, int n3, CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            memoryStack.nASCII(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            n2 = GLES31.nglGetProgramResourceIndex(n2, n3, l2);
            return n2;
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static native void nglGetProgramResourceName(int var0, int var1, int var2, int var3, long var4, long var6);

    public static void glGetProgramResourceName(int n2, int n3, int n4, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer, 1);
        }
        GLES31.nglGetProgramResourceName(n2, n3, n4, byteBuffer.remaining(), MemoryUtil.memAddressSafe(intBuffer), MemoryUtil.memAddress(byteBuffer));
    }

    public static String glGetProgramResourceName(int n2, int n3, int n4, int n5) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n6 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.ints(0);
            ByteBuffer byteBuffer = memoryStack.malloc(n5);
            GLES31.nglGetProgramResourceName(n2, n3, n4, n5, MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(byteBuffer));
            String string = MemoryUtil.memASCII(byteBuffer, intBuffer.get(0));
            return string;
        }
        finally {
            memoryStack.setPointer(n6);
        }
    }

    public static String glGetProgramResourceName(int n2, int n3, int n4) {
        return GLES31.glGetProgramResourceName(n2, n3, n4, GLES31.glGetProgramInterfacei(n2, n3, 37622));
    }

    public static native void nglGetProgramResourceiv(int var0, int var1, int var2, int var3, long var4, int var6, long var7, long var9);

    public static void glGetProgramResourceiv(int n2, int n3, int n4, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer2, 1);
        }
        GLES31.nglGetProgramResourceiv(n2, n3, n4, intBuffer.remaining(), MemoryUtil.memAddress(intBuffer), intBuffer3.remaining(), MemoryUtil.memAddressSafe(intBuffer2), MemoryUtil.memAddress(intBuffer3));
    }

    public static native int nglGetProgramResourceLocation(int var0, int var1, long var2);

    public static int glGetProgramResourceLocation(int n2, int n3, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return GLES31.nglGetProgramResourceLocation(n2, n3, MemoryUtil.memAddress(byteBuffer));
    }

    public static int glGetProgramResourceLocation(int n2, int n3, CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            memoryStack.nASCII(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            n2 = GLES31.nglGetProgramResourceLocation(n2, n3, l2);
            return n2;
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static native void glUseProgramStages(int var0, int var1, int var2);

    public static native void glActiveShaderProgram(int var0, int var1);

    public static native int nglCreateShaderProgramv(int var0, int var1, long var2);

    public static int glCreateShaderProgramv(int n2, PointerBuffer pointerBuffer) {
        return GLES31.nglCreateShaderProgramv(n2, pointerBuffer.remaining(), MemoryUtil.memAddress(pointerBuffer));
    }

    public static int glCreateShaderProgramv(int n2, CharSequence ... charSequenceArray) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            long l2 = APIUtil.apiArray(memoryStack, MemoryUtil::memUTF8, charSequenceArray);
            n2 = GLES31.nglCreateShaderProgramv(n2, charSequenceArray.length, l2);
            APIUtil.apiArrayFree(l2, charSequenceArray.length);
            return n2;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static int glCreateShaderProgramv(int n2, CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            long l2 = APIUtil.apiArray(memoryStack, MemoryUtil::memUTF8, charSequence);
            n2 = GLES31.nglCreateShaderProgramv(n2, 1, l2);
            APIUtil.apiArrayFree(l2, 1);
            return n2;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native void glBindProgramPipeline(int var0);

    public static native void nglDeleteProgramPipelines(int var0, long var1);

    public static void glDeleteProgramPipelines(IntBuffer intBuffer) {
        GLES31.nglDeleteProgramPipelines(intBuffer.remaining(), MemoryUtil.memAddress(intBuffer));
    }

    public static void glDeleteProgramPipelines(int n2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.ints(n2);
            GLES31.nglDeleteProgramPipelines(1, MemoryUtil.memAddress(intBuffer));
            return;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native void nglGenProgramPipelines(int var0, long var1);

    public static void glGenProgramPipelines(IntBuffer intBuffer) {
        GLES31.nglGenProgramPipelines(intBuffer.remaining(), MemoryUtil.memAddress(intBuffer));
    }

    public static int glGenProgramPipelines() {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.callocInt(1);
            GLES31.nglGenProgramPipelines(1, MemoryUtil.memAddress(intBuffer));
            int n3 = intBuffer.get(0);
            return n3;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static native boolean glIsProgramPipeline(int var0);

    public static native void nglGetProgramPipelineiv(int var0, int var1, long var2);

    public static void glGetProgramPipelineiv(int n2, int n3, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
        }
        GLES31.nglGetProgramPipelineiv(n2, n3, MemoryUtil.memAddress(intBuffer));
    }

    public static int glGetProgramPipelinei(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.callocInt(1);
            GLES31.nglGetProgramPipelineiv(n2, n3, MemoryUtil.memAddress(intBuffer));
            n2 = intBuffer.get(0);
            return n2;
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static native void glProgramUniform1i(int var0, int var1, int var2);

    public static native void glProgramUniform2i(int var0, int var1, int var2, int var3);

    public static native void glProgramUniform3i(int var0, int var1, int var2, int var3, int var4);

    public static native void glProgramUniform4i(int var0, int var1, int var2, int var3, int var4, int var5);

    public static native void glProgramUniform1ui(int var0, int var1, int var2);

    public static native void glProgramUniform2ui(int var0, int var1, int var2, int var3);

    public static native void glProgramUniform3ui(int var0, int var1, int var2, int var3, int var4);

    public static native void glProgramUniform4ui(int var0, int var1, int var2, int var3, int var4, int var5);

    public static native void glProgramUniform1f(int var0, int var1, float var2);

    public static native void glProgramUniform2f(int var0, int var1, float var2, float var3);

    public static native void glProgramUniform3f(int var0, int var1, float var2, float var3, float var4);

    public static native void glProgramUniform4f(int var0, int var1, float var2, float var3, float var4, float var5);

    public static native void nglProgramUniform1iv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform1iv(int n2, int n3, IntBuffer intBuffer) {
        GLES31.nglProgramUniform1iv(n2, n3, intBuffer.remaining(), MemoryUtil.memAddress(intBuffer));
    }

    public static native void nglProgramUniform2iv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform2iv(int n2, int n3, IntBuffer intBuffer) {
        GLES31.nglProgramUniform2iv(n2, n3, intBuffer.remaining() >> 1, MemoryUtil.memAddress(intBuffer));
    }

    public static native void nglProgramUniform3iv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform3iv(int n2, int n3, IntBuffer intBuffer) {
        GLES31.nglProgramUniform3iv(n2, n3, intBuffer.remaining() / 3, MemoryUtil.memAddress(intBuffer));
    }

    public static native void nglProgramUniform4iv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform4iv(int n2, int n3, IntBuffer intBuffer) {
        GLES31.nglProgramUniform4iv(n2, n3, intBuffer.remaining() >> 2, MemoryUtil.memAddress(intBuffer));
    }

    public static native void nglProgramUniform1uiv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform1uiv(int n2, int n3, IntBuffer intBuffer) {
        GLES31.nglProgramUniform1uiv(n2, n3, intBuffer.remaining(), MemoryUtil.memAddress(intBuffer));
    }

    public static native void nglProgramUniform2uiv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform2uiv(int n2, int n3, IntBuffer intBuffer) {
        GLES31.nglProgramUniform2uiv(n2, n3, intBuffer.remaining() >> 1, MemoryUtil.memAddress(intBuffer));
    }

    public static native void nglProgramUniform3uiv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform3uiv(int n2, int n3, IntBuffer intBuffer) {
        GLES31.nglProgramUniform3uiv(n2, n3, intBuffer.remaining() / 3, MemoryUtil.memAddress(intBuffer));
    }

    public static native void nglProgramUniform4uiv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform4uiv(int n2, int n3, IntBuffer intBuffer) {
        GLES31.nglProgramUniform4uiv(n2, n3, intBuffer.remaining() >> 2, MemoryUtil.memAddress(intBuffer));
    }

    public static native void nglProgramUniform1fv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform1fv(int n2, int n3, FloatBuffer floatBuffer) {
        GLES31.nglProgramUniform1fv(n2, n3, floatBuffer.remaining(), MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nglProgramUniform2fv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform2fv(int n2, int n3, FloatBuffer floatBuffer) {
        GLES31.nglProgramUniform2fv(n2, n3, floatBuffer.remaining() >> 1, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nglProgramUniform3fv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform3fv(int n2, int n3, FloatBuffer floatBuffer) {
        GLES31.nglProgramUniform3fv(n2, n3, floatBuffer.remaining() / 3, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nglProgramUniform4fv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform4fv(int n2, int n3, FloatBuffer floatBuffer) {
        GLES31.nglProgramUniform4fv(n2, n3, floatBuffer.remaining() >> 2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nglProgramUniformMatrix2fv(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix2fv(int n2, int n3, boolean bl2, FloatBuffer floatBuffer) {
        GLES31.nglProgramUniformMatrix2fv(n2, n3, floatBuffer.remaining() >> 2, bl2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nglProgramUniformMatrix3fv(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix3fv(int n2, int n3, boolean bl2, FloatBuffer floatBuffer) {
        GLES31.nglProgramUniformMatrix3fv(n2, n3, floatBuffer.remaining() / 9, bl2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nglProgramUniformMatrix4fv(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix4fv(int n2, int n3, boolean bl2, FloatBuffer floatBuffer) {
        GLES31.nglProgramUniformMatrix4fv(n2, n3, floatBuffer.remaining() >> 4, bl2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nglProgramUniformMatrix2x3fv(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix2x3fv(int n2, int n3, boolean bl2, FloatBuffer floatBuffer) {
        GLES31.nglProgramUniformMatrix2x3fv(n2, n3, floatBuffer.remaining() / 6, bl2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nglProgramUniformMatrix3x2fv(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix3x2fv(int n2, int n3, boolean bl2, FloatBuffer floatBuffer) {
        GLES31.nglProgramUniformMatrix3x2fv(n2, n3, floatBuffer.remaining() / 6, bl2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nglProgramUniformMatrix2x4fv(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix2x4fv(int n2, int n3, boolean bl2, FloatBuffer floatBuffer) {
        GLES31.nglProgramUniformMatrix2x4fv(n2, n3, floatBuffer.remaining() >> 3, bl2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nglProgramUniformMatrix4x2fv(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix4x2fv(int n2, int n3, boolean bl2, FloatBuffer floatBuffer) {
        GLES31.nglProgramUniformMatrix4x2fv(n2, n3, floatBuffer.remaining() >> 3, bl2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nglProgramUniformMatrix3x4fv(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix3x4fv(int n2, int n3, boolean bl2, FloatBuffer floatBuffer) {
        GLES31.nglProgramUniformMatrix3x4fv(n2, n3, floatBuffer.remaining() / 12, bl2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nglProgramUniformMatrix4x3fv(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix4x3fv(int n2, int n3, boolean bl2, FloatBuffer floatBuffer) {
        GLES31.nglProgramUniformMatrix4x3fv(n2, n3, floatBuffer.remaining() / 12, bl2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void glValidateProgramPipeline(int var0);

    public static native void nglGetProgramPipelineInfoLog(int var0, int var1, long var2, long var4);

    public static void glGetProgramPipelineInfoLog(int n2, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer, 1);
        }
        GLES31.nglGetProgramPipelineInfoLog(n2, byteBuffer.remaining(), MemoryUtil.memAddressSafe(intBuffer), MemoryUtil.memAddress(byteBuffer));
    }

    public static String glGetProgramPipelineInfoLog(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        ByteBuffer byteBuffer = MemoryUtil.memAlloc(n3);
        try {
            IntBuffer intBuffer = memoryStack.ints(0);
            GLES31.nglGetProgramPipelineInfoLog(n2, n3, MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(byteBuffer));
            String string = MemoryUtil.memUTF8(byteBuffer, intBuffer.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree(byteBuffer);
            memoryStack.setPointer(n4);
        }
    }

    public static String glGetProgramPipelineInfoLog(int n2) {
        int n3 = n2;
        return GLES31.glGetProgramPipelineInfoLog(n3, GLES31.glGetProgramPipelinei(n3, 35716));
    }

    public static native void glBindImageTexture(int var0, int var1, int var2, boolean var3, int var4, int var5, int var6);

    public static native void nglGetBooleani_v(int var0, int var1, long var2);

    public static void glGetBooleani_v(int n2, int n3, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)byteBuffer, 1);
        }
        GLES31.nglGetBooleani_v(n2, n3, MemoryUtil.memAddress(byteBuffer));
    }

    public static boolean glGetBooleani(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            ByteBuffer byteBuffer = memoryStack.calloc(1);
            GLES31.nglGetBooleani_v(n2, n3, MemoryUtil.memAddress(byteBuffer));
            n2 = byteBuffer.get(0) != 0 ? 1 : 0;
            return n2 != 0;
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static native void glMemoryBarrier(int var0);

    public static native void glMemoryBarrierByRegion(int var0);

    public static native void glTexStorage2DMultisample(int var0, int var1, int var2, int var3, int var4, boolean var5);

    public static native void nglGetMultisamplefv(int var0, int var1, long var2);

    public static void glGetMultisamplefv(int n2, int n3, FloatBuffer floatBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)floatBuffer, 1);
        }
        GLES31.nglGetMultisamplefv(n2, n3, MemoryUtil.memAddress(floatBuffer));
    }

    public static float glGetMultisamplef(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            FloatBuffer floatBuffer = memoryStack.callocFloat(1);
            GLES31.nglGetMultisamplefv(n2, n3, MemoryUtil.memAddress(floatBuffer));
            float f2 = floatBuffer.get(0);
            return f2;
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static native void glSampleMaski(int var0, int var1);

    public static native void nglGetTexLevelParameteriv(int var0, int var1, int var2, long var3);

    public static void glGetTexLevelParameteriv(int n2, int n3, int n4, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
        }
        GLES31.nglGetTexLevelParameteriv(n2, n3, n4, MemoryUtil.memAddress(intBuffer));
    }

    public static int glGetTexLevelParameteri(int n2, int n3, int n4) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n5 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.callocInt(1);
            GLES31.nglGetTexLevelParameteriv(n2, n3, n4, MemoryUtil.memAddress(intBuffer));
            n2 = intBuffer.get(0);
            return n2;
        }
        finally {
            memoryStack.setPointer(n5);
        }
    }

    public static native void nglGetTexLevelParameterfv(int var0, int var1, int var2, long var3);

    public static void glGetTexLevelParameterfv(int n2, int n3, int n4, FloatBuffer floatBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)floatBuffer, 1);
        }
        GLES31.nglGetTexLevelParameterfv(n2, n3, n4, MemoryUtil.memAddress(floatBuffer));
    }

    public static float glGetTexLevelParameterf(int n2, int n3, int n4) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n5 = memoryStack.getPointer();
        try {
            FloatBuffer floatBuffer = memoryStack.callocFloat(1);
            GLES31.nglGetTexLevelParameterfv(n2, n3, n4, MemoryUtil.memAddress(floatBuffer));
            float f2 = floatBuffer.get(0);
            return f2;
        }
        finally {
            memoryStack.setPointer(n5);
        }
    }

    public static native void glBindVertexBuffer(int var0, int var1, long var2, int var4);

    public static native void glVertexAttribFormat(int var0, int var1, int var2, boolean var3, int var4);

    public static native void glVertexAttribIFormat(int var0, int var1, int var2, int var3);

    public static native void glVertexAttribBinding(int var0, int var1);

    public static native void glVertexBindingDivisor(int var0, int var1);

    public static void glDrawArraysIndirect(int n2, int[] nArray) {
        long l2 = GLES.getICD().glDrawArraysIndirect;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(nArray, 4);
        }
        JNI.callPV(n2, nArray, l2);
    }

    public static void glDrawElementsIndirect(int n2, int n3, int[] nArray) {
        long l2 = GLES.getICD().glDrawElementsIndirect;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(nArray, 5);
        }
        JNI.callPV(n2, n3, nArray, l2);
    }

    public static void glGetFramebufferParameteriv(int n2, int n3, int[] nArray) {
        long l2 = GLES.getICD().glGetFramebufferParameteriv;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(nArray, 1);
        }
        JNI.callPV(n2, n3, nArray, l2);
    }

    public static void glGetProgramInterfaceiv(int n2, int n3, int n4, int[] nArray) {
        long l2 = GLES.getICD().glGetProgramInterfaceiv;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(nArray, 1);
        }
        JNI.callPV(n2, n3, n4, nArray, l2);
    }

    public static void glGetProgramResourceName(int n2, int n3, int n4, int[] nArray, ByteBuffer byteBuffer) {
        long l2 = GLES.getICD().glGetProgramResourceName;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.checkSafe(nArray, 1);
        }
        JNI.callPPV(n2, n3, n4, byteBuffer.remaining(), nArray, MemoryUtil.memAddress(byteBuffer), l2);
    }

    public static void glGetProgramResourceiv(int n2, int n3, int n4, int[] nArray, int[] nArray2, int[] nArray3) {
        long l2 = GLES.getICD().glGetProgramResourceiv;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.checkSafe(nArray2, 1);
        }
        JNI.callPPPV(n2, n3, n4, nArray.length, nArray, nArray3.length, nArray2, nArray3, l2);
    }

    public static void glDeleteProgramPipelines(int[] nArray) {
        long l2 = GLES.getICD().glDeleteProgramPipelines;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(nArray.length, nArray, l2);
    }

    public static void glGenProgramPipelines(int[] nArray) {
        long l2 = GLES.getICD().glGenProgramPipelines;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(nArray.length, nArray, l2);
    }

    public static void glGetProgramPipelineiv(int n2, int n3, int[] nArray) {
        long l2 = GLES.getICD().glGetProgramPipelineiv;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(nArray, 1);
        }
        JNI.callPV(n2, n3, nArray, l2);
    }

    public static void glProgramUniform1iv(int n2, int n3, int[] nArray) {
        long l2 = GLES.getICD().glProgramUniform1iv;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, nArray.length, nArray, l2);
    }

    public static void glProgramUniform2iv(int n2, int n3, int[] nArray) {
        long l2 = GLES.getICD().glProgramUniform2iv;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, nArray.length >> 1, nArray, l2);
    }

    public static void glProgramUniform3iv(int n2, int n3, int[] nArray) {
        long l2 = GLES.getICD().glProgramUniform3iv;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, nArray.length / 3, nArray, l2);
    }

    public static void glProgramUniform4iv(int n2, int n3, int[] nArray) {
        long l2 = GLES.getICD().glProgramUniform4iv;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, nArray.length >> 2, nArray, l2);
    }

    public static void glProgramUniform1uiv(int n2, int n3, int[] nArray) {
        long l2 = GLES.getICD().glProgramUniform1uiv;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, nArray.length, nArray, l2);
    }

    public static void glProgramUniform2uiv(int n2, int n3, int[] nArray) {
        long l2 = GLES.getICD().glProgramUniform2uiv;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, nArray.length >> 1, nArray, l2);
    }

    public static void glProgramUniform3uiv(int n2, int n3, int[] nArray) {
        long l2 = GLES.getICD().glProgramUniform3uiv;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, nArray.length / 3, nArray, l2);
    }

    public static void glProgramUniform4uiv(int n2, int n3, int[] nArray) {
        long l2 = GLES.getICD().glProgramUniform4uiv;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, nArray.length >> 2, nArray, l2);
    }

    public static void glProgramUniform1fv(int n2, int n3, float[] fArray) {
        long l2 = GLES.getICD().glProgramUniform1fv;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, fArray.length, fArray, l2);
    }

    public static void glProgramUniform2fv(int n2, int n3, float[] fArray) {
        long l2 = GLES.getICD().glProgramUniform2fv;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, fArray.length >> 1, fArray, l2);
    }

    public static void glProgramUniform3fv(int n2, int n3, float[] fArray) {
        long l2 = GLES.getICD().glProgramUniform3fv;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, fArray.length / 3, fArray, l2);
    }

    public static void glProgramUniform4fv(int n2, int n3, float[] fArray) {
        long l2 = GLES.getICD().glProgramUniform4fv;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, fArray.length >> 2, fArray, l2);
    }

    public static void glProgramUniformMatrix2fv(int n2, int n3, boolean bl2, float[] fArray) {
        long l2 = GLES.getICD().glProgramUniformMatrix2fv;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, fArray.length >> 2, bl2, fArray, l2);
    }

    public static void glProgramUniformMatrix3fv(int n2, int n3, boolean bl2, float[] fArray) {
        long l2 = GLES.getICD().glProgramUniformMatrix3fv;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, fArray.length / 9, bl2, fArray, l2);
    }

    public static void glProgramUniformMatrix4fv(int n2, int n3, boolean bl2, float[] fArray) {
        long l2 = GLES.getICD().glProgramUniformMatrix4fv;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, fArray.length >> 4, bl2, fArray, l2);
    }

    public static void glProgramUniformMatrix2x3fv(int n2, int n3, boolean bl2, float[] fArray) {
        long l2 = GLES.getICD().glProgramUniformMatrix2x3fv;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, fArray.length / 6, bl2, fArray, l2);
    }

    public static void glProgramUniformMatrix3x2fv(int n2, int n3, boolean bl2, float[] fArray) {
        long l2 = GLES.getICD().glProgramUniformMatrix3x2fv;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, fArray.length / 6, bl2, fArray, l2);
    }

    public static void glProgramUniformMatrix2x4fv(int n2, int n3, boolean bl2, float[] fArray) {
        long l2 = GLES.getICD().glProgramUniformMatrix2x4fv;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, fArray.length >> 3, bl2, fArray, l2);
    }

    public static void glProgramUniformMatrix4x2fv(int n2, int n3, boolean bl2, float[] fArray) {
        long l2 = GLES.getICD().glProgramUniformMatrix4x2fv;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, fArray.length >> 3, bl2, fArray, l2);
    }

    public static void glProgramUniformMatrix3x4fv(int n2, int n3, boolean bl2, float[] fArray) {
        long l2 = GLES.getICD().glProgramUniformMatrix3x4fv;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, fArray.length / 12, bl2, fArray, l2);
    }

    public static void glProgramUniformMatrix4x3fv(int n2, int n3, boolean bl2, float[] fArray) {
        long l2 = GLES.getICD().glProgramUniformMatrix4x3fv;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, fArray.length / 12, bl2, fArray, l2);
    }

    public static void glGetProgramPipelineInfoLog(int n2, int[] nArray, ByteBuffer byteBuffer) {
        long l2 = GLES.getICD().glGetProgramPipelineInfoLog;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.checkSafe(nArray, 1);
        }
        JNI.callPPV(n2, byteBuffer.remaining(), nArray, MemoryUtil.memAddress(byteBuffer), l2);
    }

    public static void glGetMultisamplefv(int n2, int n3, float[] fArray) {
        long l2 = GLES.getICD().glGetMultisamplefv;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(fArray, 1);
        }
        JNI.callPV(n2, n3, fArray, l2);
    }

    public static void glGetTexLevelParameteriv(int n2, int n3, int n4, int[] nArray) {
        long l2 = GLES.getICD().glGetTexLevelParameteriv;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(nArray, 1);
        }
        JNI.callPV(n2, n3, n4, nArray, l2);
    }

    public static void glGetTexLevelParameterfv(int n2, int n3, int n4, float[] fArray) {
        long l2 = GLES.getICD().glGetTexLevelParameterfv;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(fArray, 1);
        }
        JNI.callPV(n2, n3, n4, fArray, l2);
    }

    static {
        GLES.initialize();
    }
}

