/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESChecks;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class GLES20 {
    public static final int GL_DEPTH_BUFFER_BIT = 256;
    public static final int GL_STENCIL_BUFFER_BIT = 1024;
    public static final int GL_COLOR_BUFFER_BIT = 16384;
    public static final int GL_FALSE = 0;
    public static final int GL_TRUE = 1;
    public static final int GL_POINTS = 0;
    public static final int GL_LINES = 1;
    public static final int GL_LINE_LOOP = 2;
    public static final int GL_LINE_STRIP = 3;
    public static final int GL_TRIANGLES = 4;
    public static final int GL_TRIANGLE_STRIP = 5;
    public static final int GL_TRIANGLE_FAN = 6;
    public static final int GL_ZERO = 0;
    public static final int GL_ONE = 1;
    public static final int GL_SRC_COLOR = 768;
    public static final int GL_ONE_MINUS_SRC_COLOR = 769;
    public static final int GL_SRC_ALPHA = 770;
    public static final int GL_ONE_MINUS_SRC_ALPHA = 771;
    public static final int GL_DST_ALPHA = 772;
    public static final int GL_ONE_MINUS_DST_ALPHA = 773;
    public static final int GL_DST_COLOR = 774;
    public static final int GL_ONE_MINUS_DST_COLOR = 775;
    public static final int GL_SRC_ALPHA_SATURATE = 776;
    public static final int GL_FUNC_ADD = 32774;
    public static final int GL_BLEND_EQUATION = 32777;
    public static final int GL_BLEND_EQUATION_RGB = 32777;
    public static final int GL_BLEND_EQUATION_ALPHA = 34877;
    public static final int GL_FUNC_SUBTRACT = 32778;
    public static final int GL_FUNC_REVERSE_SUBTRACT = 32779;
    public static final int GL_BLEND_DST_RGB = 32968;
    public static final int GL_BLEND_SRC_RGB = 32969;
    public static final int GL_BLEND_DST_ALPHA = 32970;
    public static final int GL_BLEND_SRC_ALPHA = 32971;
    public static final int GL_CONSTANT_COLOR = 32769;
    public static final int GL_ONE_MINUS_CONSTANT_COLOR = 32770;
    public static final int GL_CONSTANT_ALPHA = 32771;
    public static final int GL_ONE_MINUS_CONSTANT_ALPHA = 32772;
    public static final int GL_BLEND_COLOR = 32773;
    public static final int GL_ARRAY_BUFFER = 34962;
    public static final int GL_ELEMENT_ARRAY_BUFFER = 34963;
    public static final int GL_ARRAY_BUFFER_BINDING = 34964;
    public static final int GL_ELEMENT_ARRAY_BUFFER_BINDING = 34965;
    public static final int GL_STREAM_DRAW = 35040;
    public static final int GL_STATIC_DRAW = 35044;
    public static final int GL_DYNAMIC_DRAW = 35048;
    public static final int GL_BUFFER_SIZE = 34660;
    public static final int GL_BUFFER_USAGE = 34661;
    public static final int GL_CURRENT_VERTEX_ATTRIB = 34342;
    public static final int GL_FRONT = 1028;
    public static final int GL_BACK = 1029;
    public static final int GL_FRONT_AND_BACK = 1032;
    public static final int GL_TEXTURE_2D = 3553;
    public static final int GL_CULL_FACE = 2884;
    public static final int GL_BLEND = 3042;
    public static final int GL_DITHER = 3024;
    public static final int GL_STENCIL_TEST = 2960;
    public static final int GL_DEPTH_TEST = 2929;
    public static final int GL_SCISSOR_TEST = 3089;
    public static final int GL_POLYGON_OFFSET_FILL = 32823;
    public static final int GL_SAMPLE_ALPHA_TO_COVERAGE = 32926;
    public static final int GL_SAMPLE_COVERAGE = 32928;
    public static final int GL_NO_ERROR = 0;
    public static final int GL_INVALID_ENUM = 1280;
    public static final int GL_INVALID_VALUE = 1281;
    public static final int GL_INVALID_OPERATION = 1282;
    public static final int GL_OUT_OF_MEMORY = 1285;
    public static final int GL_CW = 2304;
    public static final int GL_CCW = 2305;
    public static final int GL_LINE_WIDTH = 2849;
    public static final int GL_ALIASED_POINT_SIZE_RANGE = 33901;
    public static final int GL_ALIASED_LINE_WIDTH_RANGE = 33902;
    public static final int GL_CULL_FACE_MODE = 2885;
    public static final int GL_FRONT_FACE = 2886;
    public static final int GL_DEPTH_RANGE = 2928;
    public static final int GL_DEPTH_WRITEMASK = 2930;
    public static final int GL_DEPTH_CLEAR_VALUE = 2931;
    public static final int GL_DEPTH_FUNC = 2932;
    public static final int GL_STENCIL_CLEAR_VALUE = 2961;
    public static final int GL_STENCIL_FUNC = 2962;
    public static final int GL_STENCIL_FAIL = 2964;
    public static final int GL_STENCIL_PASS_DEPTH_FAIL = 2965;
    public static final int GL_STENCIL_PASS_DEPTH_PASS = 2966;
    public static final int GL_STENCIL_REF = 2967;
    public static final int GL_STENCIL_VALUE_MASK = 2963;
    public static final int GL_STENCIL_WRITEMASK = 2968;
    public static final int GL_STENCIL_BACK_FUNC = 34816;
    public static final int GL_STENCIL_BACK_FAIL = 34817;
    public static final int GL_STENCIL_BACK_PASS_DEPTH_FAIL = 34818;
    public static final int GL_STENCIL_BACK_PASS_DEPTH_PASS = 34819;
    public static final int GL_STENCIL_BACK_REF = 36003;
    public static final int GL_STENCIL_BACK_VALUE_MASK = 36004;
    public static final int GL_STENCIL_BACK_WRITEMASK = 36005;
    public static final int GL_VIEWPORT = 2978;
    public static final int GL_SCISSOR_BOX = 3088;
    public static final int GL_COLOR_CLEAR_VALUE = 3106;
    public static final int GL_COLOR_WRITEMASK = 3107;
    public static final int GL_UNPACK_ALIGNMENT = 3317;
    public static final int GL_PACK_ALIGNMENT = 3333;
    public static final int GL_MAX_TEXTURE_SIZE = 3379;
    public static final int GL_MAX_VIEWPORT_DIMS = 3386;
    public static final int GL_SUBPIXEL_BITS = 3408;
    public static final int GL_RED_BITS = 3410;
    public static final int GL_GREEN_BITS = 3411;
    public static final int GL_BLUE_BITS = 3412;
    public static final int GL_ALPHA_BITS = 3413;
    public static final int GL_DEPTH_BITS = 3414;
    public static final int GL_STENCIL_BITS = 3415;
    public static final int GL_POLYGON_OFFSET_UNITS = 10752;
    public static final int GL_POLYGON_OFFSET_FACTOR = 32824;
    public static final int GL_TEXTURE_BINDING_2D = 32873;
    public static final int GL_SAMPLE_BUFFERS = 32936;
    public static final int GL_SAMPLES = 32937;
    public static final int GL_SAMPLE_COVERAGE_VALUE = 32938;
    public static final int GL_SAMPLE_COVERAGE_INVERT = 32939;
    public static final int GL_NUM_COMPRESSED_TEXTURE_FORMATS = 34466;
    public static final int GL_COMPRESSED_TEXTURE_FORMATS = 34467;
    public static final int GL_DONT_CARE = 4352;
    public static final int GL_FASTEST = 4353;
    public static final int GL_NICEST = 4354;
    public static final int GL_GENERATE_MIPMAP_HINT = 33170;
    public static final int GL_BYTE = 5120;
    public static final int GL_UNSIGNED_BYTE = 5121;
    public static final int GL_SHORT = 5122;
    public static final int GL_UNSIGNED_SHORT = 5123;
    public static final int GL_INT = 5124;
    public static final int GL_UNSIGNED_INT = 5125;
    public static final int GL_FLOAT = 5126;
    public static final int GL_FIXED = 5132;
    public static final int GL_DEPTH_COMPONENT = 6402;
    public static final int GL_ALPHA = 6406;
    public static final int GL_RGB = 6407;
    public static final int GL_RGBA = 6408;
    public static final int GL_LUMINANCE = 6409;
    public static final int GL_LUMINANCE_ALPHA = 6410;
    public static final int GL_UNSIGNED_SHORT_4_4_4_4 = 32819;
    public static final int GL_UNSIGNED_SHORT_5_5_5_1 = 32820;
    public static final int GL_UNSIGNED_SHORT_5_6_5 = 33635;
    public static final int GL_FRAGMENT_SHADER = 35632;
    public static final int GL_VERTEX_SHADER = 35633;
    public static final int GL_MAX_VERTEX_ATTRIBS = 34921;
    public static final int GL_MAX_VERTEX_UNIFORM_VECTORS = 36347;
    public static final int GL_MAX_VARYING_VECTORS = 36348;
    public static final int GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS = 35661;
    public static final int GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS = 35660;
    public static final int GL_MAX_TEXTURE_IMAGE_UNITS = 34930;
    public static final int GL_MAX_FRAGMENT_UNIFORM_VECTORS = 36349;
    public static final int GL_SHADER_TYPE = 35663;
    public static final int GL_DELETE_STATUS = 35712;
    public static final int GL_LINK_STATUS = 35714;
    public static final int GL_VALIDATE_STATUS = 35715;
    public static final int GL_ATTACHED_SHADERS = 35717;
    public static final int GL_ACTIVE_UNIFORMS = 35718;
    public static final int GL_ACTIVE_UNIFORM_MAX_LENGTH = 35719;
    public static final int GL_ACTIVE_ATTRIBUTES = 35721;
    public static final int GL_ACTIVE_ATTRIBUTE_MAX_LENGTH = 35722;
    public static final int GL_SHADING_LANGUAGE_VERSION = 35724;
    public static final int GL_CURRENT_PROGRAM = 35725;
    public static final int GL_NEVER = 512;
    public static final int GL_LESS = 513;
    public static final int GL_EQUAL = 514;
    public static final int GL_LEQUAL = 515;
    public static final int GL_GREATER = 516;
    public static final int GL_NOTEQUAL = 517;
    public static final int GL_GEQUAL = 518;
    public static final int GL_ALWAYS = 519;
    public static final int GL_KEEP = 7680;
    public static final int GL_REPLACE = 7681;
    public static final int GL_INCR = 7682;
    public static final int GL_DECR = 7683;
    public static final int GL_INVERT = 5386;
    public static final int GL_INCR_WRAP = 34055;
    public static final int GL_DECR_WRAP = 34056;
    public static final int GL_VENDOR = 7936;
    public static final int GL_RENDERER = 7937;
    public static final int GL_VERSION = 7938;
    public static final int GL_EXTENSIONS = 7939;
    public static final int GL_NEAREST = 9728;
    public static final int GL_LINEAR = 9729;
    public static final int GL_NEAREST_MIPMAP_NEAREST = 9984;
    public static final int GL_LINEAR_MIPMAP_NEAREST = 9985;
    public static final int GL_NEAREST_MIPMAP_LINEAR = 9986;
    public static final int GL_LINEAR_MIPMAP_LINEAR = 9987;
    public static final int GL_TEXTURE_MAG_FILTER = 10240;
    public static final int GL_TEXTURE_MIN_FILTER = 10241;
    public static final int GL_TEXTURE_WRAP_S = 10242;
    public static final int GL_TEXTURE_WRAP_T = 10243;
    public static final int GL_TEXTURE = 5890;
    public static final int GL_TEXTURE_CUBE_MAP = 34067;
    public static final int GL_TEXTURE_BINDING_CUBE_MAP = 34068;
    public static final int GL_TEXTURE_CUBE_MAP_POSITIVE_X = 34069;
    public static final int GL_TEXTURE_CUBE_MAP_NEGATIVE_X = 34070;
    public static final int GL_TEXTURE_CUBE_MAP_POSITIVE_Y = 34071;
    public static final int GL_TEXTURE_CUBE_MAP_NEGATIVE_Y = 34072;
    public static final int GL_TEXTURE_CUBE_MAP_POSITIVE_Z = 34073;
    public static final int GL_TEXTURE_CUBE_MAP_NEGATIVE_Z = 34074;
    public static final int GL_MAX_CUBE_MAP_TEXTURE_SIZE = 34076;
    public static final int GL_TEXTURE0 = 33984;
    public static final int GL_TEXTURE1 = 33985;
    public static final int GL_TEXTURE2 = 33986;
    public static final int GL_TEXTURE3 = 33987;
    public static final int GL_TEXTURE4 = 33988;
    public static final int GL_TEXTURE5 = 33989;
    public static final int GL_TEXTURE6 = 33990;
    public static final int GL_TEXTURE7 = 33991;
    public static final int GL_TEXTURE8 = 33992;
    public static final int GL_TEXTURE9 = 33993;
    public static final int GL_TEXTURE10 = 33994;
    public static final int GL_TEXTURE11 = 33995;
    public static final int GL_TEXTURE12 = 33996;
    public static final int GL_TEXTURE13 = 33997;
    public static final int GL_TEXTURE14 = 33998;
    public static final int GL_TEXTURE15 = 33999;
    public static final int GL_TEXTURE16 = 34000;
    public static final int GL_TEXTURE17 = 34001;
    public static final int GL_TEXTURE18 = 34002;
    public static final int GL_TEXTURE19 = 34003;
    public static final int GL_TEXTURE20 = 34004;
    public static final int GL_TEXTURE21 = 34005;
    public static final int GL_TEXTURE22 = 34006;
    public static final int GL_TEXTURE23 = 34007;
    public static final int GL_TEXTURE24 = 34008;
    public static final int GL_TEXTURE25 = 34009;
    public static final int GL_TEXTURE26 = 34010;
    public static final int GL_TEXTURE27 = 34011;
    public static final int GL_TEXTURE28 = 34012;
    public static final int GL_TEXTURE29 = 34013;
    public static final int GL_TEXTURE30 = 34014;
    public static final int GL_TEXTURE31 = 34015;
    public static final int GL_ACTIVE_TEXTURE = 34016;
    public static final int GL_REPEAT = 10497;
    public static final int GL_CLAMP_TO_EDGE = 33071;
    public static final int GL_MIRRORED_REPEAT = 33648;
    public static final int GL_FLOAT_VEC2 = 35664;
    public static final int GL_FLOAT_VEC3 = 35665;
    public static final int GL_FLOAT_VEC4 = 35666;
    public static final int GL_INT_VEC2 = 35667;
    public static final int GL_INT_VEC3 = 35668;
    public static final int GL_INT_VEC4 = 35669;
    public static final int GL_BOOL = 35670;
    public static final int GL_BOOL_VEC2 = 35671;
    public static final int GL_BOOL_VEC3 = 35672;
    public static final int GL_BOOL_VEC4 = 35673;
    public static final int GL_FLOAT_MAT2 = 35674;
    public static final int GL_FLOAT_MAT3 = 35675;
    public static final int GL_FLOAT_MAT4 = 35676;
    public static final int GL_SAMPLER_2D = 35678;
    public static final int GL_SAMPLER_CUBE = 35680;
    public static final int GL_VERTEX_ATTRIB_ARRAY_ENABLED = 34338;
    public static final int GL_VERTEX_ATTRIB_ARRAY_SIZE = 34339;
    public static final int GL_VERTEX_ATTRIB_ARRAY_STRIDE = 34340;
    public static final int GL_VERTEX_ATTRIB_ARRAY_TYPE = 34341;
    public static final int GL_VERTEX_ATTRIB_ARRAY_NORMALIZED = 34922;
    public static final int GL_VERTEX_ATTRIB_ARRAY_POINTER = 34373;
    public static final int GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING = 34975;
    public static final int GL_IMPLEMENTATION_COLOR_READ_TYPE = 35738;
    public static final int GL_IMPLEMENTATION_COLOR_READ_FORMAT = 35739;
    public static final int GL_COMPILE_STATUS = 35713;
    public static final int GL_INFO_LOG_LENGTH = 35716;
    public static final int GL_SHADER_SOURCE_LENGTH = 35720;
    public static final int GL_SHADER_COMPILER = 36346;
    public static final int GL_SHADER_BINARY_FORMATS = 36344;
    public static final int GL_NUM_SHADER_BINARY_FORMATS = 36345;
    public static final int GL_LOW_FLOAT = 36336;
    public static final int GL_MEDIUM_FLOAT = 36337;
    public static final int GL_HIGH_FLOAT = 36338;
    public static final int GL_LOW_INT = 36339;
    public static final int GL_MEDIUM_INT = 36340;
    public static final int GL_HIGH_INT = 36341;
    public static final int GL_FRAMEBUFFER = 36160;
    public static final int GL_RENDERBUFFER = 36161;
    public static final int GL_RGBA4 = 32854;
    public static final int GL_RGB5_A1 = 32855;
    public static final int GL_RGB565 = 36194;
    public static final int GL_DEPTH_COMPONENT16 = 33189;
    public static final int GL_STENCIL_INDEX8 = 36168;
    public static final int GL_RENDERBUFFER_WIDTH = 36162;
    public static final int GL_RENDERBUFFER_HEIGHT = 36163;
    public static final int GL_RENDERBUFFER_INTERNAL_FORMAT = 36164;
    public static final int GL_RENDERBUFFER_RED_SIZE = 36176;
    public static final int GL_RENDERBUFFER_GREEN_SIZE = 36177;
    public static final int GL_RENDERBUFFER_BLUE_SIZE = 36178;
    public static final int GL_RENDERBUFFER_ALPHA_SIZE = 36179;
    public static final int GL_RENDERBUFFER_DEPTH_SIZE = 36180;
    public static final int GL_RENDERBUFFER_STENCIL_SIZE = 36181;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE = 36048;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME = 36049;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL = 36050;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE = 36051;
    public static final int GL_COLOR_ATTACHMENT0 = 36064;
    public static final int GL_DEPTH_ATTACHMENT = 36096;
    public static final int GL_STENCIL_ATTACHMENT = 36128;
    public static final int GL_NONE = 0;
    public static final int GL_FRAMEBUFFER_COMPLETE = 36053;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT = 36054;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 36055;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS = 36057;
    public static final int GL_FRAMEBUFFER_UNSUPPORTED = 36061;
    public static final int GL_FRAMEBUFFER_BINDING = 36006;
    public static final int GL_RENDERBUFFER_BINDING = 36007;
    public static final int GL_MAX_RENDERBUFFER_SIZE = 34024;
    public static final int GL_INVALID_FRAMEBUFFER_OPERATION = 1286;

    protected GLES20() {
        throw new UnsupportedOperationException();
    }

    public static native void glActiveTexture(int var0);

    public static native void glAttachShader(int var0, int var1);

    public static native void nglBindAttribLocation(int var0, int var1, long var2);

    public static void glBindAttribLocation(int n2, int n3, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        GLES20.nglBindAttribLocation(n2, n3, MemoryUtil.memAddress(byteBuffer));
    }

    public static void glBindAttribLocation(int n2, int n3, CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            memoryStack.nASCII(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            GLES20.nglBindAttribLocation(n2, n3, l2);
            return;
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static native void glBindBuffer(int var0, int var1);

    public static native void glBindFramebuffer(int var0, int var1);

    public static native void glBindRenderbuffer(int var0, int var1);

    public static native void glBindTexture(int var0, int var1);

    public static native void glBlendColor(float var0, float var1, float var2, float var3);

    public static native void glBlendEquation(int var0);

    public static native void glBlendEquationSeparate(int var0, int var1);

    public static native void glBlendFunc(int var0, int var1);

    public static native void glBlendFuncSeparate(int var0, int var1, int var2, int var3);

    public static native void nglBufferData(int var0, long var1, long var3, int var5);

    public static void glBufferData(int n2, long l2, int n3) {
        GLES20.nglBufferData(n2, l2, 0L, n3);
    }

    public static void glBufferData(int n2, ByteBuffer byteBuffer, int n3) {
        GLES20.nglBufferData(n2, byteBuffer.remaining(), MemoryUtil.memAddress(byteBuffer), n3);
    }

    public static void glBufferData(int n2, ShortBuffer shortBuffer, int n3) {
        GLES20.nglBufferData(n2, Integer.toUnsignedLong(shortBuffer.remaining()) << 1, MemoryUtil.memAddress(shortBuffer), n3);
    }

    public static void glBufferData(int n2, IntBuffer intBuffer, int n3) {
        GLES20.nglBufferData(n2, Integer.toUnsignedLong(intBuffer.remaining()) << 2, MemoryUtil.memAddress(intBuffer), n3);
    }

    public static void glBufferData(int n2, FloatBuffer floatBuffer, int n3) {
        GLES20.nglBufferData(n2, Integer.toUnsignedLong(floatBuffer.remaining()) << 2, MemoryUtil.memAddress(floatBuffer), n3);
    }

    public static native void nglBufferSubData(int var0, long var1, long var3, long var5);

    public static void glBufferSubData(int n2, long l2, ByteBuffer byteBuffer) {
        GLES20.nglBufferSubData(n2, l2, byteBuffer.remaining(), MemoryUtil.memAddress(byteBuffer));
    }

    public static void glBufferSubData(int n2, long l2, ShortBuffer shortBuffer) {
        GLES20.nglBufferSubData(n2, l2, Integer.toUnsignedLong(shortBuffer.remaining()) << 1, MemoryUtil.memAddress(shortBuffer));
    }

    public static void glBufferSubData(int n2, long l2, IntBuffer intBuffer) {
        GLES20.nglBufferSubData(n2, l2, Integer.toUnsignedLong(intBuffer.remaining()) << 2, MemoryUtil.memAddress(intBuffer));
    }

    public static void glBufferSubData(int n2, long l2, FloatBuffer floatBuffer) {
        GLES20.nglBufferSubData(n2, l2, Integer.toUnsignedLong(floatBuffer.remaining()) << 2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native int glCheckFramebufferStatus(int var0);

    public static native void glClear(int var0);

    public static native void glClearColor(float var0, float var1, float var2, float var3);

    public static native void glClearDepthf(float var0);

    public static native void glClearStencil(int var0);

    public static native void glColorMask(boolean var0, boolean var1, boolean var2, boolean var3);

    public static native void glCompileShader(int var0);

    public static native void nglCompressedTexImage2D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7);

    public static void glCompressedTexImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, long l2) {
        GLES20.nglCompressedTexImage2D(n2, n3, n4, n5, n6, n7, n8, l2);
    }

    public static void glCompressedTexImage2D(int n2, int n3, int n4, int n5, int n6, int n7, ByteBuffer byteBuffer) {
        GLES20.nglCompressedTexImage2D(n2, n3, n4, n5, n6, n7, Checks.remainingSafe(byteBuffer), MemoryUtil.memAddressSafe(byteBuffer));
    }

    public static native void nglCompressedTexSubImage2D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8);

    public static void glCompressedTexSubImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, long l2) {
        GLES20.nglCompressedTexSubImage2D(n2, n3, n4, n5, n6, n7, n8, n9, l2);
    }

    public static void glCompressedTexSubImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, ByteBuffer byteBuffer) {
        GLES20.nglCompressedTexSubImage2D(n2, n3, n4, n5, n6, n7, n8, byteBuffer.remaining(), MemoryUtil.memAddress(byteBuffer));
    }

    public static native void glCopyTexImage2D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public static native void glCopyTexSubImage2D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public static native int glCreateProgram();

    public static native int glCreateShader(int var0);

    public static native void glCullFace(int var0);

    public static native void nglDeleteBuffers(int var0, long var1);

    public static void glDeleteBuffers(IntBuffer intBuffer) {
        GLES20.nglDeleteBuffers(intBuffer.remaining(), MemoryUtil.memAddress(intBuffer));
    }

    public static void glDeleteBuffers(int n2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.ints(n2);
            GLES20.nglDeleteBuffers(1, MemoryUtil.memAddress(intBuffer));
            return;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native void nglDeleteFramebuffers(int var0, long var1);

    public static void glDeleteFramebuffers(IntBuffer intBuffer) {
        GLES20.nglDeleteFramebuffers(intBuffer.remaining(), MemoryUtil.memAddress(intBuffer));
    }

    public static void glDeleteFramebuffers(int n2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.ints(n2);
            GLES20.nglDeleteFramebuffers(1, MemoryUtil.memAddress(intBuffer));
            return;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native void glDeleteProgram(int var0);

    public static native void nglDeleteRenderbuffers(int var0, long var1);

    public static void glDeleteRenderbuffers(IntBuffer intBuffer) {
        GLES20.nglDeleteRenderbuffers(intBuffer.remaining(), MemoryUtil.memAddress(intBuffer));
    }

    public static void glDeleteRenderbuffers(int n2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.ints(n2);
            GLES20.nglDeleteRenderbuffers(1, MemoryUtil.memAddress(intBuffer));
            return;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native void glDeleteShader(int var0);

    public static native void nglDeleteTextures(int var0, long var1);

    public static void glDeleteTextures(IntBuffer intBuffer) {
        GLES20.nglDeleteTextures(intBuffer.remaining(), MemoryUtil.memAddress(intBuffer));
    }

    public static void glDeleteTextures(int n2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.ints(n2);
            GLES20.nglDeleteTextures(1, MemoryUtil.memAddress(intBuffer));
            return;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native void glDepthFunc(int var0);

    public static native void glDepthMask(boolean var0);

    public static native void glDepthRangef(float var0, float var1);

    public static native void glDetachShader(int var0, int var1);

    public static native void glDisable(int var0);

    public static native void glDisableVertexAttribArray(int var0);

    public static native void glDrawArrays(int var0, int var1, int var2);

    public static native void nglDrawElements(int var0, int var1, int var2, long var3);

    public static void glDrawElements(int n2, int n3, int n4, long l2) {
        GLES20.nglDrawElements(n2, n3, n4, l2);
    }

    public static void glDrawElements(int n2, int n3, ByteBuffer byteBuffer) {
        GLES20.nglDrawElements(n2, byteBuffer.remaining() >> GLESChecks.typeToByteShift(n3), n3, MemoryUtil.memAddress(byteBuffer));
    }

    public static void glDrawElements(int n2, ByteBuffer byteBuffer) {
        GLES20.nglDrawElements(n2, byteBuffer.remaining(), 5121, MemoryUtil.memAddress(byteBuffer));
    }

    public static void glDrawElements(int n2, ShortBuffer shortBuffer) {
        GLES20.nglDrawElements(n2, shortBuffer.remaining(), 5123, MemoryUtil.memAddress(shortBuffer));
    }

    public static void glDrawElements(int n2, IntBuffer intBuffer) {
        GLES20.nglDrawElements(n2, intBuffer.remaining(), 5125, MemoryUtil.memAddress(intBuffer));
    }

    public static native void glEnable(int var0);

    public static native void glEnableVertexAttribArray(int var0);

    public static native void glFinish();

    public static native void glFlush();

    public static native void glFramebufferRenderbuffer(int var0, int var1, int var2, int var3);

    public static native void glFramebufferTexture2D(int var0, int var1, int var2, int var3, int var4);

    public static native void glFrontFace(int var0);

    public static native void nglGenBuffers(int var0, long var1);

    public static void glGenBuffers(IntBuffer intBuffer) {
        GLES20.nglGenBuffers(intBuffer.remaining(), MemoryUtil.memAddress(intBuffer));
    }

    public static int glGenBuffers() {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.callocInt(1);
            GLES20.nglGenBuffers(1, MemoryUtil.memAddress(intBuffer));
            int n3 = intBuffer.get(0);
            return n3;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static native void glGenerateMipmap(int var0);

    public static native void nglGenFramebuffers(int var0, long var1);

    public static void glGenFramebuffers(IntBuffer intBuffer) {
        GLES20.nglGenFramebuffers(intBuffer.remaining(), MemoryUtil.memAddress(intBuffer));
    }

    public static int glGenFramebuffers() {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.callocInt(1);
            GLES20.nglGenFramebuffers(1, MemoryUtil.memAddress(intBuffer));
            int n3 = intBuffer.get(0);
            return n3;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static native void nglGenRenderbuffers(int var0, long var1);

    public static void glGenRenderbuffers(IntBuffer intBuffer) {
        GLES20.nglGenRenderbuffers(intBuffer.remaining(), MemoryUtil.memAddress(intBuffer));
    }

    public static int glGenRenderbuffers() {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.callocInt(1);
            GLES20.nglGenRenderbuffers(1, MemoryUtil.memAddress(intBuffer));
            int n3 = intBuffer.get(0);
            return n3;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static native void nglGenTextures(int var0, long var1);

    public static void glGenTextures(IntBuffer intBuffer) {
        GLES20.nglGenTextures(intBuffer.remaining(), MemoryUtil.memAddress(intBuffer));
    }

    public static int glGenTextures() {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.callocInt(1);
            GLES20.nglGenTextures(1, MemoryUtil.memAddress(intBuffer));
            int n3 = intBuffer.get(0);
            return n3;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static native void nglGetActiveAttrib(int var0, int var1, int var2, long var3, long var5, long var7, long var9);

    public static void glGetActiveAttrib(int n2, int n3, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer, 1);
            Checks.check((Buffer)intBuffer2, 1);
            Checks.check((Buffer)intBuffer3, 1);
        }
        GLES20.nglGetActiveAttrib(n2, n3, byteBuffer.remaining(), MemoryUtil.memAddressSafe(intBuffer), MemoryUtil.memAddress(intBuffer2), MemoryUtil.memAddress(intBuffer3), MemoryUtil.memAddress(byteBuffer));
    }

    public static String glGetActiveAttrib(int n2, int n3, int n4, IntBuffer intBuffer, IntBuffer intBuffer2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
            Checks.check((Buffer)intBuffer2, 1);
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n5 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer3 = memoryStack.ints(0);
            ByteBuffer byteBuffer = memoryStack.malloc(n4);
            GLES20.nglGetActiveAttrib(n2, n3, n4, MemoryUtil.memAddress(intBuffer3), MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(intBuffer2), MemoryUtil.memAddress(byteBuffer));
            String string = MemoryUtil.memASCII(byteBuffer, intBuffer3.get(0));
            return string;
        }
        finally {
            memoryStack.setPointer(n5);
        }
    }

    public static String glGetActiveAttrib(int n2, int n3, IntBuffer intBuffer, IntBuffer intBuffer2) {
        return GLES20.glGetActiveAttrib(n2, n3, GLES20.glGetProgrami(n2, 35722), intBuffer, intBuffer2);
    }

    public static native void nglGetActiveUniform(int var0, int var1, int var2, long var3, long var5, long var7, long var9);

    public static void glGetActiveUniform(int n2, int n3, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer, 1);
            Checks.check((Buffer)intBuffer2, 1);
            Checks.check((Buffer)intBuffer3, 1);
        }
        GLES20.nglGetActiveUniform(n2, n3, byteBuffer.remaining(), MemoryUtil.memAddressSafe(intBuffer), MemoryUtil.memAddress(intBuffer2), MemoryUtil.memAddress(intBuffer3), MemoryUtil.memAddress(byteBuffer));
    }

    public static String glGetActiveUniform(int n2, int n3, int n4, IntBuffer intBuffer, IntBuffer intBuffer2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
            Checks.check((Buffer)intBuffer2, 1);
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n5 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer3 = memoryStack.ints(0);
            ByteBuffer byteBuffer = memoryStack.malloc(n4);
            GLES20.nglGetActiveUniform(n2, n3, n4, MemoryUtil.memAddress(intBuffer3), MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(intBuffer2), MemoryUtil.memAddress(byteBuffer));
            String string = MemoryUtil.memASCII(byteBuffer, intBuffer3.get(0));
            return string;
        }
        finally {
            memoryStack.setPointer(n5);
        }
    }

    public static String glGetActiveUniform(int n2, int n3, IntBuffer intBuffer, IntBuffer intBuffer2) {
        return GLES20.glGetActiveUniform(n2, n3, GLES20.glGetProgrami(n2, 35719), intBuffer, intBuffer2);
    }

    public static native void nglGetAttachedShaders(int var0, int var1, long var2, long var4);

    public static void glGetAttachedShaders(int n2, IntBuffer intBuffer, IntBuffer intBuffer2) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer, 1);
        }
        GLES20.nglGetAttachedShaders(n2, intBuffer2.remaining(), MemoryUtil.memAddressSafe(intBuffer), MemoryUtil.memAddress(intBuffer2));
    }

    public static native int nglGetAttribLocation(int var0, long var1);

    public static int glGetAttribLocation(int n2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return GLES20.nglGetAttribLocation(n2, MemoryUtil.memAddress(byteBuffer));
    }

    public static int glGetAttribLocation(int n2, CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            memoryStack.nASCII(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            n2 = GLES20.nglGetAttribLocation(n2, l2);
            return n2;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native void nglGetBooleanv(int var0, long var1);

    public static void glGetBooleanv(int n2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)byteBuffer, 1);
        }
        GLES20.nglGetBooleanv(n2, MemoryUtil.memAddress(byteBuffer));
    }

    public static boolean glGetBoolean(int n2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            ByteBuffer byteBuffer = memoryStack.calloc(1);
            GLES20.nglGetBooleanv(n2, MemoryUtil.memAddress(byteBuffer));
            n2 = byteBuffer.get(0) != 0 ? 1 : 0;
            return n2 != 0;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native void nglGetBufferParameteriv(int var0, int var1, long var2);

    public static void glGetBufferParameteriv(int n2, int n3, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
        }
        GLES20.nglGetBufferParameteriv(n2, n3, MemoryUtil.memAddress(intBuffer));
    }

    public static int glGetBufferParameteri(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.callocInt(1);
            GLES20.nglGetBufferParameteriv(n2, n3, MemoryUtil.memAddress(intBuffer));
            n2 = intBuffer.get(0);
            return n2;
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static native int glGetError();

    public static native void nglGetFloatv(int var0, long var1);

    public static void glGetFloatv(int n2, FloatBuffer floatBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)floatBuffer, 1);
        }
        GLES20.nglGetFloatv(n2, MemoryUtil.memAddress(floatBuffer));
    }

    public static float glGetFloat(int n2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            FloatBuffer floatBuffer = memoryStack.callocFloat(1);
            GLES20.nglGetFloatv(n2, MemoryUtil.memAddress(floatBuffer));
            float f2 = floatBuffer.get(0);
            return f2;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native void nglGetFramebufferAttachmentParameteriv(int var0, int var1, int var2, long var3);

    public static void glGetFramebufferAttachmentParameteriv(int n2, int n3, int n4, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
        }
        GLES20.nglGetFramebufferAttachmentParameteriv(n2, n3, n4, MemoryUtil.memAddress(intBuffer));
    }

    public static int glGetFramebufferAttachmentParameteri(int n2, int n3, int n4) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n5 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.callocInt(1);
            GLES20.nglGetFramebufferAttachmentParameteriv(n2, n3, n4, MemoryUtil.memAddress(intBuffer));
            n2 = intBuffer.get(0);
            return n2;
        }
        finally {
            memoryStack.setPointer(n5);
        }
    }

    public static native void nglGetIntegerv(int var0, long var1);

    public static void glGetIntegerv(int n2, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
        }
        GLES20.nglGetIntegerv(n2, MemoryUtil.memAddress(intBuffer));
    }

    public static int glGetInteger(int n2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.callocInt(1);
            GLES20.nglGetIntegerv(n2, MemoryUtil.memAddress(intBuffer));
            n2 = intBuffer.get(0);
            return n2;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native void nglGetProgramiv(int var0, int var1, long var2);

    public static void glGetProgramiv(int n2, int n3, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
        }
        GLES20.nglGetProgramiv(n2, n3, MemoryUtil.memAddress(intBuffer));
    }

    public static int glGetProgrami(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.callocInt(1);
            GLES20.nglGetProgramiv(n2, n3, MemoryUtil.memAddress(intBuffer));
            n2 = intBuffer.get(0);
            return n2;
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static native void nglGetProgramInfoLog(int var0, int var1, long var2, long var4);

    public static void glGetProgramInfoLog(int n2, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer, 1);
        }
        GLES20.nglGetProgramInfoLog(n2, byteBuffer.remaining(), MemoryUtil.memAddressSafe(intBuffer), MemoryUtil.memAddress(byteBuffer));
    }

    public static String glGetProgramInfoLog(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        ByteBuffer byteBuffer = MemoryUtil.memAlloc(n3);
        try {
            IntBuffer intBuffer = memoryStack.ints(0);
            GLES20.nglGetProgramInfoLog(n2, n3, MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(byteBuffer));
            String string = MemoryUtil.memUTF8(byteBuffer, intBuffer.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree(byteBuffer);
            memoryStack.setPointer(n4);
        }
    }

    public static String glGetProgramInfoLog(int n2) {
        int n3 = n2;
        return GLES20.glGetProgramInfoLog(n3, GLES20.glGetProgrami(n3, 35716));
    }

    public static native void nglGetRenderbufferParameteriv(int var0, int var1, long var2);

    public static void glGetRenderbufferParameteriv(int n2, int n3, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
        }
        GLES20.nglGetRenderbufferParameteriv(n2, n3, MemoryUtil.memAddress(intBuffer));
    }

    public static int glGetRenderbufferParameteri(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.callocInt(1);
            GLES20.nglGetRenderbufferParameteriv(n2, n3, MemoryUtil.memAddress(intBuffer));
            n2 = intBuffer.get(0);
            return n2;
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static native void nglGetShaderiv(int var0, int var1, long var2);

    public static void glGetShaderiv(int n2, int n3, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
        }
        GLES20.nglGetShaderiv(n2, n3, MemoryUtil.memAddress(intBuffer));
    }

    public static int glGetShaderi(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.callocInt(1);
            GLES20.nglGetShaderiv(n2, n3, MemoryUtil.memAddress(intBuffer));
            n2 = intBuffer.get(0);
            return n2;
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static native void nglGetShaderInfoLog(int var0, int var1, long var2, long var4);

    public static void glGetShaderInfoLog(int n2, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer, 1);
        }
        GLES20.nglGetShaderInfoLog(n2, byteBuffer.remaining(), MemoryUtil.memAddressSafe(intBuffer), MemoryUtil.memAddress(byteBuffer));
    }

    public static String glGetShaderInfoLog(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        ByteBuffer byteBuffer = MemoryUtil.memAlloc(n3);
        try {
            IntBuffer intBuffer = memoryStack.ints(0);
            GLES20.nglGetShaderInfoLog(n2, n3, MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(byteBuffer));
            String string = MemoryUtil.memUTF8(byteBuffer, intBuffer.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree(byteBuffer);
            memoryStack.setPointer(n4);
        }
    }

    public static String glGetShaderInfoLog(int n2) {
        int n3 = n2;
        return GLES20.glGetShaderInfoLog(n3, GLES20.glGetShaderi(n3, 35716));
    }

    public static native void nglGetShaderPrecisionFormat(int var0, int var1, long var2, long var4);

    public static void glGetShaderPrecisionFormat(int n2, int n3, IntBuffer intBuffer, IntBuffer intBuffer2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 2);
            Checks.check((Buffer)intBuffer2, 2);
        }
        GLES20.nglGetShaderPrecisionFormat(n2, n3, MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(intBuffer2));
    }

    public static native void nglGetShaderSource(int var0, int var1, long var2, long var4);

    public static void glGetShaderSource(int n2, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer, 1);
        }
        GLES20.nglGetShaderSource(n2, byteBuffer.remaining(), MemoryUtil.memAddressSafe(intBuffer), MemoryUtil.memAddress(byteBuffer));
    }

    public static String glGetShaderSource(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        ByteBuffer byteBuffer = MemoryUtil.memAlloc(n3);
        try {
            IntBuffer intBuffer = memoryStack.ints(0);
            GLES20.nglGetShaderSource(n2, n3, MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(byteBuffer));
            String string = MemoryUtil.memUTF8(byteBuffer, intBuffer.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree(byteBuffer);
            memoryStack.setPointer(n4);
        }
    }

    public static String glGetShaderSource(int n2) {
        int n3 = n2;
        return GLES20.glGetShaderSource(n3, GLES20.glGetShaderi(n3, 35720));
    }

    public static native long nglGetString(int var0);

    public static String glGetString(int n2) {
        return MemoryUtil.memUTF8Safe(GLES20.nglGetString(n2));
    }

    public static native void nglGetTexParameterfv(int var0, int var1, long var2);

    public static void glGetTexParameterfv(int n2, int n3, FloatBuffer floatBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)floatBuffer, 1);
        }
        GLES20.nglGetTexParameterfv(n2, n3, MemoryUtil.memAddress(floatBuffer));
    }

    public static float glGetTexParameterf(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            FloatBuffer floatBuffer = memoryStack.callocFloat(1);
            GLES20.nglGetTexParameterfv(n2, n3, MemoryUtil.memAddress(floatBuffer));
            float f2 = floatBuffer.get(0);
            return f2;
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static native void nglGetTexParameteriv(int var0, int var1, long var2);

    public static void glGetTexParameteriv(int n2, int n3, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
        }
        GLES20.nglGetTexParameteriv(n2, n3, MemoryUtil.memAddress(intBuffer));
    }

    public static int glGetTexParameteri(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.callocInt(1);
            GLES20.nglGetTexParameteriv(n2, n3, MemoryUtil.memAddress(intBuffer));
            n2 = intBuffer.get(0);
            return n2;
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static native void nglGetUniformfv(int var0, int var1, long var2);

    public static void glGetUniformfv(int n2, int n3, FloatBuffer floatBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)floatBuffer, 1);
        }
        GLES20.nglGetUniformfv(n2, n3, MemoryUtil.memAddress(floatBuffer));
    }

    public static float glGetUniformf(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            FloatBuffer floatBuffer = memoryStack.callocFloat(1);
            GLES20.nglGetUniformfv(n2, n3, MemoryUtil.memAddress(floatBuffer));
            float f2 = floatBuffer.get(0);
            return f2;
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static native void nglGetUniformiv(int var0, int var1, long var2);

    public static void glGetUniformiv(int n2, int n3, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
        }
        GLES20.nglGetUniformiv(n2, n3, MemoryUtil.memAddress(intBuffer));
    }

    public static int glGetUniformi(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.callocInt(1);
            GLES20.nglGetUniformiv(n2, n3, MemoryUtil.memAddress(intBuffer));
            n2 = intBuffer.get(0);
            return n2;
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static native int nglGetUniformLocation(int var0, long var1);

    public static int glGetUniformLocation(int n2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return GLES20.nglGetUniformLocation(n2, MemoryUtil.memAddress(byteBuffer));
    }

    public static int glGetUniformLocation(int n2, CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            memoryStack.nASCII(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            n2 = GLES20.nglGetUniformLocation(n2, l2);
            return n2;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native void nglGetVertexAttribfv(int var0, int var1, long var2);

    public static void glGetVertexAttribfv(int n2, int n3, FloatBuffer floatBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)floatBuffer, 4);
        }
        GLES20.nglGetVertexAttribfv(n2, n3, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nglGetVertexAttribiv(int var0, int var1, long var2);

    public static void glGetVertexAttribiv(int n2, int n3, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 4);
        }
        GLES20.nglGetVertexAttribiv(n2, n3, MemoryUtil.memAddress(intBuffer));
    }

    public static native void nglGetVertexAttribPointerv(int var0, int var1, long var2);

    public static void glGetVertexAttribPointerv(int n2, int n3, PointerBuffer pointerBuffer) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pointerBuffer, 1);
        }
        GLES20.nglGetVertexAttribPointerv(n2, n3, MemoryUtil.memAddress(pointerBuffer));
    }

    public static long glGetVertexAttribPointer(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            PointerBuffer pointerBuffer = memoryStack.callocPointer(1);
            GLES20.nglGetVertexAttribPointerv(n2, n3, MemoryUtil.memAddress(pointerBuffer));
            long l2 = pointerBuffer.get(0);
            return l2;
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static native void glHint(int var0, int var1);

    public static native boolean glIsBuffer(int var0);

    public static native boolean glIsEnabled(int var0);

    public static native boolean glIsFramebuffer(int var0);

    public static native boolean glIsProgram(int var0);

    public static native boolean glIsRenderbuffer(int var0);

    public static native boolean glIsShader(int var0);

    public static native boolean glIsTexture(int var0);

    public static native void glLineWidth(float var0);

    public static native void glLinkProgram(int var0);

    public static native void glPixelStorei(int var0, int var1);

    public static native void glPolygonOffset(float var0, float var1);

    public static native void nglReadPixels(int var0, int var1, int var2, int var3, int var4, int var5, long var6);

    public static void glReadPixels(int n2, int n3, int n4, int n5, int n6, int n7, ByteBuffer byteBuffer) {
        GLES20.nglReadPixels(n2, n3, n4, n5, n6, n7, MemoryUtil.memAddress(byteBuffer));
    }

    public static void glReadPixels(int n2, int n3, int n4, int n5, int n6, int n7, long l2) {
        GLES20.nglReadPixels(n2, n3, n4, n5, n6, n7, l2);
    }

    public static void glReadPixels(int n2, int n3, int n4, int n5, int n6, int n7, ShortBuffer shortBuffer) {
        GLES20.nglReadPixels(n2, n3, n4, n5, n6, n7, MemoryUtil.memAddress(shortBuffer));
    }

    public static void glReadPixels(int n2, int n3, int n4, int n5, int n6, int n7, IntBuffer intBuffer) {
        GLES20.nglReadPixels(n2, n3, n4, n5, n6, n7, MemoryUtil.memAddress(intBuffer));
    }

    public static void glReadPixels(int n2, int n3, int n4, int n5, int n6, int n7, FloatBuffer floatBuffer) {
        GLES20.nglReadPixels(n2, n3, n4, n5, n6, n7, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void glReleaseShaderCompiler();

    public static native void glRenderbufferStorage(int var0, int var1, int var2, int var3);

    public static native void glSampleCoverage(float var0, boolean var1);

    public static native void glScissor(int var0, int var1, int var2, int var3);

    public static native void nglShaderBinary(int var0, long var1, int var3, long var4, int var6);

    public static void glShaderBinary(IntBuffer intBuffer, int n2, ByteBuffer byteBuffer) {
        GLES20.nglShaderBinary(intBuffer.remaining(), MemoryUtil.memAddress(intBuffer), n2, MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining());
    }

    public static native void nglShaderSource(int var0, int var1, long var2, long var4);

    public static void glShaderSource(int n2, PointerBuffer pointerBuffer, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer, pointerBuffer.remaining());
        }
        GLES20.nglShaderSource(n2, pointerBuffer.remaining(), MemoryUtil.memAddress(pointerBuffer), MemoryUtil.memAddressSafe(intBuffer));
    }

    public static void glShaderSource(int n2, CharSequence ... charSequenceArray) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            long l2;
            long l3 = l2 = APIUtil.apiArrayi(memoryStack, MemoryUtil::memUTF8, charSequenceArray);
            GLES20.nglShaderSource(n2, charSequenceArray.length, l3, l3 - (long)(charSequenceArray.length << 2));
            APIUtil.apiArrayFree(l2, charSequenceArray.length);
            return;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static void glShaderSource(int n2, CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            long l2;
            long l3 = l2 = APIUtil.apiArrayi(memoryStack, MemoryUtil::memUTF8, charSequence);
            GLES20.nglShaderSource(n2, 1, l3, l3 - 4L);
            APIUtil.apiArrayFree(l2, 1);
            return;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native void glStencilFunc(int var0, int var1, int var2);

    public static native void glStencilFuncSeparate(int var0, int var1, int var2, int var3);

    public static native void glStencilMask(int var0);

    public static native void glStencilMaskSeparate(int var0, int var1);

    public static native void glStencilOp(int var0, int var1, int var2);

    public static native void glStencilOpSeparate(int var0, int var1, int var2, int var3);

    public static native void nglTexImage2D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8);

    public static void glTexImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ByteBuffer byteBuffer) {
        GLES20.nglTexImage2D(n2, n3, n4, n5, n6, n7, n8, n9, MemoryUtil.memAddressSafe(byteBuffer));
    }

    public static void glTexImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, long l2) {
        GLES20.nglTexImage2D(n2, n3, n4, n5, n6, n7, n8, n9, l2);
    }

    public static void glTexImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ShortBuffer shortBuffer) {
        GLES20.nglTexImage2D(n2, n3, n4, n5, n6, n7, n8, n9, MemoryUtil.memAddressSafe(shortBuffer));
    }

    public static void glTexImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, IntBuffer intBuffer) {
        GLES20.nglTexImage2D(n2, n3, n4, n5, n6, n7, n8, n9, MemoryUtil.memAddressSafe(intBuffer));
    }

    public static void glTexImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, FloatBuffer floatBuffer) {
        GLES20.nglTexImage2D(n2, n3, n4, n5, n6, n7, n8, n9, MemoryUtil.memAddressSafe(floatBuffer));
    }

    public static native void glTexParameterf(int var0, int var1, float var2);

    public static native void nglTexParameterfv(int var0, int var1, long var2);

    public static void glTexParameterfv(int n2, int n3, FloatBuffer floatBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)floatBuffer, 1);
        }
        GLES20.nglTexParameterfv(n2, n3, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void glTexParameteri(int var0, int var1, int var2);

    public static native void nglTexParameteriv(int var0, int var1, long var2);

    public static void glTexParameteriv(int n2, int n3, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
        }
        GLES20.nglTexParameteriv(n2, n3, MemoryUtil.memAddress(intBuffer));
    }

    public static native void nglTexSubImage2D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8);

    public static void glTexSubImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ByteBuffer byteBuffer) {
        GLES20.nglTexSubImage2D(n2, n3, n4, n5, n6, n7, n8, n9, MemoryUtil.memAddress(byteBuffer));
    }

    public static void glTexSubImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, long l2) {
        GLES20.nglTexSubImage2D(n2, n3, n4, n5, n6, n7, n8, n9, l2);
    }

    public static void glTexSubImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ShortBuffer shortBuffer) {
        GLES20.nglTexSubImage2D(n2, n3, n4, n5, n6, n7, n8, n9, MemoryUtil.memAddress(shortBuffer));
    }

    public static void glTexSubImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, IntBuffer intBuffer) {
        GLES20.nglTexSubImage2D(n2, n3, n4, n5, n6, n7, n8, n9, MemoryUtil.memAddress(intBuffer));
    }

    public static void glTexSubImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, FloatBuffer floatBuffer) {
        GLES20.nglTexSubImage2D(n2, n3, n4, n5, n6, n7, n8, n9, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void glUniform1f(int var0, float var1);

    public static native void nglUniform1fv(int var0, int var1, long var2);

    public static void glUniform1fv(int n2, FloatBuffer floatBuffer) {
        GLES20.nglUniform1fv(n2, floatBuffer.remaining(), MemoryUtil.memAddress(floatBuffer));
    }

    public static native void glUniform1i(int var0, int var1);

    public static native void nglUniform1iv(int var0, int var1, long var2);

    public static void glUniform1iv(int n2, IntBuffer intBuffer) {
        GLES20.nglUniform1iv(n2, intBuffer.remaining(), MemoryUtil.memAddress(intBuffer));
    }

    public static native void glUniform2f(int var0, float var1, float var2);

    public static native void nglUniform2fv(int var0, int var1, long var2);

    public static void glUniform2fv(int n2, FloatBuffer floatBuffer) {
        GLES20.nglUniform2fv(n2, floatBuffer.remaining() >> 1, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void glUniform2i(int var0, int var1, int var2);

    public static native void nglUniform2iv(int var0, int var1, long var2);

    public static void glUniform2iv(int n2, IntBuffer intBuffer) {
        GLES20.nglUniform2iv(n2, intBuffer.remaining() >> 1, MemoryUtil.memAddress(intBuffer));
    }

    public static native void glUniform3f(int var0, float var1, float var2, float var3);

    public static native void nglUniform3fv(int var0, int var1, long var2);

    public static void glUniform3fv(int n2, FloatBuffer floatBuffer) {
        GLES20.nglUniform3fv(n2, floatBuffer.remaining() / 3, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void glUniform3i(int var0, int var1, int var2, int var3);

    public static native void nglUniform3iv(int var0, int var1, long var2);

    public static void glUniform3iv(int n2, IntBuffer intBuffer) {
        GLES20.nglUniform3iv(n2, intBuffer.remaining() / 3, MemoryUtil.memAddress(intBuffer));
    }

    public static native void glUniform4f(int var0, float var1, float var2, float var3, float var4);

    public static native void nglUniform4fv(int var0, int var1, long var2);

    public static void glUniform4fv(int n2, FloatBuffer floatBuffer) {
        GLES20.nglUniform4fv(n2, floatBuffer.remaining() >> 2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void glUniform4i(int var0, int var1, int var2, int var3, int var4);

    public static native void nglUniform4iv(int var0, int var1, long var2);

    public static void glUniform4iv(int n2, IntBuffer intBuffer) {
        GLES20.nglUniform4iv(n2, intBuffer.remaining() >> 2, MemoryUtil.memAddress(intBuffer));
    }

    public static native void nglUniformMatrix2fv(int var0, int var1, boolean var2, long var3);

    public static void glUniformMatrix2fv(int n2, boolean bl2, FloatBuffer floatBuffer) {
        GLES20.nglUniformMatrix2fv(n2, floatBuffer.remaining() >> 2, bl2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nglUniformMatrix3fv(int var0, int var1, boolean var2, long var3);

    public static void glUniformMatrix3fv(int n2, boolean bl2, FloatBuffer floatBuffer) {
        GLES20.nglUniformMatrix3fv(n2, floatBuffer.remaining() / 9, bl2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nglUniformMatrix4fv(int var0, int var1, boolean var2, long var3);

    public static void glUniformMatrix4fv(int n2, boolean bl2, FloatBuffer floatBuffer) {
        GLES20.nglUniformMatrix4fv(n2, floatBuffer.remaining() >> 4, bl2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void glUseProgram(int var0);

    public static native void glValidateProgram(int var0);

    public static native void glVertexAttrib1f(int var0, float var1);

    public static native void nglVertexAttrib1fv(int var0, long var1);

    public static void glVertexAttrib1fv(int n2, FloatBuffer floatBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)floatBuffer, 1);
        }
        GLES20.nglVertexAttrib1fv(n2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void glVertexAttrib2f(int var0, float var1, float var2);

    public static native void nglVertexAttrib2fv(int var0, long var1);

    public static void glVertexAttrib2fv(int n2, FloatBuffer floatBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)floatBuffer, 2);
        }
        GLES20.nglVertexAttrib2fv(n2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void glVertexAttrib3f(int var0, float var1, float var2, float var3);

    public static native void nglVertexAttrib3fv(int var0, long var1);

    public static void glVertexAttrib3fv(int n2, FloatBuffer floatBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)floatBuffer, 3);
        }
        GLES20.nglVertexAttrib3fv(n2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void glVertexAttrib4f(int var0, float var1, float var2, float var3, float var4);

    public static native void nglVertexAttrib4fv(int var0, long var1);

    public static void glVertexAttrib4fv(int n2, FloatBuffer floatBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)floatBuffer, 4);
        }
        GLES20.nglVertexAttrib4fv(n2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nglVertexAttribPointer(int var0, int var1, int var2, boolean var3, int var4, long var5);

    public static void glVertexAttribPointer(int n2, int n3, int n4, boolean bl2, int n5, ByteBuffer byteBuffer) {
        GLES20.nglVertexAttribPointer(n2, n3, n4, bl2, n5, MemoryUtil.memAddress(byteBuffer));
    }

    public static void glVertexAttribPointer(int n2, int n3, int n4, boolean bl2, int n5, long l2) {
        GLES20.nglVertexAttribPointer(n2, n3, n4, bl2, n5, l2);
    }

    public static void glVertexAttribPointer(int n2, int n3, int n4, boolean bl2, int n5, ShortBuffer shortBuffer) {
        GLES20.nglVertexAttribPointer(n2, n3, n4, bl2, n5, MemoryUtil.memAddress(shortBuffer));
    }

    public static void glVertexAttribPointer(int n2, int n3, int n4, boolean bl2, int n5, IntBuffer intBuffer) {
        GLES20.nglVertexAttribPointer(n2, n3, n4, bl2, n5, MemoryUtil.memAddress(intBuffer));
    }

    public static void glVertexAttribPointer(int n2, int n3, int n4, boolean bl2, int n5, FloatBuffer floatBuffer) {
        GLES20.nglVertexAttribPointer(n2, n3, n4, bl2, n5, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void glViewport(int var0, int var1, int var2, int var3);

    public static void glBufferData(int n2, short[] sArray, int n3) {
        long l2 = GLES.getICD().glBufferData;
        JNI.callPPV(n2, Integer.toUnsignedLong(sArray.length) << 1, sArray, n3, l2);
    }

    public static void glBufferData(int n2, int[] nArray, int n3) {
        long l2 = GLES.getICD().glBufferData;
        JNI.callPPV(n2, Integer.toUnsignedLong(nArray.length) << 2, nArray, n3, l2);
    }

    public static void glBufferData(int n2, float[] fArray, int n3) {
        long l2 = GLES.getICD().glBufferData;
        JNI.callPPV(n2, Integer.toUnsignedLong(fArray.length) << 2, fArray, n3, l2);
    }

    public static void glBufferSubData(int n2, long l2, short[] sArray) {
        long l3 = GLES.getICD().glBufferSubData;
        JNI.callPPPV(n2, l2, Integer.toUnsignedLong(sArray.length) << 1, sArray, l3);
    }

    public static void glBufferSubData(int n2, long l2, int[] nArray) {
        long l3 = GLES.getICD().glBufferSubData;
        JNI.callPPPV(n2, l2, Integer.toUnsignedLong(nArray.length) << 2, nArray, l3);
    }

    public static void glBufferSubData(int n2, long l2, float[] fArray) {
        long l3 = GLES.getICD().glBufferSubData;
        JNI.callPPPV(n2, l2, Integer.toUnsignedLong(fArray.length) << 2, fArray, l3);
    }

    public static void glDeleteBuffers(int[] nArray) {
        long l2 = GLES.getICD().glDeleteBuffers;
        JNI.callPV(nArray.length, nArray, l2);
    }

    public static void glDeleteFramebuffers(int[] nArray) {
        long l2 = GLES.getICD().glDeleteFramebuffers;
        JNI.callPV(nArray.length, nArray, l2);
    }

    public static void glDeleteRenderbuffers(int[] nArray) {
        long l2 = GLES.getICD().glDeleteRenderbuffers;
        JNI.callPV(nArray.length, nArray, l2);
    }

    public static void glDeleteTextures(int[] nArray) {
        long l2 = GLES.getICD().glDeleteTextures;
        JNI.callPV(nArray.length, nArray, l2);
    }

    public static void glGenBuffers(int[] nArray) {
        long l2 = GLES.getICD().glGenBuffers;
        JNI.callPV(nArray.length, nArray, l2);
    }

    public static void glGenFramebuffers(int[] nArray) {
        long l2 = GLES.getICD().glGenFramebuffers;
        JNI.callPV(nArray.length, nArray, l2);
    }

    public static void glGenRenderbuffers(int[] nArray) {
        long l2 = GLES.getICD().glGenRenderbuffers;
        JNI.callPV(nArray.length, nArray, l2);
    }

    public static void glGenTextures(int[] nArray) {
        long l2 = GLES.getICD().glGenTextures;
        JNI.callPV(nArray.length, nArray, l2);
    }

    public static void glGetActiveAttrib(int n2, int n3, int[] nArray, int[] nArray2, int[] nArray3, ByteBuffer byteBuffer) {
        long l2 = GLES.getICD().glGetActiveAttrib;
        if (Checks.CHECKS) {
            Checks.checkSafe(nArray, 1);
            Checks.check(nArray2, 1);
            Checks.check(nArray3, 1);
        }
        JNI.callPPPPV(n2, n3, byteBuffer.remaining(), nArray, nArray2, nArray3, MemoryUtil.memAddress(byteBuffer), l2);
    }

    public static void glGetActiveUniform(int n2, int n3, int[] nArray, int[] nArray2, int[] nArray3, ByteBuffer byteBuffer) {
        long l2 = GLES.getICD().glGetActiveUniform;
        if (Checks.CHECKS) {
            Checks.checkSafe(nArray, 1);
            Checks.check(nArray2, 1);
            Checks.check(nArray3, 1);
        }
        JNI.callPPPPV(n2, n3, byteBuffer.remaining(), nArray, nArray2, nArray3, MemoryUtil.memAddress(byteBuffer), l2);
    }

    public static void glGetAttachedShaders(int n2, int[] nArray, int[] nArray2) {
        long l2 = GLES.getICD().glGetAttachedShaders;
        if (Checks.CHECKS) {
            Checks.checkSafe(nArray, 1);
        }
        JNI.callPPV(n2, nArray2.length, nArray, nArray2, l2);
    }

    public static void glGetBufferParameteriv(int n2, int n3, int[] nArray) {
        long l2 = GLES.getICD().glGetBufferParameteriv;
        if (Checks.CHECKS) {
            Checks.check(nArray, 1);
        }
        JNI.callPV(n2, n3, nArray, l2);
    }

    public static void glGetFloatv(int n2, float[] fArray) {
        long l2 = GLES.getICD().glGetFloatv;
        if (Checks.CHECKS) {
            Checks.check(fArray, 1);
        }
        JNI.callPV(n2, fArray, l2);
    }

    public static void glGetFramebufferAttachmentParameteriv(int n2, int n3, int n4, int[] nArray) {
        long l2 = GLES.getICD().glGetFramebufferAttachmentParameteriv;
        if (Checks.CHECKS) {
            Checks.check(nArray, 1);
        }
        JNI.callPV(n2, n3, n4, nArray, l2);
    }

    public static void glGetIntegerv(int n2, int[] nArray) {
        long l2 = GLES.getICD().glGetIntegerv;
        if (Checks.CHECKS) {
            Checks.check(nArray, 1);
        }
        JNI.callPV(n2, nArray, l2);
    }

    public static void glGetProgramiv(int n2, int n3, int[] nArray) {
        long l2 = GLES.getICD().glGetProgramiv;
        if (Checks.CHECKS) {
            Checks.check(nArray, 1);
        }
        JNI.callPV(n2, n3, nArray, l2);
    }

    public static void glGetProgramInfoLog(int n2, int[] nArray, ByteBuffer byteBuffer) {
        long l2 = GLES.getICD().glGetProgramInfoLog;
        if (Checks.CHECKS) {
            Checks.checkSafe(nArray, 1);
        }
        JNI.callPPV(n2, byteBuffer.remaining(), nArray, MemoryUtil.memAddress(byteBuffer), l2);
    }

    public static void glGetRenderbufferParameteriv(int n2, int n3, int[] nArray) {
        long l2 = GLES.getICD().glGetRenderbufferParameteriv;
        if (Checks.CHECKS) {
            Checks.check(nArray, 1);
        }
        JNI.callPV(n2, n3, nArray, l2);
    }

    public static void glGetShaderiv(int n2, int n3, int[] nArray) {
        long l2 = GLES.getICD().glGetShaderiv;
        if (Checks.CHECKS) {
            Checks.check(nArray, 1);
        }
        JNI.callPV(n2, n3, nArray, l2);
    }

    public static void glGetShaderInfoLog(int n2, int[] nArray, ByteBuffer byteBuffer) {
        long l2 = GLES.getICD().glGetShaderInfoLog;
        if (Checks.CHECKS) {
            Checks.checkSafe(nArray, 1);
        }
        JNI.callPPV(n2, byteBuffer.remaining(), nArray, MemoryUtil.memAddress(byteBuffer), l2);
    }

    public static void glGetShaderPrecisionFormat(int n2, int n3, int[] nArray, int[] nArray2) {
        long l2 = GLES.getICD().glGetShaderPrecisionFormat;
        if (Checks.CHECKS) {
            Checks.check(nArray, 2);
            Checks.check(nArray2, 2);
        }
        JNI.callPPV(n2, n3, nArray, nArray2, l2);
    }

    public static void glGetShaderSource(int n2, int[] nArray, ByteBuffer byteBuffer) {
        long l2 = GLES.getICD().glGetShaderSource;
        if (Checks.CHECKS) {
            Checks.checkSafe(nArray, 1);
        }
        JNI.callPPV(n2, byteBuffer.remaining(), nArray, MemoryUtil.memAddress(byteBuffer), l2);
    }

    public static void glGetTexParameterfv(int n2, int n3, float[] fArray) {
        long l2 = GLES.getICD().glGetTexParameterfv;
        if (Checks.CHECKS) {
            Checks.check(fArray, 1);
        }
        JNI.callPV(n2, n3, fArray, l2);
    }

    public static void glGetTexParameteriv(int n2, int n3, int[] nArray) {
        long l2 = GLES.getICD().glGetTexParameteriv;
        if (Checks.CHECKS) {
            Checks.check(nArray, 1);
        }
        JNI.callPV(n2, n3, nArray, l2);
    }

    public static void glGetUniformfv(int n2, int n3, float[] fArray) {
        long l2 = GLES.getICD().glGetUniformfv;
        if (Checks.CHECKS) {
            Checks.check(fArray, 1);
        }
        JNI.callPV(n2, n3, fArray, l2);
    }

    public static void glGetUniformiv(int n2, int n3, int[] nArray) {
        long l2 = GLES.getICD().glGetUniformiv;
        if (Checks.CHECKS) {
            Checks.check(nArray, 1);
        }
        JNI.callPV(n2, n3, nArray, l2);
    }

    public static void glGetVertexAttribfv(int n2, int n3, float[] fArray) {
        long l2 = GLES.getICD().glGetVertexAttribfv;
        if (Checks.CHECKS) {
            Checks.check(fArray, 4);
        }
        JNI.callPV(n2, n3, fArray, l2);
    }

    public static void glGetVertexAttribiv(int n2, int n3, int[] nArray) {
        long l2 = GLES.getICD().glGetVertexAttribiv;
        if (Checks.CHECKS) {
            Checks.check(nArray, 4);
        }
        JNI.callPV(n2, n3, nArray, l2);
    }

    public static void glReadPixels(int n2, int n3, int n4, int n5, int n6, int n7, short[] sArray) {
        long l2 = GLES.getICD().glReadPixels;
        JNI.callPV(n2, n3, n4, n5, n6, n7, sArray, l2);
    }

    public static void glReadPixels(int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        long l2 = GLES.getICD().glReadPixels;
        JNI.callPV(n2, n3, n4, n5, n6, n7, nArray, l2);
    }

    public static void glReadPixels(int n2, int n3, int n4, int n5, int n6, int n7, float[] fArray) {
        long l2 = GLES.getICD().glReadPixels;
        JNI.callPV(n2, n3, n4, n5, n6, n7, fArray, l2);
    }

    public static void glShaderBinary(int[] nArray, int n2, ByteBuffer byteBuffer) {
        long l2 = GLES.getICD().glShaderBinary;
        JNI.callPPV(nArray.length, nArray, n2, MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining(), l2);
    }

    public static void glShaderSource(int n2, PointerBuffer pointerBuffer, int[] nArray) {
        long l2 = GLES.getICD().glShaderSource;
        if (Checks.CHECKS) {
            Checks.checkSafe(nArray, pointerBuffer.remaining());
        }
        JNI.callPPV(n2, pointerBuffer.remaining(), MemoryUtil.memAddress(pointerBuffer), nArray, l2);
    }

    public static void glTexImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, short[] sArray) {
        long l2 = GLES.getICD().glTexImage2D;
        JNI.callPV(n2, n3, n4, n5, n6, n7, n8, n9, sArray, l2);
    }

    public static void glTexImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int[] nArray) {
        long l2 = GLES.getICD().glTexImage2D;
        JNI.callPV(n2, n3, n4, n5, n6, n7, n8, n9, nArray, l2);
    }

    public static void glTexImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, float[] fArray) {
        long l2 = GLES.getICD().glTexImage2D;
        JNI.callPV(n2, n3, n4, n5, n6, n7, n8, n9, fArray, l2);
    }

    public static void glTexParameterfv(int n2, int n3, float[] fArray) {
        long l2 = GLES.getICD().glTexParameterfv;
        if (Checks.CHECKS) {
            Checks.check(fArray, 1);
        }
        JNI.callPV(n2, n3, fArray, l2);
    }

    public static void glTexParameteriv(int n2, int n3, int[] nArray) {
        long l2 = GLES.getICD().glTexParameteriv;
        if (Checks.CHECKS) {
            Checks.check(nArray, 1);
        }
        JNI.callPV(n2, n3, nArray, l2);
    }

    public static void glTexSubImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, short[] sArray) {
        long l2 = GLES.getICD().glTexSubImage2D;
        JNI.callPV(n2, n3, n4, n5, n6, n7, n8, n9, sArray, l2);
    }

    public static void glTexSubImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int[] nArray) {
        long l2 = GLES.getICD().glTexSubImage2D;
        JNI.callPV(n2, n3, n4, n5, n6, n7, n8, n9, nArray, l2);
    }

    public static void glTexSubImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, float[] fArray) {
        long l2 = GLES.getICD().glTexSubImage2D;
        JNI.callPV(n2, n3, n4, n5, n6, n7, n8, n9, fArray, l2);
    }

    public static void glUniform1fv(int n2, float[] fArray) {
        long l2 = GLES.getICD().glUniform1fv;
        JNI.callPV(n2, fArray.length, fArray, l2);
    }

    public static void glUniform1iv(int n2, int[] nArray) {
        long l2 = GLES.getICD().glUniform1iv;
        JNI.callPV(n2, nArray.length, nArray, l2);
    }

    public static void glUniform2fv(int n2, float[] fArray) {
        long l2 = GLES.getICD().glUniform2fv;
        JNI.callPV(n2, fArray.length >> 1, fArray, l2);
    }

    public static void glUniform2iv(int n2, int[] nArray) {
        long l2 = GLES.getICD().glUniform2iv;
        JNI.callPV(n2, nArray.length >> 1, nArray, l2);
    }

    public static void glUniform3fv(int n2, float[] fArray) {
        long l2 = GLES.getICD().glUniform3fv;
        JNI.callPV(n2, fArray.length / 3, fArray, l2);
    }

    public static void glUniform3iv(int n2, int[] nArray) {
        long l2 = GLES.getICD().glUniform3iv;
        JNI.callPV(n2, nArray.length / 3, nArray, l2);
    }

    public static void glUniform4fv(int n2, float[] fArray) {
        long l2 = GLES.getICD().glUniform4fv;
        JNI.callPV(n2, fArray.length >> 2, fArray, l2);
    }

    public static void glUniform4iv(int n2, int[] nArray) {
        long l2 = GLES.getICD().glUniform4iv;
        JNI.callPV(n2, nArray.length >> 2, nArray, l2);
    }

    public static void glUniformMatrix2fv(int n2, boolean bl2, float[] fArray) {
        long l2 = GLES.getICD().glUniformMatrix2fv;
        JNI.callPV(n2, fArray.length >> 2, bl2, fArray, l2);
    }

    public static void glUniformMatrix3fv(int n2, boolean bl2, float[] fArray) {
        long l2 = GLES.getICD().glUniformMatrix3fv;
        JNI.callPV(n2, fArray.length / 9, bl2, fArray, l2);
    }

    public static void glUniformMatrix4fv(int n2, boolean bl2, float[] fArray) {
        long l2 = GLES.getICD().glUniformMatrix4fv;
        JNI.callPV(n2, fArray.length >> 4, bl2, fArray, l2);
    }

    public static void glVertexAttrib1fv(int n2, float[] fArray) {
        long l2 = GLES.getICD().glVertexAttrib1fv;
        if (Checks.CHECKS) {
            Checks.check(fArray, 1);
        }
        JNI.callPV(n2, fArray, l2);
    }

    public static void glVertexAttrib2fv(int n2, float[] fArray) {
        long l2 = GLES.getICD().glVertexAttrib2fv;
        if (Checks.CHECKS) {
            Checks.check(fArray, 2);
        }
        JNI.callPV(n2, fArray, l2);
    }

    public static void glVertexAttrib3fv(int n2, float[] fArray) {
        long l2 = GLES.getICD().glVertexAttrib3fv;
        if (Checks.CHECKS) {
            Checks.check(fArray, 3);
        }
        JNI.callPV(n2, fArray, l2);
    }

    public static void glVertexAttrib4fv(int n2, float[] fArray) {
        long l2 = GLES.getICD().glVertexAttrib4fv;
        if (Checks.CHECKS) {
            Checks.check(fArray, 4);
        }
        JNI.callPV(n2, fArray, l2);
    }

    static {
        GLES.initialize();
    }
}

