/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.io.Serializable;
import java.nio.IntBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.IntFunction;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengles.GLES$1;
import org.lwjgl.opengles.GLES$ICD;
import org.lwjgl.opengles.GLES$ICDStatic;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.APIUtil$APIVersion;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Platform;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.ThreadLocalUtil;

public final class GLES {
    private static final APIUtil$APIVersion MAX_VERSION;
    private static FunctionProvider functionProvider;
    private static final ThreadLocal capabilitiesTLS;
    private static GLES$ICD icd;

    private GLES() {
    }

    static void initialize() {
    }

    public static void create() {
        SharedLibrary sharedLibrary;
        switch (Platform.get()) {
            case LINUX: {
                sharedLibrary = Library.loadNative(GLES.class, "org.lwjgl.opengles", Configuration.OPENGLES_LIBRARY_NAME, "libGLESv2.so.2");
                break;
            }
            case MACOSX: {
                sharedLibrary = Library.loadNative(GLES.class, "org.lwjgl.opengles", Configuration.OPENGLES_LIBRARY_NAME, "GLESv2");
                break;
            }
            case WINDOWS: {
                sharedLibrary = Library.loadNative(GLES.class, "org.lwjgl.opengles", Configuration.OPENGLES_LIBRARY_NAME, "libGLESv2", "GLESv2");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        GLES.create(sharedLibrary);
    }

    public static void create(String string) {
        GLES.create(Library.loadNative(GLES.class, "org.lwjgl.opengles", string));
    }

    private static FunctionProvider getContextProvider() {
        FunctionProvider functionProvider = null;
        String string = (String)Configuration.OPENGLES_CONTEXT_API.get();
        if (string == null || "EGL".equals(string)) {
            try {
                functionProvider = (FunctionProvider)Class.forName("org.lwjgl.egl.EGL").getMethod("getFunctionProvider", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Throwable throwable) {
                APIUtil.apiLog("[GLES] Failed to initialize EGL");
            }
        }
        if (functionProvider == null && (string == null || "native".equals(string))) {
            try {
                functionProvider = (FunctionProvider)Class.forName("org.lwjgl.opengl.GL").getMethod("getFunctionProvider", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Throwable throwable) {
                APIUtil.apiLog("[GLES] Failed to initialize OpenGL");
            }
        }
        return functionProvider;
    }

    private static void create(SharedLibrary sharedLibrary) {
        FunctionProvider functionProvider = GLES.getContextProvider();
        if (functionProvider == null) {
            sharedLibrary.free();
            throw new IllegalStateException("There is no OpenGL ES context management API available.");
        }
        try {
            GLES.create((FunctionProvider)new GLES$1(sharedLibrary, functionProvider));
            return;
        }
        catch (RuntimeException runtimeException) {
            sharedLibrary.free();
            throw runtimeException;
        }
    }

    public static void create(FunctionProvider functionProvider) {
        if (GLES.functionProvider != null) {
            throw new IllegalStateException("OpenGL ES has already been created.");
        }
        GLES.functionProvider = functionProvider;
        ThreadLocalUtil.setFunctionMissingAddresses(872);
    }

    public static void destroy() {
        if (functionProvider == null) {
            return;
        }
        ThreadLocalUtil.setFunctionMissingAddresses(0);
        if (functionProvider instanceof NativeResource) {
            ((NativeResource)((Object)functionProvider)).free();
        }
        functionProvider = null;
    }

    public static FunctionProvider getFunctionProvider() {
        return functionProvider;
    }

    public static void setCapabilities(GLESCapabilities gLESCapabilities) {
        capabilitiesTLS.set(gLESCapabilities);
        ThreadLocalUtil.setCapabilities(gLESCapabilities == null ? 0L : MemoryUtil.memAddress(gLESCapabilities.addresses));
        icd.set(gLESCapabilities);
    }

    public static GLESCapabilities getCapabilities() {
        return GLES.checkCapabilities((GLESCapabilities)capabilitiesTLS.get());
    }

    private static GLESCapabilities checkCapabilities(GLESCapabilities gLESCapabilities) {
        if (gLESCapabilities == null) {
            throw new IllegalStateException("No GLESCapabilities instance set for the current thread. Possible solutions:\n\ta) Call GLES.createCapabilities() after making a context current in the current thread.\n\tb) Call GLES.setCapabilities() if a GLESCapabilities instance already exists for the current context.");
        }
        return gLESCapabilities;
    }

    public static GLESCapabilities createCapabilities() {
        return GLES.createCapabilities(null);
    }

    public static GLESCapabilities createCapabilities(IntFunction intFunction) {
        int n2;
        Object object;
        int n3;
        FunctionProvider functionProvider = GLES.functionProvider;
        if (functionProvider == null) {
            throw new IllegalStateException("OpenGL ES library not been loaded.");
        }
        long l2 = functionProvider.getFunctionAddress("glGetError");
        long l3 = functionProvider.getFunctionAddress("glGetString");
        long l4 = functionProvider.getFunctionAddress("glGetIntegerv");
        if (l2 == 0L || l3 == 0L || l4 == 0L) {
            throw new IllegalStateException("Core OpenGL ES functions could not be found. Make sure that the OpenGL ES library has been loaded correctly.");
        }
        int n4 = JNI.callI(l2);
        if (n4 != 0) {
            APIUtil.apiLog(String.format("An OpenGL ES context was in an error state before the creation of its capabilities instance. Error: [0x%X]", n4));
        }
        Object object2 = MemoryStack.stackPush();
        Serializable serializable = null;
        try {
            IntBuffer intBuffer = ((MemoryStack)object2).ints(0);
            JNI.callPV(33307, MemoryUtil.memAddress(intBuffer), l4);
            if (JNI.callI(l2) == 0 && 3 <= (n4 = intBuffer.get(0))) {
                JNI.callPV(33308, MemoryUtil.memAddress(intBuffer), l4);
                n3 = intBuffer.get(0);
            } else {
                String string = MemoryUtil.memUTF8Safe(JNI.callP(7938, l3));
                if (string == null || JNI.callI(l2) != 0) {
                    throw new IllegalStateException("There is no OpenGL ES context current in the current thread.");
                }
                object = APIUtil.apiParseVersion(string);
                n4 = ((APIUtil$APIVersion)object).major;
                n3 = ((APIUtil$APIVersion)object).minor;
            }
            if (object2 != null) {
                ((MemoryStack)object2).close();
            }
        }
        catch (Throwable throwable) {
            try {
                Throwable throwable2 = throwable;
                serializable = throwable;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                if (object2 != null) {
                    if (serializable != null) {
                        try {
                            ((MemoryStack)object2).close();
                        }
                        catch (Throwable throwable4) {
                            ((Throwable)serializable).addSuppressed(throwable4);
                        }
                    } else {
                        ((MemoryStack)object2).close();
                    }
                }
                throw throwable3;
            }
        }
        if (n4 < 2) {
            throw new IllegalStateException("OpenGL ES 2.0 is required.");
        }
        object2 = new int[]{-1, 0, 2};
        serializable = new HashSet(128);
        int n5 = Math.min(n4, ((Object)object2).length);
        if (MAX_VERSION != null) {
            n5 = Math.min(GLES.MAX_VERSION.major, n5);
        }
        for (n2 = 2; n2 <= n5; ++n2) {
            Object object3 = object2[n2 - 1];
            if (n2 == n4) {
                object3 = Math.min(n3, (int)object3);
            }
            if (MAX_VERSION != null && n2 == GLES.MAX_VERSION.major) {
                object3 = Math.min(GLES.MAX_VERSION.minor, (int)object3);
            }
            for (int i2 = 0; i2 <= object3; ++i2) {
                serializable.add("GLES" + n2 + i2);
            }
        }
        if (n4 < 3) {
            String string = MemoryUtil.memASCIISafe(JNI.callP(7939, l3));
            if (string != null) {
                object = new StringTokenizer(string);
                while (((StringTokenizer)object).hasMoreTokens()) {
                    serializable.add(((StringTokenizer)object).nextToken());
                }
            }
        } else {
            object = MemoryStack.stackPush();
            Throwable throwable = null;
            try {
                IntBuffer intBuffer = ((MemoryStack)object).ints(0);
                JNI.callPV(33309, MemoryUtil.memAddress(intBuffer), l4);
                n2 = intBuffer.get(0);
                if (object != null) {
                    ((MemoryStack)object).close();
                }
            }
            catch (Throwable throwable5) {
                try {
                    Throwable throwable6 = throwable5;
                    throwable = throwable5;
                    throw throwable6;
                }
                catch (Throwable throwable7) {
                    if (object != null) {
                        if (throwable != null) {
                            try {
                                ((MemoryStack)object).close();
                            }
                            catch (Throwable throwable8) {
                                throwable.addSuppressed(throwable8);
                            }
                        } else {
                            ((MemoryStack)object).close();
                        }
                    }
                    throw throwable7;
                }
            }
            long l5 = APIUtil.apiGetFunctionAddress(functionProvider, "glGetStringi");
            for (int i3 = 0; i3 < n2; ++i3) {
                serializable.add(MemoryUtil.memASCII(JNI.callP(7939, i3, l5)));
            }
        }
        APIUtil.apiFilterExtensions((Set)((Object)serializable), Configuration.OPENGLES_EXTENSION_FILTER);
        GLESCapabilities gLESCapabilities = new GLESCapabilities(functionProvider, (Set)((Object)serializable), intFunction == null ? BufferUtils::createPointerBuffer : intFunction);
        GLES.setCapabilities(gLESCapabilities);
        return gLESCapabilities;
    }

    static GLESCapabilities getICD() {
        return GLES.checkCapabilities(icd.get());
    }

    static /* synthetic */ GLES$ICD access$102(GLES$ICD gLES$ICD) {
        icd = gLES$ICD;
        return icd;
    }

    static {
        capabilitiesTLS = new ThreadLocal();
        icd = new GLES$ICDStatic(null);
        Library.loadSystem(System::load, System::loadLibrary, GLES.class, "org.lwjgl.opengles", Platform.mapLibraryNameBundled("lwjgl_opengles"));
        MAX_VERSION = APIUtil.apiParseVersion(Configuration.OPENGLES_MAXVERSION);
        if (!((Boolean)Configuration.OPENGLES_EXPLICIT_INIT.get(Boolean.FALSE)).booleanValue()) {
            GLES.create();
        }
    }
}

