/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class EXTSeparateShaderObjects {
    public static final int GL_VERTEX_SHADER_BIT_EXT = 1;
    public static final int GL_FRAGMENT_SHADER_BIT_EXT = 2;
    public static final int GL_ALL_SHADER_BITS_EXT = -1;
    public static final int GL_PROGRAM_SEPARABLE_EXT = 33368;
    public static final int GL_ACTIVE_PROGRAM_EXT = 33369;
    public static final int GL_PROGRAM_PIPELINE_BINDING_EXT = 33370;

    protected EXTSeparateShaderObjects() {
        throw new UnsupportedOperationException();
    }

    public static native void glActiveShaderProgramEXT(int var0, int var1);

    public static native void glBindProgramPipelineEXT(int var0);

    public static native int nglCreateShaderProgramvEXT(int var0, int var1, long var2);

    public static int glCreateShaderProgramvEXT(int n2, PointerBuffer pointerBuffer) {
        return EXTSeparateShaderObjects.nglCreateShaderProgramvEXT(n2, pointerBuffer.remaining(), MemoryUtil.memAddress(pointerBuffer));
    }

    public static int glCreateShaderProgramvEXT(int n2, CharSequence ... charSequenceArray) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            long l2 = APIUtil.apiArray(memoryStack, MemoryUtil::memUTF8, charSequenceArray);
            n2 = EXTSeparateShaderObjects.nglCreateShaderProgramvEXT(n2, charSequenceArray.length, l2);
            APIUtil.apiArrayFree(l2, charSequenceArray.length);
            return n2;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static int glCreateShaderProgramvEXT(int n2, CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            long l2 = APIUtil.apiArray(memoryStack, MemoryUtil::memUTF8, charSequence);
            n2 = EXTSeparateShaderObjects.nglCreateShaderProgramvEXT(n2, 1, l2);
            APIUtil.apiArrayFree(l2, 1);
            return n2;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native void nglDeleteProgramPipelinesEXT(int var0, long var1);

    public static void glDeleteProgramPipelinesEXT(IntBuffer intBuffer) {
        EXTSeparateShaderObjects.nglDeleteProgramPipelinesEXT(intBuffer.remaining(), MemoryUtil.memAddress(intBuffer));
    }

    public static void glDeleteProgramPipelinesEXT(int n2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.ints(n2);
            EXTSeparateShaderObjects.nglDeleteProgramPipelinesEXT(1, MemoryUtil.memAddress(intBuffer));
            return;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native void nglGenProgramPipelinesEXT(int var0, long var1);

    public static void glGenProgramPipelinesEXT(IntBuffer intBuffer) {
        EXTSeparateShaderObjects.nglGenProgramPipelinesEXT(intBuffer.remaining(), MemoryUtil.memAddress(intBuffer));
    }

    public static int glGenProgramPipelinesEXT() {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.callocInt(1);
            EXTSeparateShaderObjects.nglGenProgramPipelinesEXT(1, MemoryUtil.memAddress(intBuffer));
            int n3 = intBuffer.get(0);
            return n3;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static native void nglGetProgramPipelineInfoLogEXT(int var0, int var1, long var2, long var4);

    public static void glGetProgramPipelineInfoLogEXT(int n2, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer, 1);
        }
        EXTSeparateShaderObjects.nglGetProgramPipelineInfoLogEXT(n2, byteBuffer.remaining(), MemoryUtil.memAddressSafe(intBuffer), MemoryUtil.memAddress(byteBuffer));
    }

    public static String glGetProgramPipelineInfoLogEXT(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        ByteBuffer byteBuffer = MemoryUtil.memAlloc(n3);
        try {
            IntBuffer intBuffer = memoryStack.ints(0);
            EXTSeparateShaderObjects.nglGetProgramPipelineInfoLogEXT(n2, n3, MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(byteBuffer));
            String string = MemoryUtil.memUTF8(byteBuffer, intBuffer.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree(byteBuffer);
            memoryStack.setPointer(n4);
        }
    }

    public static String glGetProgramPipelineInfoLogEXT(int n2) {
        int n3 = n2;
        return EXTSeparateShaderObjects.glGetProgramPipelineInfoLogEXT(n3, EXTSeparateShaderObjects.glGetProgramPipelineiEXT(n3, 35716));
    }

    public static native void nglGetProgramPipelineivEXT(int var0, int var1, long var2);

    public static void glGetProgramPipelineivEXT(int n2, int n3, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
        }
        EXTSeparateShaderObjects.nglGetProgramPipelineivEXT(n2, n3, MemoryUtil.memAddress(intBuffer));
    }

    public static int glGetProgramPipelineiEXT(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.callocInt(1);
            EXTSeparateShaderObjects.nglGetProgramPipelineivEXT(n2, n3, MemoryUtil.memAddress(intBuffer));
            n2 = intBuffer.get(0);
            return n2;
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static native boolean glIsProgramPipelineEXT(int var0);

    public static native void glProgramParameteriEXT(int var0, int var1, int var2);

    public static native void glProgramUniform1fEXT(int var0, int var1, float var2);

    public static native void nglProgramUniform1fvEXT(int var0, int var1, int var2, long var3);

    public static void glProgramUniform1fvEXT(int n2, int n3, FloatBuffer floatBuffer) {
        EXTSeparateShaderObjects.nglProgramUniform1fvEXT(n2, n3, floatBuffer.remaining(), MemoryUtil.memAddress(floatBuffer));
    }

    public static native void glProgramUniform1iEXT(int var0, int var1, int var2);

    public static native void nglProgramUniform1ivEXT(int var0, int var1, int var2, long var3);

    public static void glProgramUniform1ivEXT(int n2, int n3, IntBuffer intBuffer) {
        EXTSeparateShaderObjects.nglProgramUniform1ivEXT(n2, n3, intBuffer.remaining(), MemoryUtil.memAddress(intBuffer));
    }

    public static native void glProgramUniform2fEXT(int var0, int var1, float var2, float var3);

    public static native void nglProgramUniform2fvEXT(int var0, int var1, int var2, long var3);

    public static void glProgramUniform2fvEXT(int n2, int n3, FloatBuffer floatBuffer) {
        EXTSeparateShaderObjects.nglProgramUniform2fvEXT(n2, n3, floatBuffer.remaining() >> 1, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void glProgramUniform2iEXT(int var0, int var1, int var2, int var3);

    public static native void nglProgramUniform2ivEXT(int var0, int var1, int var2, long var3);

    public static void glProgramUniform2ivEXT(int n2, int n3, IntBuffer intBuffer) {
        EXTSeparateShaderObjects.nglProgramUniform2ivEXT(n2, n3, intBuffer.remaining() >> 1, MemoryUtil.memAddress(intBuffer));
    }

    public static native void glProgramUniform3fEXT(int var0, int var1, float var2, float var3, float var4);

    public static native void nglProgramUniform3fvEXT(int var0, int var1, int var2, long var3);

    public static void glProgramUniform3fvEXT(int n2, int n3, FloatBuffer floatBuffer) {
        EXTSeparateShaderObjects.nglProgramUniform3fvEXT(n2, n3, floatBuffer.remaining() / 3, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void glProgramUniform3iEXT(int var0, int var1, int var2, int var3, int var4);

    public static native void nglProgramUniform3ivEXT(int var0, int var1, int var2, long var3);

    public static void glProgramUniform3ivEXT(int n2, int n3, IntBuffer intBuffer) {
        EXTSeparateShaderObjects.nglProgramUniform3ivEXT(n2, n3, intBuffer.remaining() / 3, MemoryUtil.memAddress(intBuffer));
    }

    public static native void glProgramUniform4fEXT(int var0, int var1, float var2, float var3, float var4, float var5);

    public static native void nglProgramUniform4fvEXT(int var0, int var1, int var2, long var3);

    public static void glProgramUniform4fvEXT(int n2, int n3, FloatBuffer floatBuffer) {
        EXTSeparateShaderObjects.nglProgramUniform4fvEXT(n2, n3, floatBuffer.remaining() >> 2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void glProgramUniform4iEXT(int var0, int var1, int var2, int var3, int var4, int var5);

    public static native void nglProgramUniform4ivEXT(int var0, int var1, int var2, long var3);

    public static void glProgramUniform4ivEXT(int n2, int n3, IntBuffer intBuffer) {
        EXTSeparateShaderObjects.nglProgramUniform4ivEXT(n2, n3, intBuffer.remaining() >> 2, MemoryUtil.memAddress(intBuffer));
    }

    public static native void nglProgramUniformMatrix2fvEXT(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix2fvEXT(int n2, int n3, boolean bl2, FloatBuffer floatBuffer) {
        EXTSeparateShaderObjects.nglProgramUniformMatrix2fvEXT(n2, n3, floatBuffer.remaining() >> 2, bl2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nglProgramUniformMatrix3fvEXT(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix3fvEXT(int n2, int n3, boolean bl2, FloatBuffer floatBuffer) {
        EXTSeparateShaderObjects.nglProgramUniformMatrix3fvEXT(n2, n3, floatBuffer.remaining() / 9, bl2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nglProgramUniformMatrix4fvEXT(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix4fvEXT(int n2, int n3, boolean bl2, FloatBuffer floatBuffer) {
        EXTSeparateShaderObjects.nglProgramUniformMatrix4fvEXT(n2, n3, floatBuffer.remaining() >> 4, bl2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void glUseProgramStagesEXT(int var0, int var1, int var2);

    public static native void glValidateProgramPipelineEXT(int var0);

    public static native void glProgramUniform1uiEXT(int var0, int var1, int var2);

    public static native void glProgramUniform2uiEXT(int var0, int var1, int var2, int var3);

    public static native void glProgramUniform3uiEXT(int var0, int var1, int var2, int var3, int var4);

    public static native void glProgramUniform4uiEXT(int var0, int var1, int var2, int var3, int var4, int var5);

    public static native void nglProgramUniform1uivEXT(int var0, int var1, int var2, long var3);

    public static void glProgramUniform1uivEXT(int n2, int n3, IntBuffer intBuffer) {
        EXTSeparateShaderObjects.nglProgramUniform1uivEXT(n2, n3, intBuffer.remaining(), MemoryUtil.memAddress(intBuffer));
    }

    public static native void nglProgramUniform2uivEXT(int var0, int var1, int var2, long var3);

    public static void glProgramUniform2uivEXT(int n2, int n3, IntBuffer intBuffer) {
        EXTSeparateShaderObjects.nglProgramUniform2uivEXT(n2, n3, intBuffer.remaining() >> 1, MemoryUtil.memAddress(intBuffer));
    }

    public static native void nglProgramUniform3uivEXT(int var0, int var1, int var2, long var3);

    public static void glProgramUniform3uivEXT(int n2, int n3, IntBuffer intBuffer) {
        EXTSeparateShaderObjects.nglProgramUniform3uivEXT(n2, n3, intBuffer.remaining() / 3, MemoryUtil.memAddress(intBuffer));
    }

    public static native void nglProgramUniform4uivEXT(int var0, int var1, int var2, long var3);

    public static void glProgramUniform4uivEXT(int n2, int n3, IntBuffer intBuffer) {
        EXTSeparateShaderObjects.nglProgramUniform4uivEXT(n2, n3, intBuffer.remaining() >> 2, MemoryUtil.memAddress(intBuffer));
    }

    public static native void nglProgramUniformMatrix2x3fvEXT(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix2x3fvEXT(int n2, int n3, boolean bl2, FloatBuffer floatBuffer) {
        EXTSeparateShaderObjects.nglProgramUniformMatrix2x3fvEXT(n2, n3, floatBuffer.remaining() / 6, bl2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nglProgramUniformMatrix3x2fvEXT(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix3x2fvEXT(int n2, int n3, boolean bl2, FloatBuffer floatBuffer) {
        EXTSeparateShaderObjects.nglProgramUniformMatrix3x2fvEXT(n2, n3, floatBuffer.remaining() / 6, bl2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nglProgramUniformMatrix2x4fvEXT(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix2x4fvEXT(int n2, int n3, boolean bl2, FloatBuffer floatBuffer) {
        EXTSeparateShaderObjects.nglProgramUniformMatrix2x4fvEXT(n2, n3, floatBuffer.remaining() >> 3, bl2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nglProgramUniformMatrix4x2fvEXT(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix4x2fvEXT(int n2, int n3, boolean bl2, FloatBuffer floatBuffer) {
        EXTSeparateShaderObjects.nglProgramUniformMatrix4x2fvEXT(n2, n3, floatBuffer.remaining() >> 3, bl2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nglProgramUniformMatrix3x4fvEXT(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix3x4fvEXT(int n2, int n3, boolean bl2, FloatBuffer floatBuffer) {
        EXTSeparateShaderObjects.nglProgramUniformMatrix3x4fvEXT(n2, n3, floatBuffer.remaining() / 12, bl2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nglProgramUniformMatrix4x3fvEXT(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix4x3fvEXT(int n2, int n3, boolean bl2, FloatBuffer floatBuffer) {
        EXTSeparateShaderObjects.nglProgramUniformMatrix4x3fvEXT(n2, n3, floatBuffer.remaining() / 12, bl2, MemoryUtil.memAddress(floatBuffer));
    }

    public static void glDeleteProgramPipelinesEXT(int[] nArray) {
        long l2 = GLES.getICD().glDeleteProgramPipelinesEXT;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(nArray.length, nArray, l2);
    }

    public static void glGenProgramPipelinesEXT(int[] nArray) {
        long l2 = GLES.getICD().glGenProgramPipelinesEXT;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(nArray.length, nArray, l2);
    }

    public static void glGetProgramPipelineInfoLogEXT(int n2, int[] nArray, ByteBuffer byteBuffer) {
        long l2 = GLES.getICD().glGetProgramPipelineInfoLogEXT;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.checkSafe(nArray, 1);
        }
        JNI.callPPV(n2, byteBuffer.remaining(), nArray, MemoryUtil.memAddress(byteBuffer), l2);
    }

    public static void glGetProgramPipelineivEXT(int n2, int n3, int[] nArray) {
        long l2 = GLES.getICD().glGetProgramPipelineivEXT;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(nArray, 1);
        }
        JNI.callPV(n2, n3, nArray, l2);
    }

    public static void glProgramUniform1fvEXT(int n2, int n3, float[] fArray) {
        long l2 = GLES.getICD().glProgramUniform1fvEXT;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, fArray.length, fArray, l2);
    }

    public static void glProgramUniform1ivEXT(int n2, int n3, int[] nArray) {
        long l2 = GLES.getICD().glProgramUniform1ivEXT;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, nArray.length, nArray, l2);
    }

    public static void glProgramUniform2fvEXT(int n2, int n3, float[] fArray) {
        long l2 = GLES.getICD().glProgramUniform2fvEXT;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, fArray.length >> 1, fArray, l2);
    }

    public static void glProgramUniform2ivEXT(int n2, int n3, int[] nArray) {
        long l2 = GLES.getICD().glProgramUniform2ivEXT;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, nArray.length >> 1, nArray, l2);
    }

    public static void glProgramUniform3fvEXT(int n2, int n3, float[] fArray) {
        long l2 = GLES.getICD().glProgramUniform3fvEXT;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, fArray.length / 3, fArray, l2);
    }

    public static void glProgramUniform3ivEXT(int n2, int n3, int[] nArray) {
        long l2 = GLES.getICD().glProgramUniform3ivEXT;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, nArray.length / 3, nArray, l2);
    }

    public static void glProgramUniform4fvEXT(int n2, int n3, float[] fArray) {
        long l2 = GLES.getICD().glProgramUniform4fvEXT;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, fArray.length >> 2, fArray, l2);
    }

    public static void glProgramUniform4ivEXT(int n2, int n3, int[] nArray) {
        long l2 = GLES.getICD().glProgramUniform4ivEXT;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, nArray.length >> 2, nArray, l2);
    }

    public static void glProgramUniformMatrix2fvEXT(int n2, int n3, boolean bl2, float[] fArray) {
        long l2 = GLES.getICD().glProgramUniformMatrix2fvEXT;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, fArray.length >> 2, bl2, fArray, l2);
    }

    public static void glProgramUniformMatrix3fvEXT(int n2, int n3, boolean bl2, float[] fArray) {
        long l2 = GLES.getICD().glProgramUniformMatrix3fvEXT;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, fArray.length / 9, bl2, fArray, l2);
    }

    public static void glProgramUniformMatrix4fvEXT(int n2, int n3, boolean bl2, float[] fArray) {
        long l2 = GLES.getICD().glProgramUniformMatrix4fvEXT;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, fArray.length >> 4, bl2, fArray, l2);
    }

    public static void glProgramUniform1uivEXT(int n2, int n3, int[] nArray) {
        long l2 = GLES.getICD().glProgramUniform1uivEXT;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, nArray.length, nArray, l2);
    }

    public static void glProgramUniform2uivEXT(int n2, int n3, int[] nArray) {
        long l2 = GLES.getICD().glProgramUniform2uivEXT;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, nArray.length >> 1, nArray, l2);
    }

    public static void glProgramUniform3uivEXT(int n2, int n3, int[] nArray) {
        long l2 = GLES.getICD().glProgramUniform3uivEXT;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, nArray.length / 3, nArray, l2);
    }

    public static void glProgramUniform4uivEXT(int n2, int n3, int[] nArray) {
        long l2 = GLES.getICD().glProgramUniform4uivEXT;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, nArray.length >> 2, nArray, l2);
    }

    public static void glProgramUniformMatrix2x3fvEXT(int n2, int n3, boolean bl2, float[] fArray) {
        long l2 = GLES.getICD().glProgramUniformMatrix2x3fvEXT;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, fArray.length / 6, bl2, fArray, l2);
    }

    public static void glProgramUniformMatrix3x2fvEXT(int n2, int n3, boolean bl2, float[] fArray) {
        long l2 = GLES.getICD().glProgramUniformMatrix3x2fvEXT;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, fArray.length / 6, bl2, fArray, l2);
    }

    public static void glProgramUniformMatrix2x4fvEXT(int n2, int n3, boolean bl2, float[] fArray) {
        long l2 = GLES.getICD().glProgramUniformMatrix2x4fvEXT;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, fArray.length >> 3, bl2, fArray, l2);
    }

    public static void glProgramUniformMatrix4x2fvEXT(int n2, int n3, boolean bl2, float[] fArray) {
        long l2 = GLES.getICD().glProgramUniformMatrix4x2fvEXT;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, fArray.length >> 3, bl2, fArray, l2);
    }

    public static void glProgramUniformMatrix3x4fvEXT(int n2, int n3, boolean bl2, float[] fArray) {
        long l2 = GLES.getICD().glProgramUniformMatrix3x4fvEXT;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, fArray.length / 12, bl2, fArray, l2);
    }

    public static void glProgramUniformMatrix4x3fvEXT(int n2, int n3, boolean bl2, float[] fArray) {
        long l2 = GLES.getICD().glProgramUniformMatrix4x3fvEXT;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, fArray.length / 12, bl2, fArray, l2);
    }

    static {
        GLES.initialize();
    }
}

