/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class EXTMultiviewDrawBuffers {
    public static final int GL_COLOR_ATTACHMENT_EXT = 37104;
    public static final int GL_MULTIVIEW_EXT = 37105;
    public static final int GL_DRAW_BUFFER_EXT = 3073;
    public static final int GL_READ_BUFFER_EXT = 3074;
    public static final int GL_MAX_MULTIVIEW_BUFFERS_EXT = 37106;

    protected EXTMultiviewDrawBuffers() {
        throw new UnsupportedOperationException();
    }

    public static native void glReadBufferIndexedEXT(int var0, int var1);

    public static native void nglDrawBuffersIndexedEXT(int var0, long var1, long var3);

    public static void glDrawBuffersIndexedEXT(IntBuffer intBuffer, IntBuffer intBuffer2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer2, intBuffer.remaining());
        }
        EXTMultiviewDrawBuffers.nglDrawBuffersIndexedEXT(intBuffer.remaining(), MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(intBuffer2));
    }

    public static native void nglGetIntegeri_vEXT(int var0, int var1, long var2);

    public static void glGetIntegeri_vEXT(int n2, int n3, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
        }
        EXTMultiviewDrawBuffers.nglGetIntegeri_vEXT(n2, n3, MemoryUtil.memAddress(intBuffer));
    }

    public static int glGetIntegeriEXT(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.callocInt(1);
            EXTMultiviewDrawBuffers.nglGetIntegeri_vEXT(n2, n3, MemoryUtil.memAddress(intBuffer));
            n2 = intBuffer.get(0);
            return n2;
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static void glDrawBuffersIndexedEXT(int[] nArray, int[] nArray2) {
        long l2 = GLES.getICD().glDrawBuffersIndexedEXT;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(nArray2, nArray.length);
        }
        JNI.callPPV(nArray.length, nArray, nArray2, l2);
    }

    public static void glGetIntegeri_vEXT(int n2, int n3, int[] nArray) {
        long l2 = GLES.getICD().glGetIntegeri_vEXT;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(nArray, 1);
        }
        JNI.callPV(n2, n3, nArray, l2);
    }

    static {
        GLES.initialize();
    }
}

