/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTBufferStorage {
    public static final int GL_MAP_PERSISTENT_BIT_EXT = 64;
    public static final int GL_MAP_COHERENT_BIT_EXT = 128;
    public static final int GL_DYNAMIC_STORAGE_BIT_EXT = 256;
    public static final int GL_CLIENT_STORAGE_BIT_EXT = 512;
    public static final int GL_BUFFER_IMMUTABLE_STORAGE_EXT = 33311;
    public static final int GL_BUFFER_STORAGE_FLAGS_EXT = 33312;
    public static final int GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT_EXT = 16384;

    protected EXTBufferStorage() {
        throw new UnsupportedOperationException();
    }

    public static native void nglBufferStorageEXT(int var0, long var1, long var3, int var5);

    public static void glBufferStorageEXT(int n2, long l2, int n3) {
        EXTBufferStorage.nglBufferStorageEXT(n2, l2, 0L, n3);
    }

    public static void glBufferStorageEXT(int n2, ByteBuffer byteBuffer, int n3) {
        EXTBufferStorage.nglBufferStorageEXT(n2, byteBuffer.remaining(), MemoryUtil.memAddress(byteBuffer), n3);
    }

    public static void glBufferStorageEXT(int n2, ShortBuffer shortBuffer, int n3) {
        EXTBufferStorage.nglBufferStorageEXT(n2, Integer.toUnsignedLong(shortBuffer.remaining()) << 1, MemoryUtil.memAddress(shortBuffer), n3);
    }

    public static void glBufferStorageEXT(int n2, IntBuffer intBuffer, int n3) {
        EXTBufferStorage.nglBufferStorageEXT(n2, Integer.toUnsignedLong(intBuffer.remaining()) << 2, MemoryUtil.memAddress(intBuffer), n3);
    }

    public static void glBufferStorageEXT(int n2, FloatBuffer floatBuffer, int n3) {
        EXTBufferStorage.nglBufferStorageEXT(n2, Integer.toUnsignedLong(floatBuffer.remaining()) << 2, MemoryUtil.memAddress(floatBuffer), n3);
    }

    public static native void nglNamedBufferStorageEXT(int var0, long var1, long var3, int var5);

    public static void glNamedBufferStorageEXT(int n2, long l2, int n3) {
        EXTBufferStorage.nglNamedBufferStorageEXT(n2, l2, 0L, n3);
    }

    public static void glNamedBufferStorageEXT(int n2, ByteBuffer byteBuffer, int n3) {
        EXTBufferStorage.nglNamedBufferStorageEXT(n2, byteBuffer.remaining(), MemoryUtil.memAddress(byteBuffer), n3);
    }

    public static void glNamedBufferStorageEXT(int n2, ShortBuffer shortBuffer, int n3) {
        EXTBufferStorage.nglNamedBufferStorageEXT(n2, Integer.toUnsignedLong(shortBuffer.remaining()) << 1, MemoryUtil.memAddress(shortBuffer), n3);
    }

    public static void glNamedBufferStorageEXT(int n2, IntBuffer intBuffer, int n3) {
        EXTBufferStorage.nglNamedBufferStorageEXT(n2, Integer.toUnsignedLong(intBuffer.remaining()) << 2, MemoryUtil.memAddress(intBuffer), n3);
    }

    public static void glNamedBufferStorageEXT(int n2, FloatBuffer floatBuffer, int n3) {
        EXTBufferStorage.nglNamedBufferStorageEXT(n2, Integer.toUnsignedLong(floatBuffer.remaining()) << 2, MemoryUtil.memAddress(floatBuffer), n3);
    }

    public static void glBufferStorageEXT(int n2, short[] sArray, int n3) {
        long l2 = GLES.getICD().glBufferStorageEXT;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPPV(n2, Integer.toUnsignedLong(sArray.length) << 1, sArray, n3, l2);
    }

    public static void glBufferStorageEXT(int n2, int[] nArray, int n3) {
        long l2 = GLES.getICD().glBufferStorageEXT;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPPV(n2, Integer.toUnsignedLong(nArray.length) << 2, nArray, n3, l2);
    }

    public static void glBufferStorageEXT(int n2, float[] fArray, int n3) {
        long l2 = GLES.getICD().glBufferStorageEXT;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPPV(n2, Integer.toUnsignedLong(fArray.length) << 2, fArray, n3, l2);
    }

    public static void glNamedBufferStorageEXT(int n2, short[] sArray, int n3) {
        long l2 = GLES.getICD().glNamedBufferStorageEXT;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPPV(n2, Integer.toUnsignedLong(sArray.length) << 1, sArray, n3, l2);
    }

    public static void glNamedBufferStorageEXT(int n2, int[] nArray, int n3) {
        long l2 = GLES.getICD().glNamedBufferStorageEXT;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPPV(n2, Integer.toUnsignedLong(nArray.length) << 2, nArray, n3, l2);
    }

    public static void glNamedBufferStorageEXT(int n2, float[] fArray, int n3) {
        long l2 = GLES.getICD().glNamedBufferStorageEXT;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPPV(n2, Integer.toUnsignedLong(fArray.length) << 2, fArray, n3, l2);
    }

    static {
        GLES.initialize();
    }
}

