/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class APPLESync {
    public static final int GL_MAX_SERVER_WAIT_TIMEOUT_APPLE = 37137;
    public static final int GL_OBJECT_TYPE_APPLE = 37138;
    public static final int GL_SYNC_CONDITION_APPLE = 37139;
    public static final int GL_SYNC_STATUS_APPLE = 37140;
    public static final int GL_SYNC_FLAGS_APPLE = 37141;
    public static final int GL_SYNC_FENCE_APPLE = 37142;
    public static final int GL_SYNC_GPU_COMMANDS_COMPLETE_APPLE = 37143;
    public static final int GL_UNSIGNALED_APPLE = 37144;
    public static final int GL_SIGNALED_APPLE = 37145;
    public static final int GL_SYNC_FLUSH_COMMANDS_BIT_APPLE = 1;
    public static final long GL_TIMEOUT_IGNORED_APPLE = -1L;
    public static final int GL_ALREADY_SIGNALED_APPLE = 37146;
    public static final int GL_TIMEOUT_EXPIRED_APPLE = 37147;
    public static final int GL_CONDITION_SATISFIED_APPLE = 37148;
    public static final int GL_WAIT_FAILED_APPLE = 37149;
    public static final int GL_SYNC_OBJECT_APPLE = 35411;

    protected APPLESync() {
        throw new UnsupportedOperationException();
    }

    public static native long glFenceSyncAPPLE(int var0, int var1);

    public static native boolean nglIsSyncAPPLE(long var0);

    public static boolean glIsSyncAPPLE(long l2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return APPLESync.nglIsSyncAPPLE(l2);
    }

    public static native void nglDeleteSyncAPPLE(long var0);

    public static void glDeleteSyncAPPLE(long l2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        APPLESync.nglDeleteSyncAPPLE(l2);
    }

    public static native int nglClientWaitSyncAPPLE(long var0, int var2, long var3);

    public static int glClientWaitSyncAPPLE(long l2, int n2, long l3) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return APPLESync.nglClientWaitSyncAPPLE(l2, n2, l3);
    }

    public static native void nglWaitSyncAPPLE(long var0, int var2, long var3);

    public static void glWaitSyncAPPLE(long l2, int n2, long l3) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        APPLESync.nglWaitSyncAPPLE(l2, n2, l3);
    }

    public static native void nglGetInteger64vAPPLE(int var0, long var1);

    public static void glGetInteger64vAPPLE(int n2, LongBuffer longBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)longBuffer, 1);
        }
        APPLESync.nglGetInteger64vAPPLE(n2, MemoryUtil.memAddress(longBuffer));
    }

    public static long glGetInteger64APPLE(int n2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            LongBuffer longBuffer = memoryStack.callocLong(1);
            APPLESync.nglGetInteger64vAPPLE(n2, MemoryUtil.memAddress(longBuffer));
            long l2 = longBuffer.get(0);
            return l2;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native void nglGetSyncivAPPLE(long var0, int var2, int var3, long var4, long var6);

    public static void glGetSyncivAPPLE(long l2, int n2, IntBuffer intBuffer, IntBuffer intBuffer2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.checkSafe((Buffer)intBuffer, 1);
        }
        APPLESync.nglGetSyncivAPPLE(l2, n2, intBuffer2.remaining(), MemoryUtil.memAddressSafe(intBuffer), MemoryUtil.memAddress(intBuffer2));
    }

    public static int glGetSynciAPPLE(long l2, int n2, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.checkSafe((Buffer)intBuffer, 1);
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer2 = memoryStack.callocInt(1);
            APPLESync.nglGetSyncivAPPLE(l2, n2, 1, MemoryUtil.memAddressSafe(intBuffer), MemoryUtil.memAddress(intBuffer2));
            int n4 = intBuffer2.get(0);
            return n4;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static void glGetInteger64vAPPLE(int n2, long[] lArray) {
        long l2 = GLES.getICD().glGetInteger64vAPPLE;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(lArray, 1);
        }
        JNI.callPV(n2, lArray, l2);
    }

    public static void glGetSyncivAPPLE(long l2, int n2, int[] nArray, int[] nArray2) {
        long l3 = GLES.getICD().glGetSyncivAPPLE;
        if (Checks.CHECKS) {
            Checks.check(l3);
            Checks.check(l2);
            Checks.checkSafe(nArray, 1);
        }
        JNI.callPPPV(l2, n2, nArray2.length, nArray, nArray2, l3);
    }

    static {
        GLES.initialize();
    }
}

