/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.lang.invoke.LambdaMetafactory;
import java.nio.IntBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.IntFunction;
import org.lwjgl.opengl.GL$1;
import org.lwjgl.opengl.GL$ICD;
import org.lwjgl.opengl.GL$ICDStatic;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLX11;
import org.lwjgl.opengl.GLXCapabilities;
import org.lwjgl.opengl.WGL;
import org.lwjgl.opengl.WGLCapabilities;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.APIUtil$APIVersion;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Platform;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.ThreadLocalUtil;
import org.lwjgl.system.linux.X11;
import org.lwjgl.system.windows.GDI32;
import org.lwjgl.system.windows.PIXELFORMATDESCRIPTOR;
import org.lwjgl.system.windows.User32;
import org.lwjgl.system.windows.User32$Functions;
import org.lwjgl.system.windows.WNDCLASSEX;
import org.lwjgl.system.windows.WindowsLibrary;
import org.lwjgl.system.windows.WindowsUtil;

public final class GL {
    private static final APIUtil$APIVersion MAX_VERSION;
    private static FunctionProvider functionProvider;
    private static final ThreadLocal capabilitiesTLS;
    private static GL$ICD icd;
    private static WGLCapabilities capabilitiesWGL;
    private static GLXCapabilities capabilitiesGLXClient;
    private static GLXCapabilities capabilitiesGLX;

    private GL() {
    }

    static void initialize() {
    }

    public static void create() {
        SharedLibrary sharedLibrary;
        switch (Platform.get()) {
            case LINUX: {
                sharedLibrary = Library.loadNative(GL.class, "org.lwjgl.opengl", Configuration.OPENGL_LIBRARY_NAME, "libGLX.so.0", "libGL.so.1", "libGL.so");
                break;
            }
            case MACOSX: {
                sharedLibrary = Library.loadNative(GL.class, "org.lwjgl.opengl", Configuration.OPENGL_LIBRARY_NAME, "/System/Library/Frameworks/OpenGL.framework/Versions/Current/OpenGL");
                break;
            }
            case WINDOWS: {
                sharedLibrary = Library.loadNative(GL.class, "org.lwjgl.opengl", Configuration.OPENGL_LIBRARY_NAME, "opengl32");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        GL.create(sharedLibrary);
    }

    public static void create(String string) {
        GL.create(Library.loadNative(GL.class, "org.lwjgl.opengl", string));
    }

    private static void create(SharedLibrary sharedLibrary) {
        try {
            GL.create((FunctionProvider)new GL$1(sharedLibrary));
            return;
        }
        catch (RuntimeException runtimeException) {
            sharedLibrary.free();
            throw runtimeException;
        }
    }

    public static void create(FunctionProvider functionProvider) {
        if (GL.functionProvider != null) {
            throw new IllegalStateException("OpenGL library has already been loaded.");
        }
        GL.functionProvider = functionProvider;
        ThreadLocalUtil.setFunctionMissingAddresses(2228);
    }

    public static void destroy() {
        if (functionProvider == null) {
            return;
        }
        ThreadLocalUtil.setFunctionMissingAddresses(0);
        capabilitiesWGL = null;
        capabilitiesGLX = null;
        if (functionProvider instanceof NativeResource) {
            ((NativeResource)((Object)functionProvider)).free();
        }
        functionProvider = null;
    }

    public static FunctionProvider getFunctionProvider() {
        return functionProvider;
    }

    public static void setCapabilities(GLCapabilities gLCapabilities) {
        capabilitiesTLS.set(gLCapabilities);
        ThreadLocalUtil.setCapabilities(gLCapabilities == null ? 0L : MemoryUtil.memAddress(gLCapabilities.addresses));
        icd.set(gLCapabilities);
    }

    public static GLCapabilities getCapabilities() {
        return GL.checkCapabilities((GLCapabilities)capabilitiesTLS.get());
    }

    private static GLCapabilities checkCapabilities(GLCapabilities gLCapabilities) {
        if (Checks.CHECKS && gLCapabilities == null) {
            throw new IllegalStateException("No GLCapabilities instance set for the current thread. Possible solutions:\n\ta) Call GL.createCapabilities() after making a context current in the current thread.\n\tb) Call GL.setCapabilities() if a GLCapabilities instance already exists for the current context.");
        }
        return gLCapabilities;
    }

    public static WGLCapabilities getCapabilitiesWGL() {
        if (capabilitiesWGL == null) {
            capabilitiesWGL = GL.createCapabilitiesWGLDummy();
        }
        return capabilitiesWGL;
    }

    static GLXCapabilities getCapabilitiesGLXClient() {
        if (capabilitiesGLXClient == null) {
            capabilitiesGLXClient = GL.initCapabilitiesGLX(true);
        }
        return capabilitiesGLXClient;
    }

    public static GLXCapabilities getCapabilitiesGLX() {
        if (capabilitiesGLX == null) {
            capabilitiesGLX = GL.initCapabilitiesGLX(false);
        }
        return capabilitiesGLX;
    }

    private static GLXCapabilities initCapabilitiesGLX(boolean bl2) {
        long l2 = X11.nXOpenDisplay(0L);
        try {
            GLXCapabilities gLXCapabilities = GL.createCapabilitiesGLX(l2, bl2 ? -1 : X11.XDefaultScreen(l2));
            return gLXCapabilities;
        }
        finally {
            X11.XCloseDisplay(l2);
        }
    }

    public static GLCapabilities createCapabilities() {
        return GL.createCapabilities(null);
    }

    public static GLCapabilities createCapabilities(IntFunction intFunction) {
        return GL.createCapabilities(false, intFunction);
    }

    public static GLCapabilities createCapabilities(boolean bl2) {
        return GL.createCapabilities(bl2, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static GLCapabilities createCapabilities(boolean var0, IntFunction var1_2) {
        var2_4 = GL.functionProvider;
        if (var2_4 == null) {
            throw new IllegalStateException("OpenGL library has not been loaded.");
        }
        var3_5 = var2_4.getFunctionAddress("glGetError");
        var5_7 = var2_4.getFunctionAddress("glGetString");
        var7_10 = var2_4.getFunctionAddress("glGetIntegerv");
        if (var3_5 == 0L || var5_7 == 0L || var7_10 == 0L) {
            throw new IllegalStateException("Core OpenGL functions could not be found. Make sure that the OpenGL library has been loaded correctly.");
        }
        var9_11 = JNI.callI(var3_5);
        if (var9_11 != 0) {
            APIUtil.apiLog(String.format("An OpenGL context was in an error state before the creation of its capabilities instance. Error: 0x%X", new Object[]{var9_11}));
        }
        var10_12 = MemoryStack.stackPush();
        var11_13 = null;
        try {
            var12_14 = var10_12.ints(0);
            JNI.callPV(33307, MemoryUtil.memAddress(var12_14), var7_10);
            if (JNI.callI(var3_5) == 0 && 3 <= (var9_11 = var12_14.get(0))) {
                JNI.callPV(33308, MemoryUtil.memAddress(var12_14), var7_10);
                var3_6 = var12_14.get(0);
            } else {
                var13_17 = MemoryUtil.memUTF8Safe(JNI.callP(7938, var5_7));
                if (var13_17 == null || JNI.callI(var3_5) != 0) {
                    throw new IllegalStateException("There is no OpenGL context current in the current thread.");
                }
                var4_20 = APIUtil.apiParseVersion(var13_17);
                var9_11 = var4_20.major;
                var3_6 = var4_20.minor;
            }
            if (var10_12 != null) {
                var10_12.close();
            }
        }
        catch (Throwable v0) {
            try {
                var12_15 = v0;
                var11_13 = v0;
                throw var12_15;
            }
            catch (Throwable var14_22) {
                if (var10_12 != null) {
                    if (var11_13 != null) {
                        try {
                            var10_12.close();
                        }
                        catch (Throwable var5_8) {
                            var11_13.addSuppressed(var5_8);
                        }
                    } else {
                        var10_12.close();
                    }
                }
                throw var14_22;
            }
        }
        if (var9_11 <= 0 || var9_11 == 1 && var3_6 <= 0) {
            throw new IllegalStateException("OpenGL 1.1 is required.");
        }
        var10_12 = new int[]{5, 1, 3, 6};
        var11_13 = new HashSet<E>(512);
        var12_16 = Math.min(var9_11, ((Object)var10_12).length);
        if (GL.MAX_VERSION != null) {
            var12_16 = Math.min(GL.MAX_VERSION.major, var12_16);
        }
        for (var13_18 = 1; var13_18 <= var12_16; ++var13_18) {
            var4_21 /* !! */  = var10_12[var13_18 - 1];
            if (var13_18 == var9_11) {
                var4_21 /* !! */  = Math.min(var3_6, (int)var4_21 /* !! */ );
            }
            if (GL.MAX_VERSION != null && var13_18 == GL.MAX_VERSION.major) {
                var4_21 /* !! */  = Math.min(GL.MAX_VERSION.minor, (int)var4_21 /* !! */ );
            }
            v1 = var14_23 = var13_18 == 1 ? 1 : 0;
            while (var14_23 <= var4_21 /* !! */ ) {
                var11_13.add("OpenGL" + var13_18 + var14_23);
                ++var14_23;
            }
        }
        if (var9_11 < 3) {
            var13_19 = MemoryUtil.memASCIISafe(JNI.callP(7939, var5_7));
            if (var13_19 != null) {
                var4_20 = new StringTokenizer((String)var13_19);
                while (var4_20.hasMoreTokens()) {
                    var11_13.add(var4_20.nextToken());
                }
            }
        } else {
            var13_19 = MemoryStack.stackPush();
            var4_20 = null;
            try {
                var14_24 = var13_19.ints(0);
                JNI.callPV(33309, MemoryUtil.memAddress(var14_24), var7_10);
                var5_9 = var14_24.get(0);
                var15_26 = APIUtil.apiGetFunctionAddress(var2_4, "glGetStringi");
                for (var6_27 = 0; var6_27 < var5_9; ++var6_27) {
                    var11_13.add(MemoryUtil.memASCII(JNI.callP(7939, var6_27, var15_26)));
                }
                JNI.callPV(33310, MemoryUtil.memAddress(var14_24), var7_10);
                if ((var14_24.get(0) & 1) != 0) {
                    var0 = true;
                } else if (3 < var9_11 || var3_6 > 0) {
                    if (3 < var9_11 || 2 <= var3_6) {
                        JNI.callPV(37158, MemoryUtil.memAddress(var14_24), var7_10);
                        if ((var14_24.get(0) & 1) != 0) {
                            var0 = true;
                        }
                    } else {
                        v2 = var0 = var11_13.contains("GL_ARB_compatibility") == false;
                    }
                }
                if (var13_19 == null) ** GOTO lbl117
                var13_19.close();
            }
            catch (Throwable v3) {
                try {
                    var14_25 = v3;
                    var4_20 = v3;
                    throw var14_25;
                }
                catch (Throwable var0_1) {
                    if (var13_19 != null) {
                        if (var4_20 != null) {
                            try {
                                var13_19.close();
                            }
                            catch (Throwable var1_3) {
                                var4_20.addSuppressed(var1_3);
                            }
                        } else {
                            var13_19.close();
                        }
                    }
                    throw var0_1;
                }
            }
        }
lbl117:
        // 3 sources

        APIUtil.apiFilterExtensions((Set)var11_13, Configuration.OPENGL_EXTENSION_FILTER);
        var13_19 = new GLCapabilities(var2_4, (Set)var11_13, var0, var1_2 == null ? (IntFunction)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, createPointerBuffer(int ), (I)Lorg/lwjgl/PointerBuffer;)() : var1_2);
        GL.setCapabilities((GLCapabilities)var13_19);
        return var13_19;
    }

    private static WGLCapabilities createCapabilitiesWGLDummy() {
        long l2 = WGL.wglGetCurrentDC();
        if (l2 != 0L) {
            return GL.createCapabilitiesWGL(l2);
        }
        int n2 = 0;
        long l3 = 0L;
        long l4 = 0L;
        try {
            MemoryStack memoryStack = MemoryStack.stackPush();
            Throwable throwable = null;
            try {
                PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR;
                WNDCLASSEX wNDCLASSEX = WNDCLASSEX.calloc(memoryStack).cbSize(WNDCLASSEX.SIZEOF).style(3).hInstance(WindowsLibrary.HINSTANCE).lpszClassName(memoryStack.UTF16("WGL"));
                MemoryUtil.memPutAddress(wNDCLASSEX.address() + (long)WNDCLASSEX.LPFNWNDPROC, User32$Functions.DefWindowProc);
                short s2 = User32.RegisterClassEx(wNDCLASSEX);
                n2 = s2;
                if (s2 == 0) {
                    throw new IllegalStateException("Failed to register WGL window class");
                }
                l3 = Checks.check(User32.nCreateWindowEx(0, n2 & 0xFFFF, 0L, 114229248, 0, 0, 1, 1, 0L, 0L, 0L, 0L));
                long l5 = Checks.check(User32.GetDC(l3));
                int n3 = GDI32.ChoosePixelFormat(l5, pIXELFORMATDESCRIPTOR = PIXELFORMATDESCRIPTOR.calloc(memoryStack).nSize((short)PIXELFORMATDESCRIPTOR.SIZEOF).nVersion((short)1).dwFlags(32));
                if (n3 == 0) {
                    WindowsUtil.windowsThrowException("Failed to choose an OpenGL-compatible pixel format");
                }
                if (GDI32.DescribePixelFormat(l5, n3, pIXELFORMATDESCRIPTOR) == 0) {
                    WindowsUtil.windowsThrowException("Failed to obtain pixel format information");
                }
                if (!GDI32.SetPixelFormat(l5, n3, pIXELFORMATDESCRIPTOR)) {
                    WindowsUtil.windowsThrowException("Failed to set the pixel format");
                }
                l4 = Checks.check(WGL.wglCreateContext(l5));
                WGL.wglMakeCurrent(l5, l4);
                WGLCapabilities wGLCapabilities = GL.createCapabilitiesWGL(l5);
                if (memoryStack != null) {
                    memoryStack.close();
                }
                return wGLCapabilities;
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (memoryStack != null) {
                        if (throwable != null) {
                            try {
                                memoryStack.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            memoryStack.close();
                        }
                    }
                    throw throwable4;
                }
            }
        }
        finally {
            if (l4 != 0L) {
                WGL.wglMakeCurrent(0L, 0L);
                WGL.wglDeleteContext(l4);
            }
            if (l3 != 0L) {
                User32.DestroyWindow(l3);
            }
            if (n2 != 0) {
                User32.nUnregisterClass(n2 & 0xFFFF, WindowsLibrary.HINSTANCE);
            }
        }
    }

    public static WGLCapabilities createCapabilitiesWGL() {
        long l2 = WGL.wglGetCurrentDC();
        if (l2 == 0L) {
            throw new IllegalStateException("Failed to retrieve the device context of the current OpenGL context");
        }
        return GL.createCapabilitiesWGL(l2);
    }

    private static WGLCapabilities createCapabilitiesWGL(long l2) {
        FunctionProvider functionProvider = GL.functionProvider;
        if (functionProvider == null) {
            throw new IllegalStateException("OpenGL library has not been loaded.");
        }
        String string = null;
        long l3 = functionProvider.getFunctionAddress("wglGetExtensionsStringARB");
        if (l3 != 0L) {
            string = MemoryUtil.memASCII(JNI.callPP(l2, l3));
        } else {
            l3 = functionProvider.getFunctionAddress("wglGetExtensionsStringEXT");
            if (l3 != 0L) {
                string = MemoryUtil.memASCII(JNI.callP(l3));
            }
        }
        HashSet<String> hashSet = new HashSet<String>(32);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                hashSet.add(stringTokenizer.nextToken());
            }
        }
        APIUtil.apiFilterExtensions(hashSet, Configuration.OPENGL_EXTENSION_FILTER);
        return new WGLCapabilities(functionProvider, hashSet);
    }

    public static GLXCapabilities createCapabilitiesGLX(long l2) {
        long l3 = l2;
        return GL.createCapabilitiesGLX(l3, X11.XDefaultScreen(l3));
    }

    public static GLXCapabilities createCapabilitiesGLX(long l2, int n2) {
        int n3;
        int n4;
        FunctionProvider functionProvider = GL.functionProvider;
        if (functionProvider == null) {
            throw new IllegalStateException("OpenGL library has not been loaded.");
        }
        Object object = MemoryStack.stackPush();
        Object object2 = null;
        try {
            IntBuffer intBuffer = ((MemoryStack)object).ints(0);
            IntBuffer intBuffer2 = ((MemoryStack)object).ints(0);
            if (!GLX11.glXQueryVersion(l2, intBuffer, intBuffer2)) {
                throw new IllegalStateException("Failed to query GLX version");
            }
            n4 = intBuffer.get(0);
            n3 = intBuffer2.get(0);
            if (n4 != 1) {
                throw new IllegalStateException("Invalid GLX major version: ".concat(String.valueOf(n4)));
            }
            if (object != null) {
                ((MemoryStack)object).close();
            }
        }
        catch (Throwable throwable) {
            try {
                Throwable throwable2 = throwable;
                object2 = throwable;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                if (object != null) {
                    if (object2 != null) {
                        try {
                            ((MemoryStack)object).close();
                        }
                        catch (Throwable throwable4) {
                            ((Throwable)object2).addSuppressed(throwable4);
                        }
                    } else {
                        ((MemoryStack)object).close();
                    }
                }
                throw throwable3;
            }
        }
        object = new HashSet(32);
        object2 = new int[][]{{1, 2, 3, 4}};
        for (int i2 = 1; i2 <= ((Object)object2).length; ++i2) {
            for (Object object3 : object2[i2 - 1]) {
                if (i2 >= n4 && (i2 != n4 || object3 > n3)) continue;
                object.add("GLX" + i2 + (int)object3);
            }
        }
        if (n3 > 0) {
            String string;
            long l3;
            if (n2 == -1) {
                l3 = functionProvider.getFunctionAddress("glXGetClientString");
                string = MemoryUtil.memASCIISafe(JNI.callPP(l2, 3, l3));
            } else {
                l3 = functionProvider.getFunctionAddress("glXQueryExtensionsString");
                string = MemoryUtil.memASCIISafe(JNI.callPP(l2, n2, l3));
            }
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    object.add(stringTokenizer.nextToken());
                }
            }
        }
        APIUtil.apiFilterExtensions((Set)object, Configuration.OPENGL_EXTENSION_FILTER);
        return new GLXCapabilities(functionProvider, (Set)object);
    }

    static GLCapabilities getICD() {
        return GL.checkCapabilities(icd.get());
    }

    static /* synthetic */ GL$ICD access$102(GL$ICD gL$ICD) {
        icd = gL$ICD;
        return icd;
    }

    static {
        capabilitiesTLS = new ThreadLocal();
        icd = new GL$ICDStatic(null);
        Library.loadSystem(System::load, System::loadLibrary, GL.class, "org.lwjgl.opengl", Platform.mapLibraryNameBundled("lwjgl_opengl"));
        MAX_VERSION = APIUtil.apiParseVersion(Configuration.OPENGL_MAXVERSION);
        if (!((Boolean)Configuration.OPENGL_EXPLICIT_INIT.get(Boolean.FALSE)).booleanValue()) {
            GL.create();
        }
    }
}

