/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class EXTMemoryObject {
    public static final int GL_TEXTURE_TILING_EXT = 38272;
    public static final int GL_DEDICATED_MEMORY_OBJECT_EXT = 38273;
    public static final int GL_NUM_TILING_TYPES_EXT = 38274;
    public static final int GL_TILING_TYPES_EXT = 38275;
    public static final int GL_OPTIMAL_TILING_EXT = 38276;
    public static final int GL_LINEAR_TILING_EXT = 38277;
    public static final int GL_NUM_DEVICE_UUIDS_EXT = 38294;
    public static final int GL_DEVICE_UUID_EXT = 38295;
    public static final int GL_DRIVER_UUID_EXT = 38296;
    public static final int GL_UUID_SIZE_EXT = 16;

    protected EXTMemoryObject() {
        throw new UnsupportedOperationException();
    }

    public static native void nglGetUnsignedBytevEXT(int var0, long var1);

    public static void glGetUnsignedBytevEXT(int n2, ByteBuffer byteBuffer) {
        EXTMemoryObject.nglGetUnsignedBytevEXT(n2, MemoryUtil.memAddress(byteBuffer));
    }

    public static native void nglGetUnsignedBytei_vEXT(int var0, int var1, long var2);

    public static void glGetUnsignedBytei_vEXT(int n2, int n3, ByteBuffer byteBuffer) {
        EXTMemoryObject.nglGetUnsignedBytei_vEXT(n2, n3, MemoryUtil.memAddress(byteBuffer));
    }

    public static native void nglDeleteMemoryObjectsEXT(int var0, long var1);

    public static void glDeleteMemoryObjectsEXT(IntBuffer intBuffer) {
        EXTMemoryObject.nglDeleteMemoryObjectsEXT(intBuffer.remaining(), MemoryUtil.memAddress(intBuffer));
    }

    public static void glDeleteMemoryObjectsEXT(int n2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.ints(n2);
            EXTMemoryObject.nglDeleteMemoryObjectsEXT(1, MemoryUtil.memAddress(intBuffer));
            return;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native boolean glIsMemoryObjectEXT(int var0);

    public static native void nglCreateMemoryObjectsEXT(int var0, long var1);

    public static void glCreateMemoryObjectsEXT(IntBuffer intBuffer) {
        EXTMemoryObject.nglCreateMemoryObjectsEXT(intBuffer.remaining(), MemoryUtil.memAddress(intBuffer));
    }

    public static int glCreateMemoryObjectsEXT() {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.callocInt(1);
            EXTMemoryObject.nglCreateMemoryObjectsEXT(1, MemoryUtil.memAddress(intBuffer));
            int n3 = intBuffer.get(0);
            return n3;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static native void nglMemoryObjectParameterivEXT(int var0, int var1, long var2);

    public static void glMemoryObjectParameterivEXT(int n2, int n3, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
        }
        EXTMemoryObject.nglMemoryObjectParameterivEXT(n2, n3, MemoryUtil.memAddress(intBuffer));
    }

    public static void glMemoryObjectParameteriEXT(int n2, int n3, int n4) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n5 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.ints(n4);
            EXTMemoryObject.nglMemoryObjectParameterivEXT(n2, n3, MemoryUtil.memAddress(intBuffer));
            return;
        }
        finally {
            memoryStack.setPointer(n5);
        }
    }

    public static native void nglGetMemoryObjectParameterivEXT(int var0, int var1, long var2);

    public static void glGetMemoryObjectParameterivEXT(int n2, int n3, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
        }
        EXTMemoryObject.nglGetMemoryObjectParameterivEXT(n2, n3, MemoryUtil.memAddress(intBuffer));
    }

    public static int glGetMemoryObjectParameteriEXT(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.callocInt(1);
            EXTMemoryObject.nglGetMemoryObjectParameterivEXT(n2, n3, MemoryUtil.memAddress(intBuffer));
            n2 = intBuffer.get(0);
            return n2;
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static native void glTexStorageMem2DEXT(int var0, int var1, int var2, int var3, int var4, int var5, long var6);

    public static native void glTexStorageMem2DMultisampleEXT(int var0, int var1, int var2, int var3, int var4, boolean var5, int var6, long var7);

    public static native void glTexStorageMem3DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7);

    public static native void glTexStorageMem3DMultisampleEXT(int var0, int var1, int var2, int var3, int var4, int var5, boolean var6, int var7, long var8);

    public static native void glBufferStorageMemEXT(int var0, long var1, int var3, long var4);

    public static native void glTextureStorageMem2DEXT(int var0, int var1, int var2, int var3, int var4, int var5, long var6);

    public static native void glTextureStorageMem2DMultisampleEXT(int var0, int var1, int var2, int var3, int var4, boolean var5, int var6, long var7);

    public static native void glTextureStorageMem3DEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7);

    public static native void glTextureStorageMem3DMultisampleEXT(int var0, int var1, int var2, int var3, int var4, int var5, boolean var6, int var7, long var8);

    public static native void glNamedBufferStorageMemEXT(int var0, long var1, int var3, long var4);

    public static native void glTexStorageMem1DEXT(int var0, int var1, int var2, int var3, int var4, long var5);

    public static native void glTextureStorageMem1DEXT(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glDeleteMemoryObjectsEXT(int[] nArray) {
        long l2 = GL.getICD().glDeleteMemoryObjectsEXT;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(nArray.length, nArray, l2);
    }

    public static void glCreateMemoryObjectsEXT(int[] nArray) {
        long l2 = GL.getICD().glCreateMemoryObjectsEXT;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(nArray.length, nArray, l2);
    }

    public static void glMemoryObjectParameterivEXT(int n2, int n3, int[] nArray) {
        long l2 = GL.getICD().glMemoryObjectParameterivEXT;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(nArray, 1);
        }
        JNI.callPV(n2, n3, nArray, l2);
    }

    public static void glGetMemoryObjectParameterivEXT(int n2, int n3, int[] nArray) {
        long l2 = GL.getICD().glGetMemoryObjectParameterivEXT;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(nArray, 1);
        }
        JNI.callPV(n2, n3, nArray, l2);
    }

    static {
        GL.initialize();
    }
}

