/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.openal.ALC;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class SOFTReopenDevice {
    protected SOFTReopenDevice() {
        throw new UnsupportedOperationException();
    }

    public static boolean nalcReopenDeviceSOFT(long l2, long l3, long l4) {
        long l5 = ALC.getICD().alcReopenDeviceSOFT;
        if (Checks.CHECKS) {
            Checks.check(l5);
            Checks.check(l2);
        }
        return JNI.invokePPPZ(l2, l3, l4, l5);
    }

    public static boolean alcReopenDeviceSOFT(long l2, ByteBuffer byteBuffer, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(byteBuffer);
            Checks.checkNTSafe(intBuffer);
        }
        return SOFTReopenDevice.nalcReopenDeviceSOFT(l2, MemoryUtil.memAddressSafe(byteBuffer), MemoryUtil.memAddressSafe(intBuffer));
    }

    public static boolean alcReopenDeviceSOFT(long l2, CharSequence charSequence, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(intBuffer);
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8Safe(charSequence, true);
            long l3 = charSequence == null ? 0L : memoryStack.getPointerAddress();
            boolean bl2 = SOFTReopenDevice.nalcReopenDeviceSOFT(l2, l3, MemoryUtil.memAddressSafe(intBuffer));
            return bl2;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static boolean alcReopenDeviceSOFT(long l2, ByteBuffer byteBuffer, int[] nArray) {
        long l3 = ALC.getICD().alcReopenDeviceSOFT;
        if (Checks.CHECKS) {
            Checks.check(l3);
            Checks.check(l2);
            Checks.checkNT1Safe(byteBuffer);
            Checks.checkNTSafe(nArray);
        }
        return JNI.invokePPPZ(l2, MemoryUtil.memAddressSafe(byteBuffer), nArray, l3);
    }

    public static boolean alcReopenDeviceSOFT(long l2, CharSequence charSequence, int[] nArray) {
        long l3 = ALC.getICD().alcReopenDeviceSOFT;
        if (Checks.CHECKS) {
            Checks.check(l3);
            Checks.check(l2);
            Checks.checkNTSafe(nArray);
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8Safe(charSequence, true);
            long l4 = charSequence == null ? 0L : memoryStack.getPointerAddress();
            boolean bl2 = JNI.invokePPPZ(l2, l4, nArray, l3);
            return bl2;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }
}

