/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.util.Set;
import java.util.function.IntFunction;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.ThreadLocalUtil;

public final class ALCapabilities {
    public final long alGetError;
    public final long alEnable;
    public final long alDisable;
    public final long alIsEnabled;
    public final long alGetBoolean;
    public final long alGetInteger;
    public final long alGetFloat;
    public final long alGetDouble;
    public final long alGetBooleanv;
    public final long alGetIntegerv;
    public final long alGetFloatv;
    public final long alGetDoublev;
    public final long alGetString;
    public final long alDistanceModel;
    public final long alDopplerFactor;
    public final long alDopplerVelocity;
    public final long alListenerf;
    public final long alListeneri;
    public final long alListener3f;
    public final long alListenerfv;
    public final long alGetListenerf;
    public final long alGetListeneri;
    public final long alGetListener3f;
    public final long alGetListenerfv;
    public final long alGenSources;
    public final long alDeleteSources;
    public final long alIsSource;
    public final long alSourcef;
    public final long alSource3f;
    public final long alSourcefv;
    public final long alSourcei;
    public final long alGetSourcef;
    public final long alGetSource3f;
    public final long alGetSourcefv;
    public final long alGetSourcei;
    public final long alGetSourceiv;
    public final long alSourceQueueBuffers;
    public final long alSourceUnqueueBuffers;
    public final long alSourcePlay;
    public final long alSourcePause;
    public final long alSourceStop;
    public final long alSourceRewind;
    public final long alSourcePlayv;
    public final long alSourcePausev;
    public final long alSourceStopv;
    public final long alSourceRewindv;
    public final long alGenBuffers;
    public final long alDeleteBuffers;
    public final long alIsBuffer;
    public final long alGetBufferf;
    public final long alGetBufferi;
    public final long alBufferData;
    public final long alGetEnumValue;
    public final long alGetProcAddress;
    public final long alIsExtensionPresent;
    public final long alListener3i;
    public final long alGetListeneriv;
    public final long alSource3i;
    public final long alListeneriv;
    public final long alSourceiv;
    public final long alBufferf;
    public final long alBuffer3f;
    public final long alBufferfv;
    public final long alBufferi;
    public final long alBuffer3i;
    public final long alBufferiv;
    public final long alGetBufferiv;
    public final long alGetBufferfv;
    public final long alSpeedOfSound;
    public final long alGenEffects;
    public final long alDeleteEffects;
    public final long alIsEffect;
    public final long alEffecti;
    public final long alEffectiv;
    public final long alEffectf;
    public final long alEffectfv;
    public final long alGetEffecti;
    public final long alGetEffectiv;
    public final long alGetEffectf;
    public final long alGetEffectfv;
    public final long alGenFilters;
    public final long alDeleteFilters;
    public final long alIsFilter;
    public final long alFilteri;
    public final long alFilteriv;
    public final long alFilterf;
    public final long alFilterfv;
    public final long alGetFilteri;
    public final long alGetFilteriv;
    public final long alGetFilterf;
    public final long alGetFilterfv;
    public final long alGenAuxiliaryEffectSlots;
    public final long alDeleteAuxiliaryEffectSlots;
    public final long alIsAuxiliaryEffectSlot;
    public final long alAuxiliaryEffectSloti;
    public final long alAuxiliaryEffectSlotiv;
    public final long alAuxiliaryEffectSlotf;
    public final long alAuxiliaryEffectSlotfv;
    public final long alGetAuxiliaryEffectSloti;
    public final long alGetAuxiliaryEffectSlotiv;
    public final long alGetAuxiliaryEffectSlotf;
    public final long alGetAuxiliaryEffectSlotfv;
    public final long alBufferDataStatic;
    public final long alBufferSamplesSOFT;
    public final long alBufferSubSamplesSOFT;
    public final long alGetBufferSamplesSOFT;
    public final long alIsBufferFormatSupportedSOFT;
    public final long alBufferSubDataSOFT;
    public final long alBufferCallbackSOFT;
    public final long alGetBufferPtrSOFT;
    public final long alGetBuffer3PtrSOFT;
    public final long alGetBufferPtrvSOFT;
    public final long alDeferUpdatesSOFT;
    public final long alProcessUpdatesSOFT;
    public final long alEventControlSOFT;
    public final long alEventCallbackSOFT;
    public final long alGetPointerSOFT;
    public final long alGetPointervSOFT;
    public final long alSourcedSOFT;
    public final long alSource3dSOFT;
    public final long alSourcedvSOFT;
    public final long alGetSourcedSOFT;
    public final long alGetSource3dSOFT;
    public final long alGetSourcedvSOFT;
    public final long alSourcei64SOFT;
    public final long alSource3i64SOFT;
    public final long alSourcei64vSOFT;
    public final long alGetSourcei64SOFT;
    public final long alGetSource3i64SOFT;
    public final long alGetSourcei64vSOFT;
    public final long alGetStringiSOFT;
    public final long alSourcePlayAtTimeSOFT;
    public final long alSourcePlayAtTimevSOFT;
    public final boolean OpenAL10;
    public final boolean OpenAL11;
    public final boolean AL_EXT_ALAW;
    public final boolean AL_EXT_BFORMAT;
    public final boolean AL_EXT_DOUBLE;
    public final boolean ALC_EXT_EFX;
    public final boolean AL_EXT_EXPONENT_DISTANCE;
    public final boolean AL_EXT_FLOAT32;
    public final boolean AL_EXT_IMA4;
    public final boolean AL_EXT_LINEAR_DISTANCE;
    public final boolean AL_EXT_MCFORMATS;
    public final boolean AL_EXT_MULAW;
    public final boolean AL_EXT_MULAW_BFORMAT;
    public final boolean AL_EXT_MULAW_MCFORMATS;
    public final boolean AL_EXT_OFFSET;
    public final boolean AL_EXT_source_distance_model;
    public final boolean AL_EXT_SOURCE_RADIUS;
    public final boolean AL_EXT_STATIC_BUFFER;
    public final boolean AL_EXT_STEREO_ANGLES;
    public final boolean AL_EXT_vorbis;
    public final boolean AL_LOKI_IMA_ADPCM;
    public final boolean AL_LOKI_quadriphonic;
    public final boolean AL_LOKI_WAVE_format;
    public final boolean AL_SOFT_bformat_ex;
    public final boolean AL_SOFT_block_alignment;
    public final boolean AL_SOFT_buffer_length_query;
    public final boolean AL_SOFT_buffer_samples;
    public final boolean AL_SOFT_buffer_sub_data;
    public final boolean AL_SOFT_callback_buffer;
    public final boolean AL_SOFT_deferred_updates;
    public final boolean AL_SOFT_direct_channels;
    public final boolean AL_SOFT_direct_channels_remix;
    public final boolean AL_SOFT_effect_target;
    public final boolean AL_SOFT_events;
    public final boolean AL_SOFT_gain_clamp_ex;
    public final boolean AL_SOFT_loop_points;
    public final boolean AL_SOFT_MSADPCM;
    public final boolean AL_SOFT_source_latency;
    public final boolean AL_SOFT_source_length;
    public final boolean AL_SOFT_source_resampler;
    public final boolean AL_SOFT_source_spatialize;
    public final boolean AL_SOFT_source_start_delay;
    public final boolean AL_SOFT_UHJ;
    public final boolean AL_SOFT_UHJ_ex;
    public final boolean AL_SOFTX_hold_on_disconnect;
    final PointerBuffer addresses;

    ALCapabilities(FunctionProvider functionProvider, Set set, IntFunction object) {
        object = (PointerBuffer)object.apply(133);
        this.OpenAL10 = ALCapabilities.check_AL10(functionProvider, (PointerBuffer)object, set);
        this.OpenAL11 = ALCapabilities.check_AL11(functionProvider, (PointerBuffer)object, set);
        this.AL_EXT_ALAW = set.contains("AL_EXT_ALAW");
        this.AL_EXT_BFORMAT = set.contains("AL_EXT_BFORMAT");
        this.AL_EXT_DOUBLE = set.contains("AL_EXT_DOUBLE");
        this.ALC_EXT_EFX = ALCapabilities.check_EXT_EFX(functionProvider, (PointerBuffer)object, set);
        this.AL_EXT_EXPONENT_DISTANCE = set.contains("AL_EXT_EXPONENT_DISTANCE");
        this.AL_EXT_FLOAT32 = set.contains("AL_EXT_FLOAT32");
        this.AL_EXT_IMA4 = set.contains("AL_EXT_IMA4");
        this.AL_EXT_LINEAR_DISTANCE = set.contains("AL_EXT_LINEAR_DISTANCE");
        this.AL_EXT_MCFORMATS = set.contains("AL_EXT_MCFORMATS");
        this.AL_EXT_MULAW = set.contains("AL_EXT_MULAW");
        this.AL_EXT_MULAW_BFORMAT = set.contains("AL_EXT_MULAW_BFORMAT");
        this.AL_EXT_MULAW_MCFORMATS = set.contains("AL_EXT_MULAW_MCFORMATS");
        this.AL_EXT_OFFSET = set.contains("AL_EXT_OFFSET");
        this.AL_EXT_source_distance_model = set.contains("AL_EXT_source_distance_model");
        this.AL_EXT_SOURCE_RADIUS = set.contains("AL_EXT_SOURCE_RADIUS");
        this.AL_EXT_STATIC_BUFFER = ALCapabilities.check_EXT_STATIC_BUFFER(functionProvider, (PointerBuffer)object, set);
        this.AL_EXT_STEREO_ANGLES = set.contains("AL_EXT_STEREO_ANGLES");
        this.AL_EXT_vorbis = set.contains("AL_EXT_vorbis");
        this.AL_LOKI_IMA_ADPCM = set.contains("AL_LOKI_IMA_ADPCM");
        this.AL_LOKI_quadriphonic = set.contains("AL_LOKI_quadriphonic");
        this.AL_LOKI_WAVE_format = set.contains("AL_LOKI_WAVE_format");
        this.AL_SOFT_bformat_ex = set.contains("AL_SOFT_bformat_ex");
        this.AL_SOFT_block_alignment = set.contains("AL_SOFT_block_alignment");
        this.AL_SOFT_buffer_length_query = set.contains("AL_SOFT_buffer_length_query");
        this.AL_SOFT_buffer_samples = ALCapabilities.check_SOFT_buffer_samples(functionProvider, (PointerBuffer)object, set);
        this.AL_SOFT_buffer_sub_data = ALCapabilities.check_SOFT_buffer_sub_data(functionProvider, (PointerBuffer)object, set);
        this.AL_SOFT_callback_buffer = ALCapabilities.check_SOFT_callback_buffer(functionProvider, (PointerBuffer)object, set);
        this.AL_SOFT_deferred_updates = ALCapabilities.check_SOFT_deferred_updates(functionProvider, (PointerBuffer)object, set);
        this.AL_SOFT_direct_channels = set.contains("AL_SOFT_direct_channels");
        this.AL_SOFT_direct_channels_remix = set.contains("AL_SOFT_direct_channels_remix");
        this.AL_SOFT_effect_target = set.contains("AL_SOFT_effect_target");
        this.AL_SOFT_events = ALCapabilities.check_SOFT_events(functionProvider, (PointerBuffer)object, set);
        this.AL_SOFT_gain_clamp_ex = set.contains("AL_SOFT_gain_clamp_ex");
        this.AL_SOFT_loop_points = set.contains("AL_SOFT_loop_points");
        this.AL_SOFT_MSADPCM = set.contains("AL_SOFT_MSADPCM");
        this.AL_SOFT_source_latency = ALCapabilities.check_SOFT_source_latency(functionProvider, (PointerBuffer)object, set);
        this.AL_SOFT_source_length = set.contains("AL_SOFT_source_length");
        this.AL_SOFT_source_resampler = ALCapabilities.check_SOFT_source_resampler(functionProvider, (PointerBuffer)object, set);
        this.AL_SOFT_source_spatialize = set.contains("AL_SOFT_source_spatialize");
        this.AL_SOFT_source_start_delay = ALCapabilities.check_SOFT_source_start_delay(functionProvider, (PointerBuffer)object, set);
        this.AL_SOFT_UHJ = set.contains("AL_SOFT_UHJ");
        this.AL_SOFT_UHJ_ex = set.contains("AL_SOFT_UHJ_ex");
        this.AL_SOFTX_hold_on_disconnect = set.contains("AL_SOFTX_hold_on_disconnect");
        this.alGetError = ((PointerBuffer)object).get(0);
        this.alEnable = ((PointerBuffer)object).get(1);
        this.alDisable = ((PointerBuffer)object).get(2);
        this.alIsEnabled = ((PointerBuffer)object).get(3);
        this.alGetBoolean = ((PointerBuffer)object).get(4);
        this.alGetInteger = ((PointerBuffer)object).get(5);
        this.alGetFloat = ((PointerBuffer)object).get(6);
        this.alGetDouble = ((PointerBuffer)object).get(7);
        this.alGetBooleanv = ((PointerBuffer)object).get(8);
        this.alGetIntegerv = ((PointerBuffer)object).get(9);
        this.alGetFloatv = ((PointerBuffer)object).get(10);
        this.alGetDoublev = ((PointerBuffer)object).get(11);
        this.alGetString = ((PointerBuffer)object).get(12);
        this.alDistanceModel = ((PointerBuffer)object).get(13);
        this.alDopplerFactor = ((PointerBuffer)object).get(14);
        this.alDopplerVelocity = ((PointerBuffer)object).get(15);
        this.alListenerf = ((PointerBuffer)object).get(16);
        this.alListeneri = ((PointerBuffer)object).get(17);
        this.alListener3f = ((PointerBuffer)object).get(18);
        this.alListenerfv = ((PointerBuffer)object).get(19);
        this.alGetListenerf = ((PointerBuffer)object).get(20);
        this.alGetListeneri = ((PointerBuffer)object).get(21);
        this.alGetListener3f = ((PointerBuffer)object).get(22);
        this.alGetListenerfv = ((PointerBuffer)object).get(23);
        this.alGenSources = ((PointerBuffer)object).get(24);
        this.alDeleteSources = ((PointerBuffer)object).get(25);
        this.alIsSource = ((PointerBuffer)object).get(26);
        this.alSourcef = ((PointerBuffer)object).get(27);
        this.alSource3f = ((PointerBuffer)object).get(28);
        this.alSourcefv = ((PointerBuffer)object).get(29);
        this.alSourcei = ((PointerBuffer)object).get(30);
        this.alGetSourcef = ((PointerBuffer)object).get(31);
        this.alGetSource3f = ((PointerBuffer)object).get(32);
        this.alGetSourcefv = ((PointerBuffer)object).get(33);
        this.alGetSourcei = ((PointerBuffer)object).get(34);
        this.alGetSourceiv = ((PointerBuffer)object).get(35);
        this.alSourceQueueBuffers = ((PointerBuffer)object).get(36);
        this.alSourceUnqueueBuffers = ((PointerBuffer)object).get(37);
        this.alSourcePlay = ((PointerBuffer)object).get(38);
        this.alSourcePause = ((PointerBuffer)object).get(39);
        this.alSourceStop = ((PointerBuffer)object).get(40);
        this.alSourceRewind = ((PointerBuffer)object).get(41);
        this.alSourcePlayv = ((PointerBuffer)object).get(42);
        this.alSourcePausev = ((PointerBuffer)object).get(43);
        this.alSourceStopv = ((PointerBuffer)object).get(44);
        this.alSourceRewindv = ((PointerBuffer)object).get(45);
        this.alGenBuffers = ((PointerBuffer)object).get(46);
        this.alDeleteBuffers = ((PointerBuffer)object).get(47);
        this.alIsBuffer = ((PointerBuffer)object).get(48);
        this.alGetBufferf = ((PointerBuffer)object).get(49);
        this.alGetBufferi = ((PointerBuffer)object).get(50);
        this.alBufferData = ((PointerBuffer)object).get(51);
        this.alGetEnumValue = ((PointerBuffer)object).get(52);
        this.alGetProcAddress = ((PointerBuffer)object).get(53);
        this.alIsExtensionPresent = ((PointerBuffer)object).get(54);
        this.alListener3i = ((PointerBuffer)object).get(55);
        this.alGetListeneriv = ((PointerBuffer)object).get(56);
        this.alSource3i = ((PointerBuffer)object).get(57);
        this.alListeneriv = ((PointerBuffer)object).get(58);
        this.alSourceiv = ((PointerBuffer)object).get(59);
        this.alBufferf = ((PointerBuffer)object).get(60);
        this.alBuffer3f = ((PointerBuffer)object).get(61);
        this.alBufferfv = ((PointerBuffer)object).get(62);
        this.alBufferi = ((PointerBuffer)object).get(63);
        this.alBuffer3i = ((PointerBuffer)object).get(64);
        this.alBufferiv = ((PointerBuffer)object).get(65);
        this.alGetBufferiv = ((PointerBuffer)object).get(66);
        this.alGetBufferfv = ((PointerBuffer)object).get(67);
        this.alSpeedOfSound = ((PointerBuffer)object).get(68);
        this.alGenEffects = ((PointerBuffer)object).get(69);
        this.alDeleteEffects = ((PointerBuffer)object).get(70);
        this.alIsEffect = ((PointerBuffer)object).get(71);
        this.alEffecti = ((PointerBuffer)object).get(72);
        this.alEffectiv = ((PointerBuffer)object).get(73);
        this.alEffectf = ((PointerBuffer)object).get(74);
        this.alEffectfv = ((PointerBuffer)object).get(75);
        this.alGetEffecti = ((PointerBuffer)object).get(76);
        this.alGetEffectiv = ((PointerBuffer)object).get(77);
        this.alGetEffectf = ((PointerBuffer)object).get(78);
        this.alGetEffectfv = ((PointerBuffer)object).get(79);
        this.alGenFilters = ((PointerBuffer)object).get(80);
        this.alDeleteFilters = ((PointerBuffer)object).get(81);
        this.alIsFilter = ((PointerBuffer)object).get(82);
        this.alFilteri = ((PointerBuffer)object).get(83);
        this.alFilteriv = ((PointerBuffer)object).get(84);
        this.alFilterf = ((PointerBuffer)object).get(85);
        this.alFilterfv = ((PointerBuffer)object).get(86);
        this.alGetFilteri = ((PointerBuffer)object).get(87);
        this.alGetFilteriv = ((PointerBuffer)object).get(88);
        this.alGetFilterf = ((PointerBuffer)object).get(89);
        this.alGetFilterfv = ((PointerBuffer)object).get(90);
        this.alGenAuxiliaryEffectSlots = ((PointerBuffer)object).get(91);
        this.alDeleteAuxiliaryEffectSlots = ((PointerBuffer)object).get(92);
        this.alIsAuxiliaryEffectSlot = ((PointerBuffer)object).get(93);
        this.alAuxiliaryEffectSloti = ((PointerBuffer)object).get(94);
        this.alAuxiliaryEffectSlotiv = ((PointerBuffer)object).get(95);
        this.alAuxiliaryEffectSlotf = ((PointerBuffer)object).get(96);
        this.alAuxiliaryEffectSlotfv = ((PointerBuffer)object).get(97);
        this.alGetAuxiliaryEffectSloti = ((PointerBuffer)object).get(98);
        this.alGetAuxiliaryEffectSlotiv = ((PointerBuffer)object).get(99);
        this.alGetAuxiliaryEffectSlotf = ((PointerBuffer)object).get(100);
        this.alGetAuxiliaryEffectSlotfv = ((PointerBuffer)object).get(101);
        this.alBufferDataStatic = ((PointerBuffer)object).get(102);
        this.alBufferSamplesSOFT = ((PointerBuffer)object).get(103);
        this.alBufferSubSamplesSOFT = ((PointerBuffer)object).get(104);
        this.alGetBufferSamplesSOFT = ((PointerBuffer)object).get(105);
        this.alIsBufferFormatSupportedSOFT = ((PointerBuffer)object).get(106);
        this.alBufferSubDataSOFT = ((PointerBuffer)object).get(107);
        this.alBufferCallbackSOFT = ((PointerBuffer)object).get(108);
        this.alGetBufferPtrSOFT = ((PointerBuffer)object).get(109);
        this.alGetBuffer3PtrSOFT = ((PointerBuffer)object).get(110);
        this.alGetBufferPtrvSOFT = ((PointerBuffer)object).get(111);
        this.alDeferUpdatesSOFT = ((PointerBuffer)object).get(112);
        this.alProcessUpdatesSOFT = ((PointerBuffer)object).get(113);
        this.alEventControlSOFT = ((PointerBuffer)object).get(114);
        this.alEventCallbackSOFT = ((PointerBuffer)object).get(115);
        this.alGetPointerSOFT = ((PointerBuffer)object).get(116);
        this.alGetPointervSOFT = ((PointerBuffer)object).get(117);
        this.alSourcedSOFT = ((PointerBuffer)object).get(118);
        this.alSource3dSOFT = ((PointerBuffer)object).get(119);
        this.alSourcedvSOFT = ((PointerBuffer)object).get(120);
        this.alGetSourcedSOFT = ((PointerBuffer)object).get(121);
        this.alGetSource3dSOFT = ((PointerBuffer)object).get(122);
        this.alGetSourcedvSOFT = ((PointerBuffer)object).get(123);
        this.alSourcei64SOFT = ((PointerBuffer)object).get(124);
        this.alSource3i64SOFT = ((PointerBuffer)object).get(125);
        this.alSourcei64vSOFT = ((PointerBuffer)object).get(126);
        this.alGetSourcei64SOFT = ((PointerBuffer)object).get(127);
        this.alGetSource3i64SOFT = ((PointerBuffer)object).get(128);
        this.alGetSourcei64vSOFT = ((PointerBuffer)object).get(129);
        this.alGetStringiSOFT = ((PointerBuffer)object).get(130);
        this.alSourcePlayAtTimeSOFT = ((PointerBuffer)object).get(131);
        this.alSourcePlayAtTimevSOFT = ((PointerBuffer)object).get(132);
        this.addresses = ThreadLocalUtil.setupAddressBuffer((PointerBuffer)object);
    }

    public final PointerBuffer getAddressBuffer() {
        return this.addresses;
    }

    private static boolean check_AL10(FunctionProvider functionProvider, PointerBuffer pointerBuffer, Set set) {
        if (!set.contains("OpenAL10")) {
            return false;
        }
        return Checks.checkFunctions(functionProvider, pointerBuffer, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54}, "alGetError", "alEnable", "alDisable", "alIsEnabled", "alGetBoolean", "alGetInteger", "alGetFloat", "alGetDouble", "alGetBooleanv", "alGetIntegerv", "alGetFloatv", "alGetDoublev", "alGetString", "alDistanceModel", "alDopplerFactor", "alDopplerVelocity", "alListenerf", "alListeneri", "alListener3f", "alListenerfv", "alGetListenerf", "alGetListeneri", "alGetListener3f", "alGetListenerfv", "alGenSources", "alDeleteSources", "alIsSource", "alSourcef", "alSource3f", "alSourcefv", "alSourcei", "alGetSourcef", "alGetSource3f", "alGetSourcefv", "alGetSourcei", "alGetSourceiv", "alSourceQueueBuffers", "alSourceUnqueueBuffers", "alSourcePlay", "alSourcePause", "alSourceStop", "alSourceRewind", "alSourcePlayv", "alSourcePausev", "alSourceStopv", "alSourceRewindv", "alGenBuffers", "alDeleteBuffers", "alIsBuffer", "alGetBufferf", "alGetBufferi", "alBufferData", "alGetEnumValue", "alGetProcAddress", "alIsExtensionPresent") || Checks.reportMissing("AL", "OpenAL10");
    }

    private static boolean check_AL11(FunctionProvider functionProvider, PointerBuffer pointerBuffer, Set set) {
        if (!set.contains("OpenAL11")) {
            return false;
        }
        return Checks.checkFunctions(functionProvider, pointerBuffer, new int[]{55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68}, "alListener3i", "alGetListeneriv", "alSource3i", "alListeneriv", "alSourceiv", "alBufferf", "alBuffer3f", "alBufferfv", "alBufferi", "alBuffer3i", "alBufferiv", "alGetBufferiv", "alGetBufferfv", "alSpeedOfSound") || Checks.reportMissing("AL", "OpenAL11");
    }

    private static boolean check_EXT_EFX(FunctionProvider functionProvider, PointerBuffer pointerBuffer, Set set) {
        if (!set.contains("ALC_EXT_EFX")) {
            return false;
        }
        return Checks.checkFunctions(functionProvider, pointerBuffer, new int[]{69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101}, "alGenEffects", "alDeleteEffects", "alIsEffect", "alEffecti", "alEffectiv", "alEffectf", "alEffectfv", "alGetEffecti", "alGetEffectiv", "alGetEffectf", "alGetEffectfv", "alGenFilters", "alDeleteFilters", "alIsFilter", "alFilteri", "alFilteriv", "alFilterf", "alFilterfv", "alGetFilteri", "alGetFilteriv", "alGetFilterf", "alGetFilterfv", "alGenAuxiliaryEffectSlots", "alDeleteAuxiliaryEffectSlots", "alIsAuxiliaryEffectSlot", "alAuxiliaryEffectSloti", "alAuxiliaryEffectSlotiv", "alAuxiliaryEffectSlotf", "alAuxiliaryEffectSlotfv", "alGetAuxiliaryEffectSloti", "alGetAuxiliaryEffectSlotiv", "alGetAuxiliaryEffectSlotf", "alGetAuxiliaryEffectSlotfv") || Checks.reportMissing("AL", "ALC_EXT_EFX");
    }

    private static boolean check_EXT_STATIC_BUFFER(FunctionProvider functionProvider, PointerBuffer pointerBuffer, Set set) {
        if (!set.contains("AL_EXT_STATIC_BUFFER")) {
            return false;
        }
        return Checks.checkFunctions(functionProvider, pointerBuffer, new int[]{102}, "alBufferDataStatic") || Checks.reportMissing("AL", "AL_EXT_STATIC_BUFFER");
    }

    private static boolean check_SOFT_buffer_samples(FunctionProvider functionProvider, PointerBuffer pointerBuffer, Set set) {
        if (!set.contains("AL_SOFT_buffer_samples")) {
            return false;
        }
        return Checks.checkFunctions(functionProvider, pointerBuffer, new int[]{103, 104, 105, 106}, "alBufferSamplesSOFT", "alBufferSubSamplesSOFT", "alGetBufferSamplesSOFT", "alIsBufferFormatSupportedSOFT") || Checks.reportMissing("AL", "AL_SOFT_buffer_samples");
    }

    private static boolean check_SOFT_buffer_sub_data(FunctionProvider functionProvider, PointerBuffer pointerBuffer, Set set) {
        if (!set.contains("AL_SOFT_buffer_sub_data")) {
            return false;
        }
        return Checks.checkFunctions(functionProvider, pointerBuffer, new int[]{107}, "alBufferSubDataSOFT") || Checks.reportMissing("AL", "AL_SOFT_buffer_sub_data");
    }

    private static boolean check_SOFT_callback_buffer(FunctionProvider functionProvider, PointerBuffer pointerBuffer, Set set) {
        if (!set.contains("AL_SOFT_callback_buffer")) {
            return false;
        }
        return Checks.checkFunctions(functionProvider, pointerBuffer, new int[]{108, 109, 110, 111}, "alBufferCallbackSOFT", "alGetBufferPtrSOFT", "alGetBuffer3PtrSOFT", "alGetBufferPtrvSOFT") || Checks.reportMissing("AL", "AL_SOFT_callback_buffer");
    }

    private static boolean check_SOFT_deferred_updates(FunctionProvider functionProvider, PointerBuffer pointerBuffer, Set set) {
        if (!set.contains("AL_SOFT_deferred_updates")) {
            return false;
        }
        return Checks.checkFunctions(functionProvider, pointerBuffer, new int[]{112, 113}, "alDeferUpdatesSOFT", "alProcessUpdatesSOFT") || Checks.reportMissing("AL", "AL_SOFT_deferred_updates");
    }

    private static boolean check_SOFT_events(FunctionProvider functionProvider, PointerBuffer pointerBuffer, Set set) {
        if (!set.contains("AL_SOFT_events")) {
            return false;
        }
        return Checks.checkFunctions(functionProvider, pointerBuffer, new int[]{114, 115, 116, 117}, "alEventControlSOFT", "alEventCallbackSOFT", "alGetPointerSOFT", "alGetPointervSOFT") || Checks.reportMissing("AL", "AL_SOFT_events");
    }

    private static boolean check_SOFT_source_latency(FunctionProvider functionProvider, PointerBuffer pointerBuffer, Set set) {
        if (!set.contains("AL_SOFT_source_latency")) {
            return false;
        }
        return Checks.checkFunctions(functionProvider, pointerBuffer, new int[]{118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129}, "alSourcedSOFT", "alSource3dSOFT", "alSourcedvSOFT", "alGetSourcedSOFT", "alGetSource3dSOFT", "alGetSourcedvSOFT", "alSourcei64SOFT", "alSource3i64SOFT", "alSourcei64vSOFT", "alGetSourcei64SOFT", "alGetSource3i64SOFT", "alGetSourcei64vSOFT") || Checks.reportMissing("AL", "AL_SOFT_source_latency");
    }

    private static boolean check_SOFT_source_resampler(FunctionProvider functionProvider, PointerBuffer pointerBuffer, Set set) {
        if (!set.contains("AL_SOFT_source_resampler")) {
            return false;
        }
        return Checks.checkFunctions(functionProvider, pointerBuffer, new int[]{130}, "alGetStringiSOFT") || Checks.reportMissing("AL", "AL_SOFT_source_resampler");
    }

    private static boolean check_SOFT_source_start_delay(FunctionProvider functionProvider, PointerBuffer pointerBuffer, Set set) {
        if (!set.contains("AL_SOFT_source_start_delay")) {
            return false;
        }
        return Checks.checkFunctions(functionProvider, pointerBuffer, new int[]{131, 132}, "alSourcePlayAtTimeSOFT", "alSourcePlayAtTimevSOFT") || Checks.reportMissing("AL", "AL_SOFT_source_start_delay");
    }
}

